<?php

$page_security = 'SA_ACCESSREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	price Listing
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
add_access_extensions();
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/includes/access_levels.inc");
include_once($path_to_root . "/admin/db/security_db.inc");

//----------------------------------------------------------------------------------------------------

print_price_listing();
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------


function fetch_items($category=0)
{
		$sql = "SELECT item.stock_id, item.description AS name,
				item.material_cost AS Standardcost,
				item.category_id,item.units,
				category.description
			FROM ".TB_PREF."stock_master item,
				".TB_PREF."stock_category category
			WHERE item.category_id=category.category_id AND NOT item.inactive";
		if ($category != 0)
			$sql .= " AND category.category_id = ".db_escape($category);
		$sql .= " AND item.mb_flag<> 'F' ORDER BY item.category_id,
				item.stock_id";

    return db_query($sql,"No transactions were returned");
}

function get_kits($category=0)
{
	$sql = "SELECT i.item_code AS kit_code, i.description AS kit_name, c.category_id AS cat_id, c.description AS cat_name, count(*)>1 AS kit
			FROM
				".TB_PREF."item_codes i
				LEFT JOIN ".TB_PREF."stock_category c ON i.category_id=c.category_id
			WHERE !i.is_foreign AND i.item_code!=i.stock_id";
	if ($category != 0)
		$sql .= " AND c.category_id = ".db_escape($category);
	$sql .= " GROUP BY i.item_code";
    return db_query($sql,"No kits were returned");
}
function sort_areas($areas)
{
	$old_order = 0;
	foreach($areas as $key => $area) {
		$areas[$key][] = $old_order++;
	}
	uasort($areas,'comp_areas');
	return $areas;
}

//----------------------------------------------------------------------------------------------------

function print_price_listing()
{
    global $path_to_root, $SysPrefs;

    // $currency = $_POST['PARAM_0'];
    // $category = $_POST['PARAM_1'];
    // $salestype = $_POST['PARAM_2'];
    // $pictures = $_POST['PARAM_3'];
    // $showGP = $_POST['PARAM_4'];
    // $comments = $_POST['PARAM_5'];
    $security_role =  $_POST['PARAM_0'];
    $active_inactive =  $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];
	$REPORT_ID = 1000;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

/*	$home_curr = get_company_pref('curr_default');
	if ($currency == ALL_TEXT)
		$currency = $home_curr;
	$curr = get_currency($currency);
	$curr_sel = $currency . " - " . $curr['currency'];
	if ($category == ALL_NUMERIC)
		$category = 0;
	if ($salestype == ALL_NUMERIC)
		$salestype = 0;
	if ($category == 0)
		$cat = _('All');
	else
		$cat = get_category_name($category);
	if ($salestype == 0)
		$stype = _('All');
	else
		$stype = get_sales_type_name($salestype);
	if ($showGP == 0)
		$GP = _('No');
	else
		$GP = _('Yes');*/
    // $current_user = $_SESSION['wa_current_user']->user;
    if($active_inactive == 1)
        $active_name = "Active";
    else if($active_inactive == 1)
        $active_name = "Inactive";
    else
        $active_name = "";
        
    $current_role = $security_role;
	$cols = array(0, 100, 360, 385, 430, 515);

	$headers = array(_('Modules'), _('Forms'),	'', '',	_('Active/Inactive'));

	$aligns = array('left',	'left',	'left', 'right', 'right');

    $params =   array( 	0 => '',
    				    1 => array('text' => _('Role'), 'from' => get_security_role($current_role)['role'], 'to' => ''),
    				    2 => array('text' => _('Active/Inactive'), 'from' => $active_name, 'to' => '')
    				    );



    $rep = new FrontReport(_('Access Level'), "AccessLevel", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
   
    global $security_areas, $security_sections;
    $m=0;
    
    foreach($security_sections as $key=>$value){
        	$rep->fontSize += 2;
			$rep->TextCol(0, 3,$value);
// 			$catgor = $myrow['description'];
			$rep->fontSize -= 2;
			$rep->NewLine();
            foreach(sort_areas($security_areas) as $area =>$parms ) {
                if (user_company() && (($parms[0]&0xff00) == SS_SADMIN)) continue;
                $newsec = ($parms[0]>>8)&0xff;
                $newext  = $parms[0]>>16;
                if ($newsec != $sec || (($newext != $ext) && ($newsec>99))){ // features set selection
                $ext = $newext; 
                $sec = $newsec;
                $m = $parms[0] & ~0xff;
                }
                //   display_error($parms[0]."====".$key);
                if($m==$key){
                    
                    if($active_inactive == 1){
                        if(in_array($parms[0],get_security_role($current_role)['areas'])== 0)
                            continue;
                    }else if($active_inactive == 2){
                        // display_error(in_array($parms[0],get_security_role($current_role)['areas']));
                        if(in_array($parms[0],get_security_role($current_role)['areas'])== 1)
                            continue;
                    }
                        $rep->TextCol(1, 2,$parms[1]);
                        
                        if(in_array($parms[0],get_security_role($current_role)['areas'])== 1){
                            $active = "Active";
                        }else{
                            $active = "Inactive";
                        }
                        $rep->TextCol(4, 5,$active);
                        $rep->NewLine();
                    
                }
                
            }
			$rep->Line($rep->row  - 1);
			$rep->NewLine();
    }


	$rep->NewLine();

	//pk
    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
        $row = db_fetch($res);
        if($row['signature2'] == '' && $row['signature3'] == ''){   
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 
        }
        if($row['signature2'] != '' && $row['signature3'] == ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(441,47,150,"_________________"); 
            $rep->TextWrap(455,37,150,$row['signature2']);
        }
        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(260,47,150,"__________________"); 
            $rep->TextWrap(274,37,150,$row['signature2']); 

            $rep->TextWrap(441,47,150,"_______________"); 
            $rep->TextWrap(455,37,150,$row['signature3']);
        }
    }
    $rep->End();
}

