<?php

$page_security = 'SA_ACCESSREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	price Listing
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include($path_to_root . "/CRM/includes/db/subscription_agreement_db.inc");
include($path_to_root . "/admin/db/security_roles_agreement_db.inc");

include_once($path_to_root . "/includes/ui/ui_input.inc");


print_price_listing();
//----------------------------------------------------------------------------------------------------



function sort_areas($areas)
{
	$old_order = 0;
	foreach($areas as $key => $area) {
		$areas[$key][] = $old_order++;
	}
	uasort($areas,'comp_areas');
	return $areas;
}

//----------------------------------------------------------------------------------------------------

function print_price_listing()
{
    global $path_to_root, $SysPrefs;


    $security_role =  $_POST['PARAM_0'];

    $active_inactive =  $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];
	$opportunity_id = $_POST['PARAM_4'];
    // display_error($opportunity_id);
    // exit;

	$REPORT_ID = 1000;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

   $myrow= get_subscription_agreement_opportunity($opportunity_id );
  	
  		$_POST['id'] =  $myrow['id'];
		$_POST['reference'] =  $myrow['reference'];
		$_POST['title'] =  $myrow['title'];
		$_POST['dates'] =  sql2date($myrow['dates']);

		$_POST['provider'] =  $myrow['provider'];
		$_POST['provider_representative'] =  $myrow['provider_representative'];
		$_POST['provider_email'] =  $myrow['provider_email'];
		$_POST['provider_address'] =  $myrow['provider_address'];
		$_POST['provider_desgination'] =  $myrow['provider_desgination'];

		$_POST['client'] =  $myrow['client'];
		$_POST['client_representative'] =  $myrow['client_representative'];
		$_POST['client_email'] =  $myrow['client_email'];
		$_POST['client_address'] =  $myrow['client_address'];
		$_POST['client_desgination'] =  $myrow['client_desgination'];



     $cols = array(4, 15, 50, 150, 275,  515,15);
	$aligns = array('left',	'left',	'center', 'left', 'right', 'right', 'center');

	// $params = array('comments' => $comments, 'packing_slip' => $packing_slip);


    $rep = new FrontReport(_('Cloud Services Agreement'), "AccessLevel", user_pagesize(), 9, $orientation);
    
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->SetHeaderType('header4');
    $rep->NewPage();
		
    		
  			

  			$rep->NewLine(15);
    		$rep->fontSize +=6;
    		$rep->TextCol(6, 5,'LIST OF MODULES & FEATURES');
  			$rep->NewLine(2);
  			$rep->TextCol(6, 5,'FOR WAYZ ERP');
  			$rep->NewLine(2);
  			$rep->TextCol(6, 5,'PRESENTED TO');
  			$rep->NewLine(2);
  			$rep->TextCol(6, 5,'PHOENIXMCTLLC');
  			$rep->NewLine();
    		$rep->fontSize -=6;


    		$rep->fontSize -=2;
    		$rep->TextWrapLines2(40,530,90,'Proprietary Notice: This document contains confidential information proprietary to Wayz Consulting and may not be reproduced, copied or used for purposes other than its intended use without the prior written consent of Wayz Consulting; the information in this document is subject to change with management approval only','center');
    		$rep->fontSize +=2;

  			//page 1  ---------------------------------------------------------------------------------------
   //  		$rep->NewPage();
   //  		$rep->row=700;

   //  		 $cols = array(4, 30, 100, 330, 405,505,  545,150);
   //  		$aligns = array('left',	'center',	'left', 'center', 'center');

 		// 	$rep->Info($params, $cols, $headers, $aligns);

			// $rep->RoundedRect(75, 222, 450,22,2.25, '','DF',null,array(91,155,213));//RECTANGLE
			// $rep->rectangle(75, 600, 450,200, "F", null, array(222, 231, 236));   
			
			//  $rep->SetDrawColor(128, 128, 128);
			//  // rows
			// $rep->LineTo(75,400,75,620);
			// $rep->LineTo(290,400,290,620);
			// $rep->LineTo(525,400,525,620);

			// // coloums
			// $rep->LineTo(75,600,525,600);
			// $rep->LineTo(75,550,525,550);
			// $rep->LineTo(75,500,525,500);
			// $rep->LineTo(75,450,525,450);
			// $rep->LineTo(75,400,525,400);


			// $rep->fontSize +=1;
   //  		$rep->NewLine(8);
   //  		$rep->TextCol(2, 2,'   Provider');
   //  		$rep->TextCol(3, 4,'Client');
   //  		$rep->fontSize -=1;

   //  		$rep->NewLine(1);
   //  		$rep->TextCol(2, 2,$_POST['Provider']);
   //  		$rep->TextCol(3, 4,$_POST['Client']);

   //  		$rep->NewLine(2);
   //  		$rep->TextCol(2, 2, $_POST['provider_representative']);
   //  		$rep->TextCol(3, 4, $_POST['client_representative']);

   //  		$rep->NewLine(4);
   //  		$rep->TextCol(2, 2, $_POST['provider_email']);
   //  		$rep->TextCol(3, 4,$_POST['client_email']);

   //  		$rep->NewLine(4);
   //  		$rep->TextCol(2, 2, $_POST['provider_address']);
   //  		$rep->TextCol(3, 4,$_POST['client_address']);

   //  		$rep->NewLine(4);
   //  		$rep->TextCol(2, 2, $_POST['provider_desgination']);
   //  		$rep->TextCol(3, 4,$_POST['client_desgination']);

   //  		$rep->TextWrapLines2(500,550,50,'Page 1/15','left');

    		//page 2 ---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		 $cols = array(4, 15, 50, 150, 275,  515,15);
			$aligns = array('left',	'left',	'center', 'left', 'right', 'right', 'center');

 			$rep->Info($params, $cols, $headers, $aligns);


    		$rep->NewLine(5);
    		$rep->fontSize +=15;
    		$rep->Font('u');
    		$rep->TextCol(6, 5,'Cloud Services Agreement');
    		$rep->fontSize -=15;
    		    $rep->Font();

    		$rep->NewLine(3);
    		$rep->TextColLines(1, 5,'This legally binding '.$_POST['title'].' (the “Agreement”) is made effective as of the '.$_POST['dates'].' (the “Effective Date”).');
    		
			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(6, 5,'BY AND BETWEEN');
    		$rep->fontSize -=5;

    		$rep->NewLine(2);
    		$rep->TextColLines(1, 5,'Wayz ERP running its principal place of business at address office 501 The light commercial tower Arjan, Dubai, United Arab Emirates, (hereinafter referred to as the “Service Provider” or “Provider) of the FIRST PART;');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(6, 5,'AND');
    		$rep->fontSize -=5;


    		$rep->NewLine(2);
    		$rep->TextColLines(1, 5,$_POST['client'].', represented by '.$_POST['client'].' having its registered office at address '.$_POST['address'].', (hereinafter referred to as the “Client”) of the SECOND PART;');

    		$rep->NewLine(2);
    		$rep->TextColLines(1, 5,'Each of the Provider and the Client shall be referred to individually as a “Party”, and together they may be referred to as the “Parties”.');

    		
    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(6, 5,'WITNESSETH');
    		$rep->fontSize -=5;


    	
    		$rep->NewLine(2);
    		$rep->TextColLines(1, 5,'(A) WHEREAS, the CLIENT is of the opinion that the PROVIDER has the necessary skills, qualifications, expertise, experience and abilities to provide Service(s) to the CLIENT;');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'(B) WHEREAS, the CLIENT desires to engage the PROVIDER to perform, provide and deliver the Service(s);');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'(C) WHEREAS, the PROVIDER is agreeable to providing such Service(s) to the CLIENT on the request of CLIENT subject to the terms and conditions set out in this Agreement;');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'(D) WHEREAS, each Party is duly authorized and capable of entering into this Agreement.');


    		$rep->NewLine();
    		// $rep->Font('B');
    		$rep->TextColLines(1, 5,'          NOW, THEREFORE, for the mutual consideration set forth herein, the adequacy of which is hereby acknowledged, the PROVIDER and the CLIENT, hereby agree as follows:');
    		// $rep->Font();
    		
    		$rep->TextWrapLines2(500,550,50,'Page 2/15','left');

    		// page 3---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;
    		$rep->fontSize +=5;   		
    		$rep->NewLine(2);
    		$rep->TextCol(1, 5,'1. AGREEMENT CHANGE HISTORY:');
    		$rep->fontSize -=5;

			$rep->SetDrawColor(189, 214, 238);
			$rep->RoundedRect(40, 175, 525,22,2.25, '','DF',null,array(91,155,213));//RECTANGLE

			$rep->rectangle(40, 645, 525,120, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);
			 // row
			$rep->LineTo(40,667,40,525);
			$rep->LineTo(100,667,100,525);
			$rep->LineTo(180,667,180,525);
			$rep->LineTo(380,667,380,525);
			$rep->LineTo(564,667,564,525);


			// colum
			$rep->LineTo(40,665,565,665);
			$rep->LineTo(40,645,565,645);
			$rep->LineTo(40,585,565,585);
			$rep->LineTo(40,525,565,525);




    		$rep->fontSize +=1;   		
    		$rep->NewLine(2);
    		$rep->TextCol(1, 2,'Version');
    		$rep->TextCol(2, 3,'Date');
    		$rep->TextCol(3, 5,'Changes made to this version');
    		$rep->TextCol(4, 5,'Updated by (Provider/Client)');
    		$rep->fontSize -=1;   		


    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'1.');
    		$rep->TextCol(2, 3,$_POST['dates']);
    		$rep->TextCol(3, 5,'Creation and Signing of Agreement');
    		$rep->TextCol(4, 5,'_______________');

    		$rep->NewLine(3);
    		$rep->TextCol(1, 2,'2.');
    		$rep->TextCol(2, 3,'_______________');
    		$rep->TextCol(3, 4,'_______________');
    		$rep->TextCol(4, 5,'_______________');


    		$rep->NewLine(6);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'2. SERVICE(s):');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Service(s) provided by the Provider to the Client will include provisioning of WayZ ERP system, implementation support, training, one-time customization and such other Service(s) as the Provider may specify to the Client from time to time. The Scope of Work agreed between the Client and the Provider at the proposal level is further attached to this Agreement as Appendix (A).');
    		

    		

    		$rep->NewLine();
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'3. SERVICE FEE:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Client shall pay to the Provider, a Service Fee for the Service(s) provided by the Provider to the Client in accordance with the Pricing Terms attached to this Agreement as Appendix (B). In the event of delay by the Client in payment of Service Fee to the Provider, the Provider shall be entitled to stop the provision of further Service(s) till such time that the payment of outstanding dues is made by the Client.  In the event of any Service(s) provided, that are not included in the list of Service(s) as specified in this Agreement, the Parties shall mutually agree upon the Service Fee of such Service(s). The Agreement shall not be terminated in between the duration of its operation unless and until the Client has paid or cleared all the Service Fee due for being paid.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'2. CONDITIONS OF SERVICE(s) AVAILABILITY:');
    		$rep->fontSize -=5;


 			$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'In order to enable the Provider to provide Service(s) in an efficient and smooth manner to the Client, the Client shall:');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'1. use devices that have the ability to access the internet;');



    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'2. make payment for the subscription of Service(s);');



    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'3. absolutely refrain from using any automated means to access the services including using a bot and ensure that only a natural person (User) accesses the Service(s);');



    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'4. ensure that the User must have the knowledge, experience and training of the business cycle that the User also gets the rights to perform for;');


    		$rep->NewLine(2);
    		$rep->TextColLines(0, 5,'and fulfill such other reasonable requirements that the Provider may specify from time to time.');

    		$rep->TextWrapLines2(500,550,50,'Page 3/15','left');

    		//page 4---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;
    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'5. SERVICE AVAILABILITY:');
    		$rep->fontSize -=5;



    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Service(s) provided by the Provider will be expected to operate and function 24/7 ("24 hours a day and 7 days a week”) with an uptime of 99% (Ninety-Nine Percentage). However, the Service(s) will not function or operate during the time of maintenance or any scheduled maintenance or resolving emergency breakdown.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'6. SERVICE MAINTENANCE:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider uses IAAS (Infrastructure as a Service) or Cloud Infrastructure as a platform hosting the provisioning of Service(s). The Provider will inform the Client regarding the scheduled maintenance if AWS notifies the Provider of the time schedule of the scheduled maintenance. In case of emergency disruption to the Service(s), the Client may expect an estimated time of arrival between 30 (Thirty) to 90 (Ninety) minutes.');


    		// //page 4
    		// $rep->NewPage();
    		// $rep->row=700;

    		$rep->NewLine(2);
    		$rep->fontSize +=5;  		
    		$rep->TextCol(1, 5,'7. SERVICE RESPONSE:');
    		$rep->fontSize -=5;

			$rep->RoundedRect(40, 344, 525,24,2.25, '','DF',null,array(91,155,213));//RECTANGLE

			$rep->rectangle(40, 475, 525,310, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);

			 // coloum
			$rep->LineTo(40,165,40,499);
			$rep->LineTo(170,165,170,499);
			$rep->LineTo(410,165,410,499);
			$rep->LineTo(565,165,565,499);

			// row
			$rep->LineTo(40,475,565,475);
			$rep->LineTo(40,400,565,400);
			$rep->LineTo(40,325,565,325);
			$rep->LineTo(40,250,565,250);
			$rep->LineTo(40,165,565,165);


    		$rep->fontSize +=2;  		
    		$rep->NewLine(2);
    		$rep->TextCol(1, 2,'  Priority');
    		// $rep->TextCol(2, 3,'Date');
    		$rep->TextCol(3, 4,'  Definition');
    		$rep->TextCol(4, 5,'Response Time (In hours)');
    		$rep->fontSize -=2;


    		$rep->NewLine(3);
    		$rep->TextCol(1, 2,'Critical');
    		$rep->TextCol(4, 5,'Within 2 Hours');
    		$rep->TextWrapLines(180,240,'Responses to the Client’s inability to access the Service(s). For instance, Server Breakdown.','left');




    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'High');
    		$rep->TextCol(4, 5,'Within 4 Hours');
    		$rep->TextWrapLines(180,240,'Responses to the Client’s inability to run critical functionality due to a bug. For instance, unable to create invoices after updates.','left');


    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'Medium');
    		$rep->TextCol(4, 5,'Within 24 Hours');
    		$rep->TextWrapLines(180,240,'Responses to the Client’s need of configuration/customization of policy, form, or report.','left');




    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'Low');
    		$rep->TextCol(4, 5,'Within 24 Hours');	
    		$rep->TextWrapLines(180,240,'Responses to question regarding the features in general.','left');
    		

    		$rep->TextWrapLines2(500,550,50,'Page 4/15','left');

    

    		// page 5 ---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'8. SERVICE SUPPORT:');
    		$rep->fontSize -=5;



    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider will provide 24*7*365 ("24 hours a day, 7 days a week and 365 days a year”) technical support for the Service(s) provided to the Client with an uptime of 99.999% ("Ninety-Nine and Nine hundred Ninety-Nine Thousandths"). The functional support for the Service(s) will be provided to the Client only during the office working hours of the Provider. The functional support through the mode of telephone and email will be provided as per the following:');

    		$rep->NewLine();
    		$rep->TextCol(2, 5,'i. Telephone support: 8 A.M., to 6 P.M., Sunday – Thursday');

    		$rep->NewLine(2);
    		$rep->TextCol(0, 5,'Calls received out of office hours will be dealt with on the next working day');



    		$rep->NewLine(2);
    		$rep->TextCol(2, 5,'ii. Email support: 8 A.M., to 6 P.M., Sunday – Thursday       ');

    		$rep->NewLine(2);
    		$rep->TextCol(0, 5,'Emails received outside of office hours will be dealt with on the next working day.');
 

    		$rep->NewLine(3);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'8. SERVICE CONTINUITY');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider has taken the necessary steps to ensure the continuity of Service(s) in the event of any disruption caused to the Service(s). In case the Client has any doubts or queries regarding the service continuity then the Client must contact the Provider to seek the necessary clarifications regarding the same.');
 



 			$rep->NewLine(2);
    		$rep->fontSize +=5;		
    		$rep->TextCol(1, 5,'10. SERVICE SCALABILITY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Client may, at any time during the continuity of the Agreement, request to the Provider for an increase in the number of User(s) using the Service(s). The Provider will review the request and address the same with 24 (Twenty-Four) to 48 (Forty-Eight) hours.');
 

 			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'11. SERVICE SECURITY:');
    		$rep->fontSize -=5;   		

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'Best coding practices and best cloud services are engaged by the Provider for making the provisioning of Service(s) secured.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'12. CONFIDENTIALITY:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Parties shall keep all matters pertaining to any exchange of information relating to the Service(s), any transaction(s) details and all information gathered, obtained, or exchanged as confidential including the Agreement herein, and shall not disclose it to any third party not entitled to receive it.');

    		$rep->TextWrapLines2(500,550,50,'Page 5/15','left');

    		//  page 6---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		$rep->NewLine();
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'13. RETURN OF PROPERTY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0,5,'                     '.'Upon the expiry or termination of this Agreement, the Client shall return to the Provider any property or documentation or records or confidential information belonging to the Provider.');



			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'14. AUTONOMY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'Except as otherwise provided in this Agreement, the Provider shall have full control over working time, methods, and decision making in relation to the performance of Service(s) in accordance with the Agreement. The Provider will work autonomously and not at the direction of the Client.');


			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'15. NO EXCLUSIVITY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Client acknowledges and agrees that this Agreement is non-exclusive and that the Provider will be free, during and after the term, to engage and contract with third parties in relation to the Service(s) similar to the Service(s) provided herein under this Agreement.');



			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'16. INDEPENDENT CONTRACTOR:');
    		$rep->fontSize -=5; 		

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider shall, at all times, remain an independent contractor and nothing in this Agreement shall be construed to create the relationship of employer and employee, principal and agent, partnership or joint venture, or any other fiduciary relationship between the Client and Provider.');





			$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'17. SUB-CONTRACTOR:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider may, at its absolute discretion, engage a third-party sub-contractor to perform some or all of the obligations of the Provider under this Agreement.');



    		$rep->NewLine();
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'18. FURTHER ASSURANCES:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'In connection with this Agreement, as well as all transactions contemplated by this Agreement, the Client agrees to execute and deliver such additional documents and to perform such additional actions as may be necessary, appropriate or reasonably requested by the Provider to carry out or evidence the transactions contemplated hereby.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'19. LIABILITY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Provider shall not be liable for any direct, indirect, special, incidental, or consequential loss or damage, whether based on contract or tort or any other legal theory, arising out of any action or inaction of the Client under this Agreement or use or inability to use the Service(s) performed and delivered under this Agreement, including, without limitation, damages for loss of profits, loss of data, business interruption or any other commercial damages or losses. Certain jurisdictions do not allow exclusions on certain damages and liabilities and in such cases, the above exclusion may not be applicable and in the jurisdictions wherein such exclusions are permitted then the exclusion shall apply to the fullest extent.');

    		$rep->TextWrapLines2(500,550,50,'Page 6/15','left');

    		///page 7---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		$rep->NewLine();
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'20. INDEMNITY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The Client shall defend, indemnify, and hold the Provider harmless from and against any costs, losses, damages, liabilities, expenses, demands, and judgments, including court costs and attorney fees arising out of or resulting from the actions or inactions or omissions or breach or falsity or violation, or inaccuracy of or in any representation, warranty, obligation, or covenant made by the Client under this Agreement for which the Client would be liable in law or equity.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'21. DURATION:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'This Agreement shall become effective as of the effective date and shall continue in force for a duration of 1 (One) year unless terminated earlier as per the provisions of this Agreement. Upon termination of this Agreement, a period of six months will be granted by the Provider to the Client for accessing the cloud-based ERP on a free basis with view capability only.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'22. TERMINATION:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The parties may terminate this Agreement either by mutual consent or this Agreement may be terminated by a party (non-breaching party) in the event of a material breach by the other party (breaching party) and by giving a 30 (thirty) business days prior written notice to the breaching party to cure the material breach and the material breach continues or hasn’t been cured. For the purpose of this clause, a “Material Breach” shall include any violation of the clauses of this Agreement, any other breach that the breaching party has failed to cure within 21 (twenty-one) business days after the receipt of the prior written notice in this regard from the non-breaching party, or an act of gross negligence or wilful misconduct by any party.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'23. WAIVER:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'No waiver provided by the Provider for any default of the Client shall be deemed as a waiver of any prior or subsequent default of the same or other provisions of this Agreement.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'24. AMENDMENTS:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'Any change, alteration, amendment, or modification to this Agreement must be in writing and executed or signed by authorized representatives of both parties.');




    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'25. NOTICE:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'Any and all notifications, notices, communications, requests, consents, approvals, agreements, authorizations, acknowledgments, waiver with regard to this Agreement shall be made in written form and delivered to the responding party through the means of Registered Postal Delivery or Registered Courier or Email or any other means as agreed between parties from time to time.');


    		$rep->TextWrapLines2(500,550,50,'Page 7/15','left');
    		 
    		//page 8---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;
    		$cols = array(20, 60, 225, 240,  450, 515);
			$rep->Info($params, $cols, null, $aligns);


			$rep->RoundedRect(50, 150, 470,22,2.25, '','DF',null,array(91,155,213));//RECTANGLE

			$rep->rectangle(50, 670, 470,130, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);
			 // coloum
			$rep->LineTo(50,540,50,692);
			$rep->LineTo(270,540,270,692);
			$rep->LineTo(520,540,520,692);

			// row
			$rep->LineTo(50,670,520,670);
			$rep->LineTo(50,605,520,605);

			$rep->LineTo(50,540,520,540);

    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 2,'“Provider”');
    		// $rep->TextCol(2, 3,'Date');
    		$rep->TextCol(3, 4,'                  “Client”');
    		$rep->fontSize -=5;

    		$rep->NewLine(3);
    		$rep->TextCol(0, 2,'1. Email:');
    		$rep->TextCol(3, 4,'1. Email:');
    		$rep->NewLine(2);
    		$rep->TextCol(0, 3,$_POST['provider_email']);
    		$rep->TextCol(3, 5,$_POST['client_email']);

    		$rep->NewLine(3);
    		$rep->TextCol(0, 2,'2. Office Address (Postal Delivery or Courier):');
    		$rep->TextCol(3, 4,'2. Office Address (Postal Delivery or Courier):');
    		$rep->NewLine(2);
    		$rep->TextCol(0, 3, $_POST['provider_address']);
    		$rep->TextCol(3, 5,$_POST['client_address']);


    		
       		$cols = array(4, 15, 50, 150, 275,  515);
			$rep->Info($params, $cols, null, $aligns);


    		$rep->NewLine(5);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'26. SEVERABILITY:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'If any provision of this Agreement is determined by any court or other competent authority to be unlawful and/or unenforceable, then such provision shall either be modified to reflect the parties’ intention or completely deleted and the other provisions of this Agreement will continue in effect. If any unlawful and/or unenforceable provision would be lawful or enforceable if part of it were deleted, that part will be deemed to be deleted, and the rest of the provision will continue in effect (unless that would contradict the clear intention of the parties, in which case the entirety of the relevant provision will be deemed to be deleted).');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'27. SURVIVABILITY:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The parties understand and agree that all terms of this Agreement that require continued performance, compliance, or effect beyond the termination date of the Agreement shall survive such termination date and shall be enforceable in the event of a failure to perform or comply.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'28. FORCE MAJEURE:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'Neither party shall be liable for any loss or delay resulting from any force majeure event, including acts of God, fire, natural disaster, labour stoppage, war or military hostilities, pandemic, lockdown or inability of carriers to make scheduled deliveries, and any payment or delivery date shall be extended to the extent of any delay resulting from any force majeure event.');

    		$rep->TextWrapLines2(500,550,50,'Page 8/15','left');

    		// page 9---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'29. HEADINGS:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'The numbering and headings are solely for convenience and reference only and shall not affect the scope, meaning, intent, or interpretation of the provisions of this Agreement, nor shall such headings otherwise be given any legal effect.');



    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'30. DISPUTE RESOLUTION:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'If in case, any controversy, conflict, or dispute of any nature arises between the parties, arising out of, or in connection or in relation to this Agreement, the Parties shall spend at least 15 days to try and use all means to amicably resolve that dispute or conflict or controversy.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'31. GOVERNING LAW:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'This Agreement is governed and construed in accordance with the laws of DIFC (Dubai International Financial Centre). Any dispute, difference, controversy, or claim arising out of or in connection to or in relation with this Agreement, including (but not limited to) any question regarding its existence, validity, interpretation, performance, discharge, and applicable remedies, shall be subject to the exclusive jurisdiction of the DIFC Courts. However, the Client gives the Provider the right to choose which applicable laws shall apply to any dispute or issue regarding this agreement. The Client further gives the Provider the right to file a complaint or initiate a legal proceeding regarding any dispute arising out of this Agreement or in relation to this Agreement or in connection to this Agreement in the country of residence of the Client or the country where Client carries its business or the country where the Client is located or such other place as the Provider deems fit as per its sole discretion.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'32. ENTIRE AGREEMENT:');
    		$rep->fontSize -=5;

    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'This Agreement, and any annexures, scope of Work, schedules, duplicates, or copies, constitutes the entire Agreement for the subject matter provided herein and shall supersede any and all previous negotiations, representations, agreements, arrangements, and understandings between the parties put in place either by written form or orally, preceding the date of this Agreement.');


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'33. COUNTERPARTS:');
    		$rep->fontSize -=5;


    		$rep->NewLine(1.2);
    		$rep->TextColLines(0, 5,'                     '.'This Agreement may be signed in counterparts as necessary, each of which shall be deemed to be an original, and all of which together shall constitute one and the same instrument. The Agreement whether signed in digital mode or physical mode shall have the same validity and legal effect.');

    		$rep->TextWrapLines2(500,550,50,'Page 9/15','left');

    		// page 10---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;
    		$cols = array(60, 100,190, 265, 280,  490, 515,230);
			$rep->Info($params, $cols, null, $aligns);


    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(2, 4,'SIGNATURE PAGE');
    		$rep->fontSize -=5;


    		// $rep->rectangle(50, 670, 500,100, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);

			 //colums
			$rep->LineTo(90,670,510,670);
			// $rep->LineTo(90,620,510,620);
			$rep->LineTo(90,570,510,570);
			$rep->LineTo(90,520,510,520);
			$rep->LineTo(90,470,510,470);
			$rep->LineTo(90,425,510,425);
			$rep->LineTo(90,380,510,380);

			// rows
			$rep->LineTo(90,380,90,670);
			$rep->LineTo(290,380,290,670);
			$rep->LineTo(510,380,510,670);

    		$rep->NewLine(3);
    		$rep->TextCol(0, 2,'For,');
    		$rep->TextCol(3, 4,'For,');
    		$rep->NewLine(4);
    		$rep->TextCol(0, 2,'Name of the Provider ('.$_POST['provider'].'),');
    		$rep->TextCol(3, 5,'Name of Client ('.$_POST['client'].'),');

    		$rep->NewLine(4);
    		$rep->TextCol(0, 2,'Signature:');

    		$rep->TextWrapLines2(305, 150,555,'Signature:');


    		$rep->NewLine(4);
    		// $rep->TextCol(0, 2,'By: (Name of the Representative or Agent signing on behalf)');

    		$rep->TextWrapLines2(100, 190,510,'By: (Name of the Representative or Agent signing on behalf)');

    		$rep->TextWrapLines2(305, 190,510,'By: (Name of the Representative or Agent signing on behalf)');


    		$rep->NewLine(4);
    		$rep->TextCol(0, 7,'Designation/Position: '.$_POST['provider_desgination']);
    		$rep->TextCol(3, 6,'Designation/Position: '.$_POST['client_desgination']);
    		// $rep->TextWrapLines(255,257,'Designation/Position:','left');


    		$rep->NewLine(4);
    		$rep->TextCol(0, 2,'Date: '.$_POST['dates']);
    		$rep->TextCol(3, 5,'Date: '.$_POST['dates']);

    		$rep->TextWrapLines2(500,550,50,'Page 10/15','left');


    		// page 11---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		$cols = array(4, 20, 50, 150, 250,330,350,380, 515,150);
    		$aligns = array('left',	'left',	'left', 'left',	'left',	'left','left','left','left','center'	);
 			$rep->Info($params, $cols, $headers, $aligns);


    		$rep->NewLine(5);
    		$rep->fontSize +=5;
    		$rep->TextCol(9, 5,'APPENDIX (A) - SCOPE OF WORK');
    		$rep->fontSize -=5;


    		$rep->RoundedRect(50, 222, 500,22,2.25, '','DF',null,array(91,155,213));//RECTANGLE
			$rep->rectangle(50, 600, 500,150, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);
			 // rows
			$rep->LineTo(50,450,50,620);
			$rep->LineTo(87,450,87,620);
			$rep->LineTo(187,450,187,620);
			$rep->LineTo(287,450,287,620);

			$rep->LineTo(362,450,362,620);
			$rep->LineTo(415,450,415,620);
			$rep->LineTo(550,450,550,620);

			// coloums
			$rep->LineTo(50,600,550,600);
			$rep->LineTo(50,550,550,550);
			$rep->LineTo(50,500,550,500);
			$rep->LineTo(50,450,550,450);

			$rep->fontSize +=1;
    		$rep->NewLine(3);
    		$rep->TextCol(1, 2,'S.No');
    		$rep->TextCol(2, 3,'Short Description');
    		$rep->TextCol(3, 4,'Detail Description');
    		$rep->TextCol(4, 5,'Attachments');
    		$rep->TextCol(5, 6,'Edit');
    		$rep->TextCol(7, 8,'Delete With Attachment');
    		$rep->fontSize -=1;

    		$rep->TextWrapLines2(500,550,50,'Page 11/15','left');

    		// page 12----------------------------------------------------------------------------------------
    		
    		$rep->NewPage();
    		$rep->row=700;


    		$cols = array(4, 40, 75, 330, 405,505,  545,150);
    		$aligns = array('left',	'left',	'left', 'center', 'center');
 			$rep->Info($params, $cols, $headers, $aligns);



    		$rep->NewLine(4);
    		$rep->fontSize +=5;
    		$rep->TextColLines(7, 5,' APPENDIX (B) – PRICING TERMS');
    		$rep->fontSize -=5;

			$rep->RoundedRect(75, 222, 450,22,2.25, '','DF',null,array(91,155,213));//RECTANGLE
			$rep->rectangle(75, 600, 450,150, "F", null, array(222, 231, 236));   
			
			 $rep->SetDrawColor(128, 128, 128);
			 // rows
			$rep->LineTo(75,450,75,620);
			$rep->LineTo(105,450,105,620);
			$rep->LineTo(372,450,372,620);
			$rep->LineTo(455,450,455,620);
			$rep->LineTo(525,450,525,620);

			// coloums
			$rep->LineTo(75,600,525,600);
			$rep->LineTo(75,550,525,550);
			$rep->LineTo(75,500,525,500);
			$rep->LineTo(75,450,525,450);



    		$rep->fontSize +=1;
    		$rep->NewLine(3);
    		$rep->TextCol(1, 2,'S.No');
    		$rep->TextCol(2, 3,'Description');
    		$rep->TextCol(3, 4,'  Payment Term');
    		$rep->TextCol(4, 5,'AED');
    		$rep->fontSize -=1;


    		$rep->NewLine(3);
    		$rep->TextCol(1, 2,'1.');
    		$rep->TextCol(2, 3,'Annual Wayz ERP Subscription per user');
    		$rep->TextCol(3, 4,'UPP*');
    		$rep->TextCol(4, 5,'2,500/-');

    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'2.');
    		$rep->TextCol(2, 3,'Annual HRLOGs Subscription per user');
    		$rep->TextCol(3, 4,'FP**');
    		$rep->TextCol(4, 5,'1,500/-');

    		$rep->NewLine(4);
    		$rep->TextCol(1, 2,'3.');
    		$rep->TextCol(2, 3,'One time Training, Implementation & Customization Fee');
    		$rep->TextCol(3, 4,'FP**');
    		$rep->TextCol(4, 5,'10,000/-');


    		$rep->NewLine(8);
    		$rep->TextColLines(1, 5,'*Upon approval of this agreement');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'**Fifty percent (50 %) upon approval and Fifty Percent upon completion of training.');

    		$rep->NewLine(2);
    		$rep->fontSize +=5;
    		$rep->TextCol(1, 5,'Terms and Conditions');
    		$rep->fontSize -=5;


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'1. Minimum Ten (10) users will be charged for Wayz ERP annually.');


    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'2. Minimum Ten (10) users will be charged for HRLogs annually.');

    		$rep->NewLine();
    		$rep->TextColLines(1, 5,'3. All Prices are exclusive of VAT and other government fees and charges.');


    		$rep->TextWrapLines2(500,550,50,'Page 12/15','left');

    		// page 13---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

    		   $cols = array(4, 15,25,45, 50, 150, 275,  515,120);
    		$aligns = array('left',	'left',	'left',	'left',	'left', 'center', 'center');

 			$rep->Info($params, $cols, $headers, $aligns);


    		$rep->NewLine(5);	
    		$rep->fontSize +=5;
    		$rep->TextCol(8, 7,'APPENDIX (C) – MODULES AND FEATURES');
    		$rep->fontSize -=5;

    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(0, 5,'WayZ ERP Features');
    		$rep->fontSize -=1;
    		$rep->NewLine(2);
    		$rep->TextCol(1, 5,'1. Introduction');
    		$rep->fontSize -=1;
    		$rep->Font();

    		$rep->NewLine(2);
    		$rep->TextCol(2, 7,'WayZ ERP',-2);
    		$rep->TextColLines(2, 7,'WayZ ERP offers Effective and Efficient Accounting and business management solution. Features are specifically designed for MENA region. Silent features are as follows;',-2);

    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'=> Cloud Based software allows whole organization to work as team.');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'=> Real Time reporting enable Strategic Management to take decision on time');
    		$rep->NewLine(1);
    		$rep->TextCol(3,7,'=> Multi Language Reporting help Management on different level to be on same page.');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'=> VAT compliance.');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'=> Electronic Document Management.');

    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(0, 5,'Modules');
    		$rep->fontSize -=2;
    		$rep->Font();

    		$rep->NewLine(1);
    		$rep->TextCol(2, 7,'Following modules and features are part of this proposal;');


    		// -------------------------------------------------------------
    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(2, 7,'2.6 Reports');
    		$rep->fontSize -=2;
    		$rep->Font();

    		$rep->NewLine(2);
    		$rep->TextCol(3, 7,'Print, Email and Convert into PDF; all the reports');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Export the reports in Ms Excel format');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Generate reports on periodic and financial years basis');

    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Email documents directly to customers');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Make graphical analysis (Horizontal/Vertical Bars, Dot Lines, Pies and Donuts)');

    		// -------------------------------------------------------------
    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(2, 7,'2.7 Access levels and Adaptation');
    		$rep->fontSize -=2;
    		$rep->Font();

    		$rep->NewLine(2);
    		$rep->TextCol(3, 7,'Separate financial years can be created and closed against entries');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Multi user access with different privileges');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Make backups and restore for companies');

    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Date Picker with week numbers for all date fields');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Simple Audit Trails');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Extensions for customizing menu tabs and applications');


    		// -------------------------------------------------------------
    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(2, 7,'2.8 Multi-Currency Support');
    		$rep->fontSize -=2;
    		$rep->Font();

    		$rep->NewLine(2);
    		$rep->TextCol(3, 7,'Historical Currency Rates');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Multi-Currency Bank Accounts, Customers And Suppliers');


    		// -------------------------------------------------------------
    		$rep->NewLine(3);
    		$rep->fontSize +=2;
    		$rep->Font("u");
    		$rep->TextCol(2, 7,'2.9 Advanced VAT handling');
    		$rep->fontSize -=2;
    		$rep->Font();

    		$rep->NewLine(2);
    		$rep->TextCol(3, 7,'VAT can be selected on Customer, Supplier and Item basis');
    		$rep->NewLine(1);
    		$rep->TextCol(3, 7,'Advanced GST/VAT report for details and outputs/input');



    		$rep->TextWrapLines2(500,550,50,'Page 13/15','left');

    		// page 13---------------------------------------------------------------------------------------
    		$rep->NewPage();
    		$rep->row=700;

	$cols = array(15, 45, 360, 385, 430, 515);
	$aligns = array('left',	'left',	'left', 'right', 'right');
	$rep->Info($params, $cols, $headers, $aligns);
    

	function get_quotation_matter_byid($selected_id){
    $sql = "SELECT agreement_matter FROM ".TB_PREF."agreements_matters 
    		WHERE agreement_no = ".db_escape($selected_id)." 
    		ORDER BY id DESC LIMIT 1 ";

    $result = db_query($sql);
    	return db_fetch($result)['agreement_matter'];
	}	


    $order_no = 3;
	$matter = get_quotation_matter_byid($order_no);
	$textperline=wordwrap($matter,85,"\r\n");
	
	$pages = str_split($textperline, 2000);
	
	foreach($pages as $page){
		// $rep->writeHTMLCell('510','410','20','100',$page, false, false, false, false, '');
		$rep->MultiCell('510','410', $page, 0, false, false, false, '20', '125', false, 0, true);
		$rep->NewPage();
  		$rep->row=700;

  		$cols = array(15, 45, 360, 385, 430, 515);
		$aligns = array('left',	'left',	'left', 'right', 'right');
		$rep->Info($params, $cols, $headers, $aligns);

	}
	
	


// if ($file = fopen($matter, "r")) {
//     while(!feof($file)) {
//         $textperline = fgets($file);
//          // echo $textperline;
//      }
//     fclose($file);
//  }


    // $current_role = $security_role;
    //  global $security_areas, $security_sections;
    // $m=0;
    // $counter=0;
//     foreach($security_sections as $key=>$value){
//         	$rep->fontSize += 2;
//     		$rep->Font("u");
// 			$rep->TextCol(0, 3,$value);
//     		$rep->Font();
    		
// // 			$catgor = $myrow['description'];
// 			$rep->fontSize -= 2;
// 			$rep->NewLine(2);
//             foreach(sort_areas($security_areas) as $area =>$parms ) {
//                 if (user_company() && (($parms[0]&0xff00) == SS_SADMIN)) continue;
//                 $newsec = ($parms[0]>>8)&0xff;
//                 $newext  = $parms[0]>>16;
//                 if ($newsec != $sec || (($newext != $ext) && ($newsec>99))){ // features set selection
//                 $ext = $newext; 
//                 $sec = $newsec;
//                 $m = $parms[0] & ~0xff;
//                 }
//                 //   display_error($parms[0]."====".$key);
//                 if($m==$key){
                    
//                     if($active_inactive == 1){
//                         if(in_array($parms[0],get_security_role_agreement_by_opportunity($current_role)['areas'])== 0)
//                             continue;
//                     }else if($active_inactive == 2){
//                         // display_error(in_array($parms[0],get_security_role_agreement_by_opportunity($current_role)['areas']));
//                         if(in_array($parms[0],get_security_role_agreement_by_opportunity($current_role)['areas'])== 1)
//                             continue;
//                     }
//                         $rep->TextCol(1, 2,$counter.'  '.$parms[1]);
                        
//                         // if(in_array($parms[0],get_security_role_agreement_by_opportunity($current_role)['areas'])== 1){
//                         //     $active = "Active";
//                         // }else{
//                         //     $active = "Inactive";
//                         // }
//                         // $rep->TextCol(4, 5,$active);
//                         $rep->NewLine();
//                     $counter++;
//                 }
                
//             }
// 			// $rep->Line($rep->row  - 1);
// 			$rep->NewLine();
//     	}





    $rep->End();
}

