<?php

$page_security = 'SA_CUSTBALANCE';

// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//----------------------------------------------------------------------------------------------------

print_customer_balances();
//----------------------------------------------------------------------------------------------------

function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------


function get_open_balance($debtorno, $to)
{
	if($to)
		$to = date2sql($to);

     $sql = "SELECT SUM(IF(t.type = ".ST_SALESINVOICE." OR (t.type = ".ST_JOURNAL." AND t.ov_amount>0),
     	-abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount), 0)) AS charges,";
     $sql .= "SUM(IF(t.type != ".ST_SALESINVOICE." AND NOT(t.type = ".ST_JOURNAL." AND t.ov_amount>0),
     	abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount) * -1, 0)) AS credits,";
     $sql .= "SUM(IF(t.type != ".ST_SALESINVOICE." AND NOT(t.type = ".ST_JOURNAL." AND t.ov_amount>0), t.alloc * -1, t.alloc)) AS Allocated,";

 	$sql .=	"SUM(IF(t.type = ".ST_SALESINVOICE.", 1, -1) *
 			(abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount) - abs(t.alloc))) AS OutStanding
		FROM ".TB_PREF."debtor_trans t
    	WHERE t.debtor_no = ".db_escape($debtorno)
		." AND t.type <> ".ST_CUSTDELIVERY;
    if ($to)
    	$sql .= " AND t.tran_date < '$to'";
	$sql .= " GROUP BY debtor_no";

    $result = db_query($sql,"No transactions were returned");
    return db_fetch($result);
}

function get_transactions($debtorno, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);

 	$allocated_from = 
 			"(SELECT trans_type_from as trans_type, trans_no_from as trans_no, date_alloc, sum(amt) amount
 			FROM ".TB_PREF."cust_allocations alloc
 				WHERE person_id=".db_escape($debtorno)."
 					AND date_alloc <= '$to'
 				GROUP BY trans_type_from, trans_no_from) alloc_from";
 	$allocated_to = 
 			"(SELECT trans_type_to as trans_type, trans_no_to as trans_no, date_alloc, sum(amt) amount
 			FROM ".TB_PREF."cust_allocations alloc
 				WHERE person_id=".db_escape($debtorno)."
 					AND date_alloc <= '$to'
 				GROUP BY trans_type_to, trans_no_to) alloc_to";

     $sql = "SELECT trans.*,
 		(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount) AS TotalAmount,
 		IFNULL(alloc_from.amount, alloc_to.amount) AS Allocated,
 		((trans.type = ".ST_SALESINVOICE.")	AND trans.due_date < '$to') AS OverDue
     	FROM ".TB_PREF."debtor_trans trans
 			LEFT JOIN ".TB_PREF."voided voided ON trans.type=voided.type AND trans.trans_no=voided.id
 			LEFT JOIN $allocated_from ON alloc_from.trans_type = trans.type AND alloc_from.trans_no = trans.trans_no
 			LEFT JOIN $allocated_to ON alloc_to.trans_type = trans.type AND alloc_to.trans_no = trans.trans_no

     	WHERE trans.tran_date >= '$from'
 			AND trans.tran_date <= '$to'
 			AND trans.debtor_no = ".db_escape($debtorno)."
 			AND trans.type <> ".ST_CUSTDELIVERY."
 			AND ISNULL(voided.id)
     	ORDER BY trans.tran_date";
    return db_query($sql,"No transactions were returned");
}

function getBankTrans ($type = null, $transNo = null)
{
	$sql = " SELECT pdcStatus, transfered, bounce_cheque, pdcDate, amount FROM ".TB_PREF."bank_trans
	WHERE trans_no=".db_escape($transNo)." 
	AND type=".db_escape($type)." ";
	$res = db_query($sql, 'coulnot run getBankTrans');
	$ft = db_fetch($res);
	return($ft);

}

function getpaymentbyinvoice ($type = null, $transNo = null)
{
	$sql = " SELECT bt.pdcStatus,bt.transfered,bt.bounce_cheque,  custAlloc.trans_no_from AS trans_no, custAlloc.trans_type_from AS trans_type 
	FROM ".TB_PREF."cust_allocations custAlloc
	LEFT JOIN ".TB_PREF."bank_trans bt ON custAlloc.trans_type_from = bt.type AND custAlloc.trans_no_from=bt.id

	WHERE custAlloc.trans_no_to=".db_escape($transNo)." 
	AND custAlloc.trans_type_to=".db_escape($type)." ";
	$res = db_query($sql, 'coulnot run getBankTrans');
	$ft = db_fetch($res);
	return($ft);

}

//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
    	global $path_to_root, $systypes_array;

    	$from = $_POST['PARAM_0'];
    	$to = $_POST['PARAM_1'];
    	$fromcust = $_POST['PARAM_2'];
    	$show_pdc = $_POST['PARAM_3'];
    	$show_items = $_POST['PARAM_4'];
    	$show_balance = $_POST['PARAM_5'];
    	$currency = $_POST['PARAM_6'];
    	$no_zeros = $_POST['PARAM_7'];
    	$comments = $_POST['PARAM_8'];
		$orientation = $_POST['PARAM_9'];
		$destination = $_POST['PARAM_10'];
		$REPORT_ID = 101;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromcust == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($fromcust);
    	$dec = user_price_dec();

	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home Currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');

	$cols = array(0, 105, 150, 205,	260, 320, 405, 480,	560);

	$headers = array(_('Trans Type'), _('#'), _('Date'), _('Due Date'), _('Charges'), _('Credits'),
		_('Allocated'), _('Outstanding'));

	if ($show_balance)
		$headers[7] = _('Balance');
	$aligns = array('left',	'left',	'left',	'left',	'right', 'right', 'right', 'right');
    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 		'to' => $to),
    				    2 => array('text' => _('Customer'), 'from' => $cust,   	'to' => ''),
    				    3 => array('text' => _('Currency'), 'from' => $currency, 'to' => ''),
						4 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => ''));

    // $rep = new FrontReport(_('Customer Balances'), "CustomerBalances", user_pagesize(), 9, $orientation);

            
    $rep = new FrontReport(_('Customer Balances'), "CustomerBalances", 'A4_REP', 9, $orientation);









    if ($orientation == 'L')
    	recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$grandtotal = array(0,0,0,0);

	$sql = "SELECT debtor_no, name, curr_code FROM ".TB_PREF."debtors_master ";
	if ($fromcust != ALL_TEXT)
		$sql .= "WHERE debtor_no=".db_escape($fromcust);
	$sql .= " ORDER BY name";
	$result = db_query($sql, "The customers could not be retrieved");

	if ($show_items != 0){
				$rep->fontSize -= 1;
				$rep->TextCol(0, 1, "Stock ID");
				$rep->TextCol(1, 3, "Description");
				$rep->TextCol(3, 4, "Quantity");
				$rep->TextCol(4, 5, "Price");
				$rep->TextCol(5, 6, "Total");
				$rep->fontSize += 1;
				$rep->Line($rep->row  - 4);
				$rep->NewLine(2);
}

	while ($myrow = db_fetch($result))
	{
		if (!$convert && $currency != $myrow['curr_code']) continue;
		
		$accumulate = 0;
		$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
		$bal = get_open_balance($myrow['debtor_no'], $from, $convert);
		$init[0] = $init[1] = 0.0;
		$init[0] = round2(abs($bal['charges']*$rate), $dec);
		$init[1] = round2(Abs($bal['credits']*$rate), $dec);
		$init[2] = round2($bal['Allocated']*$rate, $dec);
		if ($show_balance)
		{
			$init[3] = $init[0] - $init[1];
			$accumulate += $init[3];
		}	
		else	
			$init[3] = round2($bal['OutStanding']*$rate, $dec);

		$res = get_transactions($myrow['debtor_no'], $from, $to);
		if ($no_zeros && db_num_rows($res) == 0) continue;

		$rep->fontSize += 2;
                   // customer 

			if ($destination)
		  $rep->TextCol(0, 2, $myrow['name']);
		   else
		   {
		    	$oldrow = $rep->row;
				$rep->TextColLines(0, 2, $myrow['name']);
		        $newrow = $rep->row;
				$rep->row = $oldrow;
		   }

		if ($convert)
			$rep->TextCol(2, 3,	$myrow['curr_code']);
		$rep->fontSize -= 2;
		$rep->TextCol(3, 4,	_("Open Balance"));
		$rep->AmountCol(4, 5, $init[0], $dec);
		$rep->AmountCol(5, 6, $init[1], $dec);
		$rep->AmountCol(6, 7, $init[2], $dec);
		$rep->AmountCol(7, 8, $init[3], $dec);
		$total = array(0,0,0,0);
		for ($i = 0; $i < 4; $i++)
		{
			$total[$i] += $init[$i];
			$grandtotal[$i] += $init[$i];
		}
		  if (!$destination)
			$rep->row = $newrow;
		$rep->NewLine(1, 2);
		$rep->Line($rep->row + 4);
		if (db_num_rows($res)==0) {
			$rep->NewLine(1, 2);
			continue;
		}
		while ($trans = db_fetch($res))
		{
			$bankTransData = array();
			if($trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKPAYMENT || $trans['type'] == ST_BANKDEPOSIT){
				$bankTransData = getBankTrans($trans['type'], $trans['trans_no']);
			}
			else{
				$bankTransData['pdcStatus'] = 0;
				$bankTransData['transfered'] = 0;
				$bankTransData['bounce_cheque'] = 0;
			}
            if ($bankTransData['pdcStatus'] == 1) continue;


            if ($no_zeros) {
                if ($show_balance) {
                    if ($trans['TotalAmount'] == 0) continue;
                } else {
                    if (floatcmp($trans['TotalAmount'], $trans['Allocated']) == 0) continue;
                }
            }
			$rep->NewLine(1, 2);
			$rep->TextCol(0, 1, $systypes_array[$trans['type']]);
			$rep->TextCol(1, 2,	$trans['reference']);
			$rep->DateCol(2, 3,	$trans['tran_date'], true);
			if ($trans['type'] == ST_SALESINVOICE)
				$rep->DateCol(3, 4,	$trans['due_date'], true);
			$item[0] = $item[1] = 0.0;
			if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
				$trans['TotalAmount'] *= -1;
			if ($trans['TotalAmount'] > 0.0)
			{
				$item[0] = round2(abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(4, 5, $item[0], $dec);
				$accumulate += $item[0];
				$item[2] = round2($trans['Allocated'] * $rate, $dec);
			}
			else
			{
				$item[1] = round2(Abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(5, 6, $item[1], $dec);
				$accumulate -= $item[1];
				$item[2] = round2($trans['Allocated'] * $rate, $dec) * -1;
			}
			$rep->AmountCol(6, 7, $item[2], $dec);
			if ($trans['type'] == ST_SALESINVOICE || $trans['type'] == ST_BANKPAYMENT || $trans['type'] == ST_JOURNAL)
				$item[3] = $item[0] - $item[2];
			else	
				$item[3] = -$item[1] - $item[2];
			if ($show_balance)	
				$rep->AmountCol(7, 8, $accumulate, $dec);
			else	
				$rep->AmountCol(7, 8, $item[3], $dec);
			for ($i = 0; $i < 4; $i++)
			{
				$total[$i] += $item[$i];
				$grandtotal[$i] += $item[$i];
			}
			if ($show_balance)
				$total[3] = $total[0] - $total[1];
				
				
				// for sales invoice
			if ($show_items != 0 && $trans['type']==ST_SALESINVOICE) {
				$rep->Line($rep->row - 8);
				$rep->NewLine(2);
		
				$result2 = get_customer_trans_details(ST_SALESINVOICE, $trans['trans_no']);
				while ($myrow2 = db_fetch($result2)) {

		$value = round2(($myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"],
		   user_price_dec());

					$rep->TextCol(0, 1, $myrow2["stock_id"]);
					$rep->TextCol(1,3, $myrow2["StockDescription"]);
					$rep->AmountCol(3, 4, $myrow2["quantity"], $dec);
					$rep->AmountCol(4, 5, $myrow2["unit_price"], $dec);
					$rep->AmountCol(5, 6, $value, $dec);
					$rep->NewLine(1);
				} //end while
					$rep->Line($rep->row  - 4);
					$rep->NewLine(1);
	
			}  //end if

// for customer credit note 
				if ($show_items != 0 && $trans['type']==ST_CUSTCREDIT) {
				$rep->Line($rep->row - 8);
				$rep->NewLine(2);
		
				$result3 = get_customer_trans_details(ST_CUSTCREDIT, $trans['trans_no']);
				while ($myrow3 = db_fetch($result3)) {

		$value3 = round2(($myrow3["unit_price"] * $myrow3["quantity"]) - $myrow3["discount_percent"],
		   user_price_dec());

					$rep->TextCol(0, 1, $myrow3["stock_id"]);
					$rep->TextCol(1,3, $myrow3["StockDescription"]);
					$rep->AmountCol(3, 4, $myrow3["quantity"], $dec);
					$rep->AmountCol(4, 5, $myrow3["unit_price"], $dec);
					$rep->AmountCol(5, 6, $value3, $dec);
					$rep->NewLine(1);
				} //end while
					$rep->Line($rep->row  - 4);
					$rep->NewLine(1);
	
			}  //end if
			
		}
		$rep->Line($rep->row - 8);
		$rep->NewLine(2);
		$rep->TextCol(0, 3, _('Total'));
		for ($i = 0; $i < 4; $i++)
			$rep->AmountCol($i + 4, $i + 5, $total[$i], $dec);
   		$rep->Line($rep->row  - 4);
   		$rep->NewLine(0.5);

   		// ________________________________  PDC DATA BELOW________________________
	   	if($show_pdc == 1){

	   			if (!$convert && $currency != $myrow['curr_code']) continue;
		
			$accumulate = 0;
			$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
			$bal = get_open_balance($myrow['debtor_no'], $from, $convert);
			$init[0] = $init[1] = 0.0;
			$init[0] = round2(abs($bal['charges']*$rate), $dec);
			$init[1] = round2(Abs($bal['credits']*$rate), $dec);
			$init[2] = round2($bal['Allocated']*$rate, $dec);

			if ($show_balance){
				$init[3] = $init[0] - $init[1];
				$accumulate += $init[3];
			}	
			else	
				$init[3] = round2($bal['OutStanding']*$rate, $dec);

			$res = get_transactions($myrow['debtor_no'], $from, $to);
			if ($no_zeros && db_num_rows($res) == 0) continue;

			$rep->fontSize += 2;
	   		$rep->NewLine(1.5);

			if ($destination)
			  	$rep->TextCol(0, 2, ' PDC RECIEVE');
			else{
			    $oldrow = $rep->row;
				$rep->TextColLines(0, 2, ' PDC RECIEVE');
				$rep->row = $oldrow;
			}
	   		
	   		$rep->NewLine(0.5);
			$rep->fontSize -= 2;
			

			$newrow = $rep->row;
			$total = array(0,0,0,0);
			$pdctotal = array(0,0,0,0);

			for ($i = 0; $i < 4; $i++){
				$pdctotal[$i] += $init[$i];
				$total[$i] += $init[$i];
				$grandtotal[$i] += $init[$i];
			}


			if (!$destination)
				$rep->row = $newrow;
			
			if (db_num_rows($res)==0){
				$rep->NewLine(1, 2);
				continue;
			}
			$ccc = 0;
			$totalPdcAmount = 0;
			while ($trans = db_fetch($res)){
				$getpaymentbyinvoice = getpaymentbyinvoice(ST_SALESINVOICE, $trans['trans_no']);

				$ccc++;
				$bankTransData = array();
				if($trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKPAYMENT || $trans['type'] == ST_BANKDEPOSIT){
						$bankTransData = getBankTrans($trans['type'], $trans['trans_no']);
				}
				else{
					$bankTransData['pdcStatus'] = 0;
					$bankTransData['transfered'] = 0;
					$bankTransData['bounce_cheque'] = 0;
					$bankTransData['pdcDate'] = "";
				}
	            if ($bankTransData['pdcStatus'] == 0 || $bankTransData['bounce_cheque'] == 1 ) continue;
	            if ($no_zeros) {
	                if ($show_balance) {
	                    if ($trans['TotalAmount'] == 0) continue;
	                }else{
	                    if (floatcmp($trans['TotalAmount'], $trans['Allocated']) == 0) continue;
	                }
	            }
				$rep->NewLine(1, 2);

				if($bankTransData['pdcStatus'] == 1 )
					$rep->SetTextColor(237,7,10);


				$rep->TextCol(0, 1, $systypes_array[$trans['type']]);
				$rep->TextCol(1, 2,	$trans['reference']);
				$rep->DateCol(2, 3,	$trans['tran_date'], true);
				if ($trans['type'] == ST_SALESINVOICE)
					$rep->DateCol(3, 4,	$trans['due_date'], true);
				else
					$rep->DateCol(3, 4,	$bankTransData['pdcDate'], true);
				$item[0] = $item[1] = 0.0;
				if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
					$trans['TotalAmount'] *= -1;



				$pdcAmount = round2($bankTransData['amount']*$rate, $dec);
				// $init[9] = round2($checkamount*$rate, $dec);
				$rep->AmountCol(7, 8, $pdcAmount, $dec);
				$totalPdcAmount += $pdcAmount;

				if($bankTransData['pdcStatus'] == 1 )
					$rep->SetTextColor(0,0,0);	
			}

			$rep->Line($rep->row - 11);
			$rep->Line($rep->row - 13);
			$rep->NewLine(2);
			$rep->TextCol(0, 3, _('PDC Total'));
			$rep->TextCol(0, 3, _('PDC Total'));
				
			$rep->AmountCol(7, 8, $totalPdcAmount, $dec);

			$rep->Line($rep->row  - 4);
			// $rep->Line($rep->row  - 6);
			$rep->NewLine(2);
			
	   	}
		$rep->NewLine(2);
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3, _('Grand Total'));
	$rep->fontSize -= 2;
	if ($show_balance)
		$grandtotal[3] = $grandtotal[0] - $grandtotal[1];
	for ($i = 0; $i < 4; $i++)
		$rep->AmountCol($i + 4, $i + 5, $grandtotal[$i], $dec);
	$rep->Line($rep->row  - 4);
	$rep->NewLine();


    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }


    	$rep->End();
}

