<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_INVOICE' : 'SA_PRINT_INVOICE';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Invoices
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");





//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------------------
function get_invoice_range($from, $to)
{
	global $SysPrefs;

	$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");

	$sql = "SELECT trans.trans_no, trans.reference, trans.type
		FROM ".TB_PREF."debtor_trans trans 
			LEFT JOIN ".TB_PREF."voided voided ON trans.type=voided.type AND trans.trans_no=voided.id
		WHERE trans.type=".ST_SALESINVOICE
			." AND ISNULL(voided.id)"
			." AND trans.reference>=".db_escape(get_reference(ST_SALESINVOICE, $from))
			." AND trans.reference<=".db_escape(get_reference(ST_SALESINVOICE, $to))
		." ORDER BY trans.tran_date, trans.$ref";

	return db_query($sql, "Cant retrieve invoice range");
}


// display_error($_SESSION['SysPrefs']->prefs['rep_style']);
if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
print_invoices_new();
else
print_invoices();



//----------------------------------------------------------------------------------------------------

function print_invoices()
{
	global $path_to_root, $SysPrefs;
	
	$show_this_payment = true; // include payments invoiced here in summary

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$pay_service = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$customer = $_POST['PARAM_6'];
	$orientation = $_POST['PARAM_7'];
	$REPORT_ID = 107;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	//-------------code-Descr-Qty--uom--tax--prc--Disc-Tot--//
	$cols = array(4, 60, 225, 260, 280, 340, 395, 450, 500);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'right', 'center', 'right', 'right', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('INVOICE'), "InvoiceBulk", user_pagesize(), 9, $orientation);
	if ($orientation == 'L')
		recalculate_cols($cols);

	$range = get_invoice_range($from, $to);
	while($row = db_fetch($range))
	{
			if (!exists_customer_trans(ST_SALESINVOICE, $row['trans_no']))
				continue;
			$sign = 1;
			$myrow = get_customer_trans($row['trans_no'], ST_SALESINVOICE);

			if ($customer && $myrow['debtor_no'] != $customer) {
				continue;
			}
			if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
				continue;
			}
			$baccount = get_default_bank_account($myrow['curr_code']);
			$params['bankaccount'] = $baccount['id'];

			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER);
			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				$rep->title = _('INVOICE');
				$rep->filename = "Invoice" . $myrow['reference'] . ".pdf";
			}	
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], true);
			$baccount['payment_service'] = $pay_service;
			$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_SALESINVOICE, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();
			// calculate summary start row for later use
			$summary_start_row = $rep->bottomMargin + (10.5 * $rep->lineHeight);

			if ($rep->formData['prepaid'])
			{
				$result = get_sales_order_invoices($myrow['order_']);
				$prepayments = array();
				while($inv = db_fetch($result))
				{
					$prepayments[] = $inv;
					if ($inv['trans_no'] == $row['trans_no'])
					break;
				}

				if (count($prepayments) > ($show_this_payment ? 0 : 1))
					$summary_start_row += (count($prepayments)) * $rep->lineHeight;
				else
					unset($prepayments);
			}

   			$result = get_customer_trans_details(ST_SALESINVOICE, $row['trans_no']);
			$SubTotal = 0;
			while ($myrow2=db_fetch($result))
			{
				if ($myrow2["quantity"] == 0)
					continue;
                $Net = round2(($sign *   $myrow2["unit_price"] * $myrow2["quantity"])-$myrow2["discount_percent"],
				   user_price_dec());

				// $Net = round2($sign * ((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
				//    user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net,$dec);
	    		if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['StockDescription'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
					
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
				// 	display_error($DisplayQty."/".$kit_qty);exit;
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($row['trans_no'], $row['type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}
	    		if ($myrow2["discount_percent"]==0)
		  			$DisplayDiscount ="0.00";
	    		else
		  			$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) . "";
				$c=0;
				
                $SpecDescription = "";
				if($myrow2["spec_description"])
					$SpecDescription = "\n".$myrow2["spec_description"];
				$complete_description = $myrow2['StockDescription'].$SpecDescription." \n ".get_specs_for_ids(explode(',',$myrow2['item_specs']));
				$desc_len += strlen($complete_description);
				// display_error($desc_len);
				if($desc_len>=700){
				    $rep->NewPage();
				    $desc_len = 0;
				}
				
				
				
				
				$rep->TextCol($c++, $c,	$myrow2['stock_id'], -2);

				$oldrow = $rep->row;
				$rep->TextColLines($c++, $c, $complete_description, -2);
				$newrow = $rep->row;
				$rep->row = $oldrow;
				if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
				{
					$rep->TextCol($c++, $c,	$DisplayQty, -2);
					$rep->TextCol($c++, $c,	$myrow2['units'], -2);
					$rep->TextCol($c++, $c,	$DisplayPrice, -2);
					$rep->TextCol($c++, $c,	$DisplayDiscount, -2);
					$rep->TextCol($c++, $c,	($myrow2['quantity'] * $myrow2['unit_tax']), -2);
					$rep->TextCol($c++, $c,	$DisplayNet, -2);
				}
				$rep->row = $newrow;
				//$rep->NewLine(1);
				if ($rep->row < $summary_start_row)
					$rep->NewPage();
			}

			$memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			if ($memo != "")
			{
				$rep->NewLine();
				$rep->TextColLines(1, 3, $memo, -2);
			}

   			$DisplaySubTot = number_format2($SubTotal,$dec);

			// set to start of summary line:
    		$rep->row = $summary_start_row;
			if (isset($prepayments))
			{
				// Partial invoices table
				$rep->TextCol(0, 3,_("Prepayments invoiced to this order up to day:"));
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->cols[2] -= 20;
				$rep->aligns[2] = 'right';
				$rep->NewLine(); $c = 0; $tot_pym=0;
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->TextCol($c++, $c, _("Date"));
				$rep->TextCol($c++, $c,	_("Invoice reference"));
				$rep->TextCol($c++, $c,	_("Amount"));

				foreach ($prepayments as $invoice)
				{
					if ($show_this_payment || ($invoice['reference'] != $myrow['reference']))
					{
						$rep->NewLine();
						$c = 0; $tot_pym += $invoice['prep_amount'];
						$rep->TextCol($c++, $c,	sql2date($invoice['tran_date']));
						$rep->TextCol($c++, $c,	$invoice['reference']);
						$rep->TextCol($c++, $c, number_format2($invoice['prep_amount'], $dec));
					}
					if ($invoice['reference']==$myrow['reference']) break;
				}
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->NewLine();
				$rep->TextCol(1, 2,	_("Total payments:"));
				$rep->TextCol(2, 3,	number_format2($tot_pym, $dec));
			}


			$doctype = ST_SALESINVOICE;
    		$rep->row = $summary_start_row;
			$rep->cols[2] += 20;
			$rep->cols[3] += 20;
			$rep->aligns[3] = 'left';
			$words = price_in_words(replace_chars($DisplaySubTot, array(",")), ST_SALESINVOICE);

// 			$rep->TextCol(0, 6, _("Sub-total : ".$words), -2);
            $words = price_in_words(replace_chars($DisplaySubTot, array(",")), ST_SALESINVOICE);
            $bankacc_row = get_default_bank_account('AED');
            $rep->TextCol(0, 6, _("Sub-Total : ".$words." "."(".$bankacc_row['bank_curr_code'].")"), -2);
			
			$rep->TextCol(7, 8,	 $DisplaySubTot, -2);
			$rep->NewLine();
			if ($myrow['ov_freight'] != 0.0)
			{
   				$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
				$rep->TextCol(3, 6, _("Shipping"), -2);
				$rep->TextCol(7, 8,	$DisplayFreight, -2);
				$rep->NewLine();
			}	
			$tax_items = get_trans_tax_details(ST_SALESINVOICE, $row['trans_no']);
			$first = true;
    		while ($tax_item = db_fetch($tax_items))
    		{
    			if ($tax_item['amount'] == 0)
    				continue;
    			$DisplayTax = number_format2($sign*$tax_item['amount'], $dec);
				$words = price_in_words(replace_chars($tax_item['amount'], array(",")), ST_SALESINVOICE);

    			if ($SysPrefs->suppress_tax_rates() == 1)
    				$tax_type_name = $tax_item['tax_type_name'];
    			else
    				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) : ".$words;

    			if ($myrow['tax_included'])
    			{
    				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
    				{
    					if ($first)
    					{
							$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
							$rep->TextCol(7, 8,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
							$rep->NewLine();
    					}
						$rep->TextCol(0, 6, $tax_type_name, -2);
						$rep->TextCol(7, 8,	$DisplayTax, -2);
						$first = false;
    				}
    				else
						$rep->TextCol(0, 6, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
				}
    			else
    			{
					$bankacc_row = get_default_bank_account('AED');
					$rep->TextCol(0, 6, $tax_type_name." (".$bankacc_row['bank_curr_code'].")", -2);
					$rep->TextCol(7, 8,	$DisplayTax, -2);
				}
				// $rep->NewLine();
    		}

    // 		$rep->NewLine();
    		if ($myrow["ov_discount"]) {
	    		$rep->TextCol(3, 6,  _("Redeem points"), - 2);
				$rep->TextCol(7, 8, number_format2($myrow["ov_discount"],$dec), -2);
    		}
    		$rep->NewLine();
			$DisplayTotal = number_format2($sign*($myrow["ov_freight"] + $myrow["ov_gst"] +
				$myrow["ov_amount"]+$myrow["ov_freight_tax"]-$myrow["ov_discount"]),$dec);
			$rep->Font('bold');
			$words = price_in_words(replace_chars($DisplayTotal, array(",")), ST_SALESINVOICE);

			if (!$myrow['prepaid']) $rep->Font('bold');
				$bankacc_row = get_default_bank_account('AED');
				$rep->TextCol(0, 6, $rep->formData['prepaid'] ? _("TOTAL ORDER VAT INCL:") : _("TOTAL INVOICE : ".$words." "."(".$bankacc_row['bank_curr_code'].")"), - 2);
			$rep->TextCol(7, 8, $DisplayTotal, -2);
			if ($rep->formData['prepaid'])
			{
				$rep->NewLine();
				$rep->Font('bold');
				$rep->TextCol(0, 6, $rep->formData['prepaid']=='final' ? _("THIS INVOICE") : _("TOTAL INVOICE : ".$words), - 2);
				$rep->TextCol(7, 8, number_format2($myrow['prep_amount'], $dec), -2);
			}
			$words = price_in_words($rep->formData['prepaid'] ? $myrow['prep_amount'] : $myrow['Total']
				, array( 'type' => ST_SALESINVOICE, 'currency' => $myrow['curr_code']));
			if ($words != "")
			{
				$rep->NewLine(1);
				$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
			}
			$rep->Font();
			if ($email == 1)
			{
				$rep->End($email);
			}
		
  	//-------------------------------------------------------------------------
// Bank Account Section
    $rep->rectangle($rep->leftMargin, 120, 270, 22, "F", null, array(222, 231, 236)); 
    $rep->rectangle($rep->leftMargin, 120, 270, 22, "", null, array(222, 231, 236));
    $rep->rectangle($rep->leftMargin, 120, 270, 100, "", null, array(222, 231, 236));
//=====================================



$cols = array(4, 55, 70, 200, 240, 255, 265, 360, 335, 450, 550);
$aligns = array('left',	'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');
$rep->Info($params, $cols, null, $aligns);
$rep->row = 103;
$rep->fontSize += 1;
$rep->Font('bold');
$rep->TextCol(0, 2, _("Bank Details:"), - 2);
$rep->Font('');
$rep->fontSize -= 1;
$rep->NewLine(1.5);
$bankacc_row = get_default_bank_account('AED');
$rep->TextCol(0, 2, _("Account Name"), -2);
$rep->TextCol(2, 6,	": Mister Xpert Technical Services" , -2);
$rep->NewLine();
$rep->TextCol(0, 2, _("Account #"), - 2);
$rep->TextCol(2, 6,	": " .$bankacc_row['bank_account_number'], -2);
$rep->NewLine();
$rep->TextCol(0, 2, _("IBAN"), - 2);
$rep->TextCol(2, 6,	": " .$bankacc_row['iban'], -2);
$rep->NewLine();
$rep->TextCol(0, 2, _("Bank Name"), - 2);
$rep->TextCol(2, 6,	": " .$bankacc_row['bank_name'], -2);
$rep->NewLine();
$rep->TextCol(0, 2, _("Address"), - 2);
$rep->TextColLines(2, 7, ": ".$bankacc_row['bank_address'], - 2);
			
	}

// ==============================================================================================================================
// New Code added here by Waleed to print terms & conditions on a new page;
// 04/10/2022
	$range = get_invoice_range($from, $to);
	$temp_var_1 = db_fetch($range);
	// $temp_var_1['trans_no'];

	$res = get_customer_trans_details(ST_CUSTDELIVERY,$temp_var_1['trans_no']);
	$terms = db_fetch($res);

	$terms_and_conditions = company_path()."/images/terms_and_conditions/".$terms['stock_id'].".jpg";
	if (file_exists($terms_and_conditions) && $terms['stock_id']) {
		$rep->SetHeaderType();
		$rep->NewPage();
		$rep->AddImage($terms_and_conditions,0,0,600,850);
	}
$rep->GetImagePolicy($rep->rep_id);
// ==============================================================================================================================

	if ($email == 0)
		$rep->End();
}


//-------------------------new Invoice Format Function-----------------------------------------------//






function print_invoices_new()
{
	global $path_to_root, $SysPrefs;
	
	$show_this_payment = true; // include payments invoiced here in summary

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$pay_service = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$customer = $_POST['PARAM_6'];
	$orientation = $_POST['PARAM_7'];
	$REPORT_ID = 107;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	//-------------code-Descr-Qty--uom--tax--prc--Disc-Tot--//
	$cols = array(4, 60, 230, 275, 350, 420, 460, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'center', 'left', 'left', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('INVOICE'), "InvoiceBulk", user_pagesize(), 9, $orientation);
	if ($orientation == 'L')
		recalculate_cols($cols);

	$range = get_invoice_range($from, $to);
	while($row = db_fetch($range))
	{

			if (!exists_customer_trans(ST_SALESINVOICE, $row['trans_no']))
				continue;
			$sign = 1;
			$myrow = get_customer_trans($row['trans_no'], ST_SALESINVOICE);

			if ($customer && $myrow['debtor_no'] != $customer) {
				continue;
			}
			if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
				continue;
			}
			$baccount = get_default_bank_account($myrow['curr_code']);
			$params['bankaccount'] = $baccount['id'];

			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER);
			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				$rep->title = _('INVOICE');
				$rep->filename = "Invoice" . $myrow['reference'] . ".pdf";
			}	
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], true);
			$baccount['payment_service'] = $pay_service;
			$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_SALESINVOICE, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();
			// calculate summary start row for later use
			$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);

			if ($rep->formData['prepaid'])
			{
				$result = get_sales_order_invoices($myrow['order_']);
				$prepayments = array();
				while($inv = db_fetch($result))
				{
					$prepayments[] = $inv;
					if ($inv['trans_no'] == $row['trans_no'])
					break;
				}

				if (count($prepayments) > ($show_this_payment ? 0 : 1))
					$summary_start_row += (count($prepayments)) * $rep->lineHeight;
				else
					unset($prepayments);
			}

   			$result = get_customer_trans_details(ST_SALESINVOICE, $row['trans_no']);
			$SubTotal = 0;
			$alt_clr = 1;
			$total_rec = db_num_rows($result);
		
			
	
			// display_error(db_num_rows($result));	
			

			$right = $rep->pageWidth - $rep->rightMargin;
			$count__ = 0;
			$print_rec = 0;
			// $start = $rep->row-477;
         $rep->row+=5;

			while ($myrow2=db_fetch($result))
			{
			    $item_image_array[] =  $myrow2['stock_id'];
     //                 if($count__== 1)  
					// $rep->NewLine(0.5);


              // for ($i=1; $i<=5 ; $i++) { 
              	# code...
            

				/**/
				if ($myrow2["quantity"] == 0)
					continue;
                $Net = round2(($sign *   $myrow2["unit_price"] * $myrow2["quantity"])-$myrow2["discount_percent"],
				   user_price_dec());

				// $Net = round2($sign * ((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
				//    user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net,$dec);
	    		if ($myrow2["discount_percent"]==0)
		  			$DisplayDiscount ="";
	    		else
		  			$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) . "";
		         $c=0;
				
                   
				$rep->TextCol($c++, $c,	$myrow2['stock_id'], -2);
				$oldrow = $rep->row;
				$rep->TextColLines($c++, $c, $myrow2['StockDescription'], -2);
				///display_error($oldrow."-".$newrow);
      //                if($count__ % 2 == 0)


				$newrow = $rep->row;
				$rep->row = $oldrow;

			//	$rep->SetAlpha(0.5);


		    if($print_rec % 2 == 0)
	      	$rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(189,214,238));  
            else
            $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));   
              //  	$rep->SetAlpha(1);
                     $c=0;
                     	$oldrow = $rep->row;
                	$rep->TextCol($c++, $c,	$myrow2['stock_id'], -2);
                	$rep->TextColLines($c++, $c, $myrow2['StockDescription'], -2);
                		$newrow = $rep->row;
			        	$rep->row = $oldrow;
			              		// $rep->TextCol(5,6,	$count__, -2);
				if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
				{

					$rep->TextCol($c++, $c,	$DisplayQty, -2);
					$rep->TextCol($c++, $c,	$myrow2['units'], -2);
					$rep->TextCol($c++, $c,	$DisplayPrice, -2);
					$rep->TextCol($c++, $c,	$DisplayDiscount, -2);
					$rep->TextCol($c++, $c,	$DisplayNet, -2);
				}
// 91,155,213
// 	$rep->SetDrawColor(91,155,213);


  //                 $rep->SetTextColor(0, 0, 0);
		// 			$rep->SetAlpha(0.5);
		// $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));  
  //               	$rep->SetAlpha(1);
				$rep->row = $newrow;
				if(($oldrow-$newrow)>12)
						$count__++;
						if(($oldrow-$newrow)>24)
						$count__++;

				
				
			    $print_rec++;
				$count__++;

			       if($count__>35 && ($total_rec-$print_rec)>1)
					    {	
					    	$rep->LineTo(41,533,41,$rep->row+10);
			    //          
							$rep->LineTo(564,533,564,$rep->row+10);

                        }
                         else
                         {
                             $rep->LineTo(41,533,41,150);




	                         $rep->LineTo(564,533,564,150);


                         }












				   if($rep->pageNumber>=1)
					{
						// display_error($count__." (".$total_rec."  -".$print_rec.")");
								       if($count__>31 && ($total_rec-$print_rec)<=1)
			   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
			   					   	 $total_rec-=$print_rec;
			   					   	 $count__=0;
			   					   	 $print_rec=0;
									$rep->NewPage();
									  $rep->row+=5;

					}
           
                   
                   }

                     else
                     { 
                             
                      // display_error($count__." = ".$total_rec."-".$print_rec);	
                      if($count__>32 && ($total_rec-$print_rec)<=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	 $count__=0;
   					   	 $print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;

						}
                     }
						  if(($count__>40 || $count__>=39 ) && ($total_rec-$print_rec)>=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	$count__=0;
						$print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;
						}

				// }  // for loop		
			}
			
			
				   if($rep->pageNumber>=1)
       	           $rep->LineTo(41,150,564,150);
       	            else
                   $rep->LineTo(41,$rep->row+10,564,$rep->row+10);
                   
                 // display_error($rep->pageNumber);
      
					           $rep->SetDrawColor(189, 214, 238);
			$rep->RoundedRect(40, 67.4+640, 290,20,2.25, '','DF',null,array(91,155,213));
			$rep->SetTextColor(255, 255, 255);
	           // display_error(67.4." + 55");
			$rep->TextWrap(50,67.4+55,150,"Memo");//50,152,150
			$rep->SetTextColor(0, 0, 0);

			$rep->RoundedRect(40,67.4+660, 290,65,2.25, '','DF',null,array(222, 234, 246));

			$memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			$memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			if ($memo != "")
			{
				//$rep->NewLine();
				$rep->cols[3]=350;
				$rep->TextWrapLines2(45,300,115, $memo, -2);
			}

 // $rep->NewLine(5);
			// $memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			// $memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			// if ($memo != "")
			// {
			// 	$rep->NewLine();
			// 	$rep->TextColLines(1, 3, $memo, -2);
			// }

   			$DisplaySubTot = number_format2($SubTotal,$dec);

			// set to start of summary line:
    		$rep->row = $summary_start_row;
			if (isset($prepayments))
			{
			    
				// Partial invoices table
				$rep->TextCol(0, 3,_("Prepayments invoiced to this order up to day:"));
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->cols[2] -= 20;
				$rep->aligns[2] = 'right';
				$rep->NewLine(); $c = 0; $tot_pym=0;
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->TextCol($c++, $c, _("Date"));
				$rep->TextCol($c++, $c,	_("Invoice reference"));
				$rep->TextCol($c++, $c,	_("Amount"));

				foreach ($prepayments as $invoice)
				{
					if ($show_this_payment || ($invoice['reference'] != $myrow['reference']))
					{
						$rep->NewLine();
						$c = 0; $tot_pym += $invoice['prep_amount'];
						$rep->TextCol($c++, $c,	sql2date($invoice['tran_date']));
						$rep->TextCol($c++, $c,	$invoice['reference']);
						$rep->TextCol($c++, $c, number_format2($invoice['prep_amount'], $dec));
					}
					if ($invoice['reference']==$myrow['reference']) break;
				}
				$rep->TextCol(0, 3,	str_pad('', 150, '_'));
				$rep->NewLine();
				$rep->TextCol(1, 2,	_("Total payments:"));
				$rep->TextCol(2, 3,	number_format2($tot_pym, $dec));
			}

    		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
    		$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);

			$doctype = ST_SALESINVOICE;
    		$rep->row = $summary_start_row-85;
			$rep->cols[2] += 20;
			$rep->cols[3] += 25;
			$rep->aligns[3] = 'left';
         
			$rep->TextCol(3, 6, _("  Sub-total"), +2,0,1,1);
			$rep->TextCol(6, 7,	$DisplaySubTot."  ",-2,0,1,1);
				
			$rep->NewLine();
			if ($myrow['ov_freight'] != 0.0)
			{
   				$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
				$rep->TextCol(3, 6, _("  Shipping"), -2,0,1,1);
				$rep->TextCol(6, 7,	$DisplayFreight, -2,0,1,1);

				$rep->NewLine();
			}	
			$tax_items = get_trans_tax_details(ST_SALESINVOICE, $row['trans_no']);
			$first = true;
    		while ($tax_item = db_fetch($tax_items))
    		{
    			if ($tax_item['amount'] == 0)
    				continue;
    			$DisplayTax = number_format2($sign*$tax_item['amount'], $dec);

    			if ($SysPrefs->suppress_tax_rates() == 1)
    				$tax_type_name = $tax_item['tax_type_name'];
    			else
    				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

    			if ($myrow['tax_included'])
    			{
    				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
    				{
    					if ($first)
    					{
    					
							$rep->TextCol(3, 6, _("   Total Tax Excluded"), -2,0,1,1);
							$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec)."  ", -2,0,1,1);
						
							$rep->NewLine();
    					}
    					
						$rep->TextCol(3, 6, "  ".$tax_type_name, -2,0,1,1);
						$rep->TextCol(6, 7,	$DisplayTax."  ", -2,0,1,1);
						
						$first = false;
    				}
    				else
					{
					
					$rep->TextCol(3, 7, _("  Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2,0,1,1);
				       //$rep->LineTo(480,$rep->row-2,480,$rep->row+10);

				     }
				}
    			else
    			{
    				//display_error($rep->row);
    				
					$rep->TextCol(3, 6, "  ".$tax_type_name, -2,0,1,1);
					$rep->TextCol(6, 7,	$DisplayTax."  ", -2,0,1,1);
					
				}
				$rep->NewLine();
    		}

    	//	$rep->NewLine();
			$DisplayTotal = number_format2($sign*($myrow["ov_freight"] + $myrow["ov_gst"] +
				$myrow["ov_amount"]+$myrow["ov_freight_tax"]),$dec);
			$rep->Font('bold');
			if (!$myrow['prepaid']) $rep->Font('bold');
				{

				
				$rep->TextCol(3, 6, $rep->formData['prepaid'] ? _("  TOTAL ORDER VAT INCL.") : _("  TOTAL INVOICE"), + 2,0,1,1);
		    	$rep->TextCol(6, 7, $DisplayTotal."  ", -2,0,1,1);
		    	// $rep->LineTo(480,$rep->row-2,480,$rep->row+10);
		    }
			if ($rep->formData['prepaid'])
			{
				$rep->NewLine();
				$rep->Font('bold');
				 
				$rep->TextCol(3, 6, $rep->formData['prepaid']=='final' ? _("  THIS INVOICE") : _("  TOTAL INVOICE"), - 2,0,1,1);
				$rep->TextCol(6, 7, number_format2($myrow['prep_amount']."  ", $dec), -2,0,1,1);
              
			}
			$words = price_in_words($rep->formData['prepaid'] ? $myrow['prep_amount'] : $myrow['Total']
				, array( 'type' => ST_SALESINVOICE, 'currency' => $myrow['curr_code']));
			if ($words != "")
			{
				$rep->NewLine(1);
				$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
			}


			// $rep->LineTo(40,160,40,80);
			// $rep->LineTo(370,160,370,80);

			// $rep->LineTo(40,160,370,160);
			
			$rep->Font();
			if ($email == 1)
			{
				$rep->End($email);
			}
	}

	if($rep->row <= 200){
	     $rep->NewPage();
	    }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	    
// =============================================================================================================================
// New Code added here by Waleed to print terms & conditions on a new page;
// 04/10/2022
	foreach(array_unique($item_image_array) as $key => $value ){
		$terms_and_conditions = company_path()."/images/terms_and_conditions/".$value.".jpg";
		if (file_exists($terms_and_conditions) && $value) {
			$rep->SetHeaderType();
			$rep->NewPage();
			$rep->AddImage($terms_and_conditions,0,0,600,850);
		}
	}
	$rep->GetImagePolicy($rep->rep_id);
// =============================================================================================================================
	    
	if ($email == 0)
		$rep->End();
}



