<?php

$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_SALE_ORDERS' : 'SA_PRINT_SALE_ORDERS';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------
if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
print_sales_orders_new();
else
print_sales_orders();



//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------


function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$print_as_quote = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 109;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(4, 60, 225, 300, 325, 385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'right', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{

		if ($print_as_quote == 0)
			$rep = new FrontReport(_("SALES ORDER"), "SalesOrderBulk", user_pagesize(), 9, $orientation);
		else
			$rep = new FrontReport(_("QUOTE"), "QuoteBulk", user_pagesize(), 9, $orientation);
	}
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);
		if ($email == 1)
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		if ($print_as_quote == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			if ($print_as_quote == 1)
			{
				$rep->title = _('QUOTE');
				$rep->filename = "Quote" . $i . ".pdf";
			}
			else
			{
				$rep->title = _("SALES ORDER");
				$rep->filename = "SalesOrder" . $i . ".pdf";
			}
		}
		else
			$rep->title = ($print_as_quote==1 ? _("QUOTE") : _("SALES ORDER"));
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		while ($myrow2=db_fetch($result))
		{
			$Net = round2( ($myrow2["unit_price"] * $myrow2["quantity"])-$myrow2["discount_percent"],
			   user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['stk_code'];
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stk_code']));
			$DisplayNet = number_format2($Net,$dec);
			
			if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['description'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
	    		    $myrow2['stk_code'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($myrow['order_no'], $myrow['trans_type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}
				
			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec());
			$rep->TextCol(0, 1,	$myrow2['stk_code'], -2);
			$oldrow = $rep->row;
			$SpecDescription = "";
			if($myrow2["spec_description"])
				$SpecDescription = "\n".$myrow2["spec_description"];
			$rep->TextColLines(1, 2, $myrow2['description'].$SpecDescription." \n ".get_specs_for_ids(explode(',',$myrow2['item_specs']), true), -2); //waleed
			$newrow = $rep->row;
			$rep->row = $oldrow;
			if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
			{
				$rep->TextCol(2, 3,	$DisplayQty, -2);
				$rep->TextCol(3, 4,	$myrow2['units'], -2);
				$rep->TextCol(4, 5,	$DisplayPrice, -2);
				$rep->TextCol(5, 6,	$DisplayDiscount, -2);
				$rep->TextCol(6, 7,	$DisplayNet, -2);
			}
			$rep->row = $newrow;
			if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
				$rep->NewPage();
		}
		if ($myrow['comments'] != "")
		{
			$rep->NewLine();
			$rep->TextColLines(1, 3, $myrow['comments'], -2);
		}
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_SALESORDER;

		$rep->TextCol(3, 6, _("Sub-total"), -2);
		$rep->TextCol(6, 7,	$DisplaySubTot, -2);
		$rep->NewLine();
		if ($myrow['freight_cost'] != 0.0)
		{
			$DisplayFreight = number_format2($myrow["freight_cost"],$dec);
			$rep->TextCol(3, 6, _("Shipping"), -2);
			$rep->TextCol(6, 7,	$DisplayFreight, -2);
			$rep->NewLine();
		}	
		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		if ($myrow['tax_included'] == 0) {
			$rep->TextCol(3, 6, _("TOTAL ORDER EX VAT"), - 2);
			$rep->TextCol(6, 7,	$DisplayTotal, -2);
			$rep->NewLine();
		}

		$tax_items = get_tax_for_items($items, $prices, $myrow["freight_cost"],
		  $myrow['tax_group_id'], $myrow['tax_included'],  null);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			$tax_type_name = $tax_item['tax_type_name'];

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . " " . _("Amount"). ": " . $DisplayTax, -2);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->TextCol(3, 6, $tax_type_name, -2);
				$rep->TextCol(6, 7,	$DisplayTax, -2);
			}
			$rep->NewLine();
		}

		$rep->NewLine();

		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		$rep->Font('bold');
		$rep->TextCol(3, 6, _("TOTAL ORDER VAT INCL."), - 2);
		$rep->TextCol(6, 7,	$DisplayTotal, -2);
		$words = price_in_words($myrow["freight_cost"] + $SubTotal, ST_SALESORDER);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}	
		$rep->Font();
		if ($email == 1)
		{
			$rep->End($email);
		}
	}

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
	        // if($row['signature2'] == '' && $row['signature3'] == ''){   
	        //   	if($orientation == 'P'){
	        //   		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	        //   	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	        //   	}else{

	        //   		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	        //   	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	        //   	}

	        // }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	    
// =============================================================================================================================
// New Code added here by Waleed to print terms & conditions on a new page;
// 04/10/2022


	$res = get_sales_order_details($from, ST_SALESORDER);

	$terms = db_fetch($res);
	$terms_and_conditions = company_path()."/images/terms_and_conditions/".$terms['stk_code'].".jpg";
	if (file_exists($terms_and_conditions) && $terms['stk_code']) {
		$rep->SetHeaderType();
		$rep->NewPage();
		$rep->AddImage($terms_and_conditions,0,0,600,850);
	}
$rep->GetImagePolicy($rep->rep_id);
// =============================================================================================================================
	    
	if ($email == 0)
		$rep->End();
}






##-----------------------------------------------------
# Report New Format
# include pdf_repory.inc 
# Developer : Abdus sami
# Comments : use for new Format Function ;
## ----------------------------------------------------


function print_sales_orders_new()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$print_as_quote = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 109;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();
	//-------------code-Descr-Qty--uom--tax--prc--Disc-Tot--//
	$cols = array(4, 60, 230, 275, 350, 420, 460, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'center', 'left', 'left', 'right', 'right');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{

		if ($print_as_quote == 0)
			$rep = new FrontReport(_("SALES ORDER"), "SalesOrderBulk", user_pagesize(), 9, $orientation);
		else
			$rep = new FrontReport(_("QUOTE"), "QuoteBulk", user_pagesize(), 9, $orientation);
	}
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);
		if ($email == 1)
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		if ($print_as_quote == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			if ($print_as_quote == 1)
			{
				$rep->title = _('QUOTE');
				$rep->filename = "Quote" . $i . ".pdf";
			}
			else
			{
				$rep->title = _("SALES ORDER");
				$rep->filename = "SalesOrder" . $i . ".pdf";
			}
		}
		else
			$rep->title = ($print_as_quote==1 ? _("QUOTE") : _("SALES ORDER"));
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		// ____________________________________________________________ COLOR LINES _____________________________________
			$right = $rep->pageWidth - $rep->rightMargin;
			$total_rec = db_num_rows($result);
			$count__ = 0;
			$print_rec = 0;
			$rep->row+=5;
// ____________________________________________________________ COLOR LINES _____________________________________
		while ($myrow2=db_fetch($result))
		{
		    $item_image_array[] =  $myrow2['stk_code'];
				  // for ($j=1; $j<5 ; $j++) { 
			$Net = round2( ($myrow2["unit_price"] * $myrow2["quantity"])-$myrow2["discount_percent"],
			   user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['stk_code'];
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stk_code']));
			$DisplayNet = number_format2($Net,$dec);
	    	if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['description'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($myrow['order_no'], $myrow['trans_type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}
			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec());
			$rep->TextCol(0, 1,	$myrow2['stk_code'], -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['description'].' - '.get_specs_for_ids(explode(',',$myrow2['item_specs'])), -2); //waleed
			$newrow = $rep->row;
			$rep->row = $oldrow;
// ____________________________________________________________ COLOR LINES _____________________________________
		    if($print_rec % 2 == 0)
	      	$rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(189,214,238));  
            else
            $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));   
// ____________________________________________________________ COLOR LINES _____________________________________
	$oldrow = $rep->row;
                	$rep->TextCol(0, 1,	$myrow2['stk_code'], -2);
					// $item_desc= htmlspecialchars_decode($myrow2['StockDescription']);
                	
                	$rep->TextColLines(1, 2, $myrow2['description'].' - '.get_specs_for_ids(explode(',',$myrow2['item_specs'])), -2);
                		$newrow = $rep->row;
			        	$rep->row = $oldrow;


			if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
			{
				$rep->TextCol(2, 3,	$DisplayQty, -2);
				$rep->TextCol(3, 4,	$myrow2['units'], -2);
				$rep->TextCol(4, 5,	$DisplayPrice, -2);
				$rep->TextCol(5, 6,	$DisplayDiscount, -2);
				$rep->TextCol(6, 7,	$DisplayNet, -2);
			}
			// ____________________________________________________________ COLOR LINES _____________________________________

			$rep->SetDrawColor(91,155,213);

				$rep->row = $newrow;
				if(($oldrow-$newrow)>12)
						$count__++;
			
				if(($oldrow-$newrow)>24)
						$count__++;
				
				
			    $print_rec++;
				$count__++;

			// ____________________________________________________________ COLOR LINES _____________________________________
			
			$rep->row = $newrow;
			 if($count__>35 && ($total_rec-$print_rec)>1)
					    {	
					    	$rep->LineTo(41,533,41,$rep->row+10);
			    //             $rep->LineTo(120,532,120,$rep->row+10);
							// $rep->LineTo(290,532,290,$rep->row+10);
							// $rep->LineTo(380,532,380,$rep->row+10);
							// $rep->LineTo(440,532,440,$rep->row+10);
							// $rep->LineTo(494,532,494,$rep->row+10);
							$rep->LineTo(564,533,564,$rep->row+10);

                        }
                         else
                         {
                             $rep->LineTo(41,533,41,150);


       //                               $rep->LineTo(120,532,120,$rep->row+10);
							// $rep->LineTo(290,532,290,$rep->row+10);
							// $rep->LineTo(380,532,380,$rep->row+10);
							// $rep->LineTo(440,532,440,$rep->row+10);
							// $rep->LineTo(494,532,494,$rep->row+10);


	                         $rep->LineTo(564,533,564,150);


                         }
			// if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
			// 	$rep->NewPage();

  if($rep->pageNumber>1)
					{
						// display_error($count__." (".$total_rec."  -".$print_rec.")");
								       if($count__>30 && ($total_rec-$print_rec)<=1)
			   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
			   					   	 $total_rec-=$print_rec;
			   					   	 $count__=0;
			   					   	 $print_rec=0;
									$rep->NewPage();
									  $rep->row+=5;

									}
           
                   //display_error($count__." = ".$total_rec."-".$print_rec);

                         // if($count__<35 && ($total_rec-$print_rec)>1)
                         // 	continue;
                   }

                     else
                     { 
                             
                      // display_error($count__." = ".$total_rec."-".$print_rec);	
                      if($count__>32 && ($total_rec-$print_rec)<=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	 $count__=0;
   					   	 $print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;

						}
                     }
						  if( ($count__>40 || $count__>=39 )  && ($total_rec-$print_rec)>=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	$count__=0;
						$print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;
						}
                     
                 // }  // for loop		
			
		}

                if($rep->pageNumber>=1)
       	           $rep->LineTo(41,150,564,150);
       	            else
                   $rep->LineTo(41,$rep->row+10,564,$rep->row+10);
		// ______________________________________________ COMMENT AREA _________________________________________________
    		$rep->SetDrawColor(189, 214, 238);
			$rep->RoundedRect(40, 67.4+640, 290,20,2.25, '','DF',null,array(91,155,213));
			$rep->SetTextColor(255, 255, 255);
			$rep->TextWrap(50,67.4+55,150,"Memo");//50,152,150

			$rep->SetTextColor(0, 0, 0);
			$rep->RoundedRect(40,67.4+660, 290,65,2.25, '','DF',null,array(222, 234, 246));

			$memo = $myrow['comments'];
			$memo = $myrow['comments'];

		if ($myrow['comments'] != "")
		{
			// $rep->NewLine();
			// $rep->TextColLines(1, 3, $myrow['comments'].'asdsa', -2);
			$rep->cols[3]=350;
			$rep->TextWrapLines2(45,300,115, $memo, -2);
		}
		// ______________________________________________ COMMENT AREA _________________________________________________

		
		// if ($myrow['comments'] != "")
		// {
		// 	$rep->NewLine();
		// 	$rep->TextColLines(1, 3, $myrow['comments'], -2);
		// }
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_SALESORDER;
		$rep->row = $summary_start_row-85;
			$rep->cols[2] += 20;
			$rep->cols[3] += 20;
        	$rep->aligns[3] = 'left';
		$rep->TextCol(3, 6, _("Sub-total"), +2,0,1,1);
		$rep->TextCol(6, 7,	$DisplaySubTot, +2,0,1,1);
		$rep->NewLine();
		if ($myrow['freight_cost'] != 0.0)
		{
			$DisplayFreight = number_format2($myrow["freight_cost"],$dec);
			$rep->TextCol(3, 6, _("Shipping"), +2,0,1,1);
			$rep->TextCol(6, 7,	$DisplayFreight, +2,0,1,1);
			$rep->NewLine();
		}	
		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		if ($myrow['tax_included'] == 0) {
			$rep->TextCol(3, 6, _("TOTAL ORDER EX VAT"), +2,0,1,1);
			$rep->TextCol(6, 7,	$DisplayTotal, +2,0,1,1);
			$rep->NewLine();
		}

		$tax_items = get_tax_for_items($items, $prices, $myrow["freight_cost"],
		  $myrow['tax_group_id'], $myrow['tax_included'],  null);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			$tax_type_name = $tax_item['tax_type_name'];

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), +2,0,1,1);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), +2,0,1,1);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . " " . _("Amount"). ": " . $DisplayTax, +2,0,1,1);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->TextCol(3, 6, $tax_type_name, +2,0,1,1);
				$rep->TextCol(6, 7,	$DisplayTax,+2,0,1,1);
			}
			$rep->NewLine();
		}

		$rep->NewLine();

		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		$rep->Font('bold');
		$rep->TextCol(3, 6, _("TOTAL ORDER VAT INCL."), +2,0,1,1);
		$rep->TextCol(6, 7,	$DisplayTotal, +2,0,1,1);
		$words = price_in_words($myrow["freight_cost"] + $SubTotal, ST_SALESORDER);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}	
		$rep->Font();
		if ($email == 1)
		{
			$rep->End($email);
		}
	}
	$res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	    
// ==============================================================================================================================
// New Code added here by Waleed to print terms & conditions on a new page;
// 04/10/2022


	foreach(array_unique($item_image_array) as $key => $value ){
		$terms_and_conditions = company_path()."/images/terms_and_conditions/".$value.".jpg";
		if (file_exists($terms_and_conditions) && $value) {
			$rep->SetHeaderType();
			$rep->NewPage();
			$rep->AddImage($terms_and_conditions,0,0,600,850);
		}
	}
	$rep->GetImagePolicy($rep->rep_id);
// ==============================================================================================================================
	    
	if ($email == 0)
		$rep->End();
}
