<?php

$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_DELIVERY' : 'SA_PRINT_DELIVERY';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Janusz Dobrwolski
// date_:	2008-01-14
// Title:	Print Delivery Notes
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");

//----------------------------------------------------------------------------------------------------

if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
print_deliveries_new();
else
print_deliveries();

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------




function print_deliveries()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$packing_slip = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 110;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	$cols = array(4, 60, 225, 300, 325, 385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'right', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments, 'packing_slip' => $packing_slip);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{
		if ($packing_slip == 0)
			$rep = new FrontReport(_('DELIVERY'), "DeliveryNoteBulk", user_pagesize(), 9, $orientation);
		else
			$rep = new FrontReport(_('PACKING SLIP'), "PackingSlipBulk", user_pagesize(), 9, $orientation);
	}
    if ($orientation == 'L')
    	recalculate_cols($cols);
	for ($i = $from; $i <= $to; $i++)
	{
			if (!exists_customer_trans(ST_CUSTDELIVERY, $i))
				continue;
			$myrow = get_customer_trans($i, ST_CUSTDELIVERY);
// 			print_r($myrow['type']);exit;
			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER); // ?
			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				if ($packing_slip == 0)
				{
					$rep->title = _('DELIVERY NOTE');
					$rep->filename = "Delivery" . $myrow['reference'] . ".pdf";
				}
				else
				{
					$rep->title = _('PACKING SLIP');
					$rep->filename = "Packing_slip" . $myrow['reference'] . ".pdf";
				}
			}
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'delivery', $branch['debtor_no'], true);
			$rep->SetCommonData($myrow, $branch, $sales_order, '', ST_CUSTDELIVERY, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();

   			$result = get_customer_trans_details(ST_CUSTDELIVERY, $i);
			$SubTotal = 0;
			
			while ($myrow2=db_fetch($result))
			{
				if ($myrow2["quantity"] == 0)
					continue;

				$Net = round2( ($myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"] ,
				   user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net,$dec);
	    
	    		if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['StockDescription'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
	    		    $myrow2['stock_id'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($myrow['trans_no'], $myrow['type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}	
				
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) . "";
				$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
				$oldrow = $rep->row;
				$rep->TextColLines(1, 2, $myrow2['StockDescription'], -2);
				$newrow = $rep->row;
				$rep->row = $oldrow;
				if ($Net != 0.0  || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
				{
					$rep->TextCol(2, 3,	$DisplayQty, -2);
					$rep->TextCol(3, 4,	$myrow2['units'], -2);
					if ($packing_slip == 0)
					{
						$rep->TextCol(4, 5,	$DisplayPrice, -2);
						$rep->TextCol(5, 6,	$DisplayDiscount, -2);
						$rep->TextCol(6, 7,	$DisplayNet, -2);
					}
				}
				$rep->row = $newrow;
				//$rep->NewLine(1);
				if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
					$rep->NewPage();
			}

			$memo = get_comments_string(ST_CUSTDELIVERY, $i);
			if ($memo != "")
			{
				$rep->NewLine();
				$rep->TextColLines(1, 3, $memo, -2);
			}

   			$DisplaySubTot = number_format2($SubTotal,$dec);

    		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
			$doctype=ST_CUSTDELIVERY;
			if ($packing_slip == 0)
			{
				$rep->TextCol(3, 6, _("Sub-total"), -2);
				$rep->TextCol(6, 7,	$DisplaySubTot, -2);
				$rep->NewLine();
				if ($myrow['ov_freight'] != 0.0)
				{
					$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
					$rep->TextCol(3, 6, _("Shipping"), -2);
					$rep->TextCol(6, 7,	$DisplayFreight, -2);
					$rep->NewLine();
				}	
				$tax_items = get_trans_tax_details(ST_CUSTDELIVERY, $i);
				$first = true;
    			while ($tax_item = db_fetch($tax_items))
    			{
    				if ($tax_item['amount'] == 0)
    					continue;
    				$DisplayTax = number_format2($tax_item['amount'], $dec);
 
 					if ($SysPrefs->suppress_tax_rates() == 1)
 		   				$tax_type_name = $tax_item['tax_type_name'];
 		   			else
 		   				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

 					if ($myrow['tax_included'])
    				{
   						if ($SysPrefs->alternative_tax_include_on_docs() == 1)
    					{
    						if ($first)
    						{
								$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
								$rep->TextCol(6, 7,	number_format2($tax_item['net_amount'], $dec), -2);
								$rep->NewLine();
    						}
							$rep->TextCol(3, 6, $tax_type_name, -2);
							$rep->TextCol(6, 7,	$DisplayTax, -2);
							$first = false;
    					}
    					else
							$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
					}
    				else
    				{
						$rep->TextCol(3, 6, $tax_type_name, -2);
						$rep->TextCol(6, 7,	$DisplayTax, -2);
					}
					$rep->NewLine();
    			}
    			$rep->NewLine();
				$DisplayTotal = number_format2($myrow["ov_freight"] +$myrow["ov_freight_tax"] + $myrow["ov_gst"] +
					$myrow["ov_amount"],$dec);
				$rep->Font('bold');
				$rep->TextCol(3, 6, _("TOTAL DELIVERY INCL. VAT"), - 2);
				$rep->TextCol(6, 7,	$DisplayTotal, -2);
				$words = price_in_words($myrow['Total'], ST_CUSTDELIVERY);
				if ($words != "")
				{
					$rep->NewLine(1);
					$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
				}	
				$rep->Font();
			}	
			if ($email == 1)
			{
				$rep->End($email);
			}
	}

	// if($rep->row <= 200){
	//      $rep->NewPage();
	//     }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		// if($row['is_policy_text'] == 1){
		// 	$rep->row = 120;
		// 	$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		// }
		// if($row['is_policy_image'] == 1){
		// 	$logo = company_path() . "/images/" . $row['filename'];
		// 	$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		// }


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	if ($email == 0)
		$rep->End();
}





##-----------------------------------------------------
# Report New Format
# include pdf_repory.inc 
# Developer : Abdus sami
# Comments : use for new Format Function ;
## ----------------------------------------------------




function print_deliveries_new()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$packing_slip = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 110;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);
	//-------------code-Descr-Qty--uom--tax--prc--Disc-Tot--//
	$cols = array(4, 60, 230, 275, 350, 420, 460, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'center', 'left', 'left', 'right', 'right');

	$params = array('comments' => $comments, 'packing_slip' => $packing_slip);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{
		if ($packing_slip == 0)
			$rep = new FrontReport(_('DELIVERY'), "DeliveryNoteBulk", user_pagesize(), 9, $orientation);
		else
			$rep = new FrontReport(_('PACKING SLIP'), "PackingSlipBulk", user_pagesize(), 9, $orientation);
	}
    if ($orientation == 'L')
    	recalculate_cols($cols);
	for ($i = $from; $i <= $to; $i++)
	{
			if (!exists_customer_trans(ST_CUSTDELIVERY, $i))
				continue;
			$myrow = get_customer_trans($i, ST_CUSTDELIVERY);
			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER); // ?
			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				if ($packing_slip == 0)
				{
					$rep->title = _('DELIVERY NOTE');
					$rep->filename = "Delivery" . $myrow['reference'] . ".pdf";
				}
				else
				{
					$rep->title = _('PACKING SLIP');
					$rep->filename = "Packing_slip" . $myrow['reference'] . ".pdf";
				}
			}
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'delivery', $branch['debtor_no'], true);
			$rep->SetCommonData($myrow, $branch, $sales_order, '', ST_CUSTDELIVERY, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();

   			$result = get_customer_trans_details(ST_CUSTDELIVERY, $i);
			$SubTotal = 0;
			$total_rec = db_num_rows($result);

			// ____________________________________________________________ COLOR LINES ___________________________
			$right = $rep->pageWidth - $rep->rightMargin;
			$count__ = 0;
			$print_rec = 0;
				$rep->row+=5;
			// ____________________________________________________________ COLOR LINES ___________________________

			while ($myrow2=db_fetch($result))
			{

				  // for ($j=1; $j<=15 ; $j++) { 


				if ($myrow2["quantity"] == 0)
					continue;

				$Net = round2( ($myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"] ,
				   user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net,$dec);
	    		
	    		if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['StockDescription'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
	    		     $myrow2['stock_id'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($myrow['trans_no'], $myrow['type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}
				
	    		if ($myrow2["discount_percent"]==0)
		  			$DisplayDiscount ="";
	    		else
		  			$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) . "";
				$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
				$oldrow = $rep->row;
				$rep->TextColLines(1, 2, $myrow2['StockDescription'], -2);
				$newrow = $rep->row;
				$rep->row = $oldrow;

		// ____________________________________________________________ COLOR LINES _____________________________________
		    if($print_rec % 2 == 0)
	      	$rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(189,214,238));  
            else
            $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));   
	$oldrow = $rep->row;
                	$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
					// $item_desc= htmlspecialchars_decode($myrow2['StockDescription']);
                	
                	$rep->TextColLines(1, 2, $myrow2['description'], -2);
                		$newrow = $rep->row;
			        	$rep->row = $oldrow;
		// ____________________________________________________________ COLOR LINES _____________________________________
				if ($Net != 0.0  || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
				{
					$rep->TextCol(2, 3,	$DisplayQty, -2);
					$rep->TextCol(3, 4,	$myrow2['units'], -2);
					if ($packing_slip == 0)
					{
						$rep->TextCol(4, 5,	$DisplayPrice, -2);
						$rep->TextCol(5, 6,	$DisplayDiscount, -2);
						$rep->TextCol(6, 7,	$DisplayNet, -2);
					}
				}
			// ____________________________________________________________ COLOR LINES _____________________________________

			$rep->SetDrawColor(91,155,213);

				$rep->row = $newrow;
				if(($oldrow-$newrow)>12)
						$count__++;
				if(($oldrow-$newrow)>24)
						$count__++;
						
			
				
			    $print_rec++;
				$count__++;

			// ____________________________________________________________ COLOR LINES _____________________________________
				$rep->row = $newrow;


				  if($count__>35 && ($total_rec-$print_rec)>1)
					    {	
					    	$rep->LineTo(41,533,41,$rep->row+10);
			    //             $rep->LineTo(120,532,120,$rep->row+10);
							// $rep->LineTo(290,532,290,$rep->row+10);
							// $rep->LineTo(380,532,380,$rep->row+10);
							// $rep->LineTo(440,532,440,$rep->row+10);
							// $rep->LineTo(494,532,494,$rep->row+10);
							$rep->LineTo(564,533,564,$rep->row+10);

                        }
                         else
                         {
                             $rep->LineTo(41,533,41,150);


       //                               $rep->LineTo(120,532,120,$rep->row+10);
							// $rep->LineTo(290,532,290,$rep->row+10);
							// $rep->LineTo(380,532,380,$rep->row+10);
							// $rep->LineTo(440,532,440,$rep->row+10);
							// $rep->LineTo(494,532,494,$rep->row+10);


	                         $rep->LineTo(564,533,564,150);


                         }
				//$rep->NewLine(1);
				// if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
				// 	$rep->NewPage();

				  if($rep->pageNumber>=1)
					{
						// display_error($count__." (".$total_rec."  -".$print_rec.")");
								       if($count__>31 && ($total_rec-$print_rec)<=1)
			   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
			   					   	 $total_rec-=$print_rec;
			   					   	 $count__=0;
			   					   	 $print_rec=0;
									$rep->NewPage();
									  $rep->row+=5;

									}
           
                   //display_error($count__." = ".$total_rec."-".$print_rec);

                         // if($count__<35 && ($total_rec-$print_rec)>1)
                         // 	continue;
                   }

                     else
                     { 
                             
                      // display_error($count__." = ".$total_rec."-".$print_rec);	
                      if($count__>32 && ($total_rec-$print_rec)<=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	 $count__=0;
   					   	 $print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;

						}
                     }
						  if($count__>40 || $count__>=39 && ($total_rec-$print_rec)>=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	$count__=0;
						$print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;
						}

						
				// }  // for loop		
			}

			    if($rep->pageNumber>=1)
       	           $rep->LineTo(41,150,564,150);
       	            else
                   $rep->LineTo(41,$rep->row+10,564,$rep->row+10);
	// ______________________________________________ COMMENT AREA _________________________________________________
    		$rep->SetDrawColor(189, 214, 238);
			$rep->RoundedRect(40, 67.4+640, 290,20,2.25, '','DF',null,array(91,155,213));
			$rep->SetTextColor(255, 255, 255);
			$rep->TextWrap(50,67.4+55,150,"Memo");//50,152,150

			$rep->SetTextColor(0, 0, 0);
			$rep->RoundedRect(40,67.4+660, 290,65,2.25, '','DF',null,array(222, 234, 246));

			$memo = get_comments_string(ST_CUSTDELIVERY, $i);

		if ($memo != "")
		{
			// $rep->NewLine();
			// $rep->TextColLines(1, 3, $myrow['comments'].'asdsa', -2);
			$rep->cols[3]=350;
			$rep->TextWrapLines2(45,300,115, $memo, -2);
		}
		// ______________________________________________ COMMENT AREA _________________________________________________

			// $memo = get_comments_string(ST_CUSTDELIVERY, $i);
			// if ($memo != "")
			// {
			// 	$rep->NewLine();
			// 	$rep->TextColLines(1, 3, $memo, -2);
			// }

   			$DisplaySubTot = number_format2($SubTotal,$dec);

    		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
    		// if($rep->row <50)
    		// 	$rep->NewPage();
    		$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);
			$doctype=ST_CUSTDELIVERY;
			$rep->row = $summary_start_row-85;
			$rep->cols[2] += 30;
			$rep->cols[3] += 0;
			$rep->aligns[3] = 'left';
			if ($packing_slip == 0)
			{
				$rep->TextCol(3, 6, _("Sub-total"), +2,0,1,1);
				$rep->TextCol(6, 7,	$DisplaySubTot, +2,0,1,1);
				$rep->NewLine();
				if ($myrow['ov_freight'] != 0.0)
				{
					$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
					$rep->TextCol(3, 6, _("Shipping"), +2,0,1,1);
					$rep->TextCol(6, 7,	$DisplayFreight, +2,0,1,1);
					$rep->NewLine();
				}	
				$tax_items = get_trans_tax_details(ST_CUSTDELIVERY, $i);
				$first = true;
    			while ($tax_item = db_fetch($tax_items))
    			{
    				if ($tax_item['amount'] == 0)
    					continue;
    				$DisplayTax = number_format2($tax_item['amount'], $dec);
 
 					if ($SysPrefs->suppress_tax_rates() == 1)
 		   				$tax_type_name = $tax_item['tax_type_name'];
 		   			else
 		   				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

 					if ($myrow['tax_included'])
    				{
   						if ($SysPrefs->alternative_tax_include_on_docs() == 1)
    					{
    						if ($first)
    						{
								$rep->TextCol(3, 6, _("Total Tax Excluded"), +2,0,1,1);
								$rep->TextCol(6, 7,	number_format2($tax_item['net_amount'], $dec), +2,0,1,1);
								$rep->NewLine();
    						}
							$rep->TextCol(3, 6, $tax_type_name,  +2,0,1,1);
							$rep->TextCol(6, 7,	$DisplayTax,  +2,0,1,1);
							$first = false;
    					}
    					else
							$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, +2,0,1,1);
					}
    				else
    				{
						$rep->TextCol(3, 6, $tax_type_name, +2,0,1,1);
						$rep->TextCol(6, 7,	$DisplayTax, +2,0,1,1);
					}
					$rep->NewLine();
    			}
    			$rep->NewLine();
				$DisplayTotal = number_format2($myrow["ov_freight"] +$myrow["ov_freight_tax"] + $myrow["ov_gst"] +
					$myrow["ov_amount"],$dec);
				$rep->Font('bold');
				$rep->TextCol(3, 6, _("TOTAL DELIVERY INCL. VAT"),+2,0,1,1);
				$rep->TextCol(6, 7,	$DisplayTotal,  +2,0,1,1);
				$words = price_in_words($myrow['Total'], ST_CUSTDELIVERY);
				if ($words != "")
				{
					$rep->NewLine(1);
					$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, -2);
				}	
				$rep->Font();
			}	
			if ($email == 1)
			{
				$rep->End($email);
			}
	}

	// if($rep->row <= 200){
	//      $rep->NewPage();
	//     }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		// if($row['is_policy_text'] == 1){
		// 	$rep->row = 120;
		// 	$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		// }
		// if($row['is_policy_image'] == 1){
		// 	$logo = company_path() . "/images/" . $row['filename'];
		// 	$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		// }


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	if ($email == 0)
		$rep->End();
}

