<?php

$page_security = 'SA_DAILY_CLOSING_REPORT';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Prem Kumar
// date_: 2020-01-08
// Title: Daily Closing
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//----------------------------------------------------------------------------------------------------

print_daily_sale();

function get_transactions($from, $to, $debtor_no=null, $branch_code=null)
{
    $from = date2sql($from);
    $to = date2sql($to);
  
    $sql="SELECT dt.*  FROM 0_debtor_trans dt  WHERE dt.tran_date >= '$from'
    AND dt.tran_date <= '$to' AND (dt.type = 10 OR dt.type = 11)   AND dt.ov_amount != '0' ";
    if($debtor_no != null){
      $sql .= " AND dt.debtor_no = '$debtor_no' ";
    }
    if($branch_code != null){
      $sql .= " AND dt.branch_code = '$branch_code' ";
    }
    $sql .= "Order by dt.trans_no ";
    
    return db_query($sql,"No transactions were returned");
}


function refund($from,$to,$debtor_no=null,$branch_code=null){
    $from = date2sql($from);
    $to = date2sql($to);
    
    $sql = " SELECT bt.* FROM ".TB_PREF."bank_trans bt where trans_date >= '$from' AND trans_date <= '$to' AND refund = 1  ";
    $result = db_query($sql , " no data gathered ");
    return $result;
}
function get_unpaid_invoices($from,$to,$debtor_no=null,$branch_code){
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = " SELECT COUNT(*) as counts FROM `0_debtor_trans` where (ov_amount+ov_gst-ov_discount) != alloc and tran_date >= '$from' and tran_date <= '$to'  AND type = 10 ";
    if($debtor_no != null)
      $sql.= " AND debtor_no = '$debtor_no' ";
    if($branch_code != null )
      $sql.= " AND branch_code = '$branch_code' ";

    $result = db_query($sql , " no data gathered ");
    $myrow = db_fetch($result);

    return $myrow['counts'];
}
function get_unpaid_invoices_amount($from,$to,$debtor_no=null,$branch_code=null){
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = " SELECT sum((ov_amount+ov_gst-ov_discount)-alloc) as amount FROM `0_debtor_trans` where (ov_amount+ov_gst-ov_discount) != alloc and tran_date >= '$from' and tran_date <= '$to' AND type = 10 ";
    if($branch_code != null)
      $sql.= " AND branch_code = '$branch_code' ";
    if($debtor_no != null)
      $sql.= " AND debtor_no = '$debtor_no' ";

    $result = db_query($sql , " no data gathered ");
    $myrow = db_fetch($result);
    // display_error($sql);
    return $myrow['amount'];
}

function checking_report($id){
  $sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
  $result = db_query($sql,"Did not Executed");
  return $result;
}


//----------------------------------------------------------------------------------------------------
function print_daily_sale()
{
  global $path_to_root, $systypes_array;

  $from = $_POST['PARAM_0'];
  $to = $_POST['PARAM_1'];
  $debtor_no = $_POST['PARAM_2'];
  $branch_code = null;
  $orientation = $_POST['PARAM_3'] = 1;
  $destination = $_POST['PARAM_4'];
  $REPORT_ID = 11011;
  

  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_report.inc");

  $orientation = ($orientation ? 'L' : 'P');
    
  $dec = user_price_dec();

  // $cols = array(3, 25, 65, 145, 255, 360, 400, 445, 500, 540);
  $cols = array(3, 25, 65,120, 175, 255, 360, 400, 445, 500, 540);

  $headers = array(_('#'), _("Ref"), _('Type'),_('Payment Term'),_('Customer Name'), _('Branch Name'), _("Disc"),
    _('Vat Amt'),_('Total Amt'), _('Status')/*,_(' Bank ')_("Balance")*/ );

  $aligns = array('left', 'left', 'left', 'left', 'left', 'left' ,'left', 'left', 'left','left');

  $params =   array(  0 => $comments,
              1 => array('text' => _('Period'), 'from' => $from,    'to' => $to),
              2 => array('text' => _('Customer'), 'from' => ($debtor_no != null) ? get_customer_name($debtor_no) : '','to' => $to),
              3 => array('text' => _('Branch'), 'from' => ($branch_code != null) ? get_branch($debtor_no)['br_name'] : ''),
            );

  $margin = array('top' => 40,
           'bottom' => 30, 
           'left' => 20, 
           'right' => 30 );

  $rep = new FrontReport(_('Daily Closing Report'), "CustomerBalances", user_pagesize(), 9, $orientation);//, $margin
  if ($orientation == 'L')
    recalculate_cols($cols);
  
  // $rep->show_image = 1;
  $rep->Font();
  $rep->Info($params, $cols, $headers, $aligns);
  $rep->NewPage();

  $total_discount = $total_of_line_total = $total_vat_amt = 0;
    $result = get_transactions($from, $to, $debtor_no, $branch_code);
    while ($myrow = db_fetch($result)){
    
      $rep->TextCol(0, 1,  $myrow['trans_no']);
      $rep->TextCol(1, 2,  $myrow['reference']);
      $rep->TextCol(2, 3,  $systypes_array[$myrow['type']]);
      $rep->TextCol(3, 4,  get_payment_terms($myrow['payment_terms'])['terms']);
      $oldrow = $rep->row;
      $rep->TextColLines(4, 5,  get_customer_name($myrow['debtor_no']));
      $newrow[] = $rep->row;
      $rep->row = $oldrow;

      $oldrow = $rep->row;
      $rep->TextColLines(5, 6,  get_branch($myrow['branch_code'])['br_name']);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;

      $discount = $myrow['ov_discount'];
      $vat = $myrow['ov_gst'];
      $line_total = ($myrow['ov_amount']+$myrow['ov_gst'])-$myrow['ov_discount'];
      // display_error($myrow['alloc']."===".$line_total);
      if($myrow['type'] == 10){
        if($myrow['alloc'] == 0)
          $status = 'UnPaid';
        else if(round($myrow['alloc'],2) == round($line_total,2))
          $status = 'Paid';
        else
          $status = 'Partail Paid';

        $rep->TextCol(6, 7,  price_format($discount));
        $rep->TextCol(7, 8,  price_format($vat));
        $rep->TextCol(8, 9,  price_format($line_total));

        $total_vat_amt += $vat;
        $total_of_line_total += $line_total;
        $total_discount += $discount;

      }else{
        $rep->TextCol(6, 7,  "(".price_format($discount).")");
        $rep->TextCol(7, 8,  "(".price_format($vat).")");
        $rep->TextCol(8, 9,  "(".price_format($line_total).")");
        $status = '-';

        $total_discount -= $discount;
        $total_vat_amt -= $vat;
        $total_of_line_total -= $line_total;
      }
      $rep->TextCol(9, 10,  $status);
      $rep->row = min($newrow);
      unset($newrow);
      $rep->NewLine(0.2);      
    } //end of trans while
     
    $rep->Line($rep->row  + 5);
    $rep->NewLine(0.5);
    $rep->TextCol(0, 3, _("Total"));
    $rep->TextCol(6, 7,  price_format($total_discount));
    $rep->TextCol(7, 8,  price_format($total_vat_amt));
    $rep->TextCol(8, 9,  price_format($total_of_line_total));
   
   if($rep->row <= 250){
     $rep->NewPage();
    }

    //setting of header in footer start here
    // $rep->NewLine(3);
    // $rep->Line($rep->row+15);

    $rep->cols[5] -= 55;
    $rep->cols[6] += 5;
    $rep->cols[7] += 25;
    $rep->TextCol(3, 4, _("Opening Balance"));
    $rep->TextCol(4, 5, _("Sales"));
    $rep->TextCol(5, 6, _("Account Rec"));
    $rep->TextCol(6, 7, _("Payment"));
    $rep->TextCol(7, 9, _("Closing Balance"));
    $rep->cols[5] += 55;
    $rep->cols[6] -= 5;
    $rep->cols[7] -= 25;
    $rep->NewLine(2);
    $rep->Line($rep->row+15);
     
    $banks_result = get_all_sales_points(false);
    $closing_date = date('d/m/Y', strtotime('+1 day', strtotime(date2sql($to))));
    $total_bob =0;
    $total_bcb =0;
    $total_bank_rec =0;
    $total_bank_sale =0;
    $total_credit =0;

    while($banks_row = db_fetch($banks_result)){

      $bob = get_balance_before_for_bank_account($banks_row['pos_account'], $from);
      $bcb = get_balance_before_for_bank_account($banks_row['pos_account'], $closing_date);
      // $get_bank_rec = get_bank_wise_payment($from,$to,$banks_row['pos_account'],"Rec",-1);
      // $credit = get_bank_credit($banks_row['pos_account'], $from, $to);
      // $get_bank_sale = get_bank_wise_payment($from,$to,$banks_row['pos_account'],"sale",-1);
      $get_bank_sale = 0;
      $credit = 0;
      $get_bank_sale_result = get_bank_trans_for_bank_account($banks_row['pos_account'], $from, $to);
      while($get_bank_sale_row = db_fetch($get_bank_sale_result)){
        if($get_bank_sale_row['amount'] > 0){
          $get_bank_sale += $get_bank_sale_row['amount'];
        }else{
          $credit += $get_bank_sale_row['amount'];
        }
      }
      
      $total_bob += $bob;
      $total_bcb += $bcb;
      $total_bank_rec += $get_bank_rec;
      $total_bank_sale += $get_bank_sale;
      $total_credit += $credit;


      $rep->cols[5] -= 55;
      $rep->cols[6] += 5;
      $rep->cols[7] += 25;
      $rep->TextCol(0, 3, $banks_row['bank_account_name']);
      $rep->TextCol(3, 4, number_format2($bob,$dec));
      $rep->TextCol(4, 5, number_format2($get_bank_sale,$dec));
      $rep->TextCol(5, 6, number_format2($get_bank_rec,$dec));
      $rep->TextCol(6, 7, "(".number_format2(abs($credit),$dec).")");
      $rep->TextCol(7, 9, number_format2($bcb,$dec));
      $rep->cols[5] += 55;
      $rep->cols[6] -= 5;
      $rep->cols[7] -= 25;
      $rep->NewLine();
    }
    $rep->NewLine();
    $rep->Line($rep->row+17);
    $rep->cols[5] -= 55;
    $rep->cols[6] += 5;
    $rep->cols[7] += 25;

    $rep->TextCol(3, 4, number_format2($total_bob,$dec));
    $rep->TextCol(4, 5, number_format2($total_bank_sale,$dec));
    $rep->TextCol(5, 6, number_format2($total_bank_rec,$dec));
    $rep->TextCol(6, 7, "(".number_format2(abs($total_credit),$dec).")");
    $rep->TextCol(7, 9, number_format2($total_bcb,$dec));

    $rep->cols[5] += 55;
    $rep->cols[6] -= 5;
    $rep->cols[7] -= 25; 
    //end of header in footer start here
    
    

    //for refund
    $rep->NewLine(2);
    $refund = refund($from, $to, $debtor_no, $branch_code);
    while($row = db_fetch($refund)){
      $rep->font('bold');
      $rep->fontSize += 1;
      $myrow = get_bank_account($row['bank_act']);
      $rep->TextCol(0, 4, $myrow['bank_account_name']." ( Refund ) ");
  
      $refund_amount += abs($row['amount']);
      $rep->TextCol(4, 6, number_format2(abs($row['amount']),2));
      $rep->fontSize -= 1;
      $rep->NewLine();
      $rep->font();
    }

    

  $rep->SetTextColor(255,0,0);
  $rep->font('bold');
  $rep->fontSize += 2;
  $rep->TextCol(0, 3, "Refund Total");
  $rep->cols[7] += 25;
  $rep->TextCol(7, 9, number_format2($refund_amount,2));
  $rep->cols[7] -= 25;
  $rep->fontSize -= 2;
  $rep->SetTextColor(0,0,0);
  $rep->NewLine(2);
  $rep->font('bold');
  $rep->fontSize += 1;
  $rep->TextCol(0, 3, "UnPaid Invoice");
  $rep->cols[7] += 25; 
  $rep->TextCol(7, 9, number_format2(get_unpaid_invoices_amount($from,$to,$debtor_no,$branch_code),2)."  (Count ".get_unpaid_invoices($from,$to,$debtor_no,$branch_code).")");
  $rep->cols[7] -= 25; 
  $rep->fontSize -= 1;
  

  $res = checking_report($REPORT_ID);

 if(db_num_rows($res) > 0){
  
     $row = db_fetch($res);
    if($row['is_policy_text'] == 1){
      $rep->row = 120;
      $rep->TextColLines(0,10,$row['policy_desc'] , 'center'); 
    }
    if($row['is_policy_image'] == 1){
      $logo = company_path() . "/images/" . $row['filename'];
      $rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
    }


          if($row['signature2'] == '' && $row['signature3'] == ''){   
              if($orientation == 'P'){
                $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
                  $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
              }else{

                $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
                  $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
              }

          }


          if($row['signature2'] != '' && $row['signature3'] == ''){
        if($orientation == 'P'){
                $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
                $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

                $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
                $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
            }else{

          $rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
                $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

                $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
                $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
            }

          }



          if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
             if($orientation == 'P'){
          $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
          $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

          $rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
          $rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

          $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
          $rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
              }else{

          $rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
          $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

          $rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
          $rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

          $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
          $rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

              }
          }
      }

        
  $rep->End();
}

