<?php

$page_security = 'ST_EMPLOYEE_PAYEMENT';


$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");

function get_employe_payment_invoice($payslip_id)
{
	$sql = " SELECT bt.* , u.designation 
			FROM ".TB_PREF."bank_trans AS bt JOIN ".TB_PREF."users AS u ON u.id = bt.emp_id
			WHERE bt.payslip_id = '$payslip_id' ";
	$result = db_query($sql,"");
	return $result;
}

function get_name($id){
		$sql = " SELECT  real_name FROM ".TB_PREF."users WHERE id = ".$id;
		$row= db_query($sql);

		$res=db_fetch($row);
		return $res;
}	

function get_late_ded($row)
{
	$salary_of_day = $row['basic_salary']/30;
	return number_format2((($row['late_ded']/4)/2)*$salary_of_day,2);
}
function get_absent_ded($row){
	$salary_of_day = $row['basic_salary']/30;
	return number_format2($row['absent_ded']*$salary_of_day,2);

}

print_employee_invoices();

function print_employee_invoices()
{
	global $path_to_root, $SysPrefs;
	
	$show_this_payment = true;

	include_once($path_to_root . "/reporting/includes/employee_pdf_report.inc");

	$orientation =  'P' ;
	$dec = user_price_dec();


	$cols = array(4, 50, 100, 150, 200);

	$aligns = array('left',	'left',	'left', 'left', 'left', 'left');


	$rep = new FrontReport(_(''), "InvoiceBulk", 'A5', 9, $orientation);

	if ($orientation == 'L')
		recalculate_cols($cols);

	$range = get_employe_payment_invoice($_GET['trans_no']);

	$myrow = db_fetch($range);

	$employee_name = get_name($myrow['emp_id']);

	$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
	$rep->title = _('INVOICE');
	$rep->filename = "Invoice" . $myrow['payslip_id'] . ".pdf";

	$rep->Font();
	$rep->Info($params, $cols, null, $aligns);

	$rep->SetCommonData($row, $branch, $sales_order, $baccount, ST_EMPLOYEE_PAYEMENT, $contacts,$myrow,$employee_name);
	$rep->SetHeaderType('Header2');
	$rep->NewPage();

	/*$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);*/

	$c=0;

	$rep->TextCol(0, 2,	"Basic Salary", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+45);
	
	$rep->TextCol(4, 6,	number_format2($myrow['basic_salary'],2), -2);
	$rep->NewLine(2);
	$rep->TextCol(0, 2,	"Late Days", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+32);
	$rep->TextCol(2, 4,	$myrow['late_ded'], -2);
	$rep->TextCol(4, 6,	get_late_ded($myrow), -2);
	$rep->NewLine(2);
	$rep->TextCol(0, 2,	"Absent Days", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+32);
	$rep->TextCol(2, 4,	$myrow['absent_ded'], -2);
	$rep->TextCol(4, 6,	get_absent_ded($myrow), -2);
	$rep->NewLine(2);
	$rep->TextCol(0, 2,	"Allowances", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+32);
	if($myrow['ded_all_type'] == 1){
		$rep->TextCol(2, 4,	$myrow['ded_all_amount'], -2);
	}else{
		$rep->TextCol(2, 4,	"---", -2);
	}
	if($myrow['ded_all_type'] == 1){
		$rep->TextCol(4, 6,	$myrow['ded_all_amount'], -2);
	}else{
		$rep->TextCol(4, 6,	"---", -2);
	}
	$rep->NewLine(2);
	$rep->TextCol(0, 2,	"Deductions", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+32);
	if($myrow['ded_all_type'] == 2){
		$rep->TextCol(2, 4,	$myrow['ded_all_amount'], -2);
	}else{
		$rep->TextCol(2, 4,	"---", -2);
	}if($myrow['ded_all_type'] == 2){
		$rep->TextCol(4, 6,	$myrow['ded_all_amount'], -2);
	}else{
		$rep->TextCol(4, 6,	"---", -2);
	}
	$rep->NewLine(2);
	$rep->TextCol(0, 2,	"Total Salary", -2);
	$rep->LineTo($rep->cols[2]-15, $rep->row-1 ,$rep->cols[2]-15 ,$rep->row+33);
	$rep->TextCol(4, 6,	number_format2($myrow['total_salary'],2), -2);



       
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,"Employee"); 

            $rep->TextWrap(441,47,150,"_________________"); 
            $rep->TextWrap(455,37,150,"Manager");
        
    

	$rep->End();
}