<?php

$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_SALESEQUOTATIONREPORT' : 'SA_SALESBULKREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Quotations
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------


print_sales_quotations();

function print_sales_quotations()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5']=1;
	$theme = $_POST['PARAM_6']='simple';

	$REPORT_ID = 111;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$pictures = $SysPrefs->print_item_images_on_quote();
	// If you want a larger image, then increase pic_height f.i.
	// $SysPrefs->pic_height += 25;
	
	$cols = array(4, 60, 130, 175, 200, 230, 300, 400);
	// $cols = array(4, 60, 150, 190, 310, 150, 300, 400);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'right', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_("SALES QUOTATION"), "SalesQuotationBulk", A5, 9, $orientation,null,null, $theme);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESQUOTE);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			if ($SysPrefs->print_invoice_no() == 1)
				$rep->filename = "SalesQuotation" . $i . ".pdf";
			else	
				$rep->filename = "SalesQuotation" . $myrow['reference'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESQUOTE, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESQUOTE);
		$SubTotal = 0;
		$items = $prices = array();
		while ($myrow2=db_fetch($result))
		{
			$Net = round2(($myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"],
			   user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['stk_code'];
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stk_code']));
			$DisplayNet = number_format2($Net,$dec);
				if($myrow2['sale_kit_id'] != 0){
	    		    $myrow2['description'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['description'];
					$myrow2['stk_code'] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
					$kit_qty = get_kit_detail_by_id($myrow2['sale_kit_id'])['quantity'];
				// 	display_error($DisplayQty."/".$kit_qty);exit;
					$DisplayQty = number_format2(str_replace(",", "", $DisplayQty)/$kit_qty,get_qty_dec($myrow2['stock_id']));
					$max_price = get_kit_price_by_id($myrow['order_no'], $myrow['trans_type'], $myrow2['sale_kit_id'])/str_replace(",", "", $DisplayQty);
				    $DisplayPrice = number_format2($max_price,$dec);
				    $DisplayNet = number_format2($max_price*str_replace(",", "", $DisplayQty),$dec);
				    if(in_array(get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'], $array_sales_kit)){
	    		        continue;
	    		    }
	    		    $array_sales_kit[] = get_kit_detail_by_id($myrow2['sale_kit_id'])['item_code'];
				}
			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec());
			$rep->TextCol(0, 1,	$myrow2['stk_code'], -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['description'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;
			if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
			{
				$rep->TextCol(2, 3,	$DisplayQty, -2);
				$rep->TextCol(3, 4,	$myrow2['units'], -2);
				$rep->TextCol(4, 5,	$DisplayPrice, -2);
				$rep->TextCol(5, 6,	$DisplayDiscount, -2);
				$rep->TextCol(6, 7,	$DisplayNet, -2);
			}
			$rep->row = $newrow;
			
			if ($pictures)
			{
				$image = company_path(). "/images/" . item_img_name($myrow2['stk_code']) . ".jpg";
				if (file_exists($image))
				{
					if ($rep->row - $SysPrefs->pic_height < $rep->bottomMargin)
						$rep->NewPage();
					$rep->AddImage($image, $rep->cols[1], $rep->row - $SysPrefs->pic_height, 0, $SysPrefs->pic_height);
					$rep->row -= $SysPrefs->pic_height;
					$rep->NewLine();
				}
			}

				if($orientation=='L'){
			if ($rep->row < $rep->bottomMargin + (9 * $rep->lineHeight)){
				$rep->NewPage();
			}
			}else{

			if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight)){
				$rep->NewPage();
			}
			}

			// if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
			// 	$rep->NewPage();
		}
		if ($myrow['comments'] != "")
		{
			$rep->NewLine();
			$rep->TextColLines(1, 3, $myrow['comments'], -2);
		}
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_SALESQUOTE;

           if($orientation=='L')
        {
        $rep->TextWrap(400,100,150,'Sub-total'); 
        $rep->TextWrap(490,100,150,$DisplaySubTot); 

    	}
    	else
    	{
		$rep->TextCol(4, 6, _("Sub-total"), -2);
		$rep->TextCol(6, 7,	$DisplaySubTot, -2);
		$rep->NewLine();
		}
		if ($myrow['freight_cost'] != 0.0)
		{
		if($orientation=='L')
        	{
        $rep->TextWrap(400,90,150,'Shipping'); 
        $rep->TextWrap(490,90,150,$$DisplayFreight); 
    		}
    		else
    		{
			$DisplayFreight = number_format2($myrow["freight_cost"],$dec);
			$rep->TextCol(4, 6, _("Shipping"), -2);
			$rep->TextCol(6, 7,	$DisplayFreight, -2);
			$rep->NewLine();
		}
		}	
		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		if ($myrow['tax_included'] == 0) {
			if($orientation=='L')
        	{
        $rep->TextWrap(341,80,150,'TOTAL ORDER EX VAT'); 
        $rep->TextWrap(490,80,150,$DisplayTotal); 
    		}
    		else
    		{
			$rep->TextCol(4, 6, _("TOTAL ORDER EX VAT"), - 2);
			$rep->TextCol(6, 7,	$DisplayTotal, -2);
			$rep->NewLine();
			}
		}

		$tax_items = get_tax_for_items($items, $prices, $myrow["freight_cost"],
		  $myrow['tax_group_id'], $myrow['tax_included'],  null);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			$tax_type_name = $tax_item['tax_type_name'];

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
			if($orientation=='L')
        	{
        		$rep->TextWrap(341,70,150,'Total Tax Excluded'); 
        		$rep->TextWrap(490,70,150,number_format2($sign*$tax_item['net_amount'], $dec)); 
    		}
    		else
    		{
						$rep->TextCol(4, 6, _("Total Tax Excluded"), -2);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
			}
					$rep->TextCol(4, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(2, 7, _("Included") . " " . $tax_type_name . " " . _("Amount") . ": " . $DisplayTax, -2);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->TextCol(4, 6, $tax_type_name, -2);
				$rep->TextCol(6, 7,	$DisplayTax, -2);
			}
			$rep->NewLine();
		}

		$rep->NewLine();

		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		if($orientation=='L')
        	{
				$rep->Font('bold');
        		$rep->TextWrap(341,60,150,'TOTAL ORDER VAT INCL.'); 
        		$rep->TextWrap(490,60,150,$DisplayTotal); 
    		}
    		else
    		{
		$rep->Font('bold');
		$rep->TextCol(4, 6, _("TOTAL ORDER VAT INCL."), - 2);
		$rep->TextCol(6, 7,	$DisplayTotal, -2);
			}
		$words = price_in_words($myrow["freight_cost"] + $SubTotal, ST_SALESQUOTE);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}	
		$rep->Font();
		if ($email == 1)
		{
			if ($SysPrefs->print_invoice_no() == 1)
				$myrow['reference'] = $i;
			$rep->End($email);
		}
	}


	//pk
    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
        $row = db_fetch($res);
        if($row['signature2'] == '' && $row['signature3'] == ''){   
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 
        }
        if($row['signature2'] != '' && $row['signature3'] == ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(441,47,150,"_________________"); 
            $rep->TextWrap(455,37,150,$row['signature2']);
        }
        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(260,47,150,"__________________"); 
            $rep->TextWrap(274,37,150,$row['signature2']); 

            $rep->TextWrap(441,47,150,"_______________"); 
            $rep->TextWrap(455,37,150,$row['signature3']);
        }
    }
	if ($email == 0)
		$rep->End();
}

