<?php

$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_SALESCREDITNOTEREPORT' : 'SA_SALESCREDITNOTEREPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Credit Notes
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------
if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
print_credits_new();
else
print_credits();

//----------------------------------------------------------------------------------------------------

function print_credits()
{
	global $path_to_root, $SysPrefs;
	
	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$paylink = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 113;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	$cols = array(4, 60, 225, 300, 325, 385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'right', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('CREDIT NOTE'), "InvoiceBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		if (!exists_customer_trans(ST_CUSTCREDIT, $i))
			continue;
		$sign = -1;
		$myrow = get_customer_trans($i, ST_CUSTCREDIT);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];

		$branch = get_branch($myrow["branch_code"]);
		$branch['disable_branch'] = $paylink; // helper
		$sales_order = null;
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('CREDIT NOTE');
			$rep->filename = "CreditNote" . $myrow['reference'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_CUSTCREDIT, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_customer_trans_details(ST_CUSTCREDIT, $i);
		$SubTotal = 0;
		while ($myrow2=db_fetch($result))
		{
			if ($myrow2["quantity"] == 0)
				continue;

			$Net = round2(($myrow2["unit_price"] * $myrow2["quantity"]) - ($myrow2["discount_percent"] * $myrow2["quantity"]),
 			   user_price_dec());
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
			$DisplayNet = number_format2($Net,$dec);
			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="0.00";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"] * $myrow2["quantity"],user_percent_dec()) ."";
			$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['StockDescription'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;
			$rep->TextCol(2, 3,	$DisplayQty, -2);
			$rep->TextCol(3, 4,	$myrow2['units'], -2);
			$rep->TextCol(4, 5,	$DisplayPrice, -2);
			$rep->TextCol(5, 6,	$DisplayDiscount, -2);
			$rep->TextCol(6, 7,	$DisplayNet, -2);
			$rep->row = $newrow;
			if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
				$rep->NewPage();
		}

		$memo = get_comments_string(ST_CUSTCREDIT, $i);
		if ($memo != "")
		{
			$rep->NewLine();
			$rep->TextColLines(1, 3, $memo, -2);
		}

		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_CUSTCREDIT;

		$rep->TextCol(3, 6, _("Sub-total"), -2);
		$rep->TextCol(6, 7,	'-'.$DisplaySubTot, -2);
		$rep->NewLine();
		if ($myrow['ov_freight'] != 0.0)
		{
			$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
			$rep->TextCol(3, 6, _("Shipping"), -2);
			$rep->TextCol(6, 7,	$DisplayFreight, -2);
			$rep->NewLine();
		}
		$tax_items = get_trans_tax_details(ST_CUSTCREDIT, $i);
		$first = true;
		while ($tax_item = db_fetch($tax_items))
		{
			if ($tax_item['amount'] == 0)
				continue;
			$DisplayTax = number_format2($sign*$tax_item['amount'], $dec);

			if ($SysPrefs->suppress_tax_rates() == 1)
				$tax_type_name = $tax_item['tax_type_name'];
			else
				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
			}
			else
			{
				$rep->TextCol(3, 6, $tax_type_name, -2);
				$rep->TextCol(6, 7,	$DisplayTax, -2);
			}
			$rep->NewLine();
		}
		$rep->NewLine();
		$DisplayTotal = number_format2($sign*($myrow["ov_freight"] + $myrow["ov_gst"] +
			$myrow["ov_amount"]+$myrow["ov_freight_tax"]),$dec);
		$rep->Font('bold');
		$rep->TextCol(3, 6, _("TOTAL CREDIT"), - 2);
		$rep->TextCol(6, 7, $DisplayTotal, -2);
		$words = price_in_words($myrow['Total'], ST_CUSTCREDIT);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}	
		$rep->Font();
		if ($email == 1)
		{
			$myrow['dimension_id'] = $paylink; // helper for pmt link
			$rep->End($email);
		}
	}

	// if($rep->row <= 200){
	//      $rep->NewPage();
	//     }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		// if($row['is_policy_text'] == 1){
		// 	$rep->row = 120;
		// 	$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		// }
		// if($row['is_policy_image'] == 1){
		// 	$logo = company_path() . "/images/" . $row['filename'];
		// 	$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		// }


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	if ($email == 0)
		$rep->End();
}












function print_credits_new()
{
	global $path_to_root, $SysPrefs;
	
	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$paylink = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 113;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	$cols = array(4, 60, 230, 275, 350, 420, 460, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'center', 'left', 'left', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('CREDIT NOTE'), "InvoiceBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		if (!exists_customer_trans(ST_CUSTCREDIT, $i))
			continue;
		$sign = -1;
		$myrow = get_customer_trans($i, ST_CUSTCREDIT);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];

		$branch = get_branch($myrow["branch_code"]);
		$branch['disable_branch'] = $paylink; // helper
		$sales_order = null;
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('CREDIT NOTE');
			$rep->filename = "CreditNote" . $myrow['reference'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_CUSTCREDIT, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_customer_trans_details(ST_CUSTCREDIT, $i);
			$SubTotal = 0;
			$alt_clr = 1;
			$total_rec = db_num_rows($result)*9;
		
			
	
			// display_error(db_num_rows($result));	
			

						$right = $rep->pageWidth - $rep->rightMargin;
			$count__ = 0;
			$print_rec = 0;
			// $start = $rep->row-477;
         $rep->row+=5;
		while ($myrow2=db_fetch($result))
		{
			if ($myrow2["quantity"] == 0)
				continue;

			$Net = round2(($sign  * $myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"],
			   user_price_dec());
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
			$DisplayNet = number_format2($Net,$dec);
			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) ."";

                  


			$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['StockDescription'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;


             	    if($print_rec % 2 == 0)
	      	$rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(189,214,238));  
            else
            $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));   


        $oldrow = $rep->row;


            $rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['StockDescription'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;



			$rep->TextCol(2, 3,	$DisplayQty, -2);
			$rep->TextCol(3, 4,	$myrow2['units'], -2);
			$rep->TextCol(4, 5,	$DisplayPrice, -2);
			$rep->TextCol(5, 6,	$DisplayDiscount, -2);
			$rep->TextCol(6, 7,	$DisplayNet, -2);
			$rep->row = $newrow;


				$rep->SetDrawColor(91,155,213);

				if(($oldrow-$newrow)>12)
						$count__++;

             
				
				
			    $print_rec++;
				$count__++;
				
				
				
				
				  if($count__>35 && ($total_rec-$print_rec)>1)
					    {	
					    	$rep->LineTo(41,533,41,$rep->row+10);
			    //         
							$rep->LineTo(564,533,564,$rep->row+10);

                        }
                         else
                         {
                             $rep->LineTo(41,533,41,150);



	                         $rep->LineTo(564,533,564,150);


                         }



							   if($rep->pageNumber>1)
								{
							// display_error($count__." (".$total_rec."  -".$print_rec.")");
							    if($count__>30 && ($total_rec-$print_rec)<=1)
			   					   {
			   					   	$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
			   					   	 $total_rec-=$print_rec;
			   					   	 $count__=0;
			   					   	 $print_rec=0;
									$rep->NewPage();
									  $rep->row+=5;

									}
              }

                     else
                     { 
                             
                      // display_error($count__." = ".$total_rec."-".$print_rec);	
                      if($count__>32 && ($total_rec-$print_rec)<=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	 $count__=0;
   					   	 $print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;

						}
                     }
						  if($count__>40 && ($total_rec-$print_rec)>=1)
   					   {$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					   	 $total_rec-=$print_rec;
   					   	$count__=0;
						$print_rec=0;
						$rep->NewPage();
						  $rep->row+=5;
						}


			// if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
			// 	$rep->NewPage();
		}


				   if($rep->pageNumber>=1)
       	           $rep->LineTo(41,150,564,150);
       	            else
                   $rep->LineTo(41,$rep->row+10,564,$rep->row+10);






		// $memo = get_comments_string(ST_CUSTCREDIT, $i);
		// if ($memo != "")
		// {
		// 	$rep->NewLine();
		// 	$rep->TextColLines(1, 3, $memo, -2);
		// }

		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (7.9 * $rep->lineHeight);
		$doctype = ST_CUSTCREDIT;
             $rep->cols[2] += 30;
			$rep->cols[3] += 30;
			$rep->aligns[3] = 'left';
		$rep->TextCol(3, 6, _("Sub-total"), +2,0,1,1);
		$rep->TextCol(6, 7,	$DisplaySubTot, -2,0,1,1);
		$rep->NewLine();
		if ($myrow['ov_freight'] != 0.0)
		{
			$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
			$rep->TextCol(3, 6, _("Shipping"), -2);
			$rep->TextCol(6, 7,	$DisplayFreight, -2);
			$rep->NewLine();
		}
		$tax_items = get_trans_tax_details(ST_CUSTCREDIT, $i);
		$first = true;
		while ($tax_item = db_fetch($tax_items))
		{
			if ($tax_item['amount'] == 0)
				continue;
			$DisplayTax = number_format2($sign*$tax_item['amount'], $dec);

			if ($SysPrefs->suppress_tax_rates() == 1)
				$tax_type_name = $tax_item['tax_type_name'];
			else
				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), -2,0,1,1);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2,0,1,1);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2,0,1,1);
					$rep->TextCol(6, 7,	$DisplayTax, -2,0,1,1);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2,0,1,1);
			}
			else
			{
				$rep->TextCol(3, 6, $tax_type_name, -2,0,1,1);
				$rep->TextCol(6, 7,	$DisplayTax, -2,0,1,1);
			}
			$rep->NewLine();
		}
		$rep->NewLine();
		$DisplayTotal = number_format2($sign*($myrow["ov_freight"] + $myrow["ov_gst"] +
			$myrow["ov_amount"]+$myrow["ov_freight_tax"]),$dec);
		$rep->Font('bold');
		$rep->TextCol(3, 6, _("TOTAL CREDIT"), - 2,0,1,1);
		$rep->TextCol(6, 7, $DisplayTotal, -2,0,1,1);
		$words = price_in_words($myrow['Total'], ST_CUSTCREDIT);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2,0,1,1);
		}	
		$rep->Font();

         $rep->SetDrawColor(189, 214, 238);
			$rep->RoundedRect(40, 67.4+640, 290,20,2.25, '','DF',null,array(91,155,213));
			$rep->SetTextColor(255, 255, 255);
	           // display_error(67.4." + 55");
			$rep->TextWrap(50,67.4+55,150,"Memo");//50,152,150
			$rep->SetTextColor(0, 0, 0);

			$rep->RoundedRect(40,67.4+660, 290,65,2.25, '','DF',null,array(222, 234, 246));

		
			$memo = get_comments_string(ST_CUSTCREDIT, $i);
			if ($memo != "")
			{
				//$rep->NewLine();
				$rep->cols[3]=350;
				$rep->TextWrapLines2(45,300,115, $memo, -2);
			}









		if ($email == 1)
		{
			$myrow['dimension_id'] = $paylink; // helper for pmt link
			$rep->End($email);
		}
	}

	// if($rep->row <= 200){
	//      $rep->NewPage();
	//     }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		// if($row['is_policy_text'] == 1){
		// 	$rep->row = 120;
		// 	$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		// }
		// if($row['is_policy_image'] == 1){
		// 	$logo = company_path() . "/images/" . $row['filename'];
		// 	$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		// }


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
	if ($email == 0)
		$rep->End();
}