<?php


$page_security = 'SA_SALES_BY_CUSTOMER';
// ----------------------------------------------------------------
// Creator:	Prem kumar Advani
// date_:	2019-07-31
// Title:	Customer Wise Sale
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

print_customer_wise_report();


//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}

function getTaxes($type, $trans_no)
{
	$sql = "SELECT included_in_price, SUM(CASE WHEN trans_type=".ST_CUSTCREDIT." THEN amount ELSE amount END * ex_rate) AS tax
		FROM ".TB_PREF."trans_tax_details WHERE trans_type='$type' AND trans_no='$trans_no' GROUP BY included_in_price";
    $result = db_query($sql,"No transactions were returned");
    
    if ($result !== false){
    	$row_ = db_fetch($result);
    	if ($row_['included_in_price'])
	    	return $row_['tax'];
	    else
	    	return 0;
    }
    else
    	return 0;
}


function get_all_trans_no_of_debtor($type,$debtor_no,$from,$to){
	$sql = " SELECT trans_no FROM ".TB_PREF."debtor_trans WHERE type = '$type' AND debtor_no = '$debtor_no' AND tran_date >= '".date2sql($from)."' AND tran_date <= '".date2sql($to)."'  ";
	$result = db_query($sql,"Did not Executed get all trans no of debtor");
	$TOTAL_TAXES = 0;
	while($Row = db_fetch($result)){
		$TOTAL_TAXES += getTaxes($type, $Row['trans_no']);
	}
	return $TOTAL_TAXES;

}


function get_transaction_for_report($from,$to,$debtor_no=-1,$type,$summary,$modify_from_date=null,$modify_to_date=null){
	
	if($summary == 1){
		$sql = " SELECT sum(((ov_amount)-ov_discount)*rate) AS amount FROM ".TB_PREF."debtor_trans WHERE type = '$type' AND tran_date >= '".date2sql($from)."' AND tran_date <= '".date2sql($to)."' ";
		if($debtor_no != -1)
			$sql .= " AND debtor_no = '$debtor_no' ";
		/*if($debtor_no == 23)
			display_error($sql);*/
		$result = db_query($sql,"Did not Executed get transaction for report");
		$row = db_fetch($result);
		if($row['amount'] == null || $row['amount'] == '' || $row['amount'] == 0)
			return 0;
		else
			return $row['amount'];
	}else{
		$sql = " SELECT * FROM ".TB_PREF."debtor_trans WHERE (type = '10' OR type = 11) AND debtor_no = '$debtor_no' 
		AND (tran_date >= '".date2sql($from)."' AND tran_date <= '".date2sql($to)."' OR tran_date >= '".$modify_from_date."' AND tran_date <= '".$modify_to_date."')  AND ov_amount != 0";
		/*if($debtor_no == 1)
		display_error($sql);*/
		return  db_query($sql,"Did not Executed get transaction for report");
	}
	

}

//----------------------------------------------------------------------------------------------------


function print_customer_wise_report()
{
	global $path_to_root, $systypes_array;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$comparison = $_POST['PARAM_2'];
	$summary = $_POST['PARAM_3'];
	$zeros = $_POST['PARAM_4']; //1 for yes 0 for no
	$orientation = $_POST['PARAM_5'];
	$destination = $_POST['PARAM_6'];
	$REPORT_ID = 116;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	if($summary == 1)
		$summ = "Yes";
	else
		$summ = "";

	if($comparison == 0)
		$com = "Not Any";
	elseif($comparison == 1)
		$com = "Previous Period";
	elseif($comparison == 2)
		$com = "Previous Year";
	
	$from_year = date('y',strtotime(sql2date($from)));
	$from_month = date('M',strtotime(sql2date($from)));
	$to_year = date('y',strtotime(sql2date($to)));
	$to_month = date('M',strtotime(sql2date($to)));
	$col_name = $from_month." ".$from_year." - ".$to_month." ".$to_year;
	// display_error($comparison);

	// $cols = array(0, 170, 300, 455, 580);
	if($summary){
		$cols = array(0, 170, 300, 455, 580);
		$headers = array(_('Customer Name'), _("Amount"), _('Comparison sales'), _("% Change") );
	}else{
		$cols = array(0, 110, 160, 240,  320, 400, 500, 580);
		$headers = array(_('Customer Name'), _('#'), _('Ref'), _('Date'), _("Amount"), _('Comparison sales'), _("% Change"));
		$line_space =1;
	}


	$aligns = array('left',	'left',	'left',	'left', 'left' ,'left', 'left');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 		'to' => $to),
    				    2 => array('text' => _('Comparison'),'from' => $com, 'to' => ''),
    				    3 => array('text' => _('summary'),'from' => $summ, 'to' => ''));

    $rep = new FrontReport(_('Sales By Customer'), "SalesByCustomer",'A4_REP', 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

    $summary_grand_total=0;
    $not_summary_grand_total=0;
    $res = get_customers();
    while($myrow = db_fetch($res)){
    	if($summary  == 1){	// if summary yes
    		
    		if($comparison == 1){

    			$date = new DateTime(sql2date($from));
				$date->modify('-1 year');
				$modify_from_date = $date->format('Y-m-d');

				$date = new DateTime(sql2date($to));
				$date->modify('-1 year');
				$modify_to_date = $date->format('Y-m-d');

				$invoice_amount_previous = get_transaction_for_report(sql2date($modify_from_date),sql2date($modify_to_date),$myrow['debtor_no'],ST_SALESINVOICE,$summary);
	    		
				$invoice_amount_previous = $invoice_amount_previous - get_all_trans_no_of_debtor(ST_SALESINVOICE,$myrow['debtor_no'],sql2date($modify_from_date),sql2date($modify_to_date));

	    		$credit_amount_previous = get_transaction_for_report(sql2date($modify_from_date),sql2date($modify_to_date),$myrow['debtor_no'],ST_CUSTCREDIT,$summary);

	    		$credit_amount_previous = $credit_amount_previous - get_all_trans_no_of_debtor(ST_CUSTCREDIT,$myrow['debtor_no'],sql2date($modify_from_date),sql2date($modify_to_date));

    		}elseif($comparison == 2){
    			$fiscal_year = get_fiscalyear(get_company_pref('f_year'));
	    		
	    		$date = new DateTime($fiscal_year['begin']);
				$date->modify('-1 year');
				$modify_from_date = $date->format('Y-m-d');

				$date = new DateTime($fiscal_year['end']);
				$date->modify('-1 year');
				$modify_to_date = $date->format('Y-m-d');

				$invoice_amount_previous = get_transaction_for_report(sql2date($modify_from_date),sql2date($modify_to_date),$myrow['debtor_no'],ST_SALESINVOICE,$summary);
				$invoice_amount_previous = $invoice_amount_previous - get_all_trans_no_of_debtor(ST_SALESINVOICE,$myrow['debtor_no'],sql2date($modify_from_date),sql2date($modify_to_date));

	    		$credit_amount_previous = get_transaction_for_report(sql2date($modify_from_date),sql2date($modify_to_date),$myrow['debtor_no'],ST_CUSTCREDIT,$summary);

	    		$credit_amount_previous = $credit_amount_previous - get_all_trans_no_of_debtor(ST_CUSTCREDIT,$myrow['debtor_no'],sql2date($modify_from_date),sql2date($modify_to_date));

    		}

    		$invoice_amount = get_transaction_for_report($from,$to,$myrow['debtor_no'],ST_SALESINVOICE,$summary);
    		$invoice_amount = $invoice_amount - get_all_trans_no_of_debtor(ST_SALESINVOICE,$myrow['debtor_no'],$from,$to);


	    	$credit_amount = get_transaction_for_report($from,$to,$myrow['debtor_no'],ST_CUSTCREDIT,$summary);
			$credit_amount = $credit_amount - get_all_trans_no_of_debtor(ST_CUSTCREDIT,$myrow['debtor_no'],$from,$to);

	    	if($invoice_amount == 0 && $credit_amount == 0 && $invoice_amount_previous == 0 && $credit_amount_previous == 0 && $zeros == 0)
	    		continue;

	    	$oldrow = $rep->row;
			$rep->TextColLines(0, 1, $myrow['name'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;
	    	
	    	$rep->TextCol(1, 2, number_format2($invoice_amount-$credit_amount,$dec));
	    	$summary_grand_total += $invoice_amount-$credit_amount;
	    	
	    	if($comparison == 0)	// comparison option Not Any
	    		$rep->TextCol(2, 3, '');
	    	
	    	elseif($comparison == 1){ // comparison option Prewvious Period

	    		$rep->TextCol(2, 3, number_format2($invoice_amount_previous-$credit_amount_previous,$dec));
	    		$not_summary_grand_total += $invoice_amount_previous-$credit_amount_previous;
	    		
	    	}elseif($comparison == 2){ // comparison option Previous year

	    		$rep->TextCol(2, 3, number_format2($invoice_amount_previous-$credit_amount_previous,$dec));
	    		$not_summary_grand_total += $invoice_amount_previous-$credit_amount_previous;
	    	}
	    	
	    	if($invoice_amount_previous-$credit_amount_previous == 0){
	    		$rep->TextCol(3, 4, number_format2(100, $dec)."%");
	    	}else
	    		$rep->TextCol(3, 4, number_format2(((($invoice_amount-$credit_amount)-($invoice_amount_previous-$credit_amount_previous))/$invoice_amount_previous-$credit_amount_previous)*100,$dec)."%");

	    	$rep->row = $newrow;
	    	$rep->NewLine(0.5);
    	}else{		// if summary no
    		
	    	if($comparison == 1){
		    	$date = new DateTime(sql2date($from));
				$date->modify('-1 year');
				$modify_from_date = $date->format('Y-m-d');

				$date = new DateTime(sql2date($to));
				$date->modify('-1 year');
				$modify_to_date = $date->format('Y-m-d');
			}elseif ($comparison == 2) {
				$fiscal_year = get_fiscalyear(get_company_pref('f_year'));

				$date = new DateTime($fiscal_year['begin']);
				$date->modify('-1 year');
				$modify_from_date = $date->format('Y-m-d');

				$date = new DateTime($fiscal_year['end']);
				$date->modify('-1 year');
				$modify_to_date = $date->format('Y-m-d');
			}

    		$a = 1;
    		$b = 1;
            $Customer_current_total = 0;
            $Customer_previous_total = 0;
    		$result = get_transaction_for_report($from,$to,$myrow['debtor_no'],ST_SALESINVOICE,$summary,$modify_from_date,$modify_to_date );
    		$num_row = db_num_rows($result);
    		while($row = db_fetch($result)){

    			if($comparison == 0 && (strtotime($row['tran_date']) < strtotime(sql2date($from)))) // if option is 1 selected
    				continue;

    			if($a == 1){
    				$rep->fontSize += 3;
    				$oldrow = $rep->row;
					$rep->TextColLines(0, 6, $myrow['name'], -2);
					$newrow = $rep->row;
					$rep->row = $oldrow;
					$rep->fontSize -= 3;
		    		
		    		$rep->row = $newrow;
			    	$rep->NewLine(0.3);
			    	$a =0;
    			}
    			$rep->TextCol(0, 1, $systypes_array[$row['type']]);
    			$rep->TextCol(1, 2, $row['trans_no']);
    			$rep->TextCol(2, 3, $row['reference']);
    			$rep->TextCol(3, 4, sql2date($row['tran_date']));

    			
    			
    			if(strtotime($row['tran_date']) >= strtotime(sql2date($from))){
    				$taxes_ = getTaxes($row['type'], $row['trans_no']);

    				$rep->TextCol(4, 5, number_format2(((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_,$dec));
    				
    				if($row['type'] == ST_SALESINVOICE){
    					$Customer_current_total += ((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
    				}
    				else if($row['type'] == ST_CUSTCREDIT){
    					$Customer_current_total -= ((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
    				}

    			}
    			
    			if($comparison == 0)	// comparison option not any
	    			$rep->TextCol(5, 6, '');
	    		elseif($comparison == 1){ // comparison option prev period
	    			
	    			if(strtotime($row['tran_date']) < strtotime(sql2date($from))){
	    				$taxes_ = getTaxes($row['type'], $row['trans_no']);

    					$rep->TextCol(5, 6, number_format2(((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_,$dec));

    					if($row['type'] == ST_SALESINVOICE)
	    					$Customer_previous_total += ((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
	    				else if($row['type'] == ST_CUSTCREDIT)
    						$Customer_previous_total -=	((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
	    			}
	    		
	    		}
	    		elseif($comparison == 2){ // comparison option previous year
	    			if(strtotime($row['tran_date']) < strtotime(sql2date($from))){
		    			$taxes_ = getTaxes($row['type'], $row['trans_no']);

		    			$rep->TextCol(5, 6, number_format2(((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_,$dec));

		    			if($row['type'] == ST_SALESINVOICE)
	    					$Customer_previous_total += ((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
	    				else if($row['type'] == ST_CUSTCREDIT)
    						$Customer_previous_total -= ((($row['ov_amount'])-$row['ov_discount'])*$row['rate'])-$taxes_;
	    			}
	    		}	

    			$rep->NewLine();
    			

    			if($num_row == $b){	// check for line and space
    				$rep->NewLine(2);
    				$rep->Line($rep->row + 20);
    				
    				$rep->TextCol(0, 2, "Total");
    				$rep->TextCol(0, 2, "Total");
    				$rep->TextCol(4, 5, number_format2($Customer_current_total,$dec));
    				$rep->TextCol(5, 6, number_format2($Customer_previous_total,$dec));
    				
    				if($Customer_previous_total == 0){
    					$v= ($row['type'] == ST_SALESINVOICE) ? 100 : -100;
    					$rep->TextCol(6, 7, number_format2($v, $dec)."%");
    				}else
	    				$rep->TextCol(6, 7, number_format2((($Customer_current_total -$Customer_previous_total)/$Customer_previous_total)*100,$dec)."%");

    				$summary_grand_total+=$Customer_current_total;
    				$not_summary_grand_total+=$Customer_previous_total;
    				
    				$rep->NewLine(2.2);
    				$rep->Line($rep->row + 20);
    			}
    			$b++;
    		}
    		
    	}

    	
    }

   
    // ---------------------------------------work for total ---------------------------------------------- 
	
    $rep->Font('b');
	
	if($summary == 1){
		$rep->NewLine();
    	$rep->Line($rep->row + 20);

    	$rep->TextCol(0, 3, _("Grand Total"), $dec);	

		$rep->AmountCol(1, 2, $summary_grand_total, $dec);


		if($comparison != 0){   			
			$rep->AmountCol(2, 3, $not_summary_grand_total, $dec);
		}else
			$rep->AmountCol(2, 3, 0, $dec);

		if($not_summary_grand_total == 0)
			$rep->TextCol(3, 4, number_format2(100, $dec)."%");
		else
			$rep->TextCol(3, 4, number_format2((($summary_grand_total-$not_summary_grand_total)/$not_summary_grand_total)*100, $dec)."%");

	}else{

		$rep->TextCol(0, 3, _("Grand Total"), $dec);

		
		$rep->AmountCol(4, 5, $summary_grand_total, $dec);

		if($comparison != 0){
			   			
			$rep->AmountCol(5, 6, $not_summary_grand_total, $dec);

		}else
			$rep->AmountCol(5, 6, 0, $dec);

		if($not_summary_grand_total == 0){
			$rep->TextCol(6, 7, number_format2(100, $dec)."%");
		}else
		$rep->TextCol(6, 7, number_format2((($summary_grand_total-$not_summary_grand_total)/$not_summary_grand_total)*100, $dec)."%");	
	}	

	//formula for change %
	//	Change is (period less comparison)/comparison
	// ---------------------------------------work for total end---------------------------------------------- 



	 if($rep->row <= 200){
	     $rep->NewPage();
	    }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(1,6,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }


    $rep->End();
}



/*$sql = " SELECT dt.debtor_no, dt.trans_no, (((dt.ov_amount+dt.ov_gst)-dt.ov_discount)*dt.rate) AS total, ttd.trans_no, SUM(ttd.net_amount) AS net_amount, ttd.amount AS amount FROM ".TB_PREF."trans_tax_details AS ttd INNER JOIN ".TB_PREF."debtor_trans AS dt ON dt.trans_no = ttd.trans_no AND dt.type = ttd.trans_type WHERE dt.type = '$type' AND dt.tran_date >= '".date2sql($from)."' AND dt.tran_date <= '".date2sql($to)."' AND dt.debtor_no = '$debtor_no' AND ttd.net_amount != 0 ";*/



?>