<?php


$page_security = 'SA_SALES_BY_ITEM';
// ----------------------------------------------------------------
// Creator:	Prem kumar Advani
// date_:	2019-08-02
// Title:	Item Wise Sale
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");


print_item_wise_report();

//----------------------------------------------------------------------------------------------------

//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
function get_transaction_for_report($type,$from,$to,$stock_id=null,$summary,$modify_from_date=null,$modify_to_date=null,$a=0){
	if($summary){		
		
		$sql = " SELECT dt.tran_date,dt.type,trans_no, sum(dtd.quantity) AS qty, dtd.unit_price, dtd.unit_tax, dtd.discount_percent, SUM((((dtd.unit_price)*dtd.quantity)- ((dtd.unit_price)*dtd.discount_percent))) AS sale  FROM ".TB_PREF."debtor_trans AS dt JOIN ".TB_PREF."debtor_trans_details AS dtd
			WHERE dt.type = dtd.debtor_trans_type AND dt.trans_no = dtd.debtor_trans_no AND dt.type = '$type'
			AND dt.tran_date >= '".date2sql($from)."' AND dt.tran_date <= '".date2sql($to)."' ";
		if($stock_id != null)
			$sql .= " AND dtd.stock_id = '$stock_id' ";	

		$result = db_query($sql , " did not Executed the function  get transaction for report");
		$row = db_fetch($result);
		if($row['qty'] == null || $row['qty'] == '' || $row['qty'] == 0)
			return 0;
		else
			return $row;
	}else{
		$sql = " SELECT dt.tran_date,dt.type,trans_no, (dtd.quantity) AS qty, dtd.unit_price, dtd.unit_tax, dtd.discount_percent, ((((dtd.unit_price)*dtd.quantity)- ((dtd.unit_price)*dtd.discount_percent))) AS sale  FROM ".TB_PREF."debtor_trans AS dt JOIN ".TB_PREF."debtor_trans_details AS dtd WHERE dt.type = dtd.debtor_trans_type AND dt.trans_no = dtd.debtor_trans_no AND (type = '10' OR type = '11' ) AND 
		( tran_date >= '".date2sql($from)."' AND tran_date <= '".date2sql($to)."' OR tran_date >= '".date2sql($modify_from_date)."' AND tran_date <= '".date2sql($modify_to_date)."' )";
		if($stock_id != null)
			$sql .= " AND stock_id = '$stock_id' ";
		
		$result = db_query($sql , " did not Executed the function  get transaction for report");
		// if($a!=0)
			// display_error($sql);exit;
		return $result;
	}
}
//----------------------------------------------------------------------------------------------------

function print_item_wise_report()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $comparison = $_POST['PARAM_2'];
    $summary = $_POST['PARAM_3'];
    $zeros = $_POST['PARAM_4']; //1 for yes 0 for no
	$orientation = $_POST['PARAM_5'];
	$destination = $_POST['PARAM_6'];
	$REPORT_ID = 117;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	if($summary == 1)
		$summ = "Yes";
	else
		$summ = "";

	if($comparison == 0)
		$com = "Not Any";
	elseif($comparison == 1)
		$com = "Previous Period";
	elseif($comparison == 2)
		$com = "Previous Year";
	
	$from_year = date('y',strtotime(sql2date($from)));
	$from_month = date('M',strtotime(sql2date($from)));
	$to_year = date('y',strtotime(sql2date($to)));
	$to_month = date('M',strtotime(sql2date($to)));
	$col_name = $from_month." ".$from_year." - ".$to_month." ".$to_year;
	// display_error($comparison);

	// $cols = array(0, 170, 300, 455, 580);
	if($summary){
		$cols = array(0, 160, 220, 340, 400, 480, 580);
		$headers = array('', '', _("Current"),  _('Comparative'), '', _("% Change") );
		//('item'), _("Qty")
	}else{
		$cols = array(0, 100, 140, 200, 340, 400, 480, 580);
		$headers = array('', '', '', _("Current"),  _('Comparative'), '', _("% Change") );
		// $headers = array(_(''), _(''),  _("Current"),  _(''), _('Comparative'), _(''), _("% Change"));
		$line_space =1;
	}


	$aligns = array('left',	'left',	'left',	'left', 'left', 'left', 'left', 'left');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 		'to' => $to),
    				    2 => array('text' => _('Comparison'),'from' => $com, 'to' => ''),
    				    3 => array('text' => _('summary'),'from' => $summ, 'to' => ''));

    $rep = new FrontReport(_('Sales By Item'), "SalesByItem",'A4_REP', 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

    $res = get_items_list();
    //$comp_invoice_row =0;
	//$comp_credit_row =0;
	$summary_grand_total=0;
	$summary_grand_sale_total=0;
	$summary_grand_total1=0;
	$summary_grand_sale_total1=0;
	$not_summary_grand_total=0;
	$not_summary_grand_sale_total=0;
	$not_summary_grand_total1=0;
	$not_summary_grand_sale_total1=0;
    
    // 2nd header setting
    if($summary  == 1){
	    $rep->Line($rep->row-5);
	    // display_error($rep->cols[0]);
	    $rep->cols[1] += 15;
	    $rep->cols[2] += 30;
	    $rep->cols[3] -= 7;
	    $rep->cols[4] -= 5;
	    $rep->TextCol(0, 1, _("Item"));
	    $rep->TextCol(1, 2, _("Qty"));
	    $rep->TextCol(2, 3, _("Revenue"));
	    $rep->TextCol(3, 4, _("Qty"));
	    $rep->TextCol(4, 5, _("Revenue"));
    }else{
    	$rep->Line($rep->row-5);
	    $rep->cols[1] -= 10;
	    $rep->cols[2] += 25;
	    $rep->cols[3] += 15;
	    $rep->cols[4] -= 20;
	    $rep->TextCol(0, 1, _("Item"));
	    $rep->TextCol(1, 2, _("Date"));
	    $rep->TextCol(2, 3, _("Qty"));
	    $rep->TextCol(3, 4, _("Revenue"));
	    $rep->TextCol(4, 5, _("Qty"));
	    $rep->TextCol(5, 6, _("Revenue"));
    }
	    $rep->NewLine(2);

    while($myrow = db_fetch($res)){
    	if($summary  == 1){

    		$invoice_row = get_transaction_for_report(ST_SALESINVOICE,$from,$to,$myrow['stock_id'],$summary);
    		$credit_row = get_transaction_for_report(ST_CUSTCREDIT,$from,$to,$myrow['stock_id'],$summary);

    		
    		if($comparison ==1){
				$date = new DateTime(sql2date($from));
				$date->modify('-1 year');
				$modify_from_date = $date->format('d/m/Y');

				$date = new DateTime(sql2date($to));
				$date->modify('-1 year');
				$modify_to_date = $date->format('d/m/Y');
				//display_error($modify_from_date."      ".$modify_to_date);
				
				$comp_invoice_row = get_transaction_for_report(ST_SALESINVOICE,$modify_from_date,$modify_to_date,$myrow['stock_id'],$summary,null,null);
    			$comp_credit_row = get_transaction_for_report(ST_CUSTCREDIT,$modify_from_date,$modify_to_date,$myrow['stock_id'],$summary,null,null);
    		}elseif($comparison == 2){
				$fiscal_year = get_fiscalyear(get_company_pref('f_year'));

				$date = new DateTime($fiscal_year['begin']);
				$date->modify('-1 year');
				$modify_from_date = $date->format('d/m/Y');

				$date = new DateTime($fiscal_year['end']);
				$date->modify('-1 year');
				$modify_to_date = $date->format('d/m/Y');

				$comp_invoice_row = get_transaction_for_report(ST_SALESINVOICE,$modify_from_date,$modify_to_date,$myrow['stock_id'],$summary);
    			$comp_credit_row = get_transaction_for_report(ST_CUSTCREDIT,$modify_from_date,$modify_to_date,$myrow['stock_id'],$summary);	
    		}





    		if($zeros == 0 && $invoice_row == 0 && $credit_row == 0 && $comp_invoice_row == 0 &&  $comp_credit_row == 0)
    			continue;

    		$oldrow = $rep->row;
			$rep->TextColLines(0, 1, $myrow['description'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;

			$rep->TextCol(1, 2, number_format2($invoice_row['qty']-$credit_row['qty'],$dec));
			$rep->TextCol(2, 3, number_format2($invoice_row['sale']-$credit_row['sale'],$dec));
			$summary_grand_total += $invoice_row['qty']-$credit_row['qty'];
			$summary_grand_sale_total += $invoice_row['sale']-$credit_row['sale'];


			if($comparison ==1){
				$rep->TextCol(3, 4, number_format2($comp_invoice_row['qty']-abs($comp_credit_row['qty']),$dec));
				$rep->TextCol(4, 5, number_format2($comp_invoice_row['sale']-abs($comp_credit_row['sale']),$dec));
				$summary_grand_total1 += $comp_invoice_row['qty']-abs($comp_credit_row['qty']);
				$summary_grand_sale_total1 += $comp_invoice_row['sale']-abs($comp_credit_row['sale']);

			}elseif($comparison == 2){
				$rep->TextCol(3, 4, number_format2($comp_invoice_row['qty']-abs($comp_credit_row['qty']),$dec));
				$rep->TextCol(4, 5, number_format2($comp_invoice_row['sale']-abs($comp_credit_row['sale']),$dec));
				$summary_grand_total1 += $comp_invoice_row['qty']-abs($comp_credit_row['qty']);
				$summary_grand_sale_total1 += $comp_invoice_row['sale']-abs($comp_credit_row['sale']);
			}

			
			if(($comp_invoice_row['sale']-abs($comp_credit_row['sale'])) == 0){
				$variable_change = 100;
			}else{
				$variable_change = ((($invoice_row['sale']-$credit_row['sale']) - ($comp_invoice_row['sale']-abs($comp_credit_row['sale'])))/($comp_invoice_row['sale']-abs($comp_credit_row['sale'])))*100;
			}
			$rep->TextCol(5, 6, number_format2($variable_change, $dec)."%");

			$rep->row = $newrow;
	    	if ($rep->row < $rep->bottomMargin + (0)){
	    		$rep->cols[1] -= 15;
			    $rep->cols[2] -= 30;
			    $rep->cols[3] += 7;
			    $rep->cols[4] += 5;
				$rep->NewPage();
				$rep->cols[1] += 15;
			    $rep->cols[2] += 30;
			    $rep->cols[3] -= 7;
			    $rep->cols[4] -= 5;
	    	}else
	    		$rep->NewLine(0.5);
	    // end of if 
    	}else{
    		if($comparison ==1){
	    		$date = new DateTime(sql2date($from));
				$date->modify('-1 year');
				$modify_from_date = $date->format('d/m/Y');

				$date = new DateTime(sql2date($to));
				$date->modify('-1 year');
				$modify_to_date = $date->format('d/m/Y');
			}elseif($comparison ==2){
				$fiscal_year = get_fiscalyear(get_company_pref('f_year'));

				$date = new DateTime($fiscal_year['begin']);
				$date->modify('-1 year');
				$modify_from_date = $date->format('d/m/Y');

				$date = new DateTime($fiscal_year['end']);
				$date->modify('-1 year');
				$modify_to_date = $date->format('d/m/Y');
			}
			//display_error($modify_to_date."   ||||   ".$modify_from_date);


			$a = 1;
    		$b = 1;
    		$items_current_total = 0;
    		$items_current_sale_total = 0;
            $items_previous_total = 0;
            $items_previous_sale_total = 0;
    		$result = get_transaction_for_report(ST_SALESINVOICE,$from,$to,$myrow['stock_id'],$summary,$modify_from_date,$modify_to_date,1);
    		$num_row = db_num_rows($result);
    		if($num_row == 0)
    			continue;
    		while($row = db_fetch($result)){

    			if($comparison == 0 && (strtotime($row['tran_date']) < strtotime(sql2date($from)))) // if option is 1 selected
    				continue;

    			if($a == 1){
    				$rep->fontSize += 3;
    				$oldrow = $rep->row;
					$rep->TextColLines(0, 6, $myrow['stock_id']." - ".$myrow['description'], -2);
					$newrow = $rep->row;
					$rep->row = $oldrow;
					$rep->fontSize -= 3;
		    		
		    		$rep->row = $newrow;
			    	$a =0;
    			}

    			$rep->TextCol(0, 1, $systypes_array[$row['type']]." - ".$row['trans_no']);
    			$rep->TextCol(1, 2, sql2date($row['tran_date']));

    			if(strtotime($row['tran_date']) >= strtotime(sql2date($from))){
    				if($row['type'] == 11){
	    				$rep->TextCol(2, 3, "(".number_format2(abs($row['qty']),$dec).")");
	    				$rep->TextCol(3, 4, "(".number_format2(abs($row['qty']),$dec).")");
	    				$items_current_total -= ($row['qty']);
	    				$items_current_sale_total -= ($row['sale']);
    				}
	    			else{
	    				$rep->TextCol(2, 3, number_format2(abs($row['qty']),$dec));
	    				$rep->TextCol(3, 4, number_format2($row['sale'],$dec));
	    				$items_current_total += abs($row['qty']);
	    				$items_current_sale_total += abs($row['sale']);
	    			}
    			}

    			if($comparison != 0){
    				if(strtotime($row['tran_date']) < strtotime(sql2date($from))){
	    				if($row['type'] == 11){
		    				$rep->TextCol(4, 5, "(".number_format2(abs($row['qty']),$dec).")");
		    				$rep->TextCol(5, 6, "(".number_format2($row['sale'],$dec).")");
		    				$items_previous_total -= ($row['qty']);
		    				$items_previous_sale_total -= (abs($row['sale']));

	    				}
		    			else{
		    				$rep->TextCol(4, 5, number_format2(abs($row['qty']),$dec));
		    				$rep->TextCol(5, 6, number_format2(abs($row['sale']),$dec));
		    				$items_previous_total += abs($row['qty']);
		    				$items_previous_sale_total += abs($row['sale']);
		    			}
		    		}
    			}
    			if ($rep->row < $rep->bottomMargin + (0)){
					$rep->cols[1] += 10;
				    $rep->cols[2] -= 25;
				    $rep->cols[3] -= 15;
				    $rep->cols[4] += 20;
					$rep->NewPage();
				    $rep->cols[1] -= 10;
				    $rep->cols[2] += 25;
				    $rep->cols[3] += 15;
				    $rep->cols[4] -= 20;

				}else{
					$rep->cols[1] += 10;
				    $rep->cols[2] -= 25;
				    $rep->cols[3] -= 15;
				    $rep->cols[4] += 20;
	    			$rep->NewLine();
	    			$rep->cols[1] -= 10;
				    $rep->cols[2] += 25;
				    $rep->cols[3] += 15;
				    $rep->cols[4] -= 20;
				}
    			if($num_row == $b){	// check for line and space
    				if ($rep->row < $rep->bottomMargin + (0)){
					$rep->cols[1] += 10;
				    $rep->cols[2] -= 25;
				    $rep->cols[3] -= 15;
				    $rep->cols[4] += 20;
					$rep->NewPage();
				    $rep->cols[1] -= 10;
				    $rep->cols[2] += 25;
				    $rep->cols[3] += 15;
				    $rep->cols[4] -= 20;

					}else{
						$rep->cols[1] += 10;
					    $rep->cols[2] -= 25;
					    $rep->cols[3] -= 15;
					    $rep->cols[4] += 20;
	    				$rep->NewLine(2);
	    				$rep->cols[1] -= 10;
					    $rep->cols[2] += 25;
					    $rep->cols[3] += 15;
					    $rep->cols[4] -= 20;
	    			}
    				$rep->Line($rep->row + 20);
    				
    				$rep->TextCol(0, 2, _("Total"));
    				$rep->TextCol(0, 2, _("Total"));
    				$rep->TextCol(2, 3, number_format2($items_current_total,$dec));
    				$rep->TextCol(3, 4, number_format2($items_current_sale_total,$dec));
    				$rep->TextCol(4, 5, number_format2($items_previous_total,$dec));
    				$rep->TextCol(5, 6, number_format2($items_previous_sale_total,$dec));

					if($items_previous_sale_total == 0){
						$rep->TextCol(6, 7, number_format2(100,$dec)."%");
					}else{
						$rep->TextCol(6, 7, number_format2((($items_current_sale_total-$items_previous_sale_total)/$items_previous_sale_total)*100,$dec)."%");    				
					}


    				$not_summary_grand_total+=$items_current_total;
    				$not_summary_grand_total1+=$items_previous_total;
    				$not_summary_grand_sale_total += $items_current_sale_total;
    				$not_summary_grand_sale_total1 += $items_previous_sale_total;
    				
    				if ($rep->row < $rep->bottomMargin + (0)){
						$rep->cols[1] += 10;
					    $rep->cols[2] -= 25;
					    $rep->cols[3] -= 15;
					    $rep->cols[4] += 20;
						$rep->NewPage();
					    $rep->cols[1] -= 10;
					    $rep->cols[2] += 25;
					    $rep->cols[3] += 15;
					    $rep->cols[4] -= 20;

					}else{
    					$rep->NewLine(2.2);
    				}
    				$rep->Line($rep->row + 20);
    			}
    			$b++;	

    		}
    	}
    }

     // ---------------------------------------work for total ---------------------------------------------- 
    $rep->Font('b');
    if($summary == 1){
		$rep->NewLine();
    	$rep->Line($rep->row + 20);
    	$rep->TextCol(0, 3, _("Grand Total"), $dec);
		
		$rep->AmountCol(1, 2, $summary_grand_total, $dec);

		$rep->AmountCol(2, 3, $summary_grand_sale_total, $dec);

		if($comparison != 0){   			
			$rep->AmountCol(3, 4, $summary_grand_total1, $dec);

			$rep->AmountCol(4, 5, $summary_grand_sale_total1, $dec);
		}else{
			$rep->AmountCol(3, 4, 0, $dec);
			$rep->AmountCol(4, 5, 0, $dec);
		}

		/*$rep->TextCol(5, 6, number_format2(($summary_grand_total-$summary_grand_total1)/$summary_grand_total1, $dec)."%");
		$rep->TextCol(5, 6, number_format2(($summary_grand_total-$summary_grand_total1)/$summary_grand_total1, $dec)."%");*/
		if($summary_grand_sale_total1 == 0)
		$rep->TextCol(5, 6, number_format2(100 , $dec)."%");
		else{
			$rep->TextCol(5, 6, number_format2((($summary_grand_sale_total-$summary_grand_sale_total1)/$summary_grand_sale_total1)*100, $dec)."%");
		}

		$rep->cols[1] -= 15;
	    $rep->cols[2] -= 30;
	    $rep->cols[3] += 7;
	    $rep->cols[4] += 5;

	}else{
		$rep->TextCol(0, 3, _("Grand Total"), $dec);
		$rep->AmountCol(2, 3, $not_summary_grand_total, $dec);
		$rep->AmountCol(3, 4, $not_summary_grand_sale_total, $dec);
		if($comparison != 0){   			
			$rep->AmountCol(4, 5, $not_summary_grand_total1, $dec);
			$rep->AmountCol(5, 6, $not_summary_grand_sale_total1, $dec);
		}

		if($not_summary_grand_sale_total1 == 0){
			$rep->TextCol(6, 7, number_format2(100, $dec)."%");
		}else{
		$rep->TextCol(6, 7, number_format2((($not_summary_grand_sale_total-$not_summary_grand_sale_total1)/$not_summary_grand_sale_total1)*100, $dec)."%");
		}

		$rep->cols[1] += 10;
	    $rep->cols[2] -= 25;
	    $rep->cols[3] -= 15;
	    $rep->cols[4] += 20;
		
	}
	$rep->Font();

    // ---------------------------------------work for total ----------------------------------------------

 if($rep->row <= 200){
	     $rep->NewPage();
	    }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(1,6,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
    
    $rep->End();

}