<?php
$page_security = 'SA_OPEN_SALES_INVOICE';
// ----------------------------------------------------------------
// Creator:	Prem kumar Advani
// date_:	2019-09-17
// Title:	Open Sales Invoice
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

print_open_sales_invoice();


function get_days_differnce($due_date){
	$now = time(); // or your date as well
	$your_date = strtotime($due_date);
	
	if($your_date > $now)
		return ;
	
	$datediff = $now - $your_date;
	return  round($datediff / (60 * 60 * 24));
}
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}

function getTransactions($debtorno)
{
    $sql = "SELECT *,
    		(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount) AS TotalAmount, alloc AS Allocated,
				type = ".ST_SALESINVOICE." 
			FROM ".TB_PREF."debtor_trans
			WHERE debtor_no = ".db_escape($debtorno)."
   				AND type <> ".ST_CUSTDELIVERY."
				AND ABS(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount) > ". FLOAT_COMP_DELTA;

	if (!$show_also_allocated)
		$sql .= " AND ABS(ABS(ov_amount + ov_gst + ov_freight +	ov_freight_tax + ov_discount) - alloc) > ". FLOAT_COMP_DELTA;
	$sql .= " ORDER BY tran_date";

    return db_query($sql,"No transactions were returned");
}

function print_open_sales_invoice()
{
    global $path_to_root, $systypes_array;


    $customers = $_POST['PARAM_0'];
    $show_items = $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];
	$REPORT_ID = 118;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	if($customers != null)
		$cust = get_customer_name($customers);
	else
		$cust = null;
	
	/*if($items != null)
		$item = get_item($items)['stockDescription'];
	else*/
		$item = null;

	
	$cols = array(1, 30, 80, 140,  200, 270, 310, 410, 490, 560, 590);
	$headers = array(_('Type'),_('#'), _('Ref'), _("Date"), _('Due Date'), _('Anging'), _("Terms") , _('Amount'), _("Balance"));

	$aligns = array('left',	'left',	'left',	'left', 'left',	'left', 'left' , 'left');
	$params = array(0 => $comments,
    				1 => array('text' => _('Customer'), 'from' => $cust, 'to' => ''),
    				2 => array('text' => _('Item'),'from' => $item, 'to' => '')
    		);

    $rep = new FrontReport(_('Open Sales Invoice'), "OpenSalesInvoice",'A4_REP', 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

    if($show_items){
    	$rep->cols[1] += 30;
    	$rep->cols[2] += 50;
    	$rep->TextCol(0, 1, _("Stock ID"));
		$rep->TextCol(1, 2, _("Description"));
		$rep->TextCol(4, 5, _("Quantity"));
		$rep->TextCol(6, 7, _("Price"));
		$rep->TextCol(7, 8, _("Total"));
		$rep->cols[1] -= 30;
		$rep->cols[2] -= 50;
		$rep->newLine(0.5);
		$rep->Line($rep->row);
		$rep->newLine(2);
    }

    $sql = "SELECT debtor_no, name, curr_code FROM ".TB_PREF."debtors_master ";
	if ($customers != null)
		$sql .= "WHERE debtor_no=".db_escape($customers);
	$sql .= " ORDER BY name";
	$result = db_query($sql, "The customers could not be retrieved");
	$total_customer_amount=0;
	$total_customer_alloc = 0;
	while ($myrow = db_fetch($result)){
		$result1 = getTransactions($myrow['debtor_no']);
		
		if(db_num_rows($result1) == 0) continue;
		
		if($num != 0)
			$rep->newLine(1);

		$rep->fontSize += 2;
		$rep->TextCol(0, 7, $myrow['name']);
		$rep->fontSize -= 2;
		$rep->newLine(1.5);
		
		while($row = db_fetch($result1)){
			$words = explode(" ", $systypes_array[$row['type']]);
			$acronym = "";
			foreach ($words as $w) {
			  $acronym .= $w[0];
			}
			$rep->TextCol(0, 1, $acronym);
			$rep->TextCol(1, 2, $row['trans_no']);
			$rep->TextCol(2, 3, $row['reference']);
			$rep->TextCol(3, 4, sql2date($row['tran_date']));
			if($row['due_date'] != '0000-00-00'){
				$rep->TextCol(4, 5, sql2date($row['due_date']));
				$rep->TextCol(5, 6, get_days_differnce($row['due_date']));
			}
			
			if ($destination)
				$rep->TextCol(6, 7, get_payment_terms($row['payment_terms'])["terms"]);
			else{
				$oldrow = $rep->row;
				$rep->TextColLines(6, 7, get_payment_terms($row['payment_terms'])["terms"]);
		        $newrow = $rep->row;
				$rep->row = $oldrow;
			}
			/*if($row['ov_amount'] < 0)
				$rep->TextCol(6, 7, "(".number_format(abs($row['ov_amount']),$dec).")");
			else*/
				$rep->TextCol(7, 8, number_format($row['ov_amount'],$dec));

			$rep->TextCol(8, 9, number_format($row['ov_amount']-$row['alloc'], $dec));
			
			$total_customer_amount += $row['ov_amount'];
			$total_customer_alloc += $row['ov_amount']-$row['alloc'];

			if ($destination)
				$rep->newLine(1.2);
			else
				$rep->row = $newrow;

			if ($rep->row < $rep->bottomMargin + (10 * $rep->lineHeight)-100)
				$rep->NewPage();
			$num=1;

			if($show_items){
				$result2 = get_customer_trans_details($row['type'], $row['trans_no']);
				if(db_num_rows($result2) == 0) continue;

				while($MYrow = db_fetch($result2)){
					$rep->cols[1] += 30;
			    	$rep->cols[2] += 50;
			    	$rep->TextCol(0, 1, $MYrow['stock_id']);
					$rep->TextCol(1, 4, $MYrow['description']);
					$rep->TextCol(4, 5, number_format($MYrow['quantity'],$dec));
					$rep->TextCol(6, 7, number_format($MYrow['unit_price'],$dec));
					$rep->TextCol(7, 8, number_format(($MYrow['quantity']*$MYrow['unit_price']),$dec));
					$rep->cols[1] -= 30;
					$rep->cols[2] -= 50;
					$rep->newLine(1);
				}
				
				//$rep->newLine(1.2);
			}
			$rep->Line($rep->row);
			$rep->newLine(1.2);


			
		}
		$rep->TextCol(0, 1, _("Total"));
		$rep->TextCol(7, 8, number_format($total_customer_amount,$dec));
		$rep->TextCol(8, 9, number_format($total_customer_alloc, $dec));
		$rep->newLine(1);
		$rep->Line($rep->row);
		$rep->newLine(1.2);
		$total_customer_amount=0;
		$total_customer_alloc=0;
	}
 if($rep->row <= 200){
	     $rep->NewPage();
	    }

    $res = checking_report($REPORT_ID);
     if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,9,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }
    $rep->End();
}