<?php

$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_DELIVERY' : 'SA_PRINT_DELIVERY';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Janusz Dobrwolski
// date_:	2008-01-14
// Title:	Print Delivery Notes
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");

//----------------------------------------------------------------------------------------------------
 
print_deliveries();

 
//-----------------------------------------------Get Attachments------------------------------------------------

function get_attachment_id($trans_no, $trans_type){

	$sql = "SELECT description, unique_name FROM ".TB_PREF."attach_inquiry_link_detail AS aild 
	LEFT JOIN ".TB_PREF."attach_inquiry_detail AS aid ON aild.attach_id = aid.attach_id 
	WHERE aild.trans_no = ".db_escape($trans_no)." AND trans_type = ".db_escape($trans_type)."
	AND unique_name != '' 
	";
	// display_error($sql);
	$result =db_query($sql);
	return $result;
}


//----------------------------------------------------------------------------------------------------

function print_deliveries()
{
	// exit();

	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$packing_slip = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 119;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	$cols = array(0, 30, 430);

	// $headers in doctext.inc
	$aligns = array('center',	'center',	'center', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments, 'packing_slip' => $packing_slip);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{
		if ($packing_slip == 0)
			$rep = new FrontReport(_('DELIVERY'), "DeliveryNoteBulk", user_pagesize(), 9, $orientation);
		else
			$rep = new FrontReport(_('PACKING SLIP'), "PackingSlipBulk", user_pagesize(), 9, $orientation);
	}
    if ($orientation == 'L')
    	recalculate_cols($cols);
	for ($i = $from; $i <= $to; $i++)
	{
			if (!exists_customer_trans(ST_CUSTDELIVERY, $i))
				continue;
			$myrow = get_customer_trans($i, ST_CUSTDELIVERY);
			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER); // ?
 
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'delivery', $branch['debtor_no'], true);
			$rep->SetCommonData($myrow, $branch, $sales_order, '', ST_CUSTDELIVERY, $contacts);
			$rep->SetHeaderType('Header5');
			$rep->NewPage();

			$result = get_customer_trans_details(ST_CUSTDELIVERY, $i);
			$SubTotal = 0;
			$ser = 1;
			while ($myrow2=db_fetch($result))
			{
				$c=0;
				if ($myrow2["quantity"] == 0)
					continue;

				$Net = round2( ($myrow2["unit_price"] * $myrow2["quantity"]) - $myrow2["discount_percent"] ,
				   user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net,$dec);
	    
	    	 	
				
				$DisplayDiscount = number_format2($myrow2["discount_percent"],user_percent_dec()) . "";
				$rep->TextCol($c++, $c,	$ser++, -2);
				$aligns[$c] = 'left';
				$rep->Info($params, $cols, null, $aligns);
				$oldrow = $rep->row;
				$rep->TextColLines($c++, $c,'  '.$myrow2['StockDescription'], -2);
				$newrow = $rep->row;
				$rep->row = $oldrow;
				$aligns[$c-1] = 'center';
				$rep->Info($params, $cols, null, $aligns);
				$rep->row = $newrow;
				$rep->line($rep->row);
				if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
					$rep->NewPage();
			}

			$RepRow = $rep->row;
			for($i = 0; $i<=10; $i++){
	 			if($rep->row>300){
						$rep->NewLine(2);
						$rep->line($rep->row);
	 			}
			} 

			// $memo = get_comments_string(ST_CUSTDELIVERY, $i);
			// if ($memo != "")
			// {
			// 	$rep->NewLine();
			// 	$rep->TextColLines(1, 3, $memo, -2);
			// }

   // 			$DisplaySubTot = number_format2($SubTotal,$dec);

   //  		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
			// $doctype=ST_CUSTDELIVERY;
			// if ($packing_slip == 0)
			// {
			// 	$rep->TextCol(3, 6, _("Sub-total"), -2);
			// 	$rep->TextCol(6, 7,	$DisplaySubTot, -2);
			// 	$rep->NewLine();
			// 	if ($myrow['ov_freight'] != 0.0)
			// 	{
			// 		$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
			// 		$rep->TextCol(3, 6, _("Shipping"), -2);
			// 		$rep->TextCol(6, 7,	$DisplayFreight, -2);
			// 		$rep->NewLine();
			// 	}	
			// 	$tax_items = get_trans_tax_details(ST_CUSTDELIVERY, $i);
			// 	$first = true;
   //  			while ($tax_item = db_fetch($tax_items))
   //  			{
   //  				if ($tax_item['amount'] == 0)
   //  					continue;
   //  				$DisplayTax = number_format2($tax_item['amount'], $dec);
 
 		// 			if ($SysPrefs->suppress_tax_rates() == 1)
 		//    				$tax_type_name = $tax_item['tax_type_name'];
 		//    			else
 		//    				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

 		// 			if ($myrow['tax_included'])
   //  				{
   // 						if ($SysPrefs->alternative_tax_include_on_docs() == 1)
   //  					{
   //  						if ($first)
   //  						{
			// 					$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
			// 					$rep->TextCol(6, 7,	number_format2($tax_item['net_amount'], $dec), -2);
			// 					$rep->NewLine();
   //  						}
			// 				$rep->TextCol(3, 6, $tax_type_name, -2);
			// 				$rep->TextCol(6, 7,	$DisplayTax, -2);
			// 				$first = false;
   //  					}
   //  					else
			// 				$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
			// 		}
   //  				else
   //  				{
			// 			$rep->TextCol(3, 6, $tax_type_name, -2);
			// 			$rep->TextCol(6, 7,	$DisplayTax, -2);
			// 		}
			// 		$rep->NewLine();
   //  			}
   //  			$rep->NewLine();
			// 	$DisplayTotal = number_format2($myrow["ov_freight"] +$myrow["ov_freight_tax"] + $myrow["ov_gst"] +
			// 		$myrow["ov_amount"],$dec);
			// 	$rep->Font('bold');
			// 	$rep->TextCol(3, 6, _("TOTAL DELIVERY INCL. VAT"), - 2);
			// 	$rep->TextCol(6, 7,	$DisplayTotal, -2);
			// 	$words = price_in_words($myrow['Total'], ST_CUSTDELIVERY);
			// 	if ($words != "")
			// 	{
			// 		$rep->NewLine(1);
			// 		$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
			// 	}	
			// 	$rep->Font();
			// }	
			 
	}
 
// =============================================================================================================================
// New Code added here by Waleed to print terms & conditions on a new page;
// 04/10/2022


	// $res = get_customer_trans_details(ST_CUSTDELIVERY,$from);
	// $terms = db_fetch($res);

	// $terms_and_conditions = company_path()."/images/terms_and_conditions/".$terms['stock_id'].".jpg";
	// if (file_exists($terms_and_conditions) && $terms['stock_id']) {
	// 	$rep->SetHeaderType();
	// 	$rep->NewPage();
	// 	$rep->AddImage($terms_and_conditions,0,0,600,850);
	// }

	// $client_sign = company_path()."/images/jobcard_signatures/client_schedule-".$myrow['trans_no'].".jpg";
	// $technician = company_path()."/images/jobcard_signatures/tech_schedule-".$myrow['trans_no'].".jpg";
	// if(file_exists( $client_sign ) || file_exists( $technician ) || $myrow['emirates_id']){
	// 		$rep->SetHeaderType('BlankHeader');
	// 		$rep->NewPage();
	// 		$rep->row = 800;
	// 		$rep->fontSize += 4;
	// }

	// $rep->fontSize  = 9;
	// $rep->SetHeaderType('BlankHeader');
	// $rep->NewPage();
//Add Id Card Image    
// 	if($myrow['emirates_id']){
// 	$rep->Font('bold');
// 	$rep->NewLine();
// 	$rep->TextWrap(30,$rep->row-150,800, "Emirates ID");
// 	$rep->TextWrap(30,$rep->row-150,0,"_____________");
// 	global $path_to_root;
// 	$emirates_id = company_path() . "/attachments/emirate_id/".$myrow['emirates_id'];
// 	if(file_exists($emirates_id))
// 		$rep->AddImage($emirates_id,30,450,260,160);

// 	$rep->Font('');

// }	
	//Signature Code
// 	if(file_exists($client_sign)){
// 	$client_sign = company_path()."/images/jobcard_signatures/client_schedule-".$myrow['trans_no'].".jpg";
// 	$rep->AddImage($client_sign,450,600,100,100);
// 	$rep->TextWrap(450,$rep->row-220,100,"Client Signature");
// 	}
// 	if(file_exists($technician)){
// 	$technician = company_path()."/images/jobcard_signatures/tech_schedule-".$myrow['trans_no'].".jpg";
// 	$rep->AddImage($technician, 450,450,100,100);
// 	$rep->TextWrap(450,$rep->row-370,120,"Technician Signature");
// }

	// $rep->NewLine(14);
	// $rep->Line($rep->row);


	//Items Attachments
	// $trans_no = $rep->formData['trans_no'];
	// $res2 = get_attachment_id($trans_no,ST_CUSTDELIVERY);
	// while($attach_row = db_fetch($res2)){
	// $rep->NewLine(3);
	// $rep->TextWrap(40,$rep->row,600, $attach_row['description']);
	// $rep->NewLine(1);
	// $rep->Line($rep->row);
	// $rep->NewLine(2);
	// $logo = company_path() . "/attachments/attachments_inquiry/".$attach_row['unique_name'];
	// if(file_exists($logo) && $attach_row['unique_name'] != '')
	// $rep->AddImage($logo,40,370,400,160);
	
	// }
//===========================================================================================================================




	if ($email == 0)
		$rep->End();
}
 