<?php
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_SALESTRANSVIEW' : 'SA_SALESBULKREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Invoices
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/multicompany_db.inc");

//----------------------------------------------------------------------------------------------------

print_invoices();

//----------------------------------------------------------------------------------------------------
function get_card_num($order_no)
{
	$sql = "SELECT card_num,order_time,cash_recieved,deliver_to  from ".TB_PREF."sales_orders where `order_no`=".$order_no;
	$db = db_query($sql);
	$ft = db_fetch($db);
	return $ft;
}
function print_invoices()
{
	global $path_to_root, $alternative_tax_include_on_docs, $suppress_tax_rates, $no_zero_lines_amount;

	include_once($path_to_root . "/reporting/includes/pdf_report_pos.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$pay_service = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];

	if (!$from || !$to) return;

	$dec = user_price_dec();
	// $dec = 0;

	// $fno = explode("-", $from);
	// $tno = explode("-", $to);
	// $from = min($fno[0], $tno[0]);
	// $to = max($fno[0], $tno[0]);

	$cols = array(5, 10, 90, 120, 160, 200, 270, 300);
	// $headers in doctext.inc
	$aligns = array('left','left','left', 'left','left','left');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
	{
		$rep = new FrontReport(_('ESTIMATE'), "InvoiceBulk", array(250.6,842), '8');
		$rep->SetHeaderType('Header107');
		$rep->currency = $cur;
		$rep->Font();

//		$rep->fontSize -= 2;
		$rep->Info($params, $cols, $headers, $aligns);
//		$rep->fontSize += 2;
	}
	for ($i = $from; $i <= $to; $i++)
	{
		if (!exists_customer_trans(ST_SALESINVOICE, $i))
			continue;
		$sign = 1;
		$myrow = get_customer_trans_invoice($i, ST_SALESINVOICE);
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];

		$branch = get_branch($myrow["branch_code"]);
		$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER);
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize());
			$rep->SetHeaderType('Header1071');
			$rep->currency = $cur;
			$rep->Font();
			$rep->title = _('');
			$rep->filename = "Invoice" . $myrow['reference'] . ".pdf";
			$rep->Info($params, $cols, null, $aligns);
		}
		else
			$rep->title = _('');



		$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], false);
		$baccount['payment_service'] = $pay_service;
		// display_error($sales_order['branch']);exit;
		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_SALESINVOICE, $contacts);
		$rep->NewPage();

			global $SysPrefs;
       $logo = $path_to_root. "/company/0/images/logo1.png";
		// $rep->AddImage($logo, 10, $rep->row+100	, 40, 28);

		$result = get_customer_trans_details_invoice(ST_SALESINVOICE, $i);
		$SubTotal = 0;
		$total_p;
		$TOTALDiscount =0;
		$rep->row += 12;
		while ($myrow2=db_fetch($result))
		{
			if ($myrow2["quantity"] == 0)
				continue;

			$Net = round2($sign * ( ($myrow2["unit_price"] * $myrow2["quantity"]) -$myrow2["discount_percent"]),
				user_price_dec());
			$SubTotal += $Net;

			$DisplayPrice = number_format2($myrow2["unit_price"],0);

			$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
			$DisplayNet = number_format2($Net,0);

			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else{
				$DisplayDiscount = number_format2($myrow2["discount_percent"], 0);
				$TOTALDiscount += $DisplayDiscount;
			}

			$rep->NewLine();
			//$rep->TextCol(0, 1,	$myrow2['stock_id'], -2);
			$rep->cols[0] += 4;
			$rep->TextColLines(0, 2, get_item($myrow2['stock_id'])['description_arabic'], -2);
			$rep->cols[0] -= 4;
			$oldrow = $rep->row;
			//$rep->fontSize += 3;
			$rep->cols[0] += 4;
			if(!is_numeric($myrow2['stk_id'])){
				$rep->TextColLines(0, 2, $myrow2['StockDescription'], -2);//."(".$myrow2['stk_id'].")"
			}else{
				$rep->TextColLines(0, 2, $myrow2['StockDescription'], -2);
			}
			$rep->cols[0] -= 4;

			//$rep->fontSize -= 3;
			$newrow = $rep->row;
			$rep->row = $oldrow;

			if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !isset($no_zero_lines_amount) || $no_zero_lines_amount == 0)
			{
				$rep->TextCol(2, 3,	$myrow2["quantity"], -2);
				//	$rep->TextCol(3, 4,	$myrow2['units'], -2);
				$rep->TextCol(3, 4,	$DisplayPrice, -2);
				$rep->TextCol(4, 5,	$DisplayDiscount, -2);
				$rep->TextCol(5, 6,	$DisplayNet, -2);

			}
				$total_p += $DisplayNet;

			$rep->NewLine(0.2);
			// $rep->cols[0] += 7;
			$rep->TextCol(0, 6,	_("........................................................................"), -2);
			// $rep->cols[0] -= 7;
			$rep->NewLine(-0.2);
			$rep->row = $newrow;
			//$rep->NewLine(1);
			if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
				$rep->NewPage();
		}

		$memo = get_comments_string(ST_SALESINVOICE, $i);
		if ($memo != "")
		{
			$rep->NewLine();
			$rep->TextColLines(1, 5, $memo, -2);
		}

		$DisplaySubTot = $SubTotal;
		$DisplayFreight = number_format2($sign*$myrow["ov_freight"],0);

		//$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_SALESINVOICE;
		//	$rep->NewLine(-25);
		//	$rep->TextCol(0, 2, _("Sub-total"), -2);
		//	$rep->TextCol(2, 4,	$DisplaySubTot, -2);
		//	$rep->NewLine();
		
		$rep->NewLine();
		$rep->TextCol(0, 2, _("Sub - Total (Ex.VAT)"), - 2);
		$rep->TextCol(5, 6, number_format2($DisplaySubTot,$dec) , $dec);
		$rep->NewLine();
		$TOTALDiscount = $TOTALDiscount;
		$rep->TextCol(0, 2, _("Total Discount"), - 2);
		$rep->TextCol(5, 6, "(".number_format2(($TOTALDiscount==0)? '0' : $TOTALDiscount,$dec).")", -2);
		// display_error($TOTALDiscount);exit;
		/*if ($myrow['ov_discount'] != 0) {
		$rep->NewLine();
			$redeem_point = $myrow['ov_discount'];
			$rep->TextCol(0, 2, _("Point Redeem"), - 2);
			$rep->TextCol(5, 6, "(".number_format2(($redeem_point==0)? '0' : $redeem_point,$dec).")", -2);
		}*/
		
		$rep->NewLine();

		$tax_items = get_trans_tax_details(ST_SALESINVOICE, $i);
		$first = true;
		while ($tax_item = db_fetch($tax_items))
		{
			if ($tax_item['amount'] == 0)
				continue;
			$DisplayTax = number_format2($sign*$tax_item['amount'], $dec);
	

			if (isset($suppress_tax_rates) && $suppress_tax_rates == 1)
				$tax_type_name = $tax_item['tax_type_name'];
			else
				$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."% VAT) ";

			if ($tax_item['included_in_price'])
			{
				if (isset($alternative_tax_include_on_docs) && $alternative_tax_include_on_docs == 1)
				{
					if ($first)
					{
						$rep->TextCol(0, 3, _("Total Tax Excluded"), -2);
						$rep->TextCol(5, 6,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
					$rep->TextCol(0, 3, $tax_type_name, -2);
					$rep->TextCol(5, 6,	$DisplayTax, -2);
					$first = false;
				}
				else{
					// $rep->fontSize -= 0.05;
					$rep->TextCol(0, 5, _("Included") . " " . $tax_type_name , -2);
					$rep->TextCol(5, 6, $DisplayTax, -2);
					// $rep->TextCol(0, 6, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
					// $rep->fontSize += 0.05;
				}
			}
			else
			{
				$rep->TextCol(0, 3, $tax_type_name, -2);
				$rep->TextCol(5, 6,	$DisplayTax, -2);
			}
			$rep->NewLine();
		}
		//card num
		$myraw = get_card_num($myrow["order_"]);
		//while($myraw = db_fetch($time_and_card_no))  {

			$rep->MultiCell(182.5, 15, $myraw['card_num'], 0, 'L', 0, 2, 70, 146);
			$rep->MultiCell(182.5, 15, $myraw['order_time'], 0, 'L', 0, 2, 160, 145);
		//}
		

		
		// $rep->NewLine();
		$DisplayTotal = $sign*($myrow["ov_gst"] +
				$myrow["ov_amount"]+$myrow["ov_freight_tax"] - $myrow["ov_discount"]);
		$DisplayTotal_back =$sign*($myrow["ov_gst"] +
				$myrow["ov_amount"]+$myrow["ov_freight_tax"]);


		

		// $rep->NewLine();
		 $get_payment_of_invoice = db_fetch(get_payment_of_invoice(ST_SALESINVOICE,$myrow["trans_no"]));
			$payment_no = $get_payment_of_invoice['trans_no_from'];
			$payment_discount = get_payment($payment_no)['ov_discount'];
			if ($payment_discount) {
			$rep->TextCol(0, 2, _("TOTAL EX DISC"), - 2);
			$rep->TextCol(5, 6, price_format($DisplayTotal - $TOTALDiscount), -2);
			$rep->NewLine();
			$rep->TextCol(0, 2, _("Point Redeem"), - 2);
			$rep->TextCol(5, 6, "(".number_format2($payment_discount, $dec).")", -2);
			$rep->NewLine();
			$rep->TextCol(0, 2, _("TOTAL INC DISC"), - 2);
			$rep->TextCol(5, 6, price_format($DisplayTotal - $TOTALDiscount - @$payment_discount), -2);
			$rep->NewLine();
			}else{
			// $rep->TextCol(0, 2, _("TOTAL"), - 2);
			// $rep->TextCol(5, 6, price_format($DisplayTotal - $total_discount_given), -2);
			$rep->Font('bold');
			$rep->TextCol(0, 3, _("Total Receipt (Inc.VAT)"), - 2);
			$rep->TextCol(5, 6,number_format2( $DisplayTotal,$dec), -2);
			$rep->Font();
			$rep->NewLine();
			}


		$rep->Font('bold');
		$rep->TextCol(0, 2, _("Cash Received"), - 2);
		$rep->TextCol(5, 6, number_format2($myrow["amount_recived"],$dec), -2);
		$rep->Font();
		$rep->NewLine();
		$rep->Font('bold');
		$rep->TextCol(0, 2, _("Cash Returned"), - 2);
		$rep->TextCol(5, 6, number_format2($myrow["amount_recived"] - $DisplayTotal,$dec), -2);
		$rep->Font();

		if($myraw['deliver_to'] == 'Take Away' || $myraw['deliver_to'] == 'Delivery' ) {
			$rep->NewLine(1);
		}else
		{
			/*$rep->NewLine(2);
			$rep->TextCol(0, 2, _("Cash Received"), -2);
			$rep->AmountCol(4, 5, $myraw['cash_recieved'], $dec);
			if($myraw['cash_recieved']!=0)
			{
				$remainning_cash = -($DisplayTotal_back - $myraw['cash_recieved']);
			}
			else{
				$remainning_cash = 0;
			}
			
			$rep->NewLine();
			$rep->TextCol(0, 2, _("Remaining Cash"), -2);
			$rep->AmountCol(4, 5, $remainning_cash, $dec);*/
		}

		$words = price_in_words($myrow['Total'], ST_SALESINVOICE);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 2, $myrow['curr_code'] . ": " . $words, - 2);
		}

		$rep->NewLine();

		//$rep->NewLine(3);

		/*$rep->TextCol(0, 6, _("- No exchange without receipt."), -2);
		$rep->NewLine();
		$rep->TextCol(0, 6, _("- Imported items have no warranty."), -2);
		$rep->NewLine();
		$rep->TextCol(0, 6, _("- Exchange within 7 days."), -2);*/
		$rep->NewLine(2);
		$rep->TextCol(0, 6, _(".............. Powered By www.wayz.ae .............."), -2);



		/*
        // Account Status
        //Debit
        $sql = "
        SELECT
        SUM(ov_amount+ov_freight) AS OutStanding
        FROM ".TB_PREF."debtor_trans
        WHERE debtor_no = '$myrow[debtor_no]'
        AND type = 10
        ";
         $result = db_query($sql,"No transactions were returned");
           $bal2 = db_fetch($result);

        //Credit
        $sql = "
        SELECT
        SUM(ov_amount) AS Payments
        FROM ".TB_PREF."debtor_trans
        WHERE debtor_no = '$myrow[debtor_no]'
        AND type IN (12 , 11 , 2)
        ";

        //AND type IN (11,12,2)
         $result = db_query($sql,"No transactions were returned");
           $bal3 = db_fetch($result);

        $TotalCredit = round2($bal3['Payments'], $dec); //Total credit side balance

        $TotalDebit = round2($bal2['OutStanding'], $dec); // Total debit side balance

        $CurrentAmount = number_format2($SubTotal+$myrow["ov_freight"]);

        $PreviousBalance = number_format2($TotalDebit-$TotalCredit-($SubTotal+$myrow["ov_freight"]));

        $TotalBalance2 = number_format2($TotalDebit-$TotalCredit);

                    $rep->NewLine(5);
                    $rep->TextCol(0, 5, _("Previous Balance"), -2);
                    if ($PreviousBalance > 0)
                    $rep->TextCol(5, 6, $PreviousBalance , -2); //previous balance
                    else
                    $rep->TextCol(5, 6, _("") , -2);
                    $rep->NewLine();
                    $rep->TextCol(0, 5, _("Current Amount"), -2);
                    $rep->TextCol(5, 6, $CurrentAmount, -2); // Current Amount

                    $rep->NewLine();
                    $rep->TextCol(0, 5, _("Total Balance"), -2);
                    $rep->TextCol(5, 6, $TotalBalance2,  -2); // TotalBalance
                    $rep->NewLine();


        */
		//	$rep->TextCol(0, 6, _("                       Powered By www.hisaab.pk"), - 2);
		$rep->Font();
		if ($email == 1)
		{
			$rep->End($email);
		}
		//$rep->NewLine(25);
	}
	if ($email == 0)
		$rep->End();
}

?>