<?php

$page_security = 'SA_CUSTBALANCE';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//------------------------------------------------------------------------------

print_customer_listing();
//------------------------------------------------------------------------------

function print_customer_listing(){
    
    global $path_to_root, $systypes_array;

    $customer = $_POST['PARAM_0'];
    $inactive = $_POST['PARAM_1'];
    $destination = $_POST['PARAM_2'];
    $REPORT_ID = 193;
    
    if($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = 'P';
	
	if ($fromcust == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($fromcust);
    	
	$dec = user_price_dec();

	$cols = array(0, 30, 180, 260, 340, 410, 480);

	$headers = array(_('Sr. #'), _('Customer Name'), _('Email'), _('Mobile'),  
	_('Sales Person'), _('Currency'), _('Tax Policy'));

	$aligns = array('left',	'left',	'left',	'left',	'left', 'left', 'left');
    
    $params = array(0=>$comments, 1=>array('text'=> 'Customer', 'from'=>$cust));

    $rep = new FrontReport(_('Customer Detail Listing'),"CustomerDetailListing",
    'A4_REP', 9, $orientation);

    if ($orientation == 'L')
    	recalculate_cols($cols);
    	
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


	$sql = "SELECT dt.name, dt.curr_code, dt.debtor_no, br.salesman, 
	br.tax_group_id FROM ".TB_PREF."debtors_master AS dt 
	LEFT JOIN ".TB_PREF."cust_branch AS br ON br.debtor_no=dt.debtor_no
	WHERE dt.debtor_no<>0";
	if ($customer != ALL_TEXT)
		$sql .= " AND dt.debtor_no=".db_escape($customer);
	if (!$inactive)
		$sql .= " AND dt.inactive=0";
	$sql .= " ORDER BY dt.name";
	
	$result = db_query($sql, "The customers could not be retrieved");
    
    $i=1;
    
	while($myrow = db_fetch($result)){
        
        $c = 0;
        
        $sql = "SELECT phone, email FROM ".TB_PREF."crm_persons AS cp 
        LEFT JOIN ".TB_PREF."crm_contacts AS cc ON cc.person_id=cp.id 
        WHERE cc.type='customer' 
        AND cc.entity_id=".db_escape($myrow['debtor_no']);
        
        $row = db_fetch(db_query($sql));
        
        $rep->TextCol($c++, $c, $i++);
        
        if($destination){
            $rep->TextCol($c++, $c, $myrow['name']);
        }
        else{
            $oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['name']);
	        $newrow = $rep->row;
			$rep->row = $oldrow;
        }
        
        $rep->TextCol($c++, $c, $row['email']);
        $rep->TextCol($c++, $c, $row['phone']);
        $rep->TextCol($c++, $c, get_salesman_name($myrow['salesman']));
        $rep->TextCol($c++, $c, $myrow['curr_code']);
        $rep->TextCol($c++, $c, get_tax_group($myrow['tax_group_id'])['name']);
        
        
        if($destination){
            $rep->NewLine();
        }
        else{
            $rep->row = $newrow;
            if($rep->row<80)
                $rep->NewLine();
        }
	}
	$rep->End();

}

