<?php

$page_security = 'SA_CUSTBALANCE';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//------------------------------------------------------------------------------

print_inventory_listing();
//------------------------------------------------------------------------------

function print_inventory_listing(){
    
    global $path_to_root, $stock_types;

    $item = $_POST['PARAM_0'];
    $inactive = $_POST['PARAM_1'];
    $destination = $_POST['PARAM_2'];
    $REPORT_ID = 193;
    
    if($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = 'P';
	
	if (!$item)
		$item_name = _('All Items');
	else
		$item_name = get_item($item);
    	
	$dec = user_price_dec();

	$cols = array(0, 30, 90, 240, 370, 430, 500);

	$headers = array(_('Sr. #'), _('Item Code'), _('Item Description'), 
	_('Item Category'), _('Item Unit'), _('Tax Policy'), _('Item Type'));

	$aligns = array('left',	'left',	'left',	'left',	'left', 'left', 'left');
    
    $params = array(0=>$comments, 1=>array('text'=> 'Item','from'=>$item_name));

    $rep = new FrontReport(_('Inventory Specification Reports'),
    "InventorySpeicationReport", 'A4_REP', 9, $orientation);

    if ($orientation == 'L')
    	recalculate_cols($cols);
    	
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


	$sql = "SELECT sm.stock_id, sm.description, sc.description as cat_desc, 
	sm.units, sm.tax_type_id, sm.mb_flag FROM ".TB_PREF."stock_master AS sm 
	LEFT JOIN ".TB_PREF."stock_category AS sc ON sc.category_id=sm.category_id
	WHERE sm.stock_id<>''";
	if ($item != ALL_TEXT)
		$sql .= " AND sm.stock_id=".db_escape($item);
	if (!$inactive)
		$sql .= " AND sm.inactive=0";
	$sql .= " ORDER BY sm.description";
	
	$result = db_query($sql, "The Items could not be retrieved");
    
    $i=1;
    
	while($myrow = db_fetch($result)){
        
        $newrow = array();
        $c = 0;
        
        $rep->TextCol($c++, $c, $i++);
        $rep->TextCol($c++, $c, $myrow['stock_id']);
        
        if($destination){
            $rep->TextCol($c++, $c, $myrow['description']);
            $rep->TextCol($c++, $c, $myrow['cat_desc']);
        }
        else{
            $oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['description']);
	        $newrow[] = $rep->row;
			$rep->row = $oldrow;
			
			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['cat_desc']);
	        $newrow[] = $rep->row;
			$rep->row = $oldrow;
        }
        
        $rep->TextCol($c++, $c, $myrow['units']);
        $rep->TextCol($c++,$c,get_item_tax_type($myrow['tax_type_id'])['name']);
        $rep->TextCol($c++, $c, $stock_types[$myrow['mb_flag']]);
        
        
        if($destination){
            $rep->NewLine();
        }
        else{
            $rep->row = min($newrow);
            if($rep->row<80)
                $rep->NewLine();
        }
	}
	$rep->End();

}

