<?php

$page_security = 'SA_CUSTBALANCE';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//------------------------------------------------------------------------------


function get_customer_details_report($customer_id, $to=null, $all=true, $month=null, $year=null, $pdc_status=null)
{

    if ($to)
        $todate = date2sql($to);
    // removed - debtor_trans.alloc from all summations
    $sign = "IF(`type` IN(".implode(',',  array(ST_CUSTCREDIT,ST_CUSTPAYMENT,ST_BANKDEPOSIT))."), -1, 1)";
    if ($all)
        $value = "IFNULL($sign*(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount),0)";
    else        
        $value = "IFNULL($sign*(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - 
            trans.alloc),0)";
    $due = "IF (trans.type=".ST_SALESINVOICE.", trans.due_date, trans.tran_date)";
    $sql = "SELECT debtor.name, debtor.curr_code, terms.terms, debtor.credit_limit,
                credit_status.dissallow_invoices, credit_status.reason_description,
                Sum($value) AS Balance 
            FROM ".TB_PREF."debtors_master debtor
                 LEFT JOIN ".TB_PREF."debtor_trans trans ON  debtor.debtor_no = trans.debtor_no AND trans.type <> ".ST_CUSTDELIVERY.","
                 .TB_PREF."payment_terms terms,"
                 .TB_PREF."credit_status credit_status
            WHERE
                    debtor.payment_terms = terms.terms_indicator
                AND debtor.credit_status = credit_status.id";
     if ($customer_id)
        $sql .= " AND debtor.debtor_no = ".db_escape($customer_id);

    if (!$all)
        $sql .= " AND ABS(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - trans.alloc) > ".FLOAT_COMP_DELTA;
    if($todate)
        $sql .= "  AND trans.tran_date <= '$todate' ";
    else{
        $sql .= " AND MONTH(trans.tran_date) = ".db_escape($month);
        $sql .= " AND YEAR(trans.tran_date) = ".db_escape($year);
    }
    if($pdc_status)
        $sql .= " AND trans.pdcStatus = 1 ";
    else
        $sql .= " AND trans.pdcStatus = 0 ";
    $sql .= " GROUP BY
                debtor.name,
                terms.terms,
                terms.days_before_due,
                terms.day_in_following_month,
                debtor.credit_limit,
                credit_status.dissallow_invoices,
                credit_status.reason_description";
             
    $result = db_query($sql,"The customer details could not be retrieved");

    $customer_record = db_fetch($result);

    return $customer_record;

}


print_customer_listing();
//------------------------------------------------------------------------------

function print_customer_listing(){
    
    global $path_to_root, $systypes_array;

    $fiscal_year = $_POST['PARAM_0'];
    $customer = $_POST['PARAM_1'];
    $comment = $_POST['PARAM_2'];
    $destination = 1;
    $REPORT_ID = 195;

    $date = DateTime::createFromFormat("Y-m-d", get_fiscalyear($fiscal_year)['begin']);
    $year = $date->format("Y");
 

    if($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = 'P';
	
	if ($fromcust == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($fromcust);
    	
	$dec = user_price_dec();

	$cols = array(0, 300, 370, 440, 510, 580, 650, 720, 790, 860, 930, 1000, 1070, 1140, 1210, 1280, 1350, 1420, 1490, 1560);

	$headers = array(
        _('Customer Name'),
        _('Opening'),
    );

    $current_month = date('m');
    $current_year = $year;
    global $tmonths;
    for($i = 1; $i<=12; $i++){
        $headers[] = ($tmonths[$i]." - ".$current_year);
    }
    
    $headers[] = _("Total");
    $headers[] = _("PDC");
    $headers[] = _("Total After PDC");

	$aligns = array('left',	'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right', 'right');
    
    $params = array(0=>$comments, 1=>array('text'=> 'Customer', 'from'=>$cust));

    $rep = new FrontReport(_('Customer Balances (Month Wise)'),"CustomerBalances(Month-Wise)",
    'A4_REP', 9, $orientation);

    if ($orientation == 'L')
    	recalculate_cols($cols);
    	
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


	$sql = "SELECT dt.name, dt.curr_code, dt.debtor_no, br.salesman, 
	br.tax_group_id FROM ".TB_PREF."debtors_master AS dt 
	LEFT JOIN ".TB_PREF."cust_branch AS br ON br.debtor_no=dt.debtor_no
	WHERE dt.debtor_no<>0";
	if ($customer != ALL_TEXT)
		$sql .= " AND dt.debtor_no=".db_escape($customer);
	if (!$inactive)
		$sql .= " AND dt.inactive=0";
	$sql .= " ORDER BY dt.name";
	
	$result = db_query($sql, "The customers could not be retrieved");
    
    $i=1;
    $TotalBalance = 0;
	while($myrow = db_fetch($result)){
        
        $c = 0;
        
        if($destination){
            $rep->TextCol($c++, $c, $myrow['name']);
        }
        else{
            $oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['name']);
	        $newrow = $rep->row;
			$rep->row = $oldrow;
        }
        
        $openning = get_customer_details_report($myrow['debtor_no'], sql2date(get_fiscalyear($fiscal_year)['begin']), true, null, null);
        $rep->AmountCol($c++, $c, $openning['Balance'], $dec);
        // $TotalBalance += $openning['Balance'];

        for($i=1; $i<=12; $i++){
            $balance = get_customer_details_report($myrow['debtor_no'], null, true, $i, $year);
            $rep->AmountCol($c++, $c, $balance['Balance'], $dec);
            $TotalBalance += $balance['Balance'];
        }
        
        $rep->AmountCol($c++, $c, $TotalBalance, $dec);

        for($i=1; $i<=12; $i++){
            $pdc_amount = get_customer_details_report($myrow['debtor_no'], null, true, $i, $year, 1);
            $pdc_total += $pdc_amount['Balance'];
        }
        $rep->AmountCol($c++, $c, abs($pdc_total), $dec);
        
        $rep->AmountCol($c++, $c, $TotalBalance , $dec);

        $pdc_total=0;
        
        if($destination){
            $rep->NewLine();
        }
        else{
            $rep->row = $newrow;
            if($rep->row<80)
                $rep->NewLine();
        }
       $TotalBalance=0; 
	}
	$rep->End();

}

