<?php

$page_security = 'SA_SUPPLIER_BALANCE_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Supplier Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_supplier_balances();

function get_open_balance($supplier_id, $to)
{
	$to = date2sql($to);

    $sql = "SELECT
    	SUM(IF(type IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst - ov_discount), 0)) AS charges,
    	SUM(IF(type NOT IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst - ov_discount), 0)) AS credits,
		SUM(IF(type NOT IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."),alloc * -1, alloc)) AS Allocated,
		SUM(IF(type IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst - ov_discount - alloc),
				(ov_amount + ov_gst - ov_discount + alloc))) AS OutStanding
		FROM ".TB_PREF."supp_trans
    	WHERE tran_date < '$to'
    	AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) 
		AND supplier_id = '$supplier_id' GROUP BY supplier_id";

    $result = db_query($sql,"No transactions were returned");
    return db_fetch($result);
}

function getTransactions($supplier_id, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);

    $sql = "SELECT *,
				(ov_amount + ov_gst - ov_discount) AS TotalAmount,
				alloc AS Allocated,
				((type = ".ST_SUPPINVOICE.") AND due_date < '$to') AS OverDue
   			FROM ".TB_PREF."supp_trans
   			WHERE tran_date >= '$from' AND tran_date <= '$to' 
    			AND supplier_id = '$supplier_id' AND ov_amount!=0 
				AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) 
    			ORDER BY tran_date";

    $TransResult = db_query($sql,"No transactions were returned");

    return $TransResult;
}

// _______________ USED FOR PDC  ________________________________________________
function getBankTrans ($type = null, $transNo = null)
{
	$sql = " SELECT pdcStatus, transfered, bounce_cheque, pdcDate, amount FROM ".TB_PREF."bank_trans
	WHERE trans_no=".db_escape($transNo)." 
	AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) 
	AND type=".db_escape($type)." ";
	$res = db_query($sql, 'coulnot run getBankTrans');
	$ft = db_fetch($res);
	return($ft);

}

function getpaymentbyinvoice ($type = null, $transNo = null)
{
	$sql = " SELECT bt.pdcStatus,bt.transfered,bt.bounce_cheque,  suppAlloc.trans_no_from AS trans_no, suppAlloc.trans_type_from AS trans_type 
	FROM ".TB_PREF."supp_allocations suppAlloc
	LEFT JOIN ".TB_PREF."bank_trans bt ON suppAlloc.trans_type_from = bt.type AND suppAlloc.trans_no_from=bt.id

	WHERE suppAlloc.trans_no_to=".db_escape($transNo)." 
	AND suppAlloc.trans_type_to=".db_escape($type)." 
	AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$res = db_query($sql, 'coulnot run getpaymentbyinvoice');
	$ft = db_fetch($res);
	return($ft);

}

//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------

function print_supplier_balances()
{
	global $path_to_root, $systypes_array;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$fromsupp = $_POST['PARAM_2'];
	$show_pdc = $_POST['PARAM_3'];
	$show_items = $_POST['PARAM_4'];
	$show_details = $_POST['PARAM_5'];
	$show_balance = $_POST['PARAM_6'];
	$currency = $_POST['PARAM_7'];
	$no_zeros = $_POST['PARAM_8'];
	$comments = $_POST['PARAM_9'];
	$orientation = $_POST['PARAM_10'];
	$destination = $_POST['PARAM_11'];
	$REPORT_ID = 201;
	
	

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromsupp == ALL_TEXT)
		$supp = _('All');
	else
		$supp = get_supplier_name($fromsupp);
    	$dec = user_price_dec();

	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');

	// $cols = array(0, 95, 140, 200,	250, 320, 385, 450,	515);
	$cols = array(0, 95, 140, 190, 250, 300, 360, 430,	490, 560);

	$headers = array(_('Trans Type'), _('#'), _("SI-REF"), _('Date'), _('Due Date'), _('Charges'),
		_('Credits'), _('Allocated'), _('Outstanding'));

	if ($show_balance)
		$headers[7] = _('Balance');
	$aligns = array('left',	'left',	'left',	'left', 'left',	'right', 'right', 'right', 'right');

    $params =   array( 	0 => $comments,
    			1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
    			2 => array('text' => _('Supplier'), 'from' => $supp, 'to' => ''),
    			3 => array(  'text' => _('Currency'),'from' => $currency, 'to' => ''),
				4 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => ''));

// user_pagesize()
 # A$_REF use for report magin size increse to showing big amount data;
    $rep = new FrontReport(_('Supplier Balances'), "SupplierBalances", 'A4_REP', 9, $orientation);

    
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$total = array();
	$grandtotal = array(0,0,0,0);

	$sql = "SELECT supplier_id, supp_name AS name, curr_code FROM ".TB_PREF."suppliers";
	if ($fromsupp != ALL_TEXT)
		$sql .= " WHERE supplier_id=".db_escape($fromsupp);
	$sql .= " ORDER BY supp_name";
	$result = db_query($sql, "The customers could not be retrieved");
    
    if ($show_items != 0){
	$rep->fontSize -= 1;
				$rep->TextCol(0, 1, "Stock ID");
				$rep->TextCol(1, 3, "Description");
				$rep->TextCol(3, 4, "Quantity");
				$rep->TextCol(4, 5, "Price");
				$rep->TextCol(5, 6, "Total");
				$rep->fontSize += 1;
				$rep->Line($rep->row  - 4);
				$rep->NewLine(2);
			}
			
	while ($myrow=db_fetch($result))
	{
		if (!$convert && $currency != $myrow['curr_code'])
			continue;
		$accumulate = 0;
		$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
		$bal = get_open_balance($myrow['supplier_id'], $from);
		$init[0] = $init[1] = 0.0;
		$init[0] = round2(abs($bal['charges']*$rate), $dec);
		$init[1] = round2(Abs($bal['credits']*$rate), $dec);
		$init[2] = round2($bal['Allocated']*$rate, $dec);
		if ($show_balance)
		{
			$init[3] = $init[0] - $init[1];
			$accumulate += $init[3];
		}	
		else	
			$init[3] = round2($bal['OutStanding']*$rate, $dec);
		$res = getTransactions($myrow['supplier_id'], $from, $to);
		if ($no_zeros && db_num_rows($res) == 0) continue;

		$rep->fontSize += 2;


       if ($destination)
		  $rep->TextCol(0, 2, $myrow['name']);
		   else
		   {
		    	$oldrow = $rep->row;
				$rep->TextColLines(0, 2, $myrow['name']);
		        $newrow = $rep->row;
				$rep->row = $oldrow;
		   }







		if ($convert) $rep->TextCol(3, 4,	$myrow['curr_code']);
		$rep->fontSize -= 2;
		$rep->TextCol(4, 5,	_("Open Balance"));
		$rep->AmountCol(5, 6, $init[0], $dec);
		$rep->AmountCol(6, 7, $init[1], $dec);
		$rep->AmountCol(7, 8, $init[2], $dec);
		$rep->AmountCol(8, 9, $init[3], $dec);
		$total = array(0,0,0,0);
		for ($i = 0; $i < 4; $i++)
		{
			$total[$i] += $init[$i];
			$grandtotal[$i] += $init[$i];
		}
		    if (!$destination)
			$rep->row = $newrow;
		$rep->NewLine(1, 2);
		$rep->Line($rep->row + 4);
		if (db_num_rows($res)==0) {
			$rep->NewLine(1, 2);
			continue;
		}	
		while ($trans=db_fetch($res))
		{
			
			$getpaymentbyinvoice = getpaymentbyinvoice(ST_SUPPINVOICE, $trans['trans_no']);
			$bankTransData = array();
			if($trans['type'] == ST_SUPPAYMENT || $trans['type'] == ST_BANKPAYMENT || $trans['type'] == ST_BANKDEPOSIT){
				$bankTransData = getBankTrans($trans['type'], $trans['trans_no']);
			}
			else{
				$bankTransData['pdcStatus'] = 0;
				$bankTransData['transfered'] = 0;
				$bankTransData['bounce_cheque'] = 0;
			}
            if ($bankTransData['pdcStatus'] == 1) continue;


			if ($no_zeros && floatcmp(abs($trans['TotalAmount']), $trans['Allocated']) == 0) continue;
			$rep->NewLine(1, 2);
			$rep->TextCol(0, 1, $systypes_array[$trans['type']]);
			$rep->TextCol(1, 2,	$trans['reference']);
			$rep->TextCol(2, 3,	$trans['supp_reference']);
			$rep->DateCol(3, 4,	$trans['tran_date'], true);
			if ($trans['type'] == ST_SUPPINVOICE)
				$rep->DateCol(4, 5,	$trans['due_date'], true);
			$item[0] = $item[1] = 0.0;
			if ($trans['TotalAmount'] > 0.0)
			{
				$item[0] = round2(abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(5, 6, $item[0], $dec);
				$accumulate += $item[0];
				$item[2] = round2($trans['Allocated'] * $rate, $dec);
			}
			else
			{
				$item[1] = round2(abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(6, 7, $item[1], $dec);
				$accumulate -= $item[1];
				$item[2] = round2($trans['Allocated'] * $rate, $dec) * -1;
			}
			$rep->AmountCol(7, 8, $item[2], $dec);
			if ($trans['TotalAmount'] > 0.0)
				$item[3] = $item[0] - $item[2];
			else	
				$item[3] = -$item[1] - $item[2];
			if ($show_balance)	
				$rep->AmountCol(8, 9, $accumulate, $dec);
			else	
				$rep->AmountCol(8, 9, $item[3], $dec);
			for ($i = 0; $i < 4; $i++)
			{
				$total[$i] += $item[$i];
				$grandtotal[$i] += $item[$i];
			}
			if ($show_balance)
				$total[3] = $total[0] - $total[1];
				
		// for supplier invoice
			if ($show_items != 0 && $trans['type']==ST_SUPPINVOICE) {
				$rep->Line($rep->row - 8);
				$rep->NewLine(2);
		
				$result2 = get_supp_invoice_items(ST_SUPPINVOICE, $trans['trans_no']);
				while ($myrow2 = db_fetch($result2)) {

		

					$rep->TextCol(0, 1, $myrow2["stock_id"]);
					$rep->TextCol(1,3, $myrow2["description"]);
					
					$rep->AmountCol(3, 4, $myrow2["qty_recd"], $dec);
					$rep->AmountCol(4, 5, $myrow2["FullUnitPrice"], $dec);
					$rep->AmountCol(5, 6, $myrow2["qty_recd"]*$myrow2["FullUnitPrice"], $dec);
					$rep->NewLine(1);
				} //end while
					$rep->Line($rep->row  - 4);
					$rep->NewLine(1);
	
			}  //end if

// for supplier invoice
			if ($show_items != 0 && $trans['type']==ST_SUPPCREDIT) {
				$rep->Line($rep->row - 8);
				$rep->NewLine(2);
			
				$result3 = 	 get_supp_invoice_items(ST_SUPPCREDIT, $trans['trans_no']);
				while ($myrow3 = db_fetch($result3)) {

		

					$rep->TextCol(0, 1, $myrow3["stock_id"]);
					$rep->TextCol(1,3, $myrow3["description"]);
					$rep->AmountCol(3, 4, $myrow3["qty_recd"], $dec);
					$rep->AmountCol(4, 5, $myrow3["FullUnitPrice"], $dec);
					$rep->AmountCol(5, 6, $myrow3["qty_recd"]*$myrow3["FullUnitPrice"], $dec);
					$rep->NewLine(1);
				} //end while
					$rep->Line($rep->row  - 4);
					$rep->NewLine(1);
	
			}  //end if

 
			// for journal Entry
			if ($show_details != 0 && $trans['type']==ST_JOURNAL) {
				$rep->Line($rep->row - 8);
				$rep->NewLine(2);
		
				$result3 = get_gl_trans(ST_JOURNAL, $trans['trans_no']);
				unset($newrow);
				$jv_debit = $jv_credit = 0;
				while ($myrow3 = db_fetch($result3)) {

		

					$rep->TextCol(0,1, $myrow3["account"]);

					if($destination)
						$rep->TextCol(1, 3, $myrow3['account_name']);
					else{
						$oldrow = $rep->row;
						$rep->TextColLines(1, 3, $myrow3['account_name']);
						$newrow[] = $rep->row;
						$rep->row = $oldrow; 
					}

					if($destination)
						$rep->TextCol(3, 5, payment_person_name($myrow3["person_type_id"],$myrow3["person_id"]));
					else{
						$oldrow = $rep->row;
		            $rep->TextColLines(3, 5, payment_person_name($myrow3["person_type_id"],$myrow3["person_id"]));
						$newrow[] = $rep->row;
						$rep->row = $oldrow;
 					}

 					if($destination)
						$rep->TextCol(5, 6, get_dimension_string($myrow3['dimension_id'], true));
					else{
						$oldrow = $rep->row;
		            $rep->TextColLines(5, 6, get_dimension_string($myrow3['dimension_id'], true));
						$newrow[] = $rep->row;
						$rep->row = $oldrow;
 					}

					if($myrow3['amount'] > 0 ){
						$jv_debit += $myrow3['amount'];
						$rep->AmountCol(6, 7, $myrow3["amount"], $dec);
						$rep->AmountCol(7, 8, 0, $dec);
					}
					else{
						$jv_credit += $myrow3['amount'];
						$rep->AmountCol(6, 7, 0, $dec);
						$rep->AmountCol(7, 8, $myrow3["amount"], $dec);
					} 
					
					if(!$destination){
						$rep->row = min($newrow);
						unset($newrow);
					}
					$rep->NewLine();
				} //end while
					$rep->Line($rep->row);
					$rep->NewLine(1.2);

					$rep->AmountCol(6, 7, $jv_debit, $dec);
					$rep->AmountCol(7, 8, $jv_credit, $dec);

					$rep->NewLine(1.2);
					$rep->Line($rep->row);

			}  //end if

			// for journal Entry			
			
		}
 
		$rep->Line($rep->row - 8);
		$rep->NewLine(2);
		$rep->TextCol(0, 3,	_('Total'));
		for ($i = 0; $i < 4; $i++)
		{
			$rep->AmountCol($i + 5, $i + 6, $total[$i], $dec);
			$total[$i] = 0.0;
		}
    	$rep->Line($rep->row  - 4);
    	$rep->NewLine(0.5);
    // _______________________________ PDC WORK BELOW __________________

    	if($show_pdc ==1 ){

    		if (!$convert && $currency != $myrow['curr_code'])
				continue;
			$accumulate = 0;
			$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
			$bal = get_open_balance($myrow['supplier_id'], $from);
			$init[0] = $init[1] = 0.0;
			$init[0] = round2(abs($bal['charges']*$rate), $dec);
			$init[1] = round2(Abs($bal['credits']*$rate), $dec);
			$init[2] = round2($bal['Allocated']*$rate, $dec);
			
			if ($show_balance){
				$init[3] = $init[0] - $init[1];
				$accumulate += $init[3];
			}	
			else	
				$init[3] = round2($bal['OutStanding']*$rate, $dec);
			
			$res = getTransactions($myrow['supplier_id'], $from, $to);
			if ($no_zeros && db_num_rows($res) == 0) continue;

		    $newrow = $rep->row;


		    if (!$destination)
				$rep->row = $newrow;

			if (db_num_rows($res)==0) {
				$rep->NewLine(1, 2);
				continue;
			}	
			$cc =1;
			$dd =1;
			while ($trans=db_fetch($res)){
				$getpaymentbyinvoice = getpaymentbyinvoice(ST_SUPPINVOICE, $trans['trans_no']);
				$bankTransData = array();
				if($trans['type'] == ST_SUPPAYMENT || $trans['type'] == ST_BANKPAYMENT || $trans['type'] == ST_BANKDEPOSIT){
					$bankTransData = getBankTrans($trans['type'], $trans['trans_no']);
				}
				else{
					$bankTransData['pdcStatus'] = 0;
					$bankTransData['transfered'] = 0;
					$bankTransData['bounce_cheque'] = 0;
					$bankTransData['pdcDate'] = "";
				}

                if ($bankTransData['pdcStatus'] == 0 ||  $bankTransData['bounce_cheque'] == 1 ) continue;
				
				$dd++;// for testing only

				if ($no_zeros && floatcmp(abs($trans['TotalAmount']), $trans['Allocated']) == 0) continue;

				$rep->NewLine(1, 2);
			

				if($bankTransData['pdcStatus'] == 1 ){
					$rep->SetTextColor(237,7,10);		//For Red Color PDC
				}

				$rep->TextCol(0, 1, $systypes_array[$trans['type']]);
				$rep->TextCol(1, 2,	$trans['reference']);
				$rep->DateCol(2, 3,	$trans['tran_date'], true);
				
				if ($trans['type'] == ST_SUPPINVOICE)
					$rep->DateCol(3, 4,	$trans['due_date'], true);
				else
					$rep->DateCol(3, 4,	$bankTransData['pdcDate'], true);
				
				$item[0] = $item[1] = 0.0;


				$AMT = str_replace('-', '', $bankTransData['amount']);
				$pdcAmount = round2($AMT*$rate, $dec);
				$rep->AmountCol(7, 8, $pdcAmount, $dec);
				$totalPdcAmount += $pdcAmount;

				if($bankTransData['pdcStatus'] == 1 ){
					$rep->SetTextColor(0,0,0);		//For Red Color PDC
				}
			
			}

		// ____________________________ PDC TOTAL ____________________________

			$rep->NewLine(1.5);
			$rep->TextCol(0, 3, _('PDC Total'));
			$rep->AmountCol(7, 8, $totalPdcAmount, $dec);
			
			$rep->Line($rep->row  - 4);
			$rep->Line($rep->row  - 6);			
    	}

    	$rep->NewLine(2);
  	
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3,	_('Grand Total'));
	$rep->fontSize -= 2;
	if ($show_balance)
		$grandtotal[3] = $grandtotal[0] - $grandtotal[1];
	for ($i = 0; $i < 4; $i++)
		$rep->AmountCol($i + 5, $i + 6,$grandtotal[$i], $dec);
	$rep->Line($rep->row  - 4);
	$rep->NewLine();
	

	$res = checking_report($REPORT_ID);
			// $rep->TextWrap(96,47,150,'edsds'); 

	if(db_num_rows($res) > 0){
		$row = db_fetch($res);
		if($row['signature2'] == '' && $row['signature3'] == ''){	
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 
		}
		if($row['signature2'] != '' && $row['signature3'] == ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(441,47,150,"_________________"); 
			$rep->TextWrap(455,37,150,$row['signature2']);
		}
		if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(260,47,150,"__________________"); 
			$rep->TextWrap(274,37,150,$row['signature2']); 

			$rep->TextWrap(441,47,150,"_______________"); 
			$rep->TextWrap(455,37,150,$row['signature3']);
		}
	}
	$rep->End();
}

