<?php

$page_security = 'SA_PURCHASE_SUMMARY_REPORTS';
// ----------------------------------------------------------------
// $ Revision:	5.0 $
// Creator:	Syed Zohaib Ali ALvi
// date_:	2018-09-5
// Title:	Purchase Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------



print_sales_summary_report();

function getTaxTransactions($from=null, $to=null, $tax_id)
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);



	// $sql = "SELECT s.supplier_id
	// 	,SUM(if(type=20,st.ov_amount,0)) as total_supp_ov_amount
	// 	,SUM(if(type=21,st.ov_amount,0)) as total_cred_ov_amount
	// 	SUM(if(type=20,st.ov_gst,0)) as total_supp_ov_gst
	// 	,SUM(if(type=20,st.ov_gst,0)) as total_supp_ov_gst
	// 	,type,supp_name,supp_ref,gst_no,ov_gst,ov_amount,tran_date FROM `".TB_PREF."suppliers` s JOIN ".TB_PREF."supp_trans st on st.supplier_id=s.supplier_id where (type=20 or type=21)"; 

$sql = "SELECT s.supplier_id,supp_name,gst_no , SUM(if(type=20,st.ov_amount,0)) as total_supp_ov_amount ,SUM(if(type=21,st.ov_amount,0)) as total_cred_ov_amount, SUM(if(type=20,st.ov_gst,0)) as total_supp_ov_gst , SUM(if(type=21,st.ov_gst,0)) as total_cred_ov_gst FROM ".TB_PREF."suppliers s JOIN ".TB_PREF."supp_trans st on st.supplier_id=s.supplier_id where (type=20 or type=21)  ";

$sql .= " and tran_date>=".db_escape(date2sql($from))." and tran_date<=".db_escape(date2sql($to))."";
$sql .= " AND (IF(st.type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), st.approve_status = 1, st.approve_status = 0 )) ";

	$sql .="  GROUP by s.supplier_id ORDER by s.supplier_id";
// display_error($sql);
    return db_query($sql,"No transactions were returned");
}

  	

//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$tax_id = $_POST['PARAM_2'];
	$comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];
	$REPORT_ID = 114;
	if ($tax_id == 0)
		$tid = _('No');
	else
		$tid = _('Yes');


	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	$dec = user_price_dec();

	$rep = new FrontReport(_('Purchase Summary Report'), "PurchaseSummaryReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array(  'text' => _('Tax Id Only'),'from' => $tid,'to' => ''));

	$cols = array(0, 240, 340, 460,520);

	$headers = array(_('Supplier'), _('Tax Id'), _('Total ex. Tax'), _('Tax'));
	$aligns = array('left', 'left', 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	

	$transactions = getTaxTransactions($from, $to, $tax_id);

	$rep->NewLine(2);
	

	while ($trans=db_fetch($transactions))
	{
	

				$rep->TextCol(0, 1, $trans['supp_name']);
				if ($tax_id !=0) {
					
				$rep->TextCol(1, 2,	$trans['gst_no']);
				}
				$rep->AmountCol(2, 3,$trans['total_supp_ov_amount']- $trans['total_cred_ov_amount'], $dec);
				$rep->AmountCol(3, 4, $trans['total_supp_ov_gst']-$trans['total_cred_ov_gst'], $dec);
			
				$rep->NewLine();

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
		
		$total_ex_tax +=($trans['total_supp_ov_amount']- $trans['total_cred_ov_amount']);
		$total_tax +=($trans['total_supp_ov_gst']-$trans['total_cred_ov_gst']);
		
	}
	
	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	$rep->AmountCol(2, 3, $total_ex_tax, $dec);
	$rep->AmountCol(3, 4, $total_tax, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();
	$rep->NewLine();

	//pk
    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
        $row = db_fetch($res);
        if($row['signature2'] == '' && $row['signature3'] == ''){   
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 
        }
        if($row['signature2'] != '' && $row['signature3'] == ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(441,47,150,"_________________"); 
            $rep->TextWrap(455,37,150,$row['signature2']);
        }
        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,37,150,$row['signature1']); 

            $rep->TextWrap(260,47,150,"__________________"); 
            $rep->TextWrap(274,37,150,$row['signature2']); 

            $rep->TextWrap(441,47,150,"_______________"); 
            $rep->TextWrap(455,37,150,$row['signature3']);
        }
    }
	$rep->End();
}

