<?php


$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_PURCHASE_ORDER' : 'SA_PRINT_PURCHASE_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Purchase Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/crm_contacts_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------
if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
	print_po_new();
else
	print_po();

//----------------------------------------------------------------------------------------------------
function get_po($order_no)
{
   	$sql = "SELECT po.*, supplier.supp_name, supplier.supp_account_no,supplier.tax_included,
   		supplier.gst_no AS tax_id,
   		supplier.curr_code, supplier.payment_terms, loc.location_name,
   		supplier.address, supplier.contact, supplier.tax_group_id
		FROM ".TB_PREF."purch_orders po,"
			.TB_PREF."suppliers supplier,"
			.TB_PREF."locations loc
		WHERE po.supplier_id = supplier.supplier_id
		AND loc.loc_code = into_stock_location
		AND po.order_no = ".db_escape($order_no);
   	$result = db_query($sql, "The order cannot be retrieved");
    return db_fetch($result);
}
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------

function get_po_details($order_no)
{
	$sql = "SELECT poline.*, units
		FROM ".TB_PREF."purch_order_details poline
			LEFT JOIN ".TB_PREF."stock_master item ON poline.item_code=item.stock_id
		WHERE order_no =".db_escape($order_no)." ";
	$sql .= " ORDER BY po_detail_item";
	return db_query($sql, "Retreive order Line Items");
}

function print_po()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 209;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(4, 60, 205, 280, 320, 355, 390, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'right', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('PURCHASE ORDER'), "PurchaseOrderBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_po($i);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];

		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('PURCHASE ORDER');
			$rep->filename = "PurchaseOrder" . $i . ".pdf";
		}	
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_supplier_contacts($myrow['supplier_id'], 'order');
		$rep->SetCommonData($myrow, null, $myrow, $baccount, ST_PURCHORDER, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$result = get_po_details($i);
		$SubTotal = 0;
		$items = $prices = array();
		while ($myrow2=db_fetch($result))
		{
			$data = get_purchase_data($myrow['supplier_id'], $myrow2['item_code']);
			if ($data !== false)
			{
				if ($data['supplier_description'] != "")
					$myrow2['description'] = $data['supplier_description'];
				if ($data['suppliers_uom'] != "")
					$myrow2['units'] = $data['suppliers_uom'];
				if ($data['conversion_factor'] != 1)
				{
					$myrow2['unit_price'] = round2($myrow2['unit_price'] * $data['conversion_factor'], user_price_dec());
					$myrow2['quantity_ordered'] = round2($myrow2['quantity_ordered'] / $data['conversion_factor'], user_qty_dec());
				}
			}
			$Net = round2((($myrow2["unit_price"] * $myrow2["quantity_ordered"] ) - $myrow2["discount"] ), user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['item_code'];
			$SubTotal += $Net;
			$dec2 = 0;
			$DisplayPrice = price_decimal_format($myrow2["unit_price"],$dec2);
			$DisplayQty = number_format2($myrow2["quantity_ordered"],get_qty_dec($myrow2['item_code']));
			$DisplayNet = number_format2($Net,$dec);
			if ($SysPrefs->show_po_item_codes()) {
				$rep->TextCol(0, 1,	$myrow2['item_code'], -2);
				$oldrow = $rep->row;
				$rep->TextColLines(1, 2,	replace_chars($myrow2['description']."\n".$myrow2['long_description'], array("&quot;")), -2);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;
			} else{
				$oldrow = $rep->row;
				$rep->TextColLines(0, 2,	replace_chars($myrow2['description']."\n".$myrow2['long_description'], array("&quot;")), -2);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;
			}
			$rep->TextCol(2, 3,	sql2date($myrow2['delivery_date']), -2);
			$rep->TextCol(3, 4,	$DisplayQty, -2);
			$rep->TextCol(4, 5,	$myrow2['units'], -2);
			$rep->TextCol(5, 6,	$DisplayPrice, -2);
			$rep->AmountCol(6, 7,	$myrow2['discount'], 2);
			$rep->TextCol(7, 8,	$DisplayNet, -2);
			$rep->row = min($newrow);
			unset($newrow);
			$rep->NewLine(1);
			if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
				$rep->NewPage();
		}
		if ($myrow['comments'] != "")
		{
			$rep->NewLine();
			$rep->TextColLines(1, 4, replace_chars($myrow['comments'], array("&quot;")), -2);
		}
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (10.5 * $rep->lineHeight);
		$doctype = ST_PURCHORDER;
		$cols = array(4, 60, 400, 300, 340, 385, 450, 522);
		$words = price_in_words(replace_chars($DisplaySubTot, array(",",".")), ST_SALESINVOICE);
        $aligns = array('','','','','','','right','right');
        $rep->Info($params, $cols, null, $aligns);
		
	    $rep->TextCol(0, 1, _("Sub-Total:"), -2);
	    $bankacc_row = get_default_bank_account('AED');
	    $rep->TextCol(1, 2,	$words." "."(".$bankacc_row['bank_curr_code'].")", -2);
        $rep->TextCol(6, 7,	$DisplaySubTot, -2);
		$rep->NewLine();

		$tax_items = get_tax_for_items($items, $prices, 0,
		  $myrow['tax_group_id'], $myrow['tax_included'],  null, TCA_LINES);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			if ($SysPrefs->suppress_tax_rates() == 1)
				$tax_type_name = $tax_item['tax_type_name'];
			else
				$tax_type_name = $tax_item['tax_type_name'];

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->TextCol(0, 1, $tax_type_name.": ", -2);
                $words = price_in_words(replace_chars($DisplayTax, array(",")), ST_SALESINVOICE);
				$bankacc_row = get_default_bank_account('AED');
				$rep->TextCol(1, 2,	$words." "."(".$bankacc_row['bank_curr_code'].")", -2);
				$rep->TextCol(6, 7,	$DisplayTax, -2);
				
			}
			$rep->NewLine();
		}

// 		$rep->NewLine();
		$DisplayTotal = number_format2($SubTotal, $dec);
		$rep->Font('bold');
		$words = price_in_words(replace_chars($DisplayTotal, array(",",".")), ST_SALESINVOICE);
		$bankacc_row = get_default_bank_account('AED');
        $rep->TextCol(0, 1, _("TOTAL PO:"), - 2);
		$rep->TextCol(1, 2, _($words." "."(".$bankacc_row['bank_curr_code'].")"), - 2);
		$rep->TextCol(6, 7,	$DisplayTotal, -2);
		$rep->NewLine();
		$words = price_in_words($SubTotal, ST_PURCHORDER);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}
		$rep->Font();
		if ($email == 1)
		{
			$myrow['DebtorName'] = $myrow['supp_name'];

			if ($myrow['reference'] == "")
				$myrow['reference'] = $myrow['order_no'];
			$rep->End($email);
		}
	}

	//pk
	if($myrow['approved'] == 0){
	    if ($rep->l['a_meta_dir'] == 'rtl'){
	        $rep->SetAlpha(0.5);
    	    // draw green square
    		$rep->StartTransform();
    		$rep->Rotate(45);
    		$rep->fontSize += 40;
    
    		$rep->TextWrap(160,100,1000,"UNAPPROVED"); 
    		$rep->fontSize -= 40;
    
    		$rep->StopTransform();
    		// restore full opacity
    		$rep->SetAlpha(1);
	    }else{
	        $rep->SetAlpha(0.5);
    	    // draw green square
    		$rep->StartTransform();
    		$rep->Rotate(45);
    		$rep->fontSize += 40;
    
    		$rep->TextWrap(300,450,1000,"UNAPPROVED"); 
    		$rep->fontSize -= 40;
    
    		$rep->StopTransform();
    		// restore full opacity
    		$rep->SetAlpha(1);
	    }
	}

	$res = checking_report($REPORT_ID);
	if(db_num_rows($res) > 0){
		$row = db_fetch($res);
		if($row['signature2'] == '' && $row['signature3'] == ''){	
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 
		}
		if($row['signature2'] != '' && $row['signature3'] == ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(441,47,150,"_________________"); 
			$rep->TextWrap(455,37,150,$row['signature2']);
		}
		if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(260,47,150,"__________________"); 
			$rep->TextWrap(274,37,150,$row['signature2']); 

			$rep->TextWrap(441,47,150,"_______________"); 
			$rep->TextWrap(455,37,150,$row['signature3']);
		}
	}

	if ($email == 0)
		$rep->End();
}

function print_po_new()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 209;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(4, 60, 225, 300, 340, 385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'right', 'left', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('PURCHASE ORDER'), "PurchaseOrderBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_po($i);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];

		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('PURCHASE ORDER');
			$rep->filename = "PurchaseOrder" . $i . ".pdf";
		}	
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_supplier_contacts($myrow['supplier_id'], 'order');
		$rep->SetCommonData($myrow, null, $myrow, $baccount, ST_PURCHORDER, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();


		$result = get_po_details($i);
		$SubTotal = 0;
		$items = $prices = array();
// ____________________________________________________________ COLOR LINES _____________________________________
			$right = $rep->pageWidth - $rep->rightMargin;
			$total_rec = db_num_rows($result);
			$count__ = 0;
			$print_rec = 0;
			$rep->row+=5;
// ____________________________________________________________ COLOR LINES _____________________________________
		while ($myrow2=db_fetch($result))
		{
			// for ($i=1; $i < 25 ; $i++) { 
			$data = get_purchase_data($myrow['supplier_id'], $myrow2['item_code']);
			if ($data !== false)
			{
				if ($data['supplier_description'] != "")
					$myrow2['description'] = $data['supplier_description'];
				if ($data['suppliers_uom'] != "")
					$myrow2['units'] = $data['suppliers_uom'];
				if ($data['conversion_factor'] != 1)
				{
					$myrow2['unit_price'] = round2($myrow2['unit_price'] * $data['conversion_factor'], user_price_dec());
					$myrow2['quantity_ordered'] = round2($myrow2['quantity_ordered'] / $data['conversion_factor'], user_qty_dec());
				}
			}
			$Net = round2(($myrow2["unit_price"] * $myrow2["quantity_ordered"]), user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['item_code'];
			$SubTotal += $Net;
			$dec2 = 0;
			$DisplayPrice = price_decimal_format($myrow2["unit_price"],$dec2);
			$DisplayQty = number_format2($myrow2["quantity_ordered"],get_qty_dec($myrow2['item_code']));
			$DisplayNet = number_format2($Net,$dec);
			$oldrow = $rep->row;
			if ($SysPrefs->show_po_item_codes()) {
				$rep->TextCol(0, 1,	$myrow2['item_code'], -2);
				$rep->TextColLines(1, 2,	$myrow2['description'], -2);
			} else
				$rep->TextColLines(1, 2,	$myrow2['description'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;
			
// ____________________________________________________________ COLOR LINES _____________________________________
		    if($print_rec % 2 == 0)
	      	$rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(189,214,238));  
            else
            $rep->rectangle($rep->leftMargin, $rep->row+10, $right - $rep->leftMargin, $oldrow-$newrow, "F", null, array(222, 231, 236));   
// ____________________________________________________________ COLOR LINES _____________________________________
        	$oldrow = $rep->row;
        	if ($SysPrefs->show_po_item_codes()) {
				$rep->TextCol(0, 1,	$myrow2['item_code'], -2);
				$rep->TextColLines(1, 2,	$myrow2['description'], -2);
			} else
				$rep->TextColLines(1, 2,	$myrow2['description'], -2);			
			$newrow = $rep->row;
			$rep->row = $oldrow;
			
			$rep->TextCol(2, 3,	sql2date($myrow2['delivery_date']), -2);
			$rep->TextCol(3, 4,	$DisplayQty, -2);
			$rep->TextCol(4, 5,	$myrow2['units'], -2);
			$rep->TextCol(5, 6,	$DisplayPrice, -2);
			$rep->TextCol(6, 7,	$DisplayNet, -2);
			$rep->row = $newrow;
			// $rep->NewLine(1);
			
		
// ____________________________________________________________ COLOR LINES _____________________________________

			$rep->SetDrawColor(91,155,213);
			// $rep->row = $newrow;
			if(($oldrow-$newrow)>12)
				$count__++;
			if(($oldrow-$newrow)>24)
				$count__++;

			$print_rec++;
			$count__++;


			  if($count__>35 && ($total_rec-$print_rec)>1){	
				$rep->LineTo(41,533,41,$rep->row+10);
			    $rep->LineTo(564,533,564,$rep->row+10);
			}else{
                $rep->LineTo(41,533,41,150);
				$rep->LineTo(564,533,564,150);
			}

// ____________________________________________________________ COLOR LINES _____________________________________

		

              if($rep->pageNumber>=1){
              	// display_error($count__." (".$total_rec."  -".$print_rec.")");
				if($count__>31 && ($total_rec-$print_rec)<=1){
					$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
			   		$total_rec-=$print_rec;
			   		$count__=0;
			   		$print_rec=0;
					$rep->NewPage();
					$rep->row+=5;
				}
              }else{ 
                    if($count__>32 && ($total_rec-$print_rec)<=1){
                    	$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
						$total_rec-=$print_rec;
						$count__=0;
						$print_rec=0;
						$rep->NewPage();
						$rep->row+=5;
					}
                }
				if(($count__>40 ||$count__>=39) && ($total_rec-$print_rec)>=1){
					$rep->LineTo(41,$rep->row+10,564,$rep->row+10);
   					$total_rec-=$print_rec;
					$count__=0;
					$print_rec=0;
					$rep->NewPage();
					$rep->row+=5;
				}

		// }
	}

		 if($rep->pageNumber>=1)
       	    $rep->LineTo(41,150,564,150);
       	 else
             $rep->LineTo(41,$rep->row+10,564,$rep->row+10);

// ______________________________________________ COMMENT AREA _________________________________________________
		$rep->SetDrawColor(189, 214, 238);
		$rep->RoundedRect(40, 67.4+640, 290,20,2.25, '','DF',null,array(91,155,213));
		$rep->SetTextColor(255, 255, 255);
		$rep->TextWrap(50,67.4+55,150,"Memo");//50,152,150

		$rep->SetTextColor(0, 0, 0);
		$rep->RoundedRect(40,67.4+660, 290,65,2.25, '','DF',null,array(222, 234, 246));

		if ($myrow['comments'] != "")
		{
			// $rep->NewLine();
			// $rep->TextColLines(1, 4, $myrow['comments'], -2);
			$rep->cols[3]=350;
			$rep->TextWrapLines2(45,300,115, $myrow['comments'], -2);
		}
// ______________________________________________ COMMENT AREA _________________________________________________		
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);
		$doctype = ST_PURCHORDER;
		$rep->row = $summary_start_row-85;

			$rep->cols[2] += 30;
			$rep->cols[3] += 30;
			$rep->aligns[3] = 'left';
		$rep->TextCol(3, 6, _("Sub-total"), +2,0,1,1);
		$rep->TextCol(6, 7,	$DisplaySubTot, +2,0,1,1);
		$rep->NewLine();

		$tax_items = get_tax_for_items($items, $prices, 0,
		  $myrow['tax_group_id'], $myrow['tax_included'],  null, TCA_LINES);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			if ($SysPrefs->suppress_tax_rates() == 1)
				$tax_type_name = $tax_item['tax_type_name'];
			else
				$tax_type_name = $tax_item['tax_type_name']/*." (".$tax_item['rate']."%) "*/;

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), +2,0,1,1);
						$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), +2,0,1,1);
						$rep->NewLine();
					}
					$rep->TextCol(3, 6, $tax_type_name, -2);
					$rep->TextCol(6, 7,	$DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, +2,0,1,1);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->TextCol(3, 6, $tax_type_name, +2,0,1,1);
				$rep->TextCol(6, 7,	$DisplayTax, +2,0,1,1);
			}
			$rep->NewLine();
		}

		$rep->NewLine();
		$DisplayTotal = number_format2($SubTotal, $dec);
		$rep->Font('bold');
		$rep->TextCol(3, 6, _("TOTAL PO"), +2,0,1,1);
		$rep->TextCol(6, 7,	$DisplayTotal, +2,0,1,1);
		$words = price_in_words($SubTotal, ST_PURCHORDER);
		if ($words != "")
		{
			$rep->NewLine(1);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
		}
		$rep->Font();
		if ($email == 1)
		{
			$myrow['DebtorName'] = $myrow['supp_name'];

			if ($myrow['reference'] == "")
				$myrow['reference'] = $myrow['order_no'];
			$rep->End($email);
		}
	}

	//pk
	if($myrow['approved'] == 0){
		$rep->SetAlpha(0.5);
	// draw green square
		$rep->StartTransform();
		$rep->Rotate(45);
		$rep->fontSize += 40;

		$rep->TextWrap(380,450,1000,"UNAPPROVED"); 
		$rep->fontSize -= 40;

		$rep->StopTransform();
		// restore full opacity
		$rep->SetAlpha(1);
	}

	$res = checking_report($REPORT_ID);
	if(db_num_rows($res) > 0){
		$row = db_fetch($res);
		if($row['signature2'] == '' && $row['signature3'] == ''){	
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 
		}
		if($row['signature2'] != '' && $row['signature3'] == ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(441,47,150,"_________________"); 
			$rep->TextWrap(455,37,150,$row['signature2']);
		}
		if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
			$rep->TextWrap(96,47,150,"_______________"); 
			$rep->TextWrap(105,37,150,$row['signature1']); 

			$rep->TextWrap(260,47,150,"__________________"); 
			$rep->TextWrap(274,37,150,$row['signature2']); 

			$rep->TextWrap(441,47,150,"_______________"); 
			$rep->TextWrap(455,37,150,$row['signature3']);
		}
	}

	if ($email == 0)
		$rep->End();
}


