<?php

$page_security = 'SA_SUPPLIERQUOTATION';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/crm_contacts_db.inc");
include_once($path_to_root . "/purchasing/includes/db/supplier_quotation_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

print_supplier_RFQ();

function print_supplier_RFQ(){

	global $path_to_root, $show_po_item_codes;

	$pr_no = $_GET['pr_no'];
	$supplier_id = $_GET['supplier_id'];


	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$def_orientation = ($def_orientation ? 'L' : 'P');


	$headers = array(_('S.NO'), _('Item Code'), _('Item Name'), _('Rate'), _('Quantity'), _('Price'));

	$cols = array(5, 50, 130,  240, 320, 420, 490, 520);

	$aligns = array('left', 'left',   'left', 'right', 'right', 'right');

	$params =   array(  0 => $comments,
                        1 => array('text' => _('PR. No'), 'from' => $pr_no, 'to'=>$to),
                        2 => array('text' => _('Supplier'), 'from' => get_supplier_name($supplier_id), 'to'=>$to),
                        3 => array('text' => _('RFQ Date'), 'from' => sql2date(get_ref_id($pr_no, $supplier_id, 1)), 'to'=>$to)
                );

	$rep = new FrontReport(_('Supplier RFQ'), "Supplier RFQ", user_pagesize(), 9, $def_orientation);

	if ($def_orientation == 'L')
        recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
    $incr = 1;
    $result = get_rfq_details_items($pr_no, $supplier_id);
    while($row = db_fetch($result)){
    	$rep->textcol(0, 1, $incr++ );
		$rep->textcol(1, 2, $row['stock_id']);
		$rep->textcol(2, 3, get_item($row['stock_id'])['description']);
		if($row['price'] != 0)
			$rep->textcol(3, 4, number_format($row['price']/$row['qty'],2));
		else
			$rep->textcol(3, 4, number_format(0,2));
		
		$rep->textcol(4, 5, number_format($row['qty'],2));
		$rep->textcol(5, 6, price_format($row['price']));
		$rep->NewLine();
		
	}


    $rep->End();
}