<?php


$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_PRINT_REMITTANCES' : 'SA_PRINT_REMITTANCES';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Purchase Remittance
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/crm_contacts_db.inc");

//----------------------------------------------------------------------------------------------------
if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
	print_remittances_new();
else
	print_remittances();

//----------------------------------------------------------------------------------------------------
function get_remittance($type, $trans_no)
{
   	$sql = "SELECT trans.*, 
   		(trans.ov_amount+trans.ov_gst) AS Total,
   		trans.ov_discount,
   		supplier.supp_name,  supplier.supp_account_no, 
   		supplier.curr_code, supplier.payment_terms, supplier.gst_no AS tax_id, 
   		supplier.address
		FROM "
			.TB_PREF."supp_trans trans,"
			.TB_PREF."suppliers supplier
		WHERE trans.supplier_id = supplier.supplier_id
		AND trans.type = ".db_escape($type)."
		AND trans.trans_no = ".db_escape($trans_no);
   	$result = db_query($sql, "The remittance cannot be retrieved");
   	if (db_num_rows($result) == 0)
   		return false;
    return db_fetch($result);
}
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------

function print_remittances()
{
	global $path_to_root, $systypes_array;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$REPORT_ID = 210;

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	$cols = array(4, 85, 150, 225, 275, 360, 450, 515);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'left', 'right', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('REMITTANCE'), "RemittanceBulk", array(1280, 550), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		if ($fno[0] == $tno[0])
			$types = array($fno[1]);
		else
			$types = array(ST_BANKPAYMENT, ST_SUPPAYMENT, ST_SUPPCREDIT);
		foreach ($types as $j)
		{
			$myrow = get_remittance($j, $i);
			if (!$myrow)
				continue;
			if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
				continue;
			}
			$res = get_bank_trans($j, $i);
			$baccount = db_fetch($res);
			$params['bankaccount'] = $baccount['bank_act'];

			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				$rep->title = _('REMITTANCE');
				$rep->filename = "Remittance" . $i . ".pdf";
			}
			$rep->currency = $cur;
			$rep->Font();
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_supplier_contacts($myrow['supplier_id'], 'invoice');
			$rep->SetCommonData($myrow, null, $myrow, $baccount, ST_SUPPAYMENT, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();
			$result = get_allocatable_to_supp_transactions($myrow['supplier_id'], $myrow['trans_no'], $myrow['type']);

			$doctype = ST_SUPPAYMENT;
			$total_allocated = 0;
			// $logo = company_path() . "/images/cheque_print.jpg";
			// $rep->AddImage($logo, $ccol, $rep->row+40, 0, 0);
			$rep->Font();



			$rep->Font('bold');
			$rep->fontSize = 14;
	
 
			if($myrow["ac_payee"])
				$rep->TextWrap(740,$rep->row-105,150, "A/C Payee", 'left');
				
			$rep->TextWrap(1090,$rep->row-110,150, sql2date($myrow["tran_date"]), 'left');

			$rep->TextWrap(630,$rep->row-180,1000, ($myrow["party_name"]), 'left'); 
			
			$words = price_in_words(replace_chars(abs($myrow["Total"]), array(",")), ST_SALESINVOICE);

			$rep->TextWrap(525,$rep->row-230,1000, ($words), 'left'); 

			$rep->TextWrap(1090,$rep->row-265,500, "**".number_format2(abs($myrow["Total"]), 2), 'left'); 

			 
		}
	}
 
		$rep->End();
}
 