<?php

$page_security = 'SA_DIMSUMMREPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Dimension Summary
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_dimension_summary();

function getTransactions($from_id, $to_id, $reference=null, $from_date=null, $to_date=null, $overdue=null, $open=null)
{
	$sql = "SELECT *
		FROM
			".TB_PREF."dimensions
		WHERE 1 ";
		if($from_id && $to_id)
			$sql .= " AND id >= ".db_escape($from_id)."
						 AND id <= ".db_escape($to_id);
		 if($reference)
			$sql .= " AND reference = ".db_escape($reference);	

		if($from_date && $to_date)
			$sql .= " AND date_ >= ".db_escape(date2sql($from_date))."
						 AND date_ <= ".db_escape(date2sql($to_date));	

		if ($overdue){
			$today = date2sql(Today());
			$sql .= " AND due_date < '$today' ";
		}
		if ($open)
			$sql .= " AND closed=0 ";		 		 	
		$sql .= " ORDER BY reference";


    return db_query($sql,"No transactions were returned");
}
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}


//----------------------------------------------------------------------------------------------------

function print_dimension_summary()
{
    global $path_to_root;

	$fromdim = $_POST['PARAM_0'];
	$todim = $_POST['PARAM_1'];
	$comments = $_POST['PARAM_2'];
	$reference = $_POST['PARAM_3'];
	$from_date = $_POST['PARAM_4'];
	$to_date = $_POST['PARAM_5'];
	$overdue = $_POST['PARAM_6'];
	$open = $_POST['PARAM_7'];

	$destination =  true;
	$REPORT_ID = 502;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$orientation = 'L';
	$cols = array(0, 50, 210, 250, 320, 395, 465,515, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1100);

	$headers = array(_('Site Code'), _('Site'), _('Inv No.'), _('Starting Date'), _('Last Activity Date'), _('Sales Order Amount'), _('Sales (NET)'), _('Sales (Gross)'), _('Cost Incurred to date'), _('Cost to Revenue'), _('Profit to Revenue'), _('Profit'), _('Advance Received'), _('Payment Status'));

	$aligns = array('left',	'left', 'left',	'left', 'left', 'left', 'right', 'right');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Dimension'), 'from' => get_dimension_string($fromdim), 'to' => get_dimension_string($todim)));

    $rep = new FrontReport(_('Dimension Summary'), "DimensionSummary", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$res = getTransactions($fromdim, $todim, $reference, $from_date, $to_date, $overdue, $open);
	while ($trans=db_fetch($res))
	{
		$c=0;
		$rep->TextCol($c, $c++, $trans['reference']);
		$rep->TextCol($c, $c++, $trans['name']);
		$rep->TextCol($c, $c++, get_invoices_against_dimension($trans['id']));
		$rep->DateCol($c, $c++, $trans['date_'], true);
		$rep->DateCol($c, $c++, get_last_attendance_on_project($trans['id']), true);

		
        $order_amount = dimension_order_total($trans['id'])['amount'];
        $order_tax = $order_amount * 0.05;
        
		$rep->AmountCol($c, $c++, ($order_amount + $order_tax), 2);
		
        $sales_invoicing = get_debtor_trans_sum_by_dimension($trans['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension($trans['id'], ST_CUSTCREDIT);
		
		$rep->AmountCol($c, $c++, ($sales_invoicing-$credit_amount), 2);
		
        $sales_invoicing_inc_vat = get_debtor_trans_sum_by_dimension_with_vat($trans['id'], ST_SALESINVOICE);
        $credit_amount_inc_vat = get_debtor_trans_sum_by_dimension_with_vat($trans['id'], ST_CUSTCREDIT);
        $total_receivable = ($sales_invoicing_inc_vat-$credit_amount_inc_vat);
        $rep->AmountCol($c, $c++, ($total_receivable), 2);
		
        $supp_inv_amount = get_supp_trans_sum_by_dimension($trans['id'], ST_SUPPINVOICE);
        $supp_credit_amount = get_supp_trans_sum_by_dimension($trans['id'], ST_SUPPCREDIT);
        $gross_salary = get_salary_allocation_on_site($trans['id']);
        $bank_payment = get_dimension_gl_amount($trans['id'], ST_BANKPAYMENT);
        $incurred_cost = $supp_inv_amount + $supp_credit_amount + $gross_salary + $bank_payment; 
		
		$rep->AmountCol($c, $c++, $incurred_cost, 2);
		
		$rep->AmountCol($c, $c++, ($incurred_cost/($sales_invoicing-$credit_amount))*100, 2);
		
		$rep->AmountCol($c, $c++, ($sales_invoicing-$credit_amount)-$incurred_cost, 2);
		
		$rep->AmountCol($c, $c++, 100 - (($incurred_cost/($sales_invoicing-$credit_amount))*100), 2);
		
        $payment = get_allocation_by_dimension($trans['id']);
        if(!$payment)
            $payment = get_dimension_gl_amount($trans['id'], ST_CUSTPAYMENT); 
        $bank_deposit = get_dimension_gl_amount($trans['id'], ST_BANKDEPOSIT);
		$payment = $payment+$bank_deposit;
		
		$rep->AmountCol($c, $c++, ($payment), 2);

		if(user_numeric($payment)==0)
			$payment_status = 'Pending';
		elseif(user_numeric($total_receivable) == user_numeric($payment))
			$payment_status = 'Fully Paid';
		elseif(user_numeric($total_receivable) > user_numeric($payment))
			$payment_status = 'Partially Paid';
		elseif(user_numeric($payment) > user_numeric($total_receivable))
			$payment_status = 'Advance Payment';

		$rep->TextCol($c, $c++, $payment_status, -2);
 
		$rep->NewLine(1, 2);
	}
	$rep->Line($rep->row);



    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,7,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }

    $rep->End();
}

