<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.

***********************************************************************/
$page_security = 'SA_BANKPDCCHECKREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Bank Accounts Transactions
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_bank_transactions();

//----------------------------------------------------------------------------------------------------
function get_bank_name1($banckAcc)
{
		$bankAcc = $myrow['bank_act'];

	$sql = "SELECT bank_account_name FROM ".TB_PREF."bank_accounts WHERE id=".db_escape($banckAcc);

	$result = db_query($sql, "could not retreive bank account for");

	return db_fetch($result)['bank_account_name'];
}

function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}


function get_bankInfo($bank_no =null)
{
	$acc_no_flag = strtoupper($bank_no);
	$sql = "SELECT * FROM ".TB_PREF."bank_accounts WHERE inactive = 0 AND UPPER(account_code) = ".db_escape($acc_no_flag)."";
	$result = db_query($sql, "could not get bank get_bankName");
	return db_fetch($result);
}

function get_bank_balance_to($to, $account, $transType = null, $transfer = 0)
{
	$to = date2sql($to);
	$sql = "SELECT SUM(amount) FROM ".TB_PREF."bank_trans WHERE bank_act='$account'
	AND pdcDate < '$to' AND transfered='$transfer' AND type='$transType'";
	$result = db_query($sql, "The starting balance on hand could not be calculated");
	$row = db_fetch_row($result);
	return $row[0];
}

function get_bank_transactions($from, $to, $account, $transType = null, $transfer = 0)
{
	$from = date2sql($from);
	$to = date2sql($to);
	$sql = "SELECT * FROM ".TB_PREF."bank_trans
		WHERE pdcDate >= '$from'
		AND pdcDate <= '$to' AND transfered='$transfer' AND type='$transType' ";
		if($transfer == 0)
		$sql .=" AND bank_act = '$account' ";

		$sql .=" ORDER BY pdcDate, id ";

	return db_query($sql,"The transactions for '$account' could not be retrieved");
}

function print_bank_transactions()
{
	global $path_to_root, $systypes_array;

	$acc = $_POST['PARAM_0'];
	$from = $_POST['PARAM_1'];
	$to = $_POST['PARAM_2'];
	$chequeStatus = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$destination = $_POST['PARAM_6'];
	$REPORT_ID = 6011;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$rep = new FrontReport("Present Cheque", "Present Cheque", user_pagesize(), 9, $orientation);
	$dec = user_price_dec();

	$cols = array(0, 100, 130, 160, 220, 360, 455);

	$aligns = array('left',	'left',	'left',	'left',	'left', 'left', 'right');

	$headers = array(_('Type'),	_('#'),	_('Ref'), _('Date'), _('Person'),_('Bank'),
		 _('Amount'));

	$account = get_bank_account($acc);
	$act = $account['bank_account_name']." - ".$account['bank_curr_code']." - ".$account['bank_account_number'];
   	$params =   array( 
   		0 => $comments,
	    1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
	    2 => array('text' => _('Bank Account'),'from' => $account['bank_account_name'].'['.$account["bank_curr_code"].']','to' => ''),
	    3 => array('text' => _('Cheque Status'),'from' => $chequeStatus!=0?'Cleared Cheque':'Uncleared Cheque','to' => '')
		);

   	
	if($comments == null || $comments == ''|| $comments == 0 )
	{
		$params[0]="";
	}

    if ($orientation == 'L')
    	recalculate_cols($cols);
	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	// ____________________________________  FOR CHEKING CUSTOMER OR PAYMENT  _________________________________________
	$myrow2 = get_company_prefs();
	$bankInfocust = get_bankInfo($myrow2["debtors_pdc_act"]);
	$bankInfosupp = get_bankInfo($myrow2["creditors_pdc_act"]);

	if($acc==$bankInfocust['id'])
		$transType = 12;
	if($acc==$bankInfosupp['id'])
		$transType = 22;

	$prev_balance = get_bank_balance_to($from, $account["id"], $transType, $chequeStatus);
	$trans = get_bank_transactions($from, $to, $account['id'], $transType, $chequeStatus);
	$rows = db_num_rows($trans);
	$rep->Font();
		
		$total_debit = $total_credit = 0;
		if ($rows > 0)
		{
	
					while ($myrow=db_fetch($trans))
					{
						if ($zero == 0 && $myrow['amount'] == 0.0)
							continue;
						$bank_Name = get_bank_name1($myrow['bank_act']);
						
						$total += $myrow['amount'];

						$rep->TextCol(0, 1, $systypes_array[$myrow["type"]]);
						$rep->TextCol(1, 2,	$myrow['trans_no']);
						$rep->TextCol(2, 3,	$myrow['ref']);
						$rep->DateCol(3, 4,	$myrow["pdcDate"], true);
						$oldrow = $rep->row;
						$rep->TextColLines(4, 5,	get_counterparty_name($myrow["type"], $myrow["trans_no"], false),-2);
						$newrow = $rep->row;
						$rep->row = $oldrow;

						$oldrow2 = $rep->row;
						$rep->TextColLines(5, 6,	$bank_Name);
						$newrow2 = $rep->row;
						$rep->row = $oldrow2;


						$rep->AmountCol(6, 7, abs($myrow["amount"]), $dec);

						if($newrow > $newrow2)
						$rep->row = $newrow2;
						elseif($newrow2 > $newrow)
						$rep->row = $newrow;
		$rep->NewLine();

						if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
						{
							$rep->Line($rep->row - 2);
							$rep->NewPage();
						}

					}

		$rep->NewLine(0.5);
		}
		
		
		if(abs($total)>0)
		{
		$rep->Line($rep->row+10);
		$rep->Font('bold');
		$rep->TextCol(0, 1, _("TOTAL"));
		$rep->AmountCol(6, 7, abs($total), $dec);
		$rep->Line($rep->row - 5, 1);
		}

    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(1,6,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }

$rep->End();
}

