<?php


//CashFlow Report Created By HK
//Date: 2021-10-06
$page_security = 'SA_CASHFLOW';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_cash_flow_statement();

function get_all_bank_accounts($show_inactive=false)
{
	$sql = "SELECT account.*, gl_account.account_name
		FROM ".TB_PREF."bank_accounts account, ".TB_PREF."chart_master gl_account
		WHERE account.account_code = gl_account.account_code";
	if (!$show_inactive) 
		$sql .= " AND !account.inactive";


	$sql .= " ORDER BY account_code, bank_curr_code";

	return db_query($sql,"could not get bank accounts");
}

//Helper function
//----------------------------------------------------------------------------------------------------

function getPeriods($yr, $mo, $id, $balance=false){

	$begin = date2sql(begin_fiscalyear());
	$date13 = date('Y-m-d',mktime(0,0,0,$mo+12,1,$yr));
	$date12 = date('Y-m-d',mktime(0,0,0,$mo+11,1,$yr));
	$date11 = date('Y-m-d',mktime(0,0,0,$mo+10,1,$yr));
	$date10 = date('Y-m-d',mktime(0,0,0,$mo+9,1,$yr));
	$date09 = date('Y-m-d',mktime(0,0,0,$mo+8,1,$yr));
	$date08 = date('Y-m-d',mktime(0,0,0,$mo+7,1,$yr));
	$date07 = date('Y-m-d',mktime(0,0,0,$mo+6,1,$yr));
	$date06 = date('Y-m-d',mktime(0,0,0,$mo+5,1,$yr));
	$date05 = date('Y-m-d',mktime(0,0,0,$mo+4,1,$yr));
	$date04 = date('Y-m-d',mktime(0,0,0,$mo+3,1,$yr));
	$date03 = date('Y-m-d',mktime(0,0,0,$mo+2,1,$yr));
	$date02 = date('Y-m-d',mktime(0,0,0,$mo+1,1,$yr));
	$date01 = date('Y-m-d',mktime(0,0,0,$mo,1,$yr));

	if (!$balance)
	{
  	  	$sql = "SELECT SUM(CASE WHEN trans_date >= '$date01' AND trans_date < '$date02' THEN amount ELSE 0 END) AS per01,
		   		SUM(CASE WHEN trans_date >= '$date02' AND trans_date < '$date03' THEN amount ELSE 0 END) AS per02,
		   		SUM(CASE WHEN trans_date >= '$date03' AND trans_date < '$date04' THEN amount ELSE 0 END) AS per03,
		   		SUM(CASE WHEN trans_date >= '$date04' AND trans_date < '$date05' THEN amount ELSE 0 END) AS per04,
		   		SUM(CASE WHEN trans_date >= '$date05' AND trans_date < '$date06' THEN amount ELSE 0 END) AS per05,
		   		SUM(CASE WHEN trans_date >= '$date06' AND trans_date < '$date07' THEN amount ELSE 0 END) AS per06,
		   		SUM(CASE WHEN trans_date >= '$date07' AND trans_date < '$date08' THEN amount ELSE 0 END) AS per07,
		   		SUM(CASE WHEN trans_date >= '$date08' AND trans_date < '$date09' THEN amount ELSE 0 END) AS per08,
		   		SUM(CASE WHEN trans_date >= '$date09' AND trans_date < '$date10' THEN amount ELSE 0 END) AS per09,
		   		SUM(CASE WHEN trans_date >= '$date10' AND trans_date < '$date11' THEN amount ELSE 0 END) AS per10,
		   		SUM(CASE WHEN trans_date >= '$date11' AND trans_date < '$date12' THEN amount ELSE 0 END) AS per11,
		   		SUM(CASE WHEN trans_date >= '$date12' AND trans_date < '$date13' THEN amount ELSE 0 END) AS per12,
		   		SUM(CASE WHEN trans_date >= '$begin' AND trans_date < '$date13' THEN amount ELSE 0 END) AS ytd,
		   		SUM(CASE WHEN trans_date >= '$date01' AND trans_date < '$date13' THEN amount ELSE 0 END) AS mon12
    			FROM ".TB_PREF."bank_trans
				WHERE bank_act='$id' 
				AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 ))";
 	}
	else
	{
  	  	$sql = "SELECT SUM(CASE WHEN trans_date < '$date01' THEN amount ELSE 0 END) AS per01,
		   		SUM(CASE WHEN trans_date < '$date02' THEN amount ELSE 0 END) AS per02,
		   		SUM(CASE WHEN trans_date < '$date03' THEN amount ELSE 0 END) AS per03,
		   		SUM(CASE WHEN trans_date < '$date04' THEN amount ELSE 0 END) AS per04,
		   		SUM(CASE WHEN trans_date < '$date05' THEN amount ELSE 0 END) AS per05,
		   		SUM(CASE WHEN trans_date < '$date06' THEN amount ELSE 0 END) AS per06,
		   		SUM(CASE WHEN trans_date < '$date07' THEN amount ELSE 0 END) AS per07,
		   		SUM(CASE WHEN trans_date < '$date08' THEN amount ELSE 0 END) AS per08,
		   		SUM(CASE WHEN trans_date < '$date09' THEN amount ELSE 0 END) AS per09,
		   		SUM(CASE WHEN trans_date < '$date10' THEN amount ELSE 0 END) AS per10,
		   		SUM(CASE WHEN trans_date < '$date11' THEN amount ELSE 0 END) AS per11,
		   		SUM(CASE WHEN trans_date < '$date12' THEN amount ELSE 0 END) AS per12,
		   		SUM(CASE WHEN trans_date < '$begin' THEN amount ELSE 0 END) AS ytd,
		   		SUM(CASE WHEN trans_date < '$date01' THEN amount ELSE 0 END) AS mon12
    			FROM ".TB_PREF."bank_trans
				WHERE bank_act='$id'
				AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	}

	$result = db_query($sql, "Transactions for bank account $id could not be calculated");

	return db_fetch($result);
}

function get_cust_deposits($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	for ($i=0; $i<12; $i++) { 
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_CUSTPAYMENT." OR type=".ST_BANKDEPOSIT.") AND person_type_id=2  
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_CUSTPAYMENT." OR type=".ST_BANKDEPOSIT.") AND person_type_id=2   
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($begin)." 
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_CUSTPAYMENT." OR type=".ST_BANKDEPOSIT.") AND person_type_id=2   
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[0])." 
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_transfers($dates_array, $account, $incoming){

	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	for ($i=0; $i<12; $i++) { 
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKTRANSFER." AND bank_act=".db_escape($account)." 
		AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
		if($incoming){
			$sql .= " AND amount>0";
		}
		else{
			$sql .= " AND amount<0";
		}
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKTRANSFER." AND bank_act=".db_escape($account)."  
		AND trans_date >= ".db_escape($begin)." AND trans_date < ".db_escape($dates_array[$i]);
	if($incoming){
		$sql .= " AND amount>0";
	}
	else{
		$sql .= " AND amount<0";
	}
	$sql .= " AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];


	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKTRANSFER." AND bank_act=".db_escape($account)." 
		AND trans_date >= ".db_escape($dates_array[0])." 
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	if($incoming){
		$sql .= " AND amount>0";
	}
	else{
		$sql .= " AND amount<0";
	}
	$returns[13] = db_fetch(db_query($sql))['val'];
	return $returns;
}

function get_deposits($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	for ($i=0; $i<12; $i++) { 
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKDEPOSIT." AND person_type_id<>2 AND bank_act=".db_escape($account)." 
		AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKDEPOSIT." AND person_type_id<>2 AND bank_act=".db_escape($account)." 
		AND trans_date >= ".db_escape($begin)." AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];


	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_BANKDEPOSIT." AND person_type_id<>2 AND bank_act=".db_escape($account)." 
		AND trans_date >= ".db_escape($dates_array[0])." 
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[13] = db_fetch(db_query($sql))['val'];
	return $returns;
}

function get_cust_refunds($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	for ($i=0; $i<12; $i++) { 
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_CUSTCREDIT.") AND person_type_id=2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_CUSTCREDIT.") AND person_type_id=2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($begin)."
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_CUSTCREDIT.") AND person_type_id=2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[0])."
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_other_pay($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	for ($i=0; $i<12; $i++) { 
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_SUPPAYMENT.") AND person_type_id<>2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_SUPPAYMENT.") AND person_type_id<>2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($begin)."
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE (type=".ST_BANKPAYMENT." OR type =".ST_SUPPAYMENT.") AND person_type_id<>2 
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[0])."
		AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_fa_sales($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	
	$fa_payments = array();
	$sql = "SELECT DISTINCT alloc.trans_no_from AS trans FROM `0_debtor_trans_details` AS line 
	LEFT JOIN 0_stock_master AS item ON line.stock_id=item.stock_id 
	AND line.debtor_trans_type=".ST_SALESINVOICE." 
	LEFT JOIN 0_cust_allocations AS alloc ON alloc.trans_no_to=line.debtor_trans_no 
	AND alloc.trans_type_to=".ST_SALESINVOICE."
	WHERE line.debtor_trans_type = 10 AND item.mb_flag= 'F'";
	$res = db_query($sql);
	while($row = db_fetch($res)){
		$fa_payments[] = $row['trans'];
	}

	for ($i=0; $i<12; $i++) {
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans AS bt
		WHERE type=".ST_CUSTPAYMENT." AND trans_no IN (".implode(',', $fa_payments).")
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1])."
		AND (IF(bt.type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), bt.approve_status = 1, bt.approve_status = 0 )) ";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_CUSTPAYMENT." AND bank_act=".db_escape($account)." 
		AND trans_no IN (".implode(',', $fa_payments).")
		AND trans_date >= ".db_escape($begin)." AND trans_date < ".db_escape($dates_array[$i])."
		AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";
	$returns[12] = db_fetch(db_query($sql))['val'];

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_CUSTPAYMENT." AND bank_act=".db_escape($account)." 
		AND trans_no IN (".implode(',', $fa_payments).") 
		AND trans_date >= ".db_escape($dates_array[0])." 
		AND trans_date < ".db_escape($dates_array[$i]);
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_fa_purchases($dates_array, $account){
	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	
	$fa_payments = array();
	$sql = "SELECT DISTINCT alloc.trans_no_from AS trans FROM `0_supp_invoice_items` AS line 
	LEFT JOIN 0_stock_master AS item ON line.stock_id=item.stock_id 
	AND line.supp_trans_type=".ST_SUPPINVOICE." 
	LEFT JOIN 0_supp_allocations AS alloc ON alloc.trans_no_to=line.supp_trans_no 
	AND alloc.trans_type_to=".ST_SUPPINVOICE."
	WHERE line.supp_trans_type = ".ST_SUPPINVOICE." AND item.mb_flag= 'F'";
	$res = db_query($sql);
	while($row = db_fetch($res)){
		if($row['trans'])
			$fa_payments[] = $row['trans'];
	}

	for ($i=0; $i<12; $i++) {
		$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans AS bt
		WHERE type=".ST_SUPPAYMENT." AND trans_no IN (".implode(',', $fa_payments).")
		AND bank_act=".db_escape($account)." AND trans_date >= ".db_escape($dates_array[$i])." 
		AND trans_date < ".db_escape($dates_array[$i+1]);
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_SUPPAYMENT." AND bank_act=".db_escape($account)." 
		AND trans_no IN (".implode(',', $fa_payments).")
		AND trans_date >= ".db_escape($begin)." AND trans_date < ".db_escape($dates_array[$i]);
	$returns[12] = db_fetch(db_query($sql))['val'];

	$sql = "SELECT SUM(amount) AS val FROM ".TB_PREF."bank_trans 
		WHERE type=".ST_SUPPAYMENT." AND bank_act=".db_escape($account)." 
		AND trans_no IN (".implode(',', $fa_payments).") 
		AND trans_date >= ".db_escape($dates_array[0])." 
		AND trans_date < ".db_escape($dates_array[$i]);
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_equity_gl($dates_array, $account, $incoming=true){

	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	for ($i=0; $i<12; $i++){
		$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
		$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

		$sql .= "AND trans.tran_date >= ".db_escape($dates_array[$i])." 
				 AND trans.tran_date < ".db_escape($dates_array[$i+1]);
		
		$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype=".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
		$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
		$sql .=	"<>0";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
	$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

	$sql .= "AND trans.tran_date >= ".db_escape($begin)." 
			 AND trans.tran_date < ".db_escape($dates_array[$i]);
	
	$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype=".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
	$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
	$sql .=	"<>0";
	$returns[12] = db_fetch(db_query($sql))['val'];


	$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
	$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

	$sql .= "AND trans.tran_date >= ".db_escape($dates_array[0])." 
			 AND trans.tran_date < ".db_escape($dates_array[$i]);
	
	$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype=".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
	$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
	$sql .=	"<>0";
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

function get_other_gl($dates_array, $account, $incoming=true){

	$begin = date2sql(begin_fiscalyear());
	$returns = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	for ($i=0; $i<12; $i++){
		$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
		$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

		$sql .= "AND trans.tran_date >= ".db_escape($dates_array[$i])." 
				 AND trans.tran_date < ".db_escape($dates_array[$i+1]);
		
		$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype<>".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
		$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
		$sql .=	"<>0";
		$returns[$i] = db_fetch(db_query($sql))['val'];
	}

	$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
	$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

	$sql .= "AND trans.tran_date >= ".db_escape($begin)." 
			 AND trans.tran_date < ".db_escape($dates_array[$i]);
	
	$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype<>".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
	$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
	$sql .=	"<>0";
	$returns[12] = db_fetch(db_query($sql))['val'];


	$sql= "SELECT SUM(trans.amount) AS val FROM ".TB_PREF."gl_trans AS trans 
		WHERE trans.account = ".db_escape($account)." AND trans.type = ".ST_JOURNAL." AND";
	$sql .= $incoming ? " trans.amount>0 " : " trans.amount<0 ";

	$sql .= "AND trans.tran_date >= ".db_escape($dates_array[0])." 
			 AND trans.tran_date < ".db_escape($dates_array[$i]);
	
	$sql .= "AND 
				(SELECT COUNT(*) FROM ".TB_PREF."gl_trans AS gl 
				LEFT JOIN ".TB_PREF."chart_master AS cm ON cm.account_code=gl.account 
				LEFT JOIN ".TB_PREF."chart_types AS ct ON cm.account_type=ct.id 
				LEFT JOIN ".TB_PREF."chart_class AS cl ON cl.cid= ct.class_id 
				WHERE cl.ctype<>".CL_EQUITY." AND gl.type=trans.type AND gl.type_no=trans.type_no 
				AND ";
	$sql .= $incoming ? " gl.amount<0)" : " gl.amount>0)";
	$sql .=	"<>0";
	$returns[13] = db_fetch(db_query($sql))['val'];

	return $returns;
}

//----------------------------------------------------------------------------------------------------

function print_cash_flow_statement(){

	global $path_to_root, $date_system, $comp_path, $bank_account_types;

	$date = $_POST['PARAM_0'];
	$comments = $_POST['PARAM_3'];
	$destination = $_POST['PARAM_4'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	if ($comments)
		$comments .= ". - ";

	$comments .= _("Balances in Home Currency");
   	$title = _("Cash Flow Statement");
   	$output_filename = "CashFlowStatement";
   	$fontsize = 7;
   	$page_size = user_pagesize();
   	$page_orientation = 'L';
   	$margins = array('top' => 30, 'bottom' => 34, 'left' => 16, 'right' => 10);
   	$excelColWidthFactor = 5;
   
   	$rep = new FrontReport($title, $output_filename, $page_size, $fontsize, $page_orientation, $margins, 
   	$excelColWidthFactor);

	$enddate = end_month($date);

   	$dec = user_price_dec();

   	
   	$cols2 = array(0, 120);
   	$endline = $rep->endLine - 20;
   	$wi = ($endline - $cols2[1]) / 14; // 14 amount columns
   	
   	for ($i = 2; $i < 17; $i++)
   		$cols2[$i] = $cols2[$i-1] + $wi;
   	
   	$cols = $cols2;	

   	$aligns2 = array('left', 'right', 'right', 'right', 'right', 'right', 'right', 'right',
				   'right', 'right', 'right', 'right', 'right', 'right', 'right');
   	$headers2 = array();


   	$aligns = array('left', 'right', 'right', 'right', 'right', 'right', 'right', 'right',
				   'right', 'right', 'right', 'right', 'right', 'right', 'right');
   	$headers = array();

	$date = begin_month($date);
	$date = add_months($date, -11);

	list($da, $mo, $yr) = explode_date_to_dmy($date);

	if ($date_system == 1)
		list($yr, $mo, $da) = jalali_to_gregorian($yr, $mo, $da);
	elseif ($date_system == 2)
		list($yr, $mo, $da) = islamic_to_gregorian($yr, $mo, $da);

    $headers2[0] = _('Account');
    $headers[0] = '';

	for ($i = 0; $i < 12; $i++){

		$header_row[$i] = $rep->DatePrettyPrint($date, 0, 1);
		// Wrap at space between month & year
	   	$wrap_point = strpos($header_row[$i], ' ');
	   	if ($wrap_point){
			$headers2[] = _(substr($header_row[$i], 0, $wrap_point));
			$headers[] = substr($header_row[$i], $wrap_point+1);
	   	}
	   	else{
			$headers2[] = '';
			$headers[] = $header_row[$i];
	   	}
   		$date = add_months($date, 1);
	}
	$header_row[] = _("Fiscal YTD");
	$header_row[] = _("12 Mo. to Date");

	for ($i = 12; $i < 14; $i++){
	   	$wrapped_header_text = $rep->TextWrapCalc($header_row[$i], $cols[$i+2] - $cols[$i+1], true);
	   	$headers2[] = trim($wrapped_header_text[0]);
	   	$headers[] = trim($wrapped_header_text[1]);
	}


	$params = array(0 => $comments, 1 => array('text' => _("Report Period"), 
			  'from' => '', 'to' => $rep->DatePrettyPrint($enddate)),
	);
    
   	// Company logo setting
   	$companylogoenable = true;

   	// Footer Settings
   	$footerenable = true;
   	$footertext = _('For Management Purposes Only');

	$rep->Font();
    $rep->SetFillColor(240, 240, 240);

    $rep->lineHeight = 8;
    $rep->SetCellPadding(4);
    $rep->Info($params, $cols, $headers, $aligns, $cols2, $headers2, $aligns2, $companylogoenable, 
    $footerenable, $footertext);

    $rep->SetHeaderType('Header3');
    $rep->NewPage();
    $rep->SetDrawColor(0, 0, 0);
    $rep->SetLineWidth(0.1);
	
	$rep->row += 8;

	$total = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	$fill = 1;

	$dates_array = array();
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+1,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+2,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+3,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+4,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+5,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+6,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+7,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+8,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+9,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+10,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+11,1,$yr));
	$dates_array[] = date('Y-m-d',mktime(0,0,0,$mo+12,1,$yr));


	//Get Accounts directly under this group/type
	$result = get_all_bank_accounts(false);	
	while ($account=db_fetch($result)){
		
		if($rep->row<100)
			$rep->NewPage();

		$ctotal = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0);
		$cf_operation = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0);
		$cf_investment = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0);



		$is_home = is_company_currency($account['bank_curr_code']);
		$rep->row += 4;
		$rep->NewLine();		
		$oldcMargin = $rep->GetCellPadding();
		$rep->SetCellPadding(0);
		$rep->SetCellPadding($oldcMargin);
		$rep->row += 1;
		$rep->Line($rep->row - 1);
		$rep->NewLine();

		$bal = getPeriods($yr, $mo, $account["id"], true);
		$balance = array(0 => $bal['per01'], $bal['per02'], $bal['per03'], $bal['per04'],
			$bal['per05'], $bal['per06'], $bal['per07'], $bal['per08'],
			$bal['per09'], $bal['per10'], $bal['per11'], $bal['per12'], $bal['ytd'], $bal['mon12']);

		//Print the account name first
		$rep->Font('b');
		$rep->fontSize +=2;	
		$rep->TextCol(0, 4,	$account['bank_account_name']." - "
		.$bank_account_types[$account['account_type']], 0, 4, 0, $fill, NULL, 1);
		$rep->Font();
		$rep->fontSize -=2;	
		$rep->NewLine(2);


		//Now Opening balances
		$rep->fontSize +=2;	
		$rep->Font('b');
		$rep->TextCol(0, 1,	_("Opening Balance"), 0, 4, 0, $fill, NULL, 1);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$balance[$i] = to_home_currency($balance[$i], $account['bank_curr_code'], $date); 
			$rep->AmountCol2($i+1, $i + 2, $balance[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$ctotal[$i] += $balance[$i];
		}
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//FA Sales will be required to be substracted from receivings to remove FA impacts
		$fa_sales = get_fa_sales($dates_array, $account["id"]);
		for($i = 0; $i < 14; $i++){
			if(!$is_home)
				$fa_sales[$i] = to_home_currency($fa_sales[$i], $account['bank_curr_code'], $date); 
		}

		//FA purchases will be required to be substracted from payments to remove FA impacts
		$fa_purchases = get_fa_purchases($dates_array, $account["id"]);
		for($i = 0; $i < 14; $i++){
			if(!$is_home)
				$fa_purchases[$i] = to_home_currency($fa_purchases[$i], $account['bank_curr_code'], 
				$date); 
		}

		//Operational CashFlows

		//First receivings
		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 3,	_("Operations: Receipts"), 0, 4, 0, $fill, NULL, 1);
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//First Receiveings from customer i.e Customer payment or bank deposits with person type as 2
		$rep->TextCol(0, 1,	_("Receive from Customers"), 0, 4, 0, $fill, NULL, 1);
		$cust_rec = get_cust_deposits($dates_array, $account["id"]);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$cust_rec[$i] = to_home_currency($cust_rec[$i], $account['bank_curr_code'], $date);
			//Remove FA impacts 
			$cust_rec[$i] -= $fa_sales[$i];
			$rep->AmountCol2($i+1, $i + 2, $cust_rec[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_operation[$i] += $cust_rec[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//Now all bank deposits where person_type_id is not 2(deposits without customers)
		$rep->TextCol(0, 1,	_("Other Receivings"), 0, 4, 0, $fill, NULL, 1);
		$other_rec = get_deposits($dates_array, $account["id"]);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$other_rec[$i] = to_home_currency($other_rec[$i], $account['bank_curr_code'], $date);
			$rep->AmountCol2($i+1, $i + 2, $other_rec[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_operation[$i] += $other_rec[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//Now Payments
		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 3,	_("Operations: Payments"), 0, 4, 0, $fill, NULL, 1);
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//First Rufunds from customer i.e Customer payment or bank deposits with person type as 2
		$rep->TextCol(0, 1,	_("Refunds to Customers"), 0, 4, 0, $fill, NULL, 1);
		$cust_pay = get_cust_refunds($dates_array, $account["id"]);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$cust_pay[$i] = to_home_currency($cust_pay[$i], $account['bank_curr_code'], $date);
			//Remove FA impacts 
			$cust_pay[$i] -= (-1*$fa_purchases[$i]); 
			$rep->AmountCol2($i+1, $i + 2, $cust_pay[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_operation[$i] += $cust_pay[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//Now all bank payment where person_type_id is not 2(deposits without customers)
		$rep->TextCol(0, 1,	_("Other Payments"), 0, 4, 0, $fill, NULL, 1);
		$other_pay = get_other_pay($dates_array, $account["id"]);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$other_pay[$i] = to_home_currency($other_pay[$i], $account['bank_curr_code'], $date);
			$rep->AmountCol2($i+1, $i + 2, $other_pay[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_operation[$i] += $other_pay[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 1,	_("Net CF - Operations"), 0, 4, 0, $fill, NULL, 1);
		for ($i = 0; $i < 14; $i++){
			$rep->AmountCol2($i+1, $i + 2, $cf_operation[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$ctotal[$i] += $cf_operation[$i];
		}
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//Now Investments CashFlows

		//First inflow
		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 3,	_("Invest & Financing Activities: Receipts"), 0, 4, 0, $fill, NULL, 1);
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//Now all Fixed Assets Sales
		$rep->TextCol(0, 1,	_("Fixed Asset - Sales"), 0, 4, 0, $fill, NULL, 1);
		for ($i = 0; $i < 14; $i++){
			$rep->AmountCol2($i+1, $i + 2, $fa_sales[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $fa_sales[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//Now all bank transfer with cash incoming
		$rep->TextCol(0, 1,	_("Receive from other banks"), 0, 4, 0, $fill, NULL, 1);
		$transfer_rec = get_transfers($dates_array, $account["id"], true);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$transfer_rec[$i] = to_home_currency($transfer_rec[$i], $account['bank_curr_code'], 
				$date);
			$rep->AmountCol2($i+1, $i + 2, $transfer_rec[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $transfer_rec[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//JE where Bank's GL account being DEBITTED (where ANY ONE of CREDIT acount must be EQUITY nature one)
		$rep->TextCol(0, 1,	_("Receive from equity investments"), 0, 4, 0, $fill, NULL, 1);
		$gl_equity = get_equity_gl($dates_array, $account["account_code"], true);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$gl_equity[$i] = to_home_currency($gl_equity[$i], $account['bank_curr_code'], 
				$date);
			$rep->AmountCol2($i+1, $i + 2, $gl_equity[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $gl_equity[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		// JE where Bank's GL account being DEBITTED (while NO GL account is CREDITTED for EQUITY class one)
		$rep->TextCol(0, 1,	_("Receive from other accounts"), 0, 4, 0, $fill, NULL, 1);
		$gl_other = get_other_gl($dates_array, $account["account_code"], true);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$gl_other[$i] = to_home_currency($gl_other[$i], $account['bank_curr_code'], 
				$date);
			$rep->AmountCol2($i+1, $i + 2, $gl_other[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $gl_other[$i];
		}
		$rep->NewLine(2);
		$rep->Font();


		//Now outflow
		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 3,	_("Invest & Financing Activities: Payments"), 0, 4, 0, $fill, NULL, 1);
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		//Now all Fixed Assets Purchase
		$rep->TextCol(0, 1,	_("Fixed Asset - Purchases"), 0, 4, 0, $fill, NULL, 1);
		for ($i = 0; $i < 14; $i++){
			$rep->AmountCol2($i+1, $i + 2, $fa_purchases[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $fa_purchases[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		//Now all bank transfer with cash outgoing
		$rep->TextCol(0, 1,	_("Paid to other banks"), 0, 4, 0, $fill, NULL, 1);
		$transfer_pay = get_transfers($dates_array, $account["id"], false);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$transfer_pay[$i] = to_home_currency($transfer_pay[$i], $account['bank_curr_code'], 
				$date);
			$rep->AmountCol2($i+1, $i + 2, $transfer_pay[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $transfer_pay[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		// JE where Bank's GL account being CREDITTED (while NO GL account is CREDITTED for EQUITY class one)
		$rep->TextCol(0, 1,	_("Paid for equity investments"), 0, 4, 0, $fill, NULL, 1);
		$gl_equity_pay = get_equity_gl($dates_array, $account["account_code"], false);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$gl_equity_pay[$i] = to_home_currency($gl_equity_pay[$i], $account['bank_curr_code'],
				$date);
			$rep->AmountCol2($i+1, $i + 2, $gl_equity_pay[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $gl_equity_pay[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		// JE where Bank's GL account being CREDITTED (where CREDIT acount must be EQUITY nature one)
		$rep->TextCol(0, 1,	_("Paid to other accounts"), 0, 4, 0, $fill, NULL, 1);
		$gl_other_pay = get_other_gl($dates_array, $account["account_code"], false);
		for ($i = 0; $i < 14; $i++){
			if (!$is_home)
				$gl_other_pay[$i] = to_home_currency($gl_other_pay[$i], $account['bank_curr_code'], 
				$date);
			$rep->AmountCol2($i+1, $i + 2, $gl_other_pay[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$cf_investment[$i] += $gl_other_pay[$i];
		}
		$rep->NewLine(2);
		$rep->Font();

		$rep->fontSize +=2;
		$rep->Font('b');
		$rep->TextCol(0, 1,	_("Net CF - Invest & Financing Activities"), 0, 4, 0, $fill, NULL,
		1);
		for ($i = 0; $i < 14; $i++){
			$rep->AmountCol2($i+1, $i + 2, $cf_investment[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$ctotal[$i] += $cf_investment[$i];
		}
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize -=2;

		$rep->fontSize+=2;
		$rep->Font('b');
		$rep->TextCol(0, 1,	_("Closing Balance"), 0, 4, 0, $fill, NULL, 1);
		for ($i = 0; $i < 14; $i++){
			$rep->AmountCol2($i+1, $i + 2, $ctotal[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
			$total[$i] += $ctotal[$i];
		}
		$rep->NewLine(2);
		$rep->Font();
		$rep->fontSize-=2;
	}
	$rep->Line($rep->row - 8);
	$rep->NewLine(2);
	$rep->fontSize+=2;
	$rep->TextCol(0, 1,	_("Total Bank Accounts"), 0, 4, 0, $fill, NULL, 1);
	for ($i = 0; $i < 14; $i++)
	{
		$rep->AmountCol2($i+1, $i + 2, $total[$i], $dec, 0, 4, 0, $fill, NULL, 1, true);
	}
	$rep->fontSize-=2;

	$rep->Font();
	$rep->End();
}
?>