<?php

$page_security = 'SA_GLCHARTACCREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Chart of GL Accounts
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------
function display_type ($type, $typename, &$dec, &$rep, $showbalance, $level)
{
	$printtitle = 0; //Flag for printing type name	

	//Get Accounts directly under this group/type
	$result = get_gl_accounts(null, null, $type);	
	while ($account=db_fetch($result))
	{
		//Print Type Title if it has atleast one non-zero account	
		if (!$printtitle)
		{
			$prefix = '';
			for ($sp=1; $sp<=$level; $sp++)
			{
				$prefix .= '         ';
			}
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 1, $type);
			$rep->TextCol(1, 4, $prefix.$typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}			
		if ($showbalance == 1)
		{
			$begin = begin_fiscalyear();
			if (is_account_balancesheet($account["account_code"]))
				$begin = "";
			$balance = get_gl_trans_from_to($begin, ToDay(), $account["account_code"], 0);
		}
		$rep->TextCol(0, 1,	$account['account_code']);
		$rep->TextCol(1, 2,	$prefix.$account['account_name']);
		$rep->TextCol(2, 3,	$account['account_code2']);
		if ($showbalance == 1)	
			$rep->AmountCol(3, 4, $balance, $dec);
		$rep->NewLine();
	}

	//Get Account groups/types under this group/type
	$result = get_account_types(false, false, $type);
	while ($accounttype=db_fetch($result))
	{
		//Print Type Title if has sub types and not previously printed
		if (!$printtitle)
		{
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 1, $type);
			$rep->TextCol(1, 4, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}
		$nextlevel = $level + 1;
		display_type($accounttype["id"], $accounttype["name"].' ('.$typename.')', $dec, $rep, $showbalance, $nextlevel);
	}
}

//----------------------------------------------------------------------------------------------------

print_Chart_of_Accounts();

//----------------------------------------------------------------------------------------------------

function print_Chart_of_Accounts()
{
	global $path_to_root;

	$showbalance = $_POST['PARAM_0'];
	$comments = $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];
	$REPORT_ID = 701;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');

	$cols = array(0, 60, 300, 425, 500);

	$headers = array(_('Account'), _('Account Name'), _('Account Code'), _('Balance'));
	
	$aligns = array('left',	'left',	'left',	'right');
	
	$params = array(0 => $comments);

	$rep = new FrontReport(_('Chart of Accounts'), "ChartOfAccounts", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);
	
	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	$classresult = get_account_classes(false);
	while ($class = db_fetch($classresult))
	{
		$rep->Font('bold');
		$rep->TextCol(0, 1, $class['cid']);
		$rep->TextCol(1, 4, $class['class_name']);
		$rep->Font();
		$rep->NewLine();

		//Get Account groups/types under this group/type with no parents
		$typeresult = get_account_types(false, $class['cid'], -1);
		while ($accounttype=db_fetch($typeresult))
		{
			display_type($accounttype["id"], $accounttype["name"], $dec, $rep, $showbalance, 0);
		}
		$rep->NewLine();
	}
	$rep->Line($rep->row + 10);


    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,4,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }


	$rep->End();
}

