<?php

$page_security = 'SA_GLACCTRANSREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	GL Accounts Transactions
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/admin/db/fiscalyears_db.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");
include_once($path_to_root . "/purchasing/includes/db/suppliers_db.inc");

//----------------------------------------------------------------------------------------------------

print_GL_transactions();

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------
function print_GL_transactions()
{
	global $path_to_root, $systypes_array;

	$dim = get_company_pref('use_dimension');
	$dimension = $dimension2 = 0;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$fromacc = $_POST['PARAM_2'];
	$toacc = $_POST['PARAM_3'];
	$counter_party = $_POST['PARAM_4'];
	$REPORT_ID = 704;
	if ($dim == 2)
	{
		$dimension = $_POST['PARAM_5'];
		$dimension2 = $_POST['PARAM_6'];
		$comments = $_POST['PARAM_7'];
		$orientation = $_POST['PARAM_8'];
		$destination = $_POST['PARAM_9'];
	}
	elseif ($dim == 1)
	{
		$dimension = $_POST['PARAM_5'];
		$comments = $_POST['PARAM_6'];
		$orientation = $_POST['PARAM_7'];
		$destination = $_POST['PARAM_8'];
	}
	else
	{
		$comments = $_POST['PARAM_5'];
		$orientation = $_POST['PARAM_6'];
		$destination = $_POST['PARAM_7'];
	}
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');
	$orientation = 'L';

	$rep = new FrontReport(_('GL Account Transactions'), "GLAccountTransactions", user_pagesize(), 9, $orientation);
	$dec = user_price_dec();

	$cols = array(0, 45, 80, 105, 150, 230, 260, 345, 405, 465, 525);
	//------------0--1---2---3----4----5----6----7----8----9----10-------
	//-----------------------dim1-dim2-----------------------------------
	//-----------------------dim1----------------------------------------
	//-------------------------------------------------------------------
	$aligns = array('left', 'left', 'left',	'left',	'left',	'left',	'left',	'right', 'right', 'right');

	if ($dim == 2)
		$headers = array(_('Type'),	_('Ref'), _('#'),	_('Date'), _('Dimension')." 1", _('Dimension')." 2",
			_('Person/Item'), _('Debit'),	_('Credit'), _('Balance'));
	elseif ($dim == 1)
		$headers = array(_('Type'),	_('Ref'), _('#'),	_('Date'), _('Dimension'), "", _('Person/Item'),
			_('Debit'),	_('Credit'), _('Balance'));
	else
		$headers = array(_('Type'),	_('Ref'), _('#'),	_('Date'), "", "", _('Person/Item'),
			_('Debit'),	_('Credit'), _('Balance'));

	if ($dim == 2)
	{
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
    				    2 => array('text' => _('Accounts'),'from' => $fromacc,'to' => $toacc),
                    	3 => array('text' => _('Dimension')." 1", 'from' => get_dimension_string($dimension),
                            'to' => ''),
                    	4 => array('text' => _('Dimension')." 2", 'from' => get_dimension_string($dimension2),
                            'to' => ''));
    }
    elseif ($dim == 1)
    {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
    				    2 => array('text' => _('Accounts'),'from' => $fromacc,'to' => $toacc),
                    	3 => array('text' => _('Dimension'), 'from' => get_dimension_string($dimension),
                            'to' => ''));
    }
    else
    {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
    				    2 => array('text' => _('Accounts'),'from' => $fromacc,'to' => $toacc));
    }
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	$accounts = get_gl_accounts($fromacc, $toacc);

	while ($account=db_fetch($accounts))
	{
		if (is_account_balancesheet($account["account_code"]))
			$begin = "";
		else
		{
			$begin = get_fiscalyear_begin_for_date($from);
			if (date1_greater_date2($begin, $from))
				$begin = $from;
			$begin = add_days($begin, -1);
		}
		$prev_balance = get_gl_balance_from_to($begin, $from, $account["account_code"], $dimension, $dimension2);

		$trans = get_gl_transactions($from, $to, -1, $account['account_code'], $dimension, $dimension2, null, null, null, $counter_party);
		$rows = db_num_rows($trans);
		if ($prev_balance == 0.0 && $rows == 0)
			continue;
		$rep->Font('bold');
		$rep->TextCol(0, 4,	$account['account_code'] . " " . $account['account_name'], -2);
		$rep->TextCol(4, 6, _('Opening Balance'));
		if ($prev_balance > 0.0)
			$rep->AmountCol(7, 8, abs($prev_balance), $dec);
		else
			$rep->AmountCol(8, 9, abs($prev_balance), $dec);
		$rep->Font();
		$total = $prev_balance;
		$rep->NewLine(2);
		if ($rows > 0)
		{
			while ($myrow=db_fetch($trans))
			{
				$total += $myrow['amount'];

				if($destination)
							$rep->TextCol(0, 1, $systypes_array[$myrow["type"]], -2);
				else{
					$oldrow = $rep->row;
	            $rep->TextColLines(0, 1, $systypes_array[$myrow["type"]], -2);
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}

				$reference = get_reference($myrow["type"], $myrow["type_no"]);
				$rep->TextCol(1, 2, $reference);
				$rep->TextCol(2, 3,	$myrow['type_no'], -2);
				$rep->DateCol(3, 4,	$myrow["tran_date"], true);
				if ($dim >= 1){
					if($destination)
							$rep->TextCol(4, 5, get_dimension_string($myrow['dimension_id']), -2);
					else{
						$oldrow = $rep->row;
		            $rep->TextColLines(4, 5, get_dimension_string($myrow['dimension_id']), -2);
						$newrow[] = $rep->row;
						$rep->row = $oldrow;
					}
				}
				if ($dim > 1){
					if($destination)
							$rep->TextCol(5, 6, get_dimension_string($myrow['dimension2_id']), -2);
					else{
						$oldrow = $rep->row;
		            $rep->TextColLines(5, 6, get_dimension_string($myrow['dimension2_id']), -2);
						$newrow[] = $rep->row;
						$rep->row = $oldrow;
					}
				}

 				
				$person_name = payment_person_name($myrow["person_type_id"],$myrow["person_id"], false);
				if($person_name>0 && $person_name <= 5000 && $myrow["person_id"]){
					if(in_array($myrow["type"], array(ST_SALESQUOTE, ST_SALESORDER, ST_CUSTDELIVERY, ST_SALESINVOICE, ST_CUSTCREDIT, ST_CUSTPAYMENT)))
						$person_name = get_customer_name($myrow["person_id"]);
					else
						$person_name = get_supplier_name($myrow["person_id"]);
				}
				// $memo = $myrow['memo_'];
				// if ($txt != "")
				// {
				// 	if ($memo != "")
				// 		$txt = $txt."/".$memo;
				// }
				// else
				// 	$txt = $memo;

				if($destination)
						$rep->TextCol(6, 7, $person_name, -2);
				else{
					$oldrow = $rep->row;
	            $rep->TextColLines(6, 7, $person_name, -2);
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}

				if ($myrow['amount'] > 0.0)
					$rep->AmountCol(7, 8, abs($myrow['amount']), $dec);
				else
					$rep->AmountCol(8, 9, abs($myrow['amount']), $dec);
				$rep->TextCol(9, 10, number_format2($total, $dec));
				$rep->row = min($newrow);
				unset($newrow);
				$rep->NewLine();
				if(!$destination){
    				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
    				{
    					$rep->Line($rep->row - 2);
    					$rep->NewPage();
    				}				    
				}

			}
			$rep->NewLine();
		}
		$rep->Font('bold');
		$rep->TextCol(4, 6,	_("Ending Balance"));
		if ($total > 0.0)
			$rep->AmountCol(7, 8, abs($total), $dec);
		else
			$rep->AmountCol(8, 9, abs($total), $dec);
		$rep->Font();
		$rep->Line($rep->row - $rep->lineHeight + 4);
		$rep->NewLine(2, 1);
	}




    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,10,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }


	$rep->End();
}

