<?php

$page_security = 'SA_GLTRAILBLNC';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Trial Balance
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/admin/db/fiscalyears_db.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

$pdeb = $pcre = $cdeb = $ccre = $tdeb = $tcre = $pbal = $cbal = $tbal = 0;

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------
function display_type ($type, $typename, &$dec, &$rep, $from, $to, $zero, $balances, $dimension, $dimension2)
{
	global $pdeb, $pcre, $cdeb, $ccre, $tdeb, $tcre, $pbal, $cbal, $tbal, $SysPrefs;
	
	$printtitle = 0; //Flag for printing type name	
	
	//Get Accounts directly under this group/type
	$accounts = get_gl_accounts(null, null, $type);	
	
	$begin = get_fiscalyear_begin_for_date($from);
	if (date1_greater_date2($begin, $from))
		$begin = $from;
	$begin = add_days($begin, -1);
	while ($account=db_fetch($accounts))
	{
		//Print Type Title if it has atleast one non-zero account	

		if (!$printtitle)
		{	
			$rep->row -= 4;
			$rep->fontSize += 1;
			// $rep->SetFont('helveticai', '2', '','', '');
			// $rep->SetFont('helveticai', 'i', 12);
			$rep->TextCol(0, 8, _("Group")." - ".$type ." - ".$typename);	
			$rep->fontSize -= 1;
			$printtitle = 1;
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();			
		}
		
		// FA doesn't really clear the closed year, therefore the brought forward balance includes all the transactions from the past, even though the balance is null.
		// If we want to remove the balanced part for the past years, this option removes the common part from from the prev and tot figures.
		if (@$SysPrefs->clear_trial_balance_opening)
		{
			$open = get_balance($account["account_code"], $dimension, $dimension2, $begin,  $begin, false, true);
			$offset = min($open['debit'], $open['credit']);
		} else
			$offset = 0;

		$prev = get_balance($account["account_code"], $dimension, $dimension2, $begin, $from, false, false);
		$curr = get_balance($account["account_code"], $dimension, $dimension2, $from, $to, true, true);
		$tot =  get_balance($account["account_code"], $dimension, $dimension2, $begin, $to, false, true);

		if ($zero == 0 && !$prev['balance'] && !$curr['balance'] && !$tot['balance'])
			continue;
		$rep->fontSize -= 1.5;
		$rep->TextCol(0, 1, $account['account_code']);
		$rep->TextCol(1, 2,	$account['account_name']);
		$rep->fontSize += 1.5;


		$rep->fontSize -= 1.5;
		if ($balances != 0)
		{
			if ($prev['balance'] >= 0.0)
				$rep->AmountCol(2, 3, $prev['balance'], $dec);
			else
				$rep->AmountCol(3, 4, abs($prev['balance']), $dec);
			if ($curr['balance'] >= 0.0)
				$rep->AmountCol(4, 5, $curr['balance'], $dec);
			else
				$rep->AmountCol(5, 6, abs($curr['balance']), $dec);
			if ($tot['balance'] >= 0.0)
				$rep->AmountCol(6, 7, $tot['balance'], $dec);
			else
				$rep->AmountCol(7, 8, abs($tot['balance']), $dec);
		}
		else
		{
			$rep->AmountCol(2, 3, $prev['debit']-$offset, $dec);
			$rep->AmountCol(3, 4, $prev['credit']-$offset, $dec);
			$rep->AmountCol(4, 5, $curr['debit'], $dec);
			$rep->AmountCol(5, 6, $curr['credit'], $dec);
			$rep->AmountCol(6, 7, $tot['debit']-$offset, $dec);
			$rep->AmountCol(7, 8, $tot['credit']-$offset, $dec);
			$pdeb += $prev['debit']-$offset;
			$pcre += $prev['credit']-$offset;
			$cdeb += $curr['debit'];
			$ccre += $curr['credit'];
			$tdeb += $tot['debit']-$offset;
			$tcre += $tot['credit']-$offset;
		}	
		$rep->fontSize += 1.5;


		$pbal += $prev['balance'];
		$cbal += $curr['balance'];
		$tbal += $tot['balance'];
		$rep->NewLine();

		if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
		{
			$rep->Line($rep->row - 2);
			$rep->NewPage();
		}
	}
		
	//Get Account groups/types under this group/type
	$result = get_account_types(false, false, $type);
	while ($accounttype=db_fetch($result))
	{
		//Print Type Title if has sub types and not previously printed
		if (!$printtitle)
		{
			$rep->row -= 4;
			$rep->TextCol(0, 8, _("Group")." - ".$type ." - ".$typename);	
			$printtitle = 1;
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}
		display_type($accounttype["id"], $accounttype["name"].' ('.$typename.')', $dec, $rep, $from, $to, $zero, $balances, $dimension, $dimension2);
	}
}

//----------------------------------------------------------------------------------------------------

print_trial_balance();

//----------------------------------------------------------------------------------------------------

function print_trial_balance()
{
	global $path_to_root;
	global $pdeb, $pcre, $cdeb, $ccre, $tdeb, $tcre, $pbal, $cbal, $tbal;

	$dim = get_company_pref('use_dimension');
	$dimension = $dimension2 = 0;

	$REPORT_ID = 708;
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$zero = $_POST['PARAM_2'];
	$balances = $_POST['PARAM_3'];
	if ($dim == 2)
	{
		$dimension = $_POST['PARAM_4'];
		$dimension2 = $_POST['PARAM_5'];
		$comments = $_POST['PARAM_6'];
		$orientation = $_POST['PARAM_7'];
		$destination = $_POST['PARAM_8'];
	}
	else if ($dim == 1)
	{
		$dimension = $_POST['PARAM_4'];
		$comments = $_POST['PARAM_5'];
		$orientation = $_POST['PARAM_6'];
		$destination = $_POST['PARAM_7'];
	}
	else
	{
		$comments = $_POST['PARAM_4'];
		$orientation = $_POST['PARAM_5'];
		$destination = $_POST['PARAM_6'];
	}
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols2 = array(0, 50, 190, 360, 510, 620);
	// $cols2 = array(0, 50, 190, 370, 500, 600);
	//-------------0--1---2----3----4----5--
	$headers2 = array('', '', _('Brought Forward'),	_('This Period'), _('Balance'));

	$aligns2 = array('left', 'left', 'left', 'left', 'left');

	$cols = array(0, 50, 150, 210, 270,	360, 420, 510, 580,	620);
	// $headers2 = array('', '', _('Brought Forward'),	_('This Period'), _('Balance'));

	// $aligns2 = array('left', 'left', 'left', 'left', 'left');

	// $cols = array(0, 50, 150, 210, 270,	380, 430, 500, 560,	640);
	//------------0--1---2----3----4----5----6----7----8--

	$headers = array(_('Account'), _('Account Name'), _('Debit'), _('Credit'), _('Debit'),
		_('Credit'), _('Debit'), _('Credit'));

	$aligns = array('left',	'left',	'right', 'right', 'right', 'right',	'right', 'right');
	// $headers = array(_('Account'), _('Account Name'), _('Debit'), _('Credit'), _('Debit'),
		// _('Credit'), _('Debit'), _('Credit'));

	// $aligns = array('left',	'left',	'right', 'right', 'right', 'right',	'right', 'right');

    if ($dim == 2)
    {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
                    	2 => array('text' => _('Dimension')." 1",
                            'from' => get_dimension_string($dimension), 'to' => ''),
                    	3 => array('text' => _('Dimension')." 2",
                            'from' => get_dimension_string($dimension2), 'to' => ''));
    }
    elseif ($dim == 1)
    {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
                    	2 => array('text' => _('Dimension'),
                            'from' => get_dimension_string($dimension), 'to' => ''));
    }
    else
    {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to));
    }
		$margins = array('top' => 30 ,'bottom' => 40,'left' =>8 ,'right' =>8 );
// $margins = array('top' => 40 ,'bottom' =>30 ,'left' =>15 ,'right' =>15 );

	$rep = new FrontReport(_('Trial Balance'), "TrialBalance", user_pagesize(), 9, $orientation, $margins);
    if ($orientation == 'L')
    {
    	recalculate_cols($cols);
    	recalculate_cols($cols2);
	}

	$rep->Info($params, $cols, $headers, $aligns, $cols2, $headers2, $aligns2);
	$rep->NewPage();

	$classresult = get_account_classes(false);
	while ($class = db_fetch($classresult))
	{
		$rep->Font('bold');
		$rep->fontSize += 5;
		$rep->TextCol(0, 1, $class['cid']);
		$rep->TextCol(1, 4, $class['class_name']);
		$rep->fontSize -= 5;
		$rep->Font();
		$rep->NewLine();

		//Get Account groups/types under this group/type with no parents
		$typeresult = get_account_types(false, $class['cid'], -1);
		while ($accounttype=db_fetch($typeresult))
		{
			display_type($accounttype["id"], $accounttype["name"], $dec, $rep, $from, $to,	$zero, $balances, $dimension, $dimension2);
		}
		$rep->NewLine();
	}
	$rep->Line($rep->row);
	$rep->NewLine();
        // $rep->Font('bold');

	 $rep->Font('bold');
	if ($balances == 0)
	{
		$rep->TextCol(0, 2, _("Total"));
		$rep->fontSize -= 1.5;
		$rep->AmountCol(2, 3, $pdeb, $dec);
		$rep->AmountCol(3, 4, $pcre, $dec);
		$rep->AmountCol(4, 5, $cdeb, $dec);
		$rep->AmountCol(5, 6, $ccre, $dec);
		$rep->AmountCol(6, 7, $tdeb, $dec);
		$rep->AmountCol(7, 8, $tcre, $dec);
		$rep->fontSize += 1.5;
		$rep->NewLine();
	}	

	$rep->TextCol(0, 2, _("Ending Balance"));

		$rep->fontSize -= 1.5;
	if ($pbal >= 0.0)
		$rep->AmountCol(2, 3, $pbal, $dec);
	else
		$rep->AmountCol(3, 4, abs($pbal), $dec);
	if ($cbal >= 0.0)
		$rep->AmountCol(4, 5, $cbal, $dec);
	else
		$rep->AmountCol(5, 6, abs($cbal), $dec);
	if ($tbal >= 0.0)
		$rep->AmountCol(6, 7, $tbal, $dec);
	else
		$rep->AmountCol(7, 8, abs($tbal), $dec);
		$rep->fontSize += 1.5;
	 $rep->Font();

	$rep->NewLine();

	$rep->Line($rep->row + 10);
	if (($pbal = round2($pbal, $dec)) != 0.0 && $dimension == 0 && $dimension2 == 0)
	{
		$rep->NewLine(2);
		$rep->TextCol(0, 8, _("The Opening Balance is not in balance, probably due to a non closed Previous Fiscalyear."));
	}

	
    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }


	
	$rep->End();
}

