<?php

$page_security = 'SA_SYSGLAUDITREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Audit Trail
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");
include_once($path_to_root . "/includes/db/sales_order_db.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
    $sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
    $result = db_query($sql,"Did not Executed");
    return $result;
}
//----------------------------------------------------------------------------------------------------
function getTransactions($from, $to, $type, $user)
{
    $fromdate = date2sql($from) . " 00:00:00";
    $todate = date2sql($to). " 23:59.59";

    /*$sql = "SELECT a.*, 
        SUM(IF(ISNULL(g.amount), NULL, IF(g.amount > 0, g.amount, 0))) AS amount,
        u.user_id,
        UNIX_TIMESTAMP(a.stamp) as unix_stamp
        FROM ".TB_PREF."audit_trail AS a JOIN ".TB_PREF."users AS u
        LEFT JOIN ".TB_PREF."gl_trans AS g ON (g.type_no=a.trans_no
            AND g.type=a.type)
        WHERE a.user = u.id ";
    if ($type != -1)
        $sql .= "AND a.type=$type ";
    if ($user != -1)    
        $sql .= "AND a.user='$user' ";
    $sql .= "AND a.stamp >= '$fromdate'
            AND a.stamp <= '$todate'
        GROUP BY a.trans_no,a.gl_seq,a.stamp    
        ORDER BY a.stamp,a.gl_seq";*/
        $sql = "SELECT a.*, 
        u.user_id,
        UNIX_TIMESTAMP(a.stamp) as unix_stamp
        FROM ".TB_PREF."audit_trail AS a JOIN ".TB_PREF."users AS u
        WHERE a.user = u.id ";
    if ($type != -1)
        $sql .= "AND a.type=$type ";
    if ($user != -1)    
        $sql .= "AND a.user='$user' ";
    $sql .= "AND a.stamp >= '$fromdate'
            AND a.stamp <= '$todate'
        ";
        // display_error($sql);
    return db_query($sql,"No transactions were returned");
}
//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $systype = $_POST['PARAM_2'];
    $user = $_POST['PARAM_3'];
    $comments = $_POST['PARAM_4'];
    $orientation = $_POST['PARAM_5'];
    $destination = $_POST['PARAM_6'];
    $REPORT_ID = 710;
    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 60, 110, 150, 210, 290, 320, 360, 490);

    $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
        _('Type'), _('#'), _('Action'), _('Description'), _('Amount'));

    $aligns = array('left', 'left', 'left', 'left', 'left', 'center', 'left', 'left', 'right');

    $usr = get_user($user);
    $user_id = $usr['user_id'];
    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
                        2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
                        3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));

    $rep = new FrontReport(_('Audit Trail'), "AuditTrail", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
        recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

    $trans = getTransactions($from, $to, $systype, $user);

    while ($myrow=db_fetch($trans))
    {
        $rep->TextCol(0, 1, sql2date(date("Y-m-d", $myrow['unix_stamp'])));
        if (user_date_format() == 0)
            $rep->TextCol(1, 2, date("h:i:s a", $myrow['unix_stamp']));
        else    
            $rep->TextCol(1, 2, date("H:i:s", $myrow['unix_stamp']));
        $rep->TextCol(2, 3, $myrow['user_id']);
        $rep->TextCol(3, 4, sql2date($myrow['gl_date']));
        $rep->TextCol(4, 5, $systypes_array[$myrow['type']]);
        $rep->TextCol(5, 6, $myrow['trans_no']);
        if ($myrow['gl_seq'] == null)
            $action = _('Changed');
        else
            $action = _('Closed');
        $rep->TextCol(6, 7, $action);
        $rep->TextCol(7, 8, $myrow['description']);
        if($myrow['type'] == 30){  //sales order
            $rep->AmountCol(8, 9, get_sales_order_total($myrow['trans_no']), $dec);
        }
        else if($myrow['type'] == 32){ //sales quotetion
            $rep->AmountCol(8, 9, get_sales_order_total($myrow['trans_no']), $dec);
        }
        else if($myrow['type'] == 13){ //customer delivery
            $rep->AmountCol(8, 9, get_delivery_note_gst($myrow['trans_no']), $dec);
        }
        else if($myrow['type'] == 18){ //purchase order
            $rep->AmountCol(8, 9, get_purchase_amount_gst($myrow['trans_no']), $dec);
        }
        else if($myrow['amount'] != null){
            $rep->AmountCol(8, 9, $myrow['amount'], $dec);
        }
        $rep->NewLine(1, 2);
    }
    $rep->Line($rep->row  + 4);

       
    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
        if($row['is_policy_text'] == 1){
            $rep->row = 120;
            $rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
        }
        if($row['is_policy_image'] == 1){
            $logo = company_path() . "/images/" . $row['filename'];
            $rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
        }


            if($row['signature2'] == '' && $row['signature3'] == ''){   
                if($orientation == 'P'){
                    $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
                }else{

                    $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
                }

            }


            if($row['signature2'] != '' && $row['signature3'] == ''){
                if($orientation == 'P'){
                    $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

                    $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
                }else{

                    $rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

                    $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
                }

            }



            if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
               if($orientation == 'P'){
                    $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

                    $rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

                    $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
                }else{

                    $rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

                    $rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
                    $rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

                    $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
                    $rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

                }
            }
        }




    $rep->End();
}
