<?php

$page_security = 'SA_VOIDTRANSACTION';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";
include($path_to_root . "/reporting/includes/reporting.inc");
include($path_to_root . "/reporting/includes/tcpdf.php");
include($path_to_root . "/reporting/includes/pdf_report.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");
include_once($path_to_root . "/admin/db/transactions_db.inc");
include_once($path_to_root . "/admin/db/voiding_db.inc");
//----------------------------------------------------------------------------------------------------



function get_void_trans($type,$from,$to,$From_Date,$To_Date)
{
  # code...
$datefrom = date2sql($From_Date);
$dateto = date2sql($To_Date);
$sql ="SELECT * FROM ".TB_PREF."voided ";
if ($type != -1) {
$sql .= "WHERE type=".db_escape($type)." AND";
}
else
$sql .= "WHERE ";

if ($from != null && $to != null)
  {
    $sql .= " id >= ".db_escape($from). "
      AND id <= ".db_escape($to)." AND";
  }

    $sql .= "  date_ >= '$datefrom' AND date_ <= '$dateto'";

$result = db_query($sql);

 return $result;
 
}

function get_user_created($type,$trans_no,$id){


  $sql = "SELECT * FROM ".TB_PREF."audit_trail WHERE id != '$id' AND  type = '$type' and trans_no = '$trans_no' ";
  $result  = db_query($sql," no data ");
  $myrow = db_fetch($result); 

  return $myrow;
}

function get_user_voided($type,$trans_no){

$sql = "SELECT * FROM ".TB_PREF."audit_trail WHERE description LIKE '%Voided%' and type = '$type' and trans_no = '$trans_no' ";
  $result  = db_query($sql," no data ");
  $myrow = db_fetch($result); 

   $get_created_user =  get_user_created($type,$trans_no,$myrow["id"]);

  $voided_info = array(
                   'created_user' => $get_created_user['user'],
                   'created_date' => $get_created_user['gl_date'],
                   'voided_user' => $myrow['user'],
                   'voided_date' => $myrow['gl_date'],
                 );


  return $voided_info;
}


print_void_transaction();


//----------------------------------------------------------------------------------------------------

function print_void_transaction()
{



global $path_to_root, $systypes_array;


$filterType =    $_POST['PARAM_0'];
$FromTransNo =   $_POST['PARAM_1'];
$ToTransNo =     $_POST['PARAM_2'];
$FromDate =      $_POST['PARAM_3'];
$ToDate =        $_POST['PARAM_4'];
$comments =      $_POST['PARAM_5'];
$orientation =   $_POST['PARAM_6'];
$destination =   $_POST['PARAM_7'];


if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();



    $cols = array(5, 120,155,220,290,350,430);


    $headers = array(_('#'), _('ID'), _('C. Date'), _('V. Date'),_('C. User'),_('V. User'), _('Memo'));


    $aligns = array('left','left','left','left','left','left','left');

 $params =   array(  0 => $comments,
                     1 => array('text' => _('Type'), 'from' =>  $systypes_array[$filterType] ),
                     2 => array('text' => _('To #'), 'from' => $FromTransNo),
                     3 => array('text' => _('From #'), 'from' => $ToTransNo)
                     
                     // 1 => array('text' => _('Date before'), 'from' => $from),
                   
                
                        

                    );

    $rep = new FrontReport(_('Void Transation'), "AccountInq", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
    recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


    //--------------------------------------------------------------------------------------------------

$result2 = get_void_trans($filterType,$FromTransNo,$ToTransNo,$FromDate,$ToDate);


    while ($myrow2 = db_fetch($result2))
    {

       global $path_to_root, $systypes_array;
        $rep->TextCol(0, 1,$systypes_array[$myrow2['type']]);
        $rep->TextCol(1, 2, $myrow2["id"]);
        $user_info = get_user_voided($myrow2['type'],$myrow2['id']);
        $rep->TextCol(2, 3,  sql2date($user_info["created_date"]));
        $rep->TextCol(3, 4,  sql2date($user_info["voided_date"]));
        $rep->TextCol(4, 5,  get_user($user_info["created_user"])['real_name']);
        $rep->TextCol(5, 6,  get_user($user_info["voided_user"])['real_name']);
        $memo = str_split($myrow2["memo_"],22);
        for($i= 0 ; $i<= count($memo); $i++){
          if($i >= 1 && count($memo) != 1 )
         $rep->NewLine();
        $rep->TextCol(6, 7, $memo[$i]);
       
        
        }
  $rep->NewLine();
     }   
    
        $rep->End();
  }


