<?php

$page_security = 'SA_ANNUALEXPNEWREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt, Chaitanya for the recursive version 2009-02-05.
// date_:	2005-05-19
// Title:	Annual expense breakdown
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/admin/db/tags_db.inc");

//----------------------------------------------------------------------------------------------------

print_annual_expense_breakdown();

//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM `0_report_sign` WHERE rep_id = '$id' ";
	$result = db_query($sql,"Did not Executed");
	return $result;
}
//----------------------------------------------------------------------------------------------------
function getPeriods($yr, $mo, $account, $dimension, $dimension2, $syr, $smo, $months_)
{
	
	$date13 = date('Y-m-d',mktime(0,0,0,$mo+1,1,$yr));
	$date12 = date('Y-m-d',mktime(0,0,0,$mo,1,$yr));
	$date11 = date('Y-m-d',mktime(0,0,0,$mo-1,1,$yr));
	$date10 = date('Y-m-d',mktime(0,0,0,$mo-2,1,$yr));
	$date09 = date('Y-m-d',mktime(0,0,0,$mo-3,1,$yr));
	$date08 = date('Y-m-d',mktime(0,0,0,$mo-4,1,$yr));
	$date07 = date('Y-m-d',mktime(0,0,0,$mo-5,1,$yr));
	$date06 = date('Y-m-d',mktime(0,0,0,$mo-6,1,$yr));
	$date05 = date('Y-m-d',mktime(0,0,0,$mo-7,1,$yr));
	$date04 = date('Y-m-d',mktime(0,0,0,$mo-8,1,$yr));
	$date03 = date('Y-m-d',mktime(0,0,0,$mo-9,1,$yr));
	$date02 = date('Y-m-d',mktime(0,0,0,$mo-10,1,$yr));
	$date01 = date('Y-m-d',mktime(0,0,0,$mo-11,1,$yr));
	
	
	$mon= $mo+1;
	$yr_ = $yr;
	
	$str_date = $yr_."-".$mon;
	$end_date = $yr_."-".$mon;

	for($j=0; $j<$months_; $j++){
	 	$date_s_[$j] = $str_date."-01";
	 	$date_e_[$j] = $end_date."-31";

	 	$str_date = date('Y-m', strtotime("+1 months", strtotime($str_date)));
	 	$end_date = date('Y-m', strtotime("+1 months", strtotime($end_date)));
	 	
	}


	
    
    $sql = "SELECT ";
    for($j=0; $j<$months_; $j++){
    	$sql .= " SUM(CASE WHEN tran_date >= '".$date_s_[$j]."' AND tran_date <= '".$date_e_[$j]."' THEN amount / 1000 ELSE 0 END) AS per$j ,";

    }
    
    $sql = substr_replace($sql,"",-1);
    /*$sql = "SELECT 
    			SUM(CASE WHEN tran_date >= '$date01' AND tran_date < '$date02' THEN amount / 1000 ELSE 0 END) AS per01,
		   		SUM(CASE WHEN tran_date >= '$date02' AND tran_date < '$date03' THEN amount / 1000 ELSE 0 END) AS per02,
		   		SUM(CASE WHEN tran_date >= '$date03' AND tran_date < '$date04' THEN amount / 1000 ELSE 0 END) AS per03,
		   		SUM(CASE WHEN tran_date >= '$date04' AND tran_date < '$date05' THEN amount / 1000 ELSE 0 END) AS per04,
		   		SUM(CASE WHEN tran_date >= '$date05' AND tran_date < '$date06' THEN amount / 1000 ELSE 0 END) AS per05,
		   		SUM(CASE WHEN tran_date >= '$date06' AND tran_date < '$date07' THEN amount / 1000 ELSE 0 END) AS per06,
		   		SUM(CASE WHEN tran_date >= '$date07' AND tran_date < '$date08' THEN amount / 1000 ELSE 0 END) AS per07,
		   		SUM(CASE WHEN tran_date >= '$date08' AND tran_date < '$date09' THEN amount / 1000 ELSE 0 END) AS per08,
		   		SUM(CASE WHEN tran_date >= '$date09' AND tran_date < '$date10' THEN amount / 1000 ELSE 0 END) AS per09,
		   		SUM(CASE WHEN tran_date >= '$date10' AND tran_date < '$date11' THEN amount / 1000 ELSE 0 END) AS per10,
		   		SUM(CASE WHEN tran_date >= '$date11' AND tran_date < '$date12' THEN amount / 1000 ELSE 0 END) AS per11,
		   		SUM(CASE WHEN tran_date >= '$date12' AND tran_date < '$date13' THEN amount / 1000 ELSE 0 END) AS per12*/
   	$sql .= " FROM ".TB_PREF."gl_trans
				WHERE account='$account'";
	if ($dimension != 0)
  		$sql .= " AND dimension_id = ".($dimension<0?0:db_escape($dimension));
	if ($dimension2 != 0)
  		$sql .= " AND dimension2_id = ".($dimension2<0?0:db_escape($dimension2));
  	// display_error($sql);
	$result = db_query($sql, "Transactions for account $account could not be calculated");

	return db_fetch($result);
}

//----------------------------------------------------------------------------------------------------

function display_type ($type, $typename, $yr, $mo, $convert, &$dec, &$rep, $dimension, $dimension2, $tags, $syr, $smo, $months_)
{
	$ctotal = array(0 => 0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	$total = array(0 => 0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	$totals_arr = array();

	$printtitle = 0; //Flag for printing type name	

	//Get Accounts directly under this group/type
	$result = get_gl_accounts(null, null, $type);	
	while ($account=db_fetch($result))
	{
		if ($tags != -1 && is_array($tags) && $tags[0] != false)
		{
			if (!is_record_in_tags($tags, TAG_ACCOUNT, $account['account_code']))
				continue;
		}	
		
		$bal = getPeriods($yr, $mo, $account["account_code"], $dimension, $dimension2, $syr, $smo, $months_);
		$loop_varaible = [];
		for($j=0; $j<$months_; $j++){
			//if (!$bal['per'.$j])
			$loop_varaible[] = abs($bal['per'.$j]);
		}
		if(array_sum($loop_varaible) == 0)
		    continue;
	
		//Print Type Title if it has atleast one non-zero account	
		if (!$printtitle)
		{
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 5, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();
		}			

		/*$balance = array(1 => $bal['per01'], $bal['per02'], $bal['per03'], $bal['per04'],
			$bal['per05'], $bal['per06'], $bal['per07'], $bal['per08'],
			$bal['per09'], $bal['per10'], $bal['per11'], $bal['per12']);*/
		for($j=0; $j<$months_; $j++){
			$balance[$j] = $bal['per'.$j];
		}	
		$rep->TextCol(0, 1,	$account['account_code']);
		$rep->TextCol(1, 2,	$account['account_name']);
	/*	print_r($balance);
		exit;*/
		$line_total = 0;
		$i = 0;
		for ($i = 0; $i <$months_; $i++)
		{
			if($balance[$i] * $convert < 0){
				// $rep->SetDrawColor(255,0,0);
				$rep->SetTextColor(255,0,0);
				$rep->TextCol($i + 2, $i + 3, "(".number_format2(abs($balance[$i] * $convert),$dec).")", $dec);
				$rep->SetTextColor(0, 0, 0);
				$line_total = $line_total + ($balance[$i] * $convert);
			}
			else{
				$rep->AmountCol($i + 2, $i + 3, $balance[$i] * $convert, $dec);
				$line_total = $line_total + ($balance[$i] * $convert);
			}
			$ctotal[$i] += $balance[$i];
		}
		if($line_total < 0){
			$rep->SetTextColor(255,0,0);
			$rep->TextCol($i + 2, $i + 3,"(".abs($line_total).")", $dec);
			$rep->SetTextColor(0, 0, 0);
		}
		else
			$rep->AmountCol($i + 2, $i + 3,$line_total, $dec);
		$rep->NewLine();
	}
		
	//Get Account groups/types under this group/type
	$result = get_account_types(false, false, $type);
	while ($accounttype=db_fetch($result))
	{
		//Print Type Title if has sub types and not previously printed
		if (!$printtitle)
		{
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 5, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();
		}

		$totals_arr = display_type($accounttype["id"], $accounttype["name"], $yr, $mo, $convert, $dec, $rep, $dimension, $dimension2, $tags, $syr, $smo, $months_);
		for ($i = 0; $i <$months_; $i++)
		{
			$total[$i] += $totals_arr[$i];
		}
	}

	//Display Type Summary if total is != 0 OR head is printed (Needed in case of unused hierarchical COA) 
	if ($printtitle)
	{
		$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->TextCol(0, 2,	_('Total') . " " . $typename);
		$i = 0;
		$line_total2=0;
		for ($i = 0; $i <$months_; $i++){
			$rep->AmountCol($i + 2, $i + 3, ($total[$i] + $ctotal[$i]) * $convert, $dec);
			$line_total2 = $line_total2 + (($total[$i] + $ctotal[$i]) * $convert);
		}

		$rep->AmountCol($i + 2, $i + 3,$line_total2, $dec);
		$rep->NewLine();
	}
	for ($i = 0; $i <$months_; $i++)
		$totals_arr[$i] = $total[$i] + $ctotal[$i];	
	return $totals_arr;
}

//----------------------------------------------------------------------------------------------------

function print_annual_expense_breakdown()
{
	global $path_to_root, $SysPrefs;

	$REPORT_ID = 713;
	$dim = get_company_pref('use_dimension');
	$dimension = $dimension2 = 0;

	if ($dim == 2)
	{
		$from_month = $_POST['PARAM_0'];
		$from_year = $_POST['PARAM_1'];
		$to_month = $_POST['PARAM_2'];
		$to_year = $_POST['PARAM_3'];
		//$year = 6;
		$dimension = $_POST['PARAM_4'];
		$dimension2 = $_POST['PARAM_5'];
		$tags = (isset($_POST['PARAM_6']) ? $_POST['PARAM_6'] : -1);
		$comments = $_POST['PARAM_7'];
		$orientation = $_POST['PARAM_8'] = 1;
		$destination = $_POST['PARAM_9'];
	}
	elseif ($dim == 1)
	{
		$year = $_POST['PARAM_0'];
		$dimension = $_POST['PARAM_1'];
		$tags = (isset($_POST['PARAM_2']) ? $_POST['PARAM_2'] : -1);
		$comments = $_POST['PARAM_3'];
		$orientation = $_POST['PARAM_4'];
		$destination = $_POST['PARAM_5'];
	}
	else
	{
		$year = $_POST['PARAM_0'];
		$tags = (isset($_POST['PARAM_1']) ? $_POST['PARAM_1'] : -1);
		$comments = $_POST['PARAM_2'];
		$orientation = $_POST['PARAM_3'];
		$destination = $_POST['PARAM_4'];
	}
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	$dec = 1;
	
	if($from_month == 0){
		display_error("Select the from month please.");
		exit;
	}
	if($to_month == 0){
		display_error("Select the to month please.");
		exit;
	}
	if(	strtotime(get_selected_years($from_year)."-".$from_month."-01") > strtotime(get_selected_years($to_year)."-".$to_month."-31")){
		display_error("From month and year should be less then to month and to year.");
		exit;
	}

	$date1 = strtotime(get_selected_years($from_year)."-".$from_month."-01");  
	$date2 = strtotime(get_selected_years($to_year)."-".$to_month."-31"); 
	$diff = abs($date2 - $date1);

	$years_ = floor($diff / (365*60*60*24));
	if($diff == 31536000)
		$years_ = floor($diff / (366*60*60*24));

	$months_ = round(($diff - $years_ * 365*60*60*24)/ (30*60*60*24));   

	if($years_ > 0){
		display_error("Time difference should be 12 months");
		exit;
	}

	// from now
	$sql = "SELECT begin, end, YEAR(end) AS yr, MONTH(end) AS mo FROM ".TB_PREF."fiscal_year WHERE id=".db_escape($year);
	$result = db_query($sql, "could not get fiscal year");
	$row = db_fetch($result);
	
	$year = sql2date($row['begin'])." - ".sql2date($row['end']);
	$yr = $row['yr'];
	$mo = $row['mo'];

	$year = sql2date(get_selected_years($from_year)."-".$from_month."-01")." - ".sql2date(get_selected_years($to_year)."-".$to_month."-31");
	$yr = get_selected_years($from_year);
	$mo = $from_month-1;
	$syr = get_selected_years($to_year);
	$smo = $to_month;

	//display_error($yr ."   ".$mo."     ".$smo."   ".$syr."    ".$months_);
	$da = 1;
	if ($SysPrefs->date_system == 1)
		list($yr, $mo, $da) = jalali_to_gregorian($yr, $mo, $da);
	elseif ($SysPrefs->date_system == 2)
		list($yr, $mo, $da) = islamic_to_gregorian($yr, $mo, $da);
	
	$array_header[] = _('Account');
	$array_header[] = _('Account Name');
	$array_col[] = 0;
	$array_col[] = 40;
	$array_col[] = 150;
	$added_with = 150;
	// $col_width = 360/$months_;
	$col_width = 384/($months_+1);
	// display_error($months_);
	
	for($j=0; $j <$months_; $j++){
		$array_header[] = strftime('%b',mktime(0,0,0,$mo-11+$j,$da,$yr));
		$added_with += $col_width;
		$array_col[] = $added_with;
	}
	$array_header[] = _('Total');
	$per12 = strftime('%b',mktime(0,0,0,$mo,$da,$yr));
	$per11 = strftime('%b',mktime(0,0,0,$mo-1,$da,$yr));
	$per10 = strftime('%b',mktime(0,0,0,$mo-2,$da,$yr));
	$per09 = strftime('%b',mktime(0,0,0,$mo-3,$da,$yr));
	$per08 = strftime('%b',mktime(0,0,0,$mo-4,$da,$yr));
	$per07 = strftime('%b',mktime(0,0,0,$mo-5,$da,$yr));
	$per06 = strftime('%b',mktime(0,0,0,$mo-6,$da,$yr));
	$per05 = strftime('%b',mktime(0,0,0,$mo-7,$da,$yr));
	$per04 = strftime('%b',mktime(0,0,0,$mo-8,$da,$yr));
	$per03 = strftime('%b',mktime(0,0,0,$mo-9,$da,$yr));
	$per02 = strftime('%b',mktime(0,0,0,$mo-10,$da,$yr));
	$per01 = strftime('%b',mktime(0,0,0,$mo-11,$da,$yr));

	/*$headers = array(_('Account'), _('Account Name'), $per01, $per02, $per03, $per04,
		$per05, $per06, $per07, $per08, $per09, $per10, $per11, $per12);
	$cols = array(0, 40, 150, 180, 210, 240, 270, 300, 330, 360, 390, 420, 450, 480, 510);
	//------------0--1---2----3----4----5----6----7----8----10---11---12---13---14---15-
	*/

	$headers = 	$array_header;
	$cols = $array_col;
	
	// $cols = array(0, 40, 150, 180, 210, 240, 270, 300, 330, 360, 390, 420, 450, 480, 510);
	

	$aligns = array('left',	'left',	'right', 'right', 'right',	'right', 'right', 'right',
		'right', 'right', 'right',	'right', 'right', 'right');

    if ($dim == 2)
    {
    	$params =   array( 	0 => $comments,
                    	1 => array('text' => _("Year"),
                    		'from' => $year, 'to' => ''),
                    	2 => array('text' => _("Dimension")." 1",
                    		'from' => get_dimension_string($dimension), 'to' => ''),
                    	3 => array('text' => _("Dimension")." 2",
                    		'from' => get_dimension_string($dimension2), 'to' => ''),
                    	4 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''),	
                    	5 => array('text' => _('Info'), 'from' => _('Amounts in thousands'),
                    		'to' => ''));
    }
    elseif ($dim == 1)
    {
    	$params =   array( 	0 => $comments,
                    	1 => array('text' => _("Year"),
                    		'from' => $year, 'to' => ''),
                    	2 => array('text' => _('Dimension'),
                    		'from' => get_dimension_string($dimension), 'to' => ''),
                    	3 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''),	
                    	4 => array('text' => _('Info'), 'from' => _('Amounts in thousands'),
                    		'to' => ''));
    }
    else
    {
    	$params =   array( 	0 => $comments,
                    	1 => array('text' => _("Year"),
                    		'from' => $year, 'to' => ''),
                    	2 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''),	
                    	3 => array('text' => _('Info'), 'from' => _('Amounts in thousands'),
                    		'to' => ''));
    }

	$rep = new FrontReport(_('Annual Expense Breakdown'), "AnnualBreakDown", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	$sales = Array(0 => 0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	
	$classresult = get_account_classes(false, 0);
	while ($class = db_fetch($classresult))
	{
		$ctotal = Array(0 => 0,0,0,0,0,0,0,0,0,0,0,0,0,0);
		$convert = get_class_type_convert($class["ctype"]); 		
		
		//Print Class Name	
		$rep->Font('bold');
		$rep->TextCol(0, 5, $class["class_name"]);
		$rep->Font();
		$rep->NewLine();
		
		//Get Account groups/types under this group/type with no parents
		$typeresult = get_account_types(false, $class['cid'], -1);
		while ($accounttype=db_fetch($typeresult))
		{
			$classtotal = display_type($accounttype["id"], $accounttype["name"], $yr, $mo, $convert, $dec, $rep, $dimension, 
				$dimension2, $tags, $syr, $smo, $months_);
			for ($i = 0; $i <$months_; $i++)
				$ctotal[$i] += $classtotal[$i];
		}
		
		//Print Class Summary	
		$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->Font('bold');
		$rep->TextCol(0, 2,	_('Total') . " " . $class["class_name"]);
		$i = 0;
		$line_total = 0;
		for ($i = 0; $i <$months_; $i++)
		{
			$rep->AmountCol($i + 2, $i + 3, $ctotal[$i] * $convert, $dec);
			$sales[$i] += $ctotal[$i];

			if($class["ctype"] == '4')
				$total_income_array[$i] = $ctotal[$i] * $convert;
			if($class["ctype"] == '5')
				$total_cost_array[$i] = $ctotal[$i] * $convert;
			$line_total = $line_total + ($ctotal[$i] * $convert);
		}
		$rep->AmountCol($i + 2, $i + 3, $line_total, $dec);
		// display_error($class["ctype"]);
		if($class["ctype"] == '5'){
			$rep->NewLine(1.3);
			$rep->TextCol(0, 2,	_('Gross Profit'));
			$rep->TextCol(0, 2,	_('Gross Profit'));
			$i = 0;
			$line_total2 = 0;
			for ($i = 0; $i <$months_; $i++){
				$rep->AmountCol($i + 2, $i + 3, $total_income_array[$i] - $total_cost_array[$i] , $dec);
				$rep->AmountCol($i + 2, $i + 3, $total_income_array[$i] - $total_cost_array[$i] , $dec);
				// display_error($total_income_array[$i]."-".$total_cost_array[$i]);
				$gross_profit_array[$i] = $total_income_array[$i] - $total_cost_array[$i];
				$line_total2 = $line_total2 + ($total_income_array[$i] - $total_cost_array[$i]);
			}
			$rep->AmountCol($i + 2, $i + 3, $line_total2, $dec);
		}

		$rep->Font();
		$rep->NewLine(2);
	}
	$rep->Font('bold');	
	$rep->TextCol(0, 2,	_("Net Profit"));
	$rep->TextCol(0, 2,	_("Net Profit"));
	$i = 0;
	$line_total3 = 0;
	for ($i = 0; $i < $months_; $i++){
		$rep->AmountCol($i + 2, $i + 3, $sales[$i] * -1, $dec);
		$line_total3 = $line_total3 + ($sales[$i] * -1);
	}
	$rep->AmountCol($i + 2, $i + 3, $line_total3, $dec);
	$rep->Font();
	$rep->NewLine();
	$rep->Line($rep->row);
	$rep->NewLine();

	$rep->TextCol(0, 2,	_("Gross Profit Margin %"));
	$i = 0;
	$line_total4 = 0;
	for ($i = 0; $i < $months_; $i++){
		$rep->TextCol($i + 2, $i + 3, number_format2(($gross_profit_array[$i]/$total_income_array[$i])*100)."%", $dec);
		$line_total4 = $line_total4 + (($gross_profit_array[$i]/$total_income_array[$i])*100);
		// display_error($gross_profit_array[$i]."/".$total_income_array[$i]);
	}
	$rep->TextCol($i + 2, $i + 3, number_format2($line_total4)."%", $dec);
	$rep->NewLine(1.5);
	$rep->TextCol(0, 2,	_("Net Profit Margin %"));
	$i = 0;
	$line_total5 = 0;
	for ($i = 0; $i < $months_; $i++){
		$rep->TextCol($i + 2, $i + 3, number_format2(($sales[$i]*-1/$total_income_array[$i])*100)."%", $dec);
		$line_total5 = $line_total5 + (($sales[$i]*-1/$total_income_array[$i])*100);
	}
	$rep->TextCol($i + 2, $i + 3, number_format2($line_total5)."%", $dec);

    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }



	$rep->End();
}

