<?php

$page_security = 'SA_RETENTIONDASHBOARD';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/db/sales_order_db.inc");

//------------------------------------------------------------------------------
print_client_dashboard();

//---------------------------------------------------------------------------
//Helper Function

function total_amount($row){
    $sql = "SELECT SUM(total) as total_amount
    FROM ".TB_PREF."sales_orders WHERE trans_type=30 AND 
    debtor_no=".db_escape($row['debtor_no'])." AND 
    branch_code=".db_escape($row['branch_code'])." AND deleted=0";
    $amount = db_fetch(db_query($sql))['total_amount'];
    if(!$amount)
        $amount = '0';
    return number_format2($amount, user_price_dec());
}

function get_phone_no($row){
    $sql = "SELECT cp.phone FROM ".TB_PREF."crm_contacts AS cc 
    LEFT JOIN ".TB_PREF."crm_persons AS cp ON cp.id=cc.person_id  
    WHERE cc.type= 'cust_branch' 
    AND cc.entity_id = ".db_escape($row['branch_code'])." 
    ORDER BY cp.id DESC";
    $res = db_query($sql);
    //Iterate until a record is found
    while($row = db_fetch($res)){
        $phone = $row['phone'];
        if($phone)
            return $phone;
    }
    if(!$phone){
        $phone = 'N/A';
    }
    return $phone;
}

function get_email($row){
    $sql = "SELECT cp.email FROM ".TB_PREF."crm_contacts AS cc 
    LEFT JOIN ".TB_PREF."crm_persons AS cp ON cp.id=cc.person_id  
    WHERE cc.type= 'cust_branch' 
    AND cc.entity_id = ".db_escape($row['branch_code'])." 
    ORDER BY cp.id DESC";
    $res = db_query($sql);
    //Iterate until a record is found
    while($row = db_fetch($res)){
        $email = $row['email'];
        if($email)
            return $email;
    }
    if(!$email){
        $email = 'N/A';
    }
    return $email;
}

function last_order($row){
    $sql = "SELECT ord_date FROM ".TB_PREF."sales_orders 
    WHERE debtor_no=".db_escape($row['debtor_no'])." AND 
    branch_code=".db_escape($row['branch_code'])." ORDER BY ord_date 
    DESC LIMIT 1";
    $date = db_fetch(db_query($sql))['ord_date'];
    if(!$date)
        $date = 'N/A';
    else
        $date = sql2date($date);
    
    return $date;
}
//----------------------------------------------------------------------------

function print_client_dashboard(){
  
  global $path_to_root, $systypes_array;


  $destination = $_POST['PARAM_0'];
  $cust = $_POST['PARAM_1'];
  $branch = $_POST['PARAM_2'];
  $sales_type = $_POST['PARAM_3'];
  $sales_area = $_POST['PARAM_4'];
  $date = $_POST['PARAM_5'];
  $amount = $_POST['PARAM_6'];
  $stock_id = $_POST['PARAM_7'];
  $days_before = $_POST['PARAM_8'];

  if($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_report.inc");

  $def_orientation =  'L';
	 
 
  $cols = array(5, 25, 110, 200, 265, 360, 420, 480, 545);
  $headers = array(_('Sr. #'), _('Customer Name'), _('Branch Name'), 
  _('Mobile No'), _('Email Address'), _('Total Orders'), _('Last Order Date'), 
  _('Total Order Amt.'));

  $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left',
  'right');

  $params = array(0 => $comments);

  $rep = new FrontReport(_('Retention Management Dashboard'), "Retention Management Dashboard",
  user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
    recalculate_cols($cols);

  $rep->Font();
  $rep->Info($params, $cols, $headers, $aligns);
  $rep->NewPage();

  $sql = get_sql_for_retention_dashboard($cust, $branch, $sales_type, $sales_area, $date, $amount,
  $stock_id, $days_before);

  $result = db_query($sql);
  $newrow = array();
  $sr = 1;
  while($myrow = db_fetch($result)){
    $newrow =array();
    $c=0;

    $rep->TextCol($c++, $c, $sr++);
    if($destination){ 
      $rep->TextCol($c++, $c, get_customer_name($myrow['debtor_no']));
      $rep->TextCol($c++, $c, get_branch_name($myrow['branch_code']));
    }
    else{
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, get_customer_name($myrow['debtor_no']), -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
      
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, get_branch_name($myrow['branch_code']), -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
    }
    
    $rep->TextCol($c++, $c, $myrow['phone']);
    
    if($destination){ 
      $rep->TextCol($c++, $c, $myrow['email']);
    }
    else{
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, $myrow['email'], -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
    }

    $rep->TextCol($c++, $c, $myrow['ord_count']);
    $rep->DateCol($c++, $c, $myrow['order_date'], true);
    $rep->AmountCol($c++, $c, $myrow['value'], user_price_dec());
    
    if(!$destination){
      $rep->row = min($newrow);
      $newrow = array();
    }
    $rep->NewLine();
  }

  $rep->Line($rep->row  - 4);
  $rep->End();
}