<?php

$page_security = 'SA_CLIENTDASHBOARD';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/db/sales_order_db.inc");

//------------------------------------------------------------------------------
print_client_dashboard();

//---------------------------------------------------------------------------
//Helper Function
function customer_name($row){
    return get_customer_name($row['debtor_no']);
}

function branch_name($row){
    return get_branch_name($row['branch_code']);
}
//----------------------------------------------------------------------------

function print_client_dashboard(){
  
  global $path_to_root, $systypes_array;


  $destination = $_POST['PARAM_0'];
  $cust = $_POST['PARAM_1'];
  $branch = $_POST['PARAM_2'];
  $sales_type = $_POST['PARAM_2'];
  $fromdate = $_POST['PARAM_4'];
  $todate = $_POST['PARAM_5'];

  if($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_report.inc");

  $def_orientation =  'L';
	 
 
  $cols = array(5, 25, 110, 200, 265, 360, 420, 480, 545);
  $headers = array(_('Sr. #'), _('Customer Name'), _('Branch Name'), 
  _('Mobile No'), _('Email Address'), _('Total Orders'), _('Last Order Date'), 
  _('Total Order Amt.'));

  $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left',
  'right');

  $params = array(0 => $comments);

  $rep = new FrontReport(_('Client Management Dashboard'), "Client Management Dashboard",
  user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
    recalculate_cols($cols);

  $rep->Font();
  $rep->Info($params, $cols, $headers, $aligns);
  $rep->NewPage();

  $sql = get_sql_for_client_dashboard($cust, $branch, $sales_type, $fromdate, $todate);

  $result = db_query($sql);
  $newrow =array();
  $sr = 1;
  while($myrow = db_fetch($result)){
    $newrow =array();
    $c=0;

    $rep->TextCol($c++, $c, $sr++);
    if($destination){ 
      $rep->TextCol($c++, $c, get_customer_name($myrow['debtor_no']));
      $rep->TextCol($c++, $c, get_branch_name($myrow['branch_code']));
    }
    else{
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, get_customer_name($myrow['debtor_no']), -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
      
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, get_branch_name($myrow['branch_code']), -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
    }
    
    $rep->TextCol($c++, $c, $myrow['phone']);
    
    if($destination){ 
      $rep->TextCol($c++, $c, $myrow['email']);
    }
    else{
      $oldrow = $rep->row;
      $rep->TextColLines($c++, $c, $myrow['email'], -2);
      $newrow[] = $rep->row;
      $rep->row = $oldrow;
    }

    $rep->AmountCol($c++, $c, $myrow['ord_count'], 0);
    $rep->DateCol($c++, $c, $myrow['order_date'], true);
    $rep->AmountCol($c++, $c, $myrow['value'], user_price_dec());
    
    if(!$destination){
      $rep->row = min($newrow);
      $newrow = array();
    }
    $rep->NewLine();
  }

  $rep->Line($rep->row  - 4);
  $rep->End();
}