<?php

$page_security = 'SA_CUSTTRANSINQUIRIES';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/inventory/includes/db/make_db.inc");
include_once($path_to_root . "/inventory/includes/db/items_category_db.inc");
include_once($path_to_root . "/inventory/includes/db/system_db.inc");


// ============================================

  function get_itemstock_rep($stock_id=null, $show_inactive=null){

    $sql = "SELECT sm.*, p.price FROM ".TB_PREF."stock_master as sm
            LEFT JOIN ".TB_PREF."prices as p 
            ON sm.stock_id = p.stock_id 
            WHERE 1 ";
    if($stock_id)
        $sql .= " AND stock_id = ".db_escape($stock_id);
    if($show_inactive)
        $sql .= " AND inactive = 0 OR inactive = 1";
    else
        $sql .= " AND inactive = 0 ";
    return $sql;
 }
 // ====================================


function null_or_not($val=null){
    if($val)
        return $val;
    else 
        return 'N/A';

}
 

function get_tax_type_name($type_id)
{
    $sql = "SELECT name FROM ".TB_PREF."tax_types WHERE id=".db_escape($type_id);

    $result = db_query($sql, "could not get tax type rate");

    $row = db_fetch_row($result);
    return $row[0];
}

print_customer_balances();



function print_customer_balances(){
global $path_to_root, $systypes_array;

$trans_type = $_POST['PARAM_0'];
$stock_id = $_POST['PARAM_1'];
$show_inactive = $_POST['PARAM_2'];
$destination = $_POST['PARAM_3'];



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");
    $def_orientation='P';
    // $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




     $cols = array(0,30,80,200,280,320,420,480, 530);


 $headers = array(_('S.no'), _('Stock ID'),  _('Name'), _('Description'), _('Unit'), _('Category.'), _("Item Type"), _('Tax Type'));

    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to'=>$to)
                    );

    $rep = new FrontReport(_('Item Stock Report'), "Item Stock Report", user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();



$sql = get_itemstock_rep($stock_id, $show_inactive);

$result=db_query($sql);
$ser = 1;
global $stock_types;
    while ($myrow = db_fetch($result))
    {
        $c=0;
        $rep->TextCol($c, $c++,  $ser++);        

        if(!$destination){
                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c,  $myrow['stock_id'], -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, null_or_not($myrow['description']), -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;
                
                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, null_or_not($myrow['long_description']), -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, null_or_not($myrow['units']), -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, get_category_name($myrow['category_id']), -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $stock_types[$myrow['mb_flag']], -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow; 

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, get_tax_type_name($myrow['tax_type_id']), -2);
                $newrow[] = $rep->row;
                $rep->row = $oldrow;                

        }else{
            // $rep->TextCol($c, $c++,  get_make($myrow['item_make'])['description']);
            // $rep->TextCol($c, $c++,  get_system($myrow['system'])['description']);
            $rep->TextCol($c, $c++,  null_or_not($myrow['stock_id']));
            $rep->TextCol($c, $c++,  null_or_not($myrow['description']));
            $rep->TextCol($c, $c++,  null_or_not($myrow['long_description']));
            $rep->TextCol($c, $c++,  null_or_not($myrow['units']));
            $rep->TextCol($c, $c++,  get_category_name($myrow['category_id']));
            $rep->TextCol($c, $c++,  $stock_types[$myrow['mb_flag']]);
            $rep->TextCol($c, $c++,  get_tax_type_name($myrow['tax_type_id']));
        }


         


    if(!$destination){
          $rep->row = min($newrow);
          unset($newrow);
          $rep->NewLine(0.5);
    }else{
          $rep->NewLine();
    }
      if($rep->row < 35 && !$destination)
            $rep->NewPage();

     }   
//--------------------------------------------------------------------------------------------------------


    $rep->Line($rep->row  - 4);
        $rep->End();
}