<?php

$page_security = 'SA_REALESTATEINQUIRY';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/CRM/includes/db/crm_real_estate_db.inc");


//-------------------------------------------------------------------------------------------------
function get_header(){
    $user_id = $_SESSION['wa_current_user']->user;
    $sql = "SELECT header_name FROM ".TB_PREF."buyer_header 
    WHERE user_id=".db_escape($user_id)." ORDER BY header_id";
    return db_query($sql);
}


//---------------------------------------------------------------------------------------------------
print_buyer_inquiry();
//----------------------------------------------------------------------------------------------------

function print_buyer_inquiry(){


    global $path_to_root, $systypes_array, $availability_type, $payment_pref, $property_type, $looking_for;

    $destination = $_POST['PARAM_0'];
    $full_name = $_POST['PARAM_1'];
    $email = $_POST['PARAM_2'];
    $looking_for_var = $_POST['PARAM_3'];
    $availability_type = $_POST['PARAM_4'];
    $payment_pref = $_POST['PARAM_5'];
    $community_pref = $_POST['PARAM_6'];
    $phase_pref = $_POST['PARAM_7'];
    $no_of_br = $_POST['PARAM_8'];
    $single_row = $_POST['PARAM_9'];
    $bank = $_POST['PARAM_10'];
    $specific_req = $_POST['PARAM_11'];
    $days = $_POST['PARAM_12'];
    $budget = $_POST['PARAM_13'];
    $phone = $_POST['PARAM_14'];
    $def_orientation = 1;

    if($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
   

    $cols = array(5, 15, 85, 145, 200);
    $headers = array(_("ID"), _("Full Name"), _("Email"), _("Phone"));
    $aligns = array('left', 'left', 'left', 'left');

    $header = get_header();

while($row = db_fetch($header)){
    
    if($row['header_name'] == 'Looking For'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Looking For");

    }
    if($row['header_name'] == 'Property Type'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Property Type");
    }
    if($row['header_name'] == 'Community Preference'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Community Preference");
    }
    if($row['header_name'] == 'Phase Preference'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Phase Preference");
    }
    if($row['header_name'] == 'No of BR'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("No of BR");
    }
    if($row['header_name'] == 'Bk or bk or Single Row'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Bk or bk or Single Row");
    }
    if($row['header_name'] == 'Availability Type'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Availability Type");
    }
    if($row['header_name'] == 'Payment Preference'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Payment Preference");
    }
    if($row['header_name'] == 'Bank'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Bank");
    }
    if($row['header_name'] == 'Other specific requirement'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Other specific requirement");
    }
    if($row['header_name'] == 'Required (In Days)'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Required (In Days)");
    }
    if($row['header_name'] == 'Budget'){
        $cols[] = max($cols) + 60;
        $aligns[] = "left";
        $headers[] = _("Budget");
    }
}

    $params = array(0 => $comments);

    $rep = new FrontReport(_('Buyer Inquiry'), "BuyerInquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
        recalculate_cols($cols);
    
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
    
    $sql = get_sql_for_real_estate_buyer($full_name, $email, $looking_for_var, $availability_type, $payment_pref, $community_pref, $phase_pref, 
    $no_of_br, $single_row, $bank, $specific_req, $days, $budget, $phone);

    $result = db_query($sql);

    while($myrow = db_fetch($result)){
        $c=0;
        $rep->TextCol($c, $c++, $myrow['id']);
        $rep->TextCol($c, $c++, $myrow['full_name']);
        $rep->TextCol($c, $c++, $myrow['email']);
        $rep->TextCol($c, $c++, $myrow['phone']);

        $header = get_header();

        while($row = db_fetch($header)){
            if($row['header_name'] == 'Looking For'){
                $rep->TextCol($c, $c++, $looking_for[$myrow['looking_for']]);
            }
            if($row['header_name'] == 'Property Type'){
                $rep->TextCol($c, $c++, $property_type[$myrow['property_type']]);
            }
            if($row['header_name'] == 'Community Preference'){
                $rep->TextCol($c, $c++, $myrow['community_pref']);
            }
            if($row['header_name'] == 'Phase Preference'){
                $rep->TextCol($c, $c++, $myrow['phase_pref']);
            }
            if($row['header_name'] == 'No of BR'){
                $rep->AmountCol($c, $c++, $myrow['no_of_br'], 0);
            }
            if($row['header_name'] == 'Bk or bk or Single Row'){
                $rep->TextCol($c, $c++, $myrow['single_row']);
            }
            if($row['header_name'] == 'Availability Type'){
                $rep->TextCol($c, $c++, $availability_type[$myrow['availability_type']]);
            }
            if($row['header_name'] == 'Payment Preference'){
                $rep->TextCol($c, $c++, $payment_pref[$myrow['payment_pref']]);
            }
            if($row['header_name'] == 'Bank'){
                $rep->TextCol($c, $c++, $myrow['bank']);
            }
            if($row['header_name'] == 'Other specific requirement'){
                $rep->TextCol($c, $c++, $myrow['specific_req']);
            }
            if($row['header_name'] == 'Required (In Days)'){
                $rep->AmountCol($c, $c++, $myrow['days'], 0);
            }
            if($row['header_name'] == 'Budget'){
                $rep->AmountCol($c, $c++, $myrow['budget'], user_price_dec());
            }
        }

        $rep->NewLine();
    }


    $rep->Line($rep->row  - 4);
    $rep->End();
}