<?php

$page_security = 'SA_REALESTATEINQUIRY';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/CRM/includes/db/crm_real_estate_db.inc");


//-------------------------------------------------------------------------------------------------
function get_header(){
    $user_id = $_SESSION['wa_current_user']->user;
    $sql = "SELECT header_name FROM ".TB_PREF."seller_header 
    WHERE user_id=".db_escape($user_id)." ORDER BY header_id";

    return db_query($sql);
}

//---------------------------------------------------------------------------------------------------
print_seller_inquiry();
//----------------------------------------------------------------------------------------------------

function print_seller_inquiry(){


    global $path_to_root, $systypes_array, $availability_type, $payment_pref, $property_type, $looking_for, $financial_status;

    $destination = $_POST['PARAM_0'];
    $full_name = $_POST['PARAM_1'];
    $email = $_POST['PARAM_2'];
    $offer_type = $_POST['PARAM_3'];
    $property_category = $_POST['PARAM_4'];
    $availability_status = $_POST['PARAM_5'];
    $br = $_POST['PARAM_6'];
    $community = $_POST['PARAM_7'];
    $phase = $_POST['PARAM_8'];
    $location_detail = $_POST['PARAM_9'];
    $bua = $_POST['PARAM_10'];
    $plot = $_POST['PARAM_11'];
    $vaastu_compliant = $_POST['PARAM_12'];
    $financial_status = $_POST['PARAM_13'];
    $mortgage_amount = $_POST['PARAM_14'];
    $view = $_POST['PARAM_15'];
    $rent_amount = $_POST['PARAM_16'];
    $expiry_date_from = $_POST['PARAM_17'];
    $expiry_date_to = $_POST['PARAM_18'];
    $phone = $_POST['PARAM_19'];
    $def_orientation = 1;

    if($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
   

    $cols = array(5, 15, 85, 145, 200);
    $headers = array(_("ID"), _("Full Name"), _("Email"), _("Phone"));
    $aligns = array('left', 'left', 'left', 'left');

    $header = get_header();

    while($row = db_fetch($header)){
        
        if($row['header_name'] == 'Offer Type'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Offer Type");

        }
        if($row['header_name'] == 'Property Category'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Property Category");
        }
        if($row['header_name'] == '# BR'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("# BR");
        }
        if($row['header_name'] == 'Community'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Community");
        }
        if($row['header_name'] == 'Phase'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Phase");
        }
        if($row['header_name'] == 'Location Details'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Location Details");
        }
        if($row['header_name'] == 'BUA'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("BUA");
        }
        if($row['header_name'] == 'Plot'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Plot");
        }
        if($row['header_name'] == 'View'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("View");
        }
        if($row['header_name'] == 'Availability Status'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Availability Status");
        }
        if($row['header_name'] == 'Rent Amount'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Rent Amount");
        }
        if($row['header_name'] == 'Expiry Date'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Expiry Date");
        }
        if($row['header_name'] == 'Vaastu Compliant'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Vaastu Compliant");
        }
        if($row['header_name'] == 'Financial Status'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Financial Status");
        }
        if($row['header_name'] == 'Mortgage Amount'){
            $cols[] = max($cols) + 60;
            $aligns[] = "left";
            $headers[] = _("Mortgage Amount");
        }
    }

    $params = array(0 => $comments);

    $rep = new FrontReport(_('Seller Inquiry'), "SellerInquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
        recalculate_cols($cols);
    
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
    
    $sql = get_sql_for_real_estate_seller($full_name, $email, $offer_type, $property_category, $availability_status, 
    $br, $community, $phase, $location_detail, $bua, $plot, $vaastu_compliant, $financial_status, $mortgage_amount,
    $view, $rent_amount, $expiry_date_from, $expiry_date_to, $phone);

    $result = db_query($sql);

    while($myrow = db_fetch($result)){
        $c=0;
        $rep->TextCol($c, $c++, $myrow['id']);
        $rep->TextCol($c, $c++, $myrow['full_name']);
        $rep->TextCol($c, $c++, $myrow['email']);
        $rep->TextCol($c, $c++, $myrow['phone']);

        $header = get_header();

        while($row = db_fetch($header)){
        
            if($row['header_name'] == 'Offer Type'){
                $rep->TextCol($c, $c++, $offer_type[$myrow['offer_type']]);
            }
            if($row['header_name'] == 'Property Category'){
                $rep->TextCol($c, $c++, $property_type[$myrow['property_category']]);
            }
            if($row['header_name'] == '# BR'){
               $rep->AmountCol($c, $c++, $myrow['br'], 0);

            }
            if($row['header_name'] == 'Community'){
                $rep->TextCol($c, $c++, $myrow['community']);
            }
            if($row['header_name'] == 'Phase'){
                $rep->TextCol($c, $c++, $myrow['phase']);
            }
            if($row['header_name'] == 'Location Details'){
                $rep->TextCol($c, $c++, $myrow['location_detail']);
            }
            if($row['header_name'] == 'BUA'){
                $rep->TextCol($c, $c++, $myrow['bua']);
            }
            if($row['header_name'] == 'Plot'){
                $rep->TextCol($c, $c++, $myrow['plot']);
            }
            if($row['header_name'] == 'View'){
                $rep->TextCol($c, $c++, $myrow['view']);
            }
            if($row['header_name'] == 'Availability Status'){
                $rep->TextCol($c, $c++, $availability_type[$myrow['availability_status']]);
            }
            if($row['header_name'] == 'Rent Amount'){
                $rep->AmountCol($c, $c++, $myrow['rent_amount'], user_price_dec());
            }
            if($row['header_name'] == 'Expiry Date'){
                $rep->DateCol($c, $c++, $myrow['expiry_date'], true);
            }
            if($row['header_name'] == 'Vaastu Compliant'){
                $rep->TextCol($c, $c++, $myrow['vaastu_compliant']);
            }
            if($row['header_name'] == 'Financial Status'){
                $rep->TextCol($c, $c++, $financial_status[$myrow['financial_status']]);
            }
            if($row['header_name'] == 'Mortgage Amount'){
                $rep->AmountCol($c, $c++, $myrow['mortgage_amount'], user_price_dec());
            }
        }

        $rep->NewLine();
    }


    $rep->Line($rep->row  - 4);
    $rep->End();
}