<?php

$page_security = 'SA_GLANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();

function getTransactionsAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)."";
            //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getCreditNoteAmount($from,$to,$dim1));
      return ( $row[0]-getCreditNoteAmount($from,$to,$dim1) ); 
    

}

function getTransactionsVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.trans_no=ttd.trans_no AND ttd.trans_type = 10 AND ttd.net_amount != 0 AND ttd.tax_type_id = 1 WHERE dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

    //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-getCreditNoteVat($from,$to,$dim1) ); 
}

function getCreditNoteAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE ttd.tax_type_id='1' AND dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";
           //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getInclusiveVAt($from,$to,$dim1));
     // return ( $row[0]-getInclusiveVAt($from,$to,$dim1) ); 
     return  $row[0] ; 

}


function getCreditNoteVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON  dt.trans_no=ttd.trans_no AND ttd.trans_type = 11 AND ttd.net_amount != 0 AND ttd.tax_type_id = 1 WHERE dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

   //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}


function getZeroRated($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2' ";
            
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}

function getZeroRatedSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2'";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ($row[0]-getZeroRatedCraditNoteSupplies($from, $to)); 
}
function getZeroRatedCraditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2'";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row['tot_amount']; 
}
/*function getZeroRatedSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql = "SELECT 
SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
FROM ".TB_PREF."debtor_trans AS dt 
LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
WHERE dt.type = '10' 
AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
AND sm.tax_type_id = 3";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ($row['tot_amount']-getZeroRatedCraditNoteSupplies($from, $to)); 
}*/

/*function getZeroRatedCraditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT 
SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
FROM ".TB_PREF."debtor_trans AS dt 
LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
WHERE dt.type = '11' 
AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
AND sm.tax_type_id = 3";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row['tot_amount']; 
}*/

// function ExemptSupplies($from, $to)
// {
//     $fromdate = date2sql($from);
//     $todate = date2sql($to);

//   /* $sql .= "SELECT SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount FROM ".TB_PREF."debtor_trans_details AS dtd LEFT JOIN ".TB_PREF."stock_master AS sm ON  sm.stock_id = dtd.stock_id WHERE dtd.debtor_trans_type = 10 AND sm.tax_type_id = 2";*/
//         $sql = "SELECT 
//         SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
//         FROM ".TB_PREF."debtor_trans AS dt 
//         LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
//         LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
//         WHERE dt.type = '10' 
//         AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
//         AND sm.tax_type_id = 2";
    
//             display_error($sql);
//      $result=db_query($sql);
//      $row=db_fetch($result);
//      return ( $row[0]-ExemptCreditNoteSupplies($from, $to) ) ; 
// }

// function ExemptCreditNoteSupplies($from, $to)
// {
//     $fromdate = date2sql($from);
//     $todate = date2sql($to);

//     $sql .= "SELECT 
//         SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
//         FROM ".TB_PREF."debtor_trans AS dt 
//         LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
//         LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
//         WHERE dt.type = '11' 
//         AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
//         AND sm.tax_type_id = 2";
//             // display_error($sql);
//      $result=db_query($sql);
//      $row=db_fetch($result);
//      return $row[0]; 
// }

function ExemptSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(net_amount*ex_rate) AS tot_amount FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND tax_type_id='0' ";
    $sql = "SELECT 
SUM(ttd.net_amount*ttd.ex_rate) AS tot_amount 
FROM 0_trans_tax_details AS ttd 
LEFT JOIN 0_debtor_trans AS dt ON dt.trans_no = ttd.trans_no AND dt.type = ttd.trans_type
LEFT JOIN 0_cust_branch AS cb ON cb.branch_code = dt.branch_code
WHERE ttd.trans_type='10' 
AND ttd.tran_date >= '$fromdate' AND ttd.tran_date <= '$todate' 
AND ttd.tax_type_id='0'
AND cb.cust_gcc = 0";
    
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-ExemptCreditNoteSupplies($from, $to) ) ; 
}

function ExemptCreditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

   /* $sql .= "SELECT SUM(net_amount*ex_rate) AS tot_amount FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='0' ";*/
            
    $sql = "SELECT 
SUM(ttd.net_amount*ttd.ex_rate) AS tot_amount 
FROM 0_trans_tax_details AS ttd 
LEFT JOIN 0_debtor_trans AS dt ON dt.trans_no = ttd.trans_no AND dt.type = ttd.trans_type
LEFT JOIN 0_cust_branch AS cb ON cb.branch_code = dt.branch_code
WHERE ttd.trans_type='11' 
AND ttd.tran_date >= '$fromdate' AND ttd.tran_date <= '$todate' 
AND ttd.tax_type_id='0'
AND cb.cust_gcc = 0";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}

function CustGCCSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(net_amount*ex_rate) AS tot_amount FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND tax_type_id='0' ";
    $sql = "SELECT 
SUM(ttd.net_amount*ttd.ex_rate) AS tot_amount 
FROM 0_trans_tax_details AS ttd 
LEFT JOIN 0_debtor_trans AS dt ON dt.trans_no = ttd.trans_no AND dt.type = ttd.trans_type
LEFT JOIN 0_cust_branch AS cb ON cb.branch_code = dt.branch_code
WHERE ttd.trans_type='10' 
AND ttd.tran_date >= '$fromdate' AND ttd.tran_date <= '$todate' 
AND ttd.tax_type_id='0'
AND cb.cust_gcc = 1";
    
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-CustGCCCreditNoteSupplies($from, $to) ) ; 
}

function CustGCCCreditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

   /* $sql .= "SELECT SUM(net_amount*ex_rate) AS tot_amount FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='0' ";*/
            
    $sql = "SELECT 
SUM(ttd.net_amount*ttd.ex_rate) AS tot_amount 
FROM 0_trans_tax_details AS ttd 
LEFT JOIN 0_debtor_trans AS dt ON dt.trans_no = ttd.trans_no AND dt.type = ttd.trans_type
LEFT JOIN 0_cust_branch AS cb ON cb.branch_code = dt.branch_code
WHERE ttd.trans_type='11' 
AND ttd.tran_date >= '$fromdate' AND ttd.tran_date <= '$todate' 
AND ttd.tax_type_id='0'
AND cb.cust_gcc = 1";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}






function SuppAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND( SUM((((ov_amount-ov_discount)*st.rate)*ttd.rate)/100) ,2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import_amount=0 AND   st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function SuppCreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*st.rate ) ) ,2) as amount , ROUND( ABS(SUM((((ov_amount-ov_discount)*st.rate)*ttd.rate)/100)) ,2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}
function get_import_supp_invoices($from, $to){
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = "SELECT sum(ov_amount) as payable, sum(ov_gst) as tax_amount  FROM ".TB_PREF."supp_trans WHERE type = 20 AND import = 1 AND tran_date >= '".$from."' AND tran_date <= '".$to."' AND ov_gst != 0";
    // display_error($sql);
    $run = db_query($sql);
    return db_fetch($run);

}

function get_import_amount_supp_inv($from, $to){
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = "SELECT SUM(import_amount) as import_amount ,SUM(import_amount*(SELECT rate FROM ".TB_PREF."tax_types WHERE id = 1)/100) AS import_tax FROM ".TB_PREF."supp_trans WHERE type = 20 AND import = 1 AND ov_amount != 0 AND tran_date >= '".$from."' AND tran_date <= '".$to."'";
    // $sql = "SELECT SUM(st.import_amount) AS import_amount ,SUM(st.import_amount*(SELECT rate FROM ".TB_PREF."tax_types WHERE id = (SELECT tax_group_id FROM ".TB_PREF."suppliers WHERE supplier_id = st.supplier_id))/100) AS import_tax FROM ".TB_PREF."supp_trans AS st WHERE st.type = 20 AND st.import = 1 AND st.tran_date >= '".$from."' AND st.tran_date <= '".$to."'";
    // display_error($sql);exit;
    $run = db_query($sql);
    return db_fetch($run);

}

function Supp_Imported_AmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND(SUM(ov_gst*st.rate),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
         //    display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function Supp_Imported_CreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*ex_rate ) ) ,2) as amount , ROUND( ABS (SUM(ov_gst*st.rate) ),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'  AND st.import=1 AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function Supp_Import_Amount_own_useable($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(SUM((import_amount)*st.rate),2) as import_amt  FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'AND st.import_amount!=0 AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function tourist_amount_vat($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( SUM((dt.ov_amount-dt.ov_discount)*dt.rate ) ,2) as amount , ROUND(SUM(dt.ov_gst*dt.rate),2) as vat FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."cust_allocations ca on dt.trans_no=ca.trans_no_to AND dt.type=ca.trans_type_to WHERE dt.type='10' AND ca.trans_type_from='1'  AND  dt.tran_date >= '$fromdate'  AND dt.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

  function get_excise_tax_data($from,$to,$type_id,$dimension){
        $from = date2sql($from);
        $to = date2sql($to);
        $sql = "SELECT 
SUM(dtd.net_amount) AS amount , SUM(dtd.amount) AS tax 
FROM 0_trans_tax_details AS dtd LEFT JOIN 0_gl_trans AS gl ON dtd.trans_type = gl.type AND dtd.trans_no = gl.type_no 
WHERE dtd.tax_type_id = '1' AND dtd.tran_date >= '$from' AND dtd.tran_date <= '$to' AND dtd.excise_tax_type = '$type_id' AND gl.account = '2150'";
    if($dimension != null && $dimension != 0){
          $sql .= "AND gl.dimension_id = '$dimension'";  
    }
       // display_error($sql);
        $run = db_query($sql);
        return db_fetch($run);
    }
    
    function get_excise_tax_total_data($from,$to){
        $from = date2sql($from);
        $to = date2sql($to);
        $sql = "SELECT 
SUM(dtd.net_amount) AS amount , SUM(dtd.amount) AS tax 
FROM 0_trans_tax_details AS dtd LEFT JOIN 0_gl_trans AS gl ON dtd.trans_type = gl.type AND dtd.trans_no = gl.type_no 
WHERE dtd.tax_type_id = '1' AND dtd.tran_date >= '$from' AND dtd.tran_date <= '$to' AND dtd.excise_tax_type = '1' AND gl.account = '2150' AND gl.dimension_id IN ('1','2','3','4','5','6','7')";
// display_error($sql);
        $run = db_query($sql);
        return db_fetch($run);
    }


//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $orientation = $_POST['PARAM_2'];
    $destination = $_POST['PARAM_3'];
  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_vat_return_report.inc");

  $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 60, 120, 180, 240, 340, 400, 460, 520);

    $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
      _('Type'), _('#'), _('Action'), _('Amount'));

    $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'right');

  $usr = get_user($user);
  $user_id = $usr['user_id'];
    $params =   array(  0 => $comments,
                1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
                      2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
                      3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));
    
    $rep = new FrontReport(_('VAT201 - VAT Returns'), "AuditTrail", user_pagesize(), 8, $orientation);
    
    if ($orientation == 'L')
      recalculate_cols($cols);

    $rep->Font();

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);
    $rep->NewPage();

    
    //$trans = getTransactions($from, $to, $systype, $user);
    $companyCol = $rep->endLine - 150;
    $titleCol = $rep->leftMargin + 130;
    $col1 = $rep->leftMargin + 280;
    $col2 = $rep->leftMargin + 410;
    $col4 = $rep->leftMargin + 440;
    $amount_col=160;
    $rep->row=$rep->row+10;
    $rep->leftMargin=$rep->leftMargin-10;

    $rep->row += 10;
    $rep->fontSize += 4;
    if ($rep->l['a_meta_dir'] == 'rtl'){
        $rep->SetFont('dejavusans', '', '', '', true);
        $rep->Text($rep->leftMargin+200,  _("Value Added Tax Return"), $companyCol);
        $rep->Text($rep->leftMargin+200,  _("Value Added Tax Return"), $companyCol);
    }else{
        $rep->SetFont('helvetica', 'B', '', '', true);
        $rep->Text($rep->leftMargin+200,  _("Value Added Tax Return"), $companyCol);
        $rep->SetFont('helvetica', '', '', '', true);
        $rep->SetFont('helvetica', 'B', '', '', true);
    
    $rep->Text($rep->leftMargin+200,  _("Value Added Tax Return"), $companyCol);
    $rep->SetFont('helvetica', '', '', '', true);
    }
    
    $rep->fontSize -= 4;
    $rep->row -= 10;
    $rep->SetFont('dejavusans', '', '', '', true);
   
    //-----------------------work start for main heading table zubair--------------------------------
/*     $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 70, 555, 30,0, '0000','DF',null,array(242, 242, 242));

     $rep->RoundedRect(30, 100, 555, 100,0, '0000','DF',null,array(255, 255, 255));
     // $rep->SetFont('helvetica', 'B', '', '', true);
     // $rep->Text($rep->leftMargin+15, _("Taxable Person Detail "), $companyCol,0,20);
     // $rep->SetFont('helvetica', '', '', '', true);
    $rep->fontSize += 3;
    $rep->Text($rep->leftMargin+15, _("Main"), $companyCol,0,20);
    $rep->fontSize -= 3;

    $rep->Text($rep->leftMargin+20, _("Form Type"), $companyCol,0,50);
    $rep->RoundedRect(50, 125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
     // $rep->Text($rep->leftMargin+30,$rep->company['gst_no'], $companyCol,0,70);
//       
    $rep->Text($rep->leftMargin+20, _("Document Locator"), $companyCol,0,90);
    $rep->RoundedRect(50, 165, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
    // $rep->Text($rep->leftMargin+30,$rep->company['coy_name'] , $companyCol,0,120);

     $rep->Text($rep->leftMargin+295, _("Tax Form Filing Type"), $companyCol,0,50);
        $rep->RoundedRect(325, 125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));

    $rep->Text($rep->leftMargin+295, _("Submission Date"), $companyCol,0,90);
        $rep->RoundedRect(325, 165, 250,20,2.25, '1111','DF',null,array(242, 242, 242));*/
    //-----------------------work End for main heading table zubair--------------------------------
 $rep->row += 130;
$box_alignment = -130;

    //-----------------------work start for Taxable Person Detail heading table zubair--------------------------------
         $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 210+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 240+$box_alignment, 555, 220,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Taxable Person Detail"), $companyCol,0,160);
        $rep->fontSize -= 3;
        $rep->Text($rep->leftMargin+20, _("TRN"), $companyCol,0,190);
        $rep->RoundedRect(50, 265+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->company['gst_no'], $companyCol,0,210);
  // //       
        $rep->Text($rep->leftMargin+20, _("Taxable Person Name(English)"), $companyCol,0,230);
        $rep->RoundedRect(50, 305+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->company['coy_name'] , $companyCol,0,250);

        $rep->Text($rep->leftMargin+20, _("Taxable Person Name(Arabic)"), $companyCol+40,0,270);
        $rep->RoundedRect(50, 345+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Font('');
        $rep->Text($rep->leftMargin+30   ,$_SESSION['SysPrefs']->prefs['arabic_coy_name'],$companyCol+140,0,290);
        // $rep->TextWrap(310, 655, 250,$_SESSION['SysPrefs']->prefs['arabic_coy_name'], 'right'); 

        $rep->Text($rep->leftMargin+20, _("Taxable Person Address"), $companyCol,0,310);
        $rep->RoundedRect(50, 385+$box_alignment, 250,60,2.25, '1111','DF',null,array(242, 242, 242));
        $old_row=$rep->row;
        $rep->row=570;
        $rep->TextWrapLines($rep->leftMargin+30,500,$rep->company['postal_address']);
        // $rep->Text($rep->leftMargin+20,$rep->company['postal_address'], $companyCol,0,310);
        $rep->row=$old_row;

        $rep->Text($rep->leftMargin+295, _("Tax Agency Name"), $companyCol,0,190);
        $rep->RoundedRect(325, 265+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305,$rep->company['tax_agency_name'], $companyCol,0,210);
  // //       
        $rep->Text($rep->leftMargin+295, _("TAN"), $companyCol,0,230);
        $rep->RoundedRect(325, 305+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305,$rep->company['tan'] , $companyCol,0,250);

        $rep->Text($rep->leftMargin+295, _("Tax Agent Name"), $companyCol+40,0,270);
        $rep->RoundedRect(325, 345+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305   ,$rep->company['tax_agent_name'],$companyCol+140,0,290);

         $rep->Text($rep->leftMargin+295, _("TAAN"), $companyCol+40,0,310);
        $rep->RoundedRect(325, 385+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305   ,$rep->company['taan'],$companyCol+140,0,330);


    //-----------------------work end for Taxable Person Detail heading table zubair--------------------------------

    //-----------------------work start for VAT Return Period heading table zubair--------------------------------

     
          $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 470+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 500+$box_alignment, 555, 100,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT Return Period"), $companyCol,0,420);
        $rep->fontSize -= 3;

        $rep->Text($rep->leftMargin+20, _("VAT Return Period"), $companyCol+40,0,450);
        $rep->RoundedRect(50, 525+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30   ,date('d-m-Y',strtotime(date2sql($rep->from))) ." - ".date('d-m-Y',strtotime(date2sql($rep->to))),$companyCol+140,0,470);

        $rep->Text($rep->leftMargin+20, _("Tax Year"), $companyCol+40,0,490);
        $rep->RoundedRect(50, 565+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30   ,date('Y'),$companyCol+140,0,510);

        $ref_date=strtotime($rep->from);
        $end_date=strtotime(date2sql($rep->to));
        $rep->Text($rep->leftMargin+295, _("VAT Return Period Reference Number"), $companyCol+40,0,450);
        $rep->RoundedRect(325, 525+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305   ,date('d',$ref_date)."-".date('Y',$end_date),$companyCol+140,0,470);

     //-----------------------work send for VAT Return Period heading table zubair--------------------------------


$text_box_alignment = 130;
if ($rep->l['a_meta_dir'] == 'rtl')
    $amt_align = 40;
    //---------------------First section start------------------------

        $rep->RoundedRect(30, 610+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 640+$box_alignment, 555, 250,0, '0000','DF',null,array(255, 255, 255));
      
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT on Sales and ALL Other Outputs"), $companyCol,0,560);
        $rep->fontSize -= 3;
          

    $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));


          $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,590);
          $rep->Text($rep->leftMargin+350, _("VAT Amount(AED)"), $companyCol+40,0,590);
           $rep->Text($rep->leftMargin+460,_("Adjustment(AED)"), $companyCol,0,590);
              
$rep->Text($rep->leftMargin+15, _("1a Standard rated supplies in Abu Dhabi"), $companyCol,0,610);
    $rep->RoundedRect(280, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));

          //$rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,1),2), $companyCol,0,465);
          
               $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment, 100,number_format(getTransactionsAmount($from, $to,1),2) , 'right'); 
              
    $rep->RoundedRect(380, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
              $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment, 100,number_format(getTransactionsVat($from, $to,1),2), 'right');
           //$rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,1),2), $companyCol+20,0,465);
    $rep->RoundedRect(480, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
   
        $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment, 100,number_format(get_excise_tax_data($from,$to,1,1)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 670+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,615);
                $rep->fontSize -= 4;

$rep->Text($rep->leftMargin+15, _("1b Standard rated supplies in Dubai"), $companyCol,0,640);
    $rep->RoundedRect(280, 700+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
         // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,2),2), $companyCol,0,500);
          $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-32, 100,number_format(getTransactionsAmount($from, $to,2),2), 'right');
    $rep->RoundedRect(380, 700+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
          $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-32, 100,number_format(getTransactionsVat($from, $to,2),2), 'right');
         // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,2),2), $companyCol+20,0,500);



    $rep->RoundedRect(480, 700+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 700+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
        $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-32, 100,number_format(get_excise_tax_data($from,$to,1,2)['tax'],2) , 'right'); 
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,645);
                $rep->fontSize -= 4;   

$rep->Text($rep->leftMargin+15, _("1c Standard rated supplies in Sharjah"), $companyCol,0,670);
    $rep->RoundedRect(280, 730+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));

          // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,3),2), $companyCol,0,535);

            $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-63, 100,number_format(getTransactionsAmount($from, $to,3),2), 'right');
    $rep->RoundedRect(380, 730+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-63, 100,number_format(getTransactionsVat($from, $to,3),2), 'right');
        //   $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,3),2), $companyCol+20,0,535);
    $rep->RoundedRect(480, 730+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
     $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-63, 100,number_format(get_excise_tax_data($from,$to,1,3)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 730+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,675);
                $rep->fontSize -= 4;  

$rep->Text($rep->leftMargin+15, _("1d Standard rated supplies in Ajman"), $companyCol,0,700);
    $rep->RoundedRect(280, 760+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
              // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,4),2), $companyCol,0,570);
            $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-93, 100,number_format(getTransactionsAmount($from, $to,4),2), 'right');


   $rep->RoundedRect(380, 760+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-93, 100,number_format(getTransactionsVat($from, $to,4),2), 'right');
              //$rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,4),2), $companyCol+20,0,570);
    $rep->RoundedRect(480, 760+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
     $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-93, 100,number_format(get_excise_tax_data($from,$to,1,4)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 760+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,705);
                $rep->fontSize -= 4;  

    $rep->Text($rep->leftMargin+15, _("1e Standard rated supplies in Umm Al Quwain"), $companyCol,0,730);
    $rep->RoundedRect(280, 790+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
              //   $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,5),2), $companyCol,0,605);
        $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-123, 100,number_format(getTransactionsAmount($from, $to,5),2), 'right');
   $rep->RoundedRect(380, 790+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
         $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-123, 100,number_format(getTransactionsVat($from, $to,5),2), 'right');
               // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,5),2), $companyCol+20,0,605);
    $rep->RoundedRect(480, 790+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
     $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-123, 100,number_format(get_excise_tax_data($from,$to,1,5)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 790+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,730);
                $rep->fontSize -= 4;  

$rep->Text($rep->leftMargin+15, _("1f Standard rated supplies in Ras Al Khaimah"), $companyCol,0,760);
    $rep->RoundedRect(280, 820+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
              //  $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,6),2), $companyCol,0,640);
          $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-153, 100,number_format(getTransactionsAmount($from, $to,6),2), 'right');
    $rep->RoundedRect(380, 820+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
           $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-153, 100,number_format(getTransactionsVat($from, $to,6),2), 'right');
             // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,6),2), $companyCol+20,0,640);
    $rep->RoundedRect(480, 820+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
     $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-153, 100,number_format(get_excise_tax_data($from,$to,1,6)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 820+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,760);
                $rep->fontSize -= 4;  


$rep->Text($rep->leftMargin+15, _("1g Standard rated supplies in Fujairah"), $companyCol,0,790);
    $rep->RoundedRect(280,850+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
            // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,7),2), $companyCol,0,675);
              $rep->TextWrap($amt_align+260, $amount_col+$text_box_alignment-183, 100,number_format(getTransactionsAmount($from, $to,7),2), 'right');
    $rep->RoundedRect(380, 850+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
               $rep->TextWrap($amt_align+360, $amount_col+$text_box_alignment-183, 100,number_format(getTransactionsVat($from, $to,7),2), 'right');
            // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,7),2), $companyCol+20,0,675);
    $rep->RoundedRect(480, 850+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
     $rep->TextWrap($amt_align+460, $amount_col+$text_box_alignment-183, 100,number_format(get_excise_tax_data($from,$to,1,7)['tax'],2) , 'right'); 
        $rep->RoundedRect(480, 850+$box_alignment, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,790);
                $rep->fontSize -= 4;  
//---------------------------------------2nd Page start--------------------------------

    $rep->NewPage();
 $rep->row=$rep->row+600;
        $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));
        $rep->RoundedRect(30, 23, 555, 235,0, '0000','DF',null,array(255, 255, 255));

    $rep->row=$rep->row+240;
    $box_align_2 = -90;
//         $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));
//         $rep->RoundedRect(30, 23, 555, 280,0, '0000','DF',null,array(255, 255, 255));

// // 2 Tax Refunds provide to Tourists Under the Tax Refunds
// //  
// //
// // 

// // 

// // 

// // 
// // 8 Totals

/*
  $rep->Text($rep->leftMargin+15, _("2 Tax  Refunds  provide  to  Tourists  Under  the  Tax "), $companyCol,0,10);

  $rep->Text($rep->leftMargin+25, _("Refunds for Tourists Scheme "), $companyCol,0,22);

    $rep->RoundedRect(280, 145, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 145, 85,22,3, '1111','DF',null,array(255, 255, 255));
    //$rep->RoundedRect(480, 45, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(280, 145, 15,22,3, '0000','DF',null,array(235, 235, 235));
          $rep->RoundedRect(380, 145, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+255, _("-"), $companyCol,0,15);
        $rep->Text($rep->leftMargin+355, _("-"), $companyCol,0,15);
                $rep->fontSize -= 4;

   

      $touris_amt_row= tourist_amount_vat($from, $to);
      $rep->TextWrap(260, 682, 100, number_format($touris_amt_row['amount'] ,2), 'right');
      $rep->TextWrap(360, 682, 100, number_format($touris_amt_row['vat'],2), 'right');*/


   $rep->Text($rep->leftMargin+15,_("2 Supplies subject to the reverse charge provision"),$companyCol,0,0);
    $rep->RoundedRect(280,$box_align_2+145-14, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380,$box_align_2+145-14, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(480,$box_align_2+145-14, 85,22,3, '1111','DF',null,array(255, 255, 255));
    
       $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
       $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);

       // get_import_amount_supp_inv($from, $to)
        // $rep->Text($rep->leftMargin+290,number_format(get_import_amount_supp_inv($from, $to)['import_amount'] ,2), $companyCol+20,0,0);
        //  $rep->Text($rep->leftMargin+390,number_format(get_import_amount_supp_inv($from, $to)['import_tax'],2), $companyCol+20,0,0);
      /* $rep->TextWrap($amt_align+260,785, 100, number_format(get_import_amount_supp_inv($from, $to)['import_amount'] ,2), 'right');
      $rep->TextWrap($amt_align+360, 785, 100, number_format(get_import_amount_supp_inv($from, $to)['import_tax'],2), 'right');
      $rep->TextWrap($amt_align+460, 785, 100, number_format(get_excise_tax_data($from,$to,4)['tax'],2), 'right');*/
       $rep->TextWrap($amt_align+260,785, 100, number_format(0 ,2), 'right');
      $rep->TextWrap($amt_align+360, 785, 100, number_format(0,2), 'right');
      $rep->TextWrap($amt_align+460, 785, 100, number_format(0,2), 'right');
      /*$rep->TextWrap(260, 682+12, 100, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), 'right');
      $rep->TextWrap(360, 682+12, 100, number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), 'right');*/



    $rep->Text($rep->leftMargin+15, _("3 Zero rated supplies"), $companyCol,0,30);
    $rep->RoundedRect(280,$box_align_2+178-16, 85,22,3, '1111','DF',null,array(255, 255, 255));
         $rep->TextWrap($amt_align+260, 755, 100, number_format(getZeroRatedSupplies($from, $to),2), 'right');
    // $rep->Text($rep->leftMargin+310,number_format(getZeroRatedSupplies($from, $to),2), $companyCol+20,0,30);


    $rep->Text($rep->leftMargin+15, _("4 Supplies of goods and services to registered"), $companyCol,0,55);
    $rep->Text($rep->leftMargin+15, _("Customers in other GCC implementing states"), $companyCol,0,65);
    $rep->RoundedRect(280,$box_align_2+213-20, 85,22,3, '1111','DF',null,array(255, 255, 255));
      $rep->TextWrap($amt_align+260, 725, 100, number_format(CustGCCSupplies($from, $to),2), 'right');
     // $rep->Text($rep->leftMargin+310,number_format(0.00,2), $companyCol+20,0,60);

    $rep->Text($rep->leftMargin+15, _("5 Exempt supplies"), $companyCol,0,90);
    $rep->RoundedRect(280,$box_align_2+223, 85,22,3, '1111','DF',null,array(255, 255, 255));
      $rep->TextWrap($amt_align+260, 695, 100, number_format(ExemptSupplies($from, $to),2), 'right');
     // $rep->Text($rep->leftMargin+310,number_format(ExemptSupplies($from, $to),2), $companyCol+20,0,90);



  $rep->Text($rep->leftMargin+15, _("6 Import VAT accounted through UAE customs"), $companyCol,0,120);
    $rep->RoundedRect(280,$box_align_2+253, 85,22,3, '1111','DF',null,array(255, 255, 255));//235, 235, 235
     // $rep->Text($rep->leftMargin+310,number_format(get_import_supp_invoices($from, $to)['payable'],2), $companyCol,0,120);
      $rep->TextWrap($amt_align+260, 665, 100, number_format(get_import_supp_invoices($from, $to)['payable'],2), 'right');
    $rep->RoundedRect(380,$box_align_2+253, 85,22,3, '1111','DF',null,array(255, 255, 255));//235, 235, 235
     // $rep->Text($rep->leftMargin+410,number_format(get_import_supp_invoices($from, $to)['tax_amount'],2), $companyCol,0,120);
    $rep->TextWrap($amt_align+360, 665, 100, number_format(get_import_supp_invoices($from, $to)['tax_amount'],2), 'right');

//     $rep->Text($rep->leftMargin+15, _("6 Goods imported into UAE "), $companyCol,0,150);
//     $rep->RoundedRect(280,$box_align_2+185, 85,22,3, '1111','DF',null,array(235, 235, 235));
//     $rep->RoundedRect(380,$box_align_2+185, 85,22,3, '1111','DF',null,array(235, 235, 235));


    
//   $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
//       $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);
//       $rep->TextWrap(260, 640, 100, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), 'right');
//       $rep->TextWrap(360, 640, 100, number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), 'right');

    /*$rep->Text($rep->leftMargin+15, _("7 Adjustment to goods imported into the UAE. "), $companyCol,0,185);
    
    $rep->RoundedRect(280,$box_align_2+220, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380,$box_align_2+220, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $goods_import=Supp_Import_Amount_own_useable($from, $to);
           $rep->TextWrap(260, 605, 100, number_format($goods_import['import_amt'],2), 'right');
      $rep->TextWrap(360, 605, 100, number_format(($goods_import['import_amt']*5/100),2), 'right');*/

      $rep->Text($rep->leftMargin+15, _("7 Amendments or correction to Output figures"), $companyCol,0,152);
    
            // $goods_import=Supp_Import_Amount_own_useable($from, $to);
    $rep->RoundedRect(280,$box_align_2+284, 85,22,3, '1111','DF',null,array(255, 255, 255));
    //   $rep->Text($rep->leftMargin+310, number_format(get_excise_tax_data($from,$to,2)['amount'],2), $companyCol,0,152);
      $rep->TextWrap($amt_align+260, 635, 100, number_format(get_excise_tax_data($from,$to,2)['amount'],2), 'right');
    $rep->RoundedRect(380,$box_align_2+284, 85,22,3, '1111','DF',null,array(255, 255, 255));
            //  $rep->Text($rep->leftMargin+410,number_format(get_excise_tax_data($from,$to,2)['tax'],2), $companyCol,0,152);
             $rep->TextWrap($amt_align+360, 635, 100, number_format(get_excise_tax_data($from,$to,2)['tax'],2), 'right');
      //      $rep->TextWrap(260, 605, 100, number_format($goods_import['import_amt'],2), 'right');
      // $rep->TextWrap(360, 605, 100, number_format(($goods_import['import_amt']*5/100),2), 'right');

    //   $rep->TextWrap(260, 605, 100, number_format(0,2), 'right');
    //   $rep->TextWrap(360, 605, 100, number_format(0,2), 'right');


    $rep->Text($rep->leftMargin+15, _("8 Totals"), $companyCol,0,183);
    $rep->RoundedRect(280,$box_align_2+315, 85,22,3, '1111','DF',null,array(235, 235, 235));
      for($i=1; $i<=7;$i++)
        $amount_total+=( getTransactionsAmount($from, $to,$i)  ); 
      for($i=1; $i<=7;$i++)     
      $vat_total+=getTransactionsVat($from, $to,$i);
//display_error($amount_total ."+= ".ExemptSupplies($from, $to)." +". getZeroRatedSupplies($from, $to) );


   /*$amount_total+=  (  CustGCCSupplies($from, $to) + ExemptSupplies($from, $to) + getZeroRatedSupplies($from, $to)  + ( $Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ) + $goods_import['import_amt']  );*/
  $amount_total+=  (  CustGCCSupplies($from, $to) + ExemptSupplies($from, $to) + getZeroRatedSupplies($from, $to)  + ( $Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ) + $goods_import['import_amt']  );
  $vat_total+=$Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'];
            /*$vat_total+=($goods_import['import_amt']*5/100)+get_import_amount_supp_inv($from, $to)['import_tax']+get_excise_tax_data($from,$to,2)['tax'];*/
            $vat_total+=($goods_import['import_amt']*5/100)+get_excise_tax_data($from,$to,2)['tax'];
            
          /*  $adjustment_total = (get_excise_tax_data($from,$to,1,1)['tax']+get_excise_tax_data($from,$to,1,2)['tax']+get_excise_tax_data($from,$to,1,3)['tax']+get_excise_tax_data($from,$to,1,4)['tax']+get_excise_tax_data($from,$to,1,5)['tax']+get_excise_tax_data($from,$to,1,6)['tax']+get_excise_tax_data($from,$to,1,7)['tax']+get_excise_tax_data($from,$to,4)['tax']);*/
             $adjustment_total = get_excise_tax_total_data($from,$to)['tax'] + get_excise_tax_data($from,$to,4)['tax'];
             // display_error($adjustment_total);
           // $rep->TextWrap(260, 600, 100, number_format($amount_total,2), 'right');
        // $rep->Text($rep->leftMargin+290,number_format($amount_total,2), $companyCol,0,183);
          $rep->RoundedRect(380,$box_align_2+315, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(480,$box_align_2+315, 85,22,3, '1111','DF',null,array(235, 235, 235));
            $rep->TextWrap($amt_align+360, 600, 100, number_format($vat_total,2), 'right');
            // $rep->TextWrap(460, 600, 100, number_format(get_excise_tax_total_data($from,$to)['tax'],2), 'right');
            $rep->TextWrap($amt_align+460, 600, 100, number_format($adjustment_total,2), 'right');
            //  $rep->TextWrap(460, 600, 100, number_format(0.00,2), 'right');
        // $rep->Text($rep->leftMargin+370,number_format($vat_total,2), $companyCol+20,0,183);
    



    //---------------------First section end-------------------------



//--------------------------------------------- 4th Collum Start-----------------------------------------

$rep->row += 45;

   $rep->RoundedRect(30,$box_align_2+315+50, 555, 30,0, '0000','DF',null,array(242, 242, 242));

 $rep->RoundedRect(30,$box_align_2+345+50, 555, 160,0, '0000','DF',null,array(255, 255, 255));



            $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,320);
                  $rep->Text($rep->leftMargin+350, _("Rocoverable VAT"), $companyCol+40,0,320);
            $rep->Text($rep->leftMargin+350, _("Amount(AED)"), $companyCol+20,0,345);
            $rep->Text($rep->leftMargin+450,_("Adjustment(AED)"), $companyCol,0,320);
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT on Expense and All Other Inputs"), $companyCol,0,285);
        $rep->fontSize -= 3;

    
         




    $rep->Text($rep->leftMargin+15, _("9 Standard rated expenses"), $companyCol,0,345);
    $rep->RoundedRect(280,$box_align_2+400+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380,$box_align_2+400+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(480,$box_align_2+400+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
       $SuppAmt_VAT=SuppAmountAndVAt($from, $to);
       $SuppCreditAmt_vat=SuppCreditAmountAndVAt($from, $to);
    // $rep->Text($rep->leftMargin+290, number_format($SuppAmt_VAT['amount']-$SuppCreditAmt_vat['amount'] ,2), $companyCol,0,345);
    // $rep->Text($rep->leftMargin+390,number_format($SuppAmt_VAT['supp_vat']-$SuppCreditAmt_vat['supp_vat'],2), $companyCol,0,345);
      $rep->TextWrap($amt_align+260, 488, 100, number_format($SuppAmt_VAT['amount']-$SuppCreditAmt_vat['amount'] ,2), 'right');
      $rep->TextWrap($amt_align+360, 488, 100, number_format($SuppAmt_VAT['supp_vat']-$SuppCreditAmt_vat['supp_vat'],2), 'right');
      $rep->TextWrap($amt_align+460, 488, 100, number_format(get_excise_tax_data($from,$to,5)['tax'],2), 'right');
        // $rep->RoundedRect(480,$box_align_2+400, 15,22,3, '0000','DF',null,array(235, 235, 235));
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,370);
        //         $rep->fontSize -= 4;  



    $rep->Text($rep->leftMargin+15, _("10 Supplies subject to the reverse charge provisions"), $companyCol,0,375);
    $rep->RoundedRect(280,$box_align_2+435+25, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380,$box_align_2+435+25, 85,22,3, '1111','DF',null,array(255, 255, 255));
    
    //   $goods_import=Supp_Import_Amount_own_useable($from, $to);
    //   $rep->TextWrap(260, 390, 100, number_format($goods_import['import_amt'],2), 'right');
    //   $rep->TextWrap(360, 390, 100, number_format(($goods_import['import_amt']*5/100),2), 'right');
    
      $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
      $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);
    //   display_error(get_import_supp_invoices($from, $to)['payable']." - ".get_import_amount_supp_inv($from, $to)['import_amount']);exit;
      $rep->TextWrap($amt_align+260, 455, 100, number_format(get_import_supp_invoices($from, $to)['payable']-get_import_amount_supp_inv($from, $to)['import_amount'] ,2), 'right');
      $rep->TextWrap($amt_align+360, 455, 100, number_format(get_import_supp_invoices($from, $to)['tax_amount']-get_import_amount_supp_inv($from, $to)['import_tax'],2), 'right');
    //   $rep->Text($rep->leftMargin+290, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), $companyCol,0,375);
    // $rep->Text($rep->leftMargin+390,number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), $companyCol,0,375);
      
    $rep->RoundedRect(480,$box_align_2+435+25, 85,22,3, '1111','DF',null,array(255, 255, 255));
        // $rep->RoundedRect(480,$box_align_2+435+25, 15,22,3, '0000','DF',null,array(235, 235, 235));
         $rep->TextWrap($amt_align+460, 455, 100, number_format(get_excise_tax_data($from,$to,6)['tax'],2), 'right');
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,370);
        //         $rep->fontSize -= 4;  
                


 $rep->Text($rep->leftMargin+15, _("11 Amendments or corrections to Input figures"), $companyCol,0,405);
    $rep->RoundedRect(280,$box_align_2+490, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380,$box_align_2+490, 85,22,3, '1111','DF',null,array(255, 255, 255));
    // $rep->RoundedRect(480,$box_align_2+490, 85,22,3, '1111','DF',null,array(255, 255, 255));

         // $supp_amount_total+= ($SuppAmt_VAT['amount'] - $SuppCreditAmt_vat['amount']);
         // $supp_vat_total+=( $SuppAmt_VAT['supp_vat'] - $SuppCreditAmt_vat['supp_vat'] );
 //display_error( $supp_vat_total."+=(". $SuppAmt_VAT['supp_vat'] ."-". $SuppCreditAmt_vat['supp_vat'] .")" );
          // $rep->TextWrap(260, 355, 100, number_format($supp_amount_total,2), 'right');
          // $rep->TextWrap(360, 355, 100, number_format($supp_vat_total,2), 'right');
        
        // $rep->Text($rep->leftMargin+290, number_format(0.00,2), $companyCol,0,405);
        //  $rep->Text($rep->leftMargin+390,number_format(0.00,2), $companyCol,0,405);
         $rep->TextWrap($amt_align+260, 428, 100, number_format(get_excise_tax_data($from,$to,3)['amount'],2), 'right');
         $rep->TextWrap($amt_align+360, 428, 100, number_format(get_excise_tax_data($from,$to,3)['tax'],2), 'right');




    $rep->Text($rep->leftMargin+15, _("12 Totals"), $companyCol,0,435);
    $rep->RoundedRect(280,$box_align_2+520, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(380,$box_align_2+520, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(480,$box_align_2+520, 85,22,3, '1111','DF',null,array(235, 235, 235));

         $supp_amount_total+= ($SuppAmt_VAT['amount'] - $SuppCreditAmt_vat['amount']);
         $supp_vat_total+=( $SuppAmt_VAT['supp_vat'] - $SuppCreditAmt_vat['supp_vat'] )+(get_import_supp_invoices($from, $to)['tax_amount']-get_import_amount_supp_inv($from, $to)['import_tax'])+get_excise_tax_data($from,$to,3)['tax'];
         $supp_adjust_total = get_excise_tax_data($from,$to,5)['tax']+get_excise_tax_data($from,$to,6)['tax'];
 //display_error( $supp_vat_total."+=(". $SuppAmt_VAT['supp_vat'] ."-". $SuppCreditAmt_vat['supp_vat'] .")" );
          // $rep->TextWrap(260, 395, 100, number_format($supp_amount_total,2), 'right');
          $rep->TextWrap($amt_align+360, 395, 100, number_format($supp_vat_total,2), 'right');
          $rep->TextWrap($amt_align+460, 395, 100, number_format($supp_adjust_total,2), 'right');
        
        // $rep->Text($rep->leftMargin+290, number_format($supp_amount_total,2), $companyCol,0,435);
        //  $rep->Text($rep->leftMargin+390,number_format($supp_vat_total,2), $companyCol,0,435);


//-----------------------------Net VAT due----------------
$rep->RoundedRect(30,$box_align_2+570, 555, 30,0, '0000','DF',null,array(242, 242, 242));

$rep->RoundedRect(30,$box_align_2+600, 555, 160,0, '0000','DF',null,array(255, 255, 255));

 $rep->fontSize += 3;
 $rep->Text($rep->leftMargin+15, _("Net VAT due"), $companyCol,0,490);
 $rep->fontSize -= 3;

 $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,520);

$rep->Text($rep->leftMargin+15, _("13 Total Value of due tax for the period"), $companyCol,0,545);
$rep->RoundedRect(280,$box_align_2+630, 85,22,3, '1111','DF',null,array(235, 235, 235));
// $rep->Text($rep->leftMargin+290, number_format($vat_total+$adjustment_total,2), $companyCol,0,545);
$rep->TextWrap($amt_align+260, 395-110, 100, number_format($vat_total+$adjustment_total,2), 'right');

$rep->Text($rep->leftMargin+15, _("14 Total Value of recoverable tax for the period"), $companyCol,0,575);
$rep->RoundedRect(280,$box_align_2+660, 85,22,3, '1111','DF',null,array(235, 235, 235));
// $rep->Text($rep->leftMargin+290, number_format($supp_vat_total+$supp_adjust_total,2), $companyCol,0,575);
$rep->TextWrap($amt_align+260, 395-110-30, 100,number_format($supp_vat_total+$supp_adjust_total,2), 'right');

$rep->Text($rep->leftMargin+15, _("15 Net VAT due(or reclaimed) for the period"), $companyCol,0,605);
$rep->RoundedRect(280,$box_align_2+690, 85,22,3, '1111','DF',null,array(235, 235, 235));
// $rep->Text($rep->leftMargin+290, number_format(($vat_total+$adjustment_total)-($supp_vat_total+$supp_adjust_total),2), $companyCol,0,605);
$rep->TextWrap($amt_align+260, 395-110-30-30, 100, number_format(($vat_total+$adjustment_total)-($supp_vat_total+$supp_adjust_total),2), 'right');

$rep->Text($rep->leftMargin+15, _("16 If a VAT refund is due,do you wish to request"), $companyCol,0,630);
$rep->Text($rep->leftMargin+15, _("   that the refund is paid to you?"), $companyCol,0,640);
$rep->RoundedRect(280,$box_align_2+720, 85,22,3, '1111','DF',null,array(235, 235, 235));
$rep->Text($rep->leftMargin+290, 'Y/N', $companyCol,0,635);


    $rep->End();
}

