<?php

$page_security = 'SA_GLANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();

function getTransactionsAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)."";
            //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getCreditNoteAmount($from,$to,$dim1));
      return ( $row[0]-getCreditNoteAmount($from,$to,$dim1) ); 
    

}

function getTransactionsVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

   //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-getCreditNoteVat($from,$to,$dim1) ); 
}

function getCreditNoteAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE ttd.tax_type_id='1' AND dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";
           //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getInclusiveVAt($from,$to,$dim1));
     // return ( $row[0]-getInclusiveVAt($from,$to,$dim1) ); 
     return  $row[0] ; 

}


function getCreditNoteVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

   //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}


function getZeroRated($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2' ";
            
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}

function getZeroRatedSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2'";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ($row[0]-getZeroRatedCraditNoteSupplies($from, $to)); 
}

function getZeroRatedCraditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2'";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}


function ExemptSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='3' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-ExemptCreditNoteSupplies($from, $to) ) ; 
}

function ExemptCreditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='3' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}






function SuppAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND(SUM(st.ov_gst*st.rate),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import_amount=0 AND   st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
           //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function SuppCreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*st.rate ) ) ,2) as amount , ROUND( ABS (SUM(st.ov_gst*st.rate) ),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function Supp_Imported_AmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND(SUM(ov_gst*st.rate),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
         //    display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function Supp_Imported_CreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*ex_rate ) ) ,2) as amount , ROUND( ABS (SUM(ov_gst*st.rate) ),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'  AND st.import=1 AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function Supp_Import_Amount_own_useable($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(SUM((import_amount)*st.rate),2) as import_amt  FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'AND st.import_amount!=0 AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function tourist_amount_vat($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( SUM((dt.ov_amount-dt.ov_discount)*dt.rate ) ,2) as amount , ROUND(SUM(dt.ov_gst*dt.rate),2) as vat FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."cust_allocations ca on dt.trans_no=ca.trans_no_to AND dt.type=ca.trans_type_to WHERE dt.type='10' AND ca.trans_type_from='1'  AND  dt.tran_date >= '$fromdate'  AND dt.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}



//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
  $orientation = $_POST['PARAM_2'];
  $destination = $_POST['PARAM_3'];
  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_vat_return_report.inc");

  $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 60, 120, 180, 240, 340, 400, 460, 520);

    $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
      _('Type'), _('#'), _('Action'), _('Amount'));

    $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'right');

  $usr = get_user($user);
  $user_id = $usr['user_id'];
    $params =   array(  0 => $comments,
                1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
                      2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
                      3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));

    $rep = new FrontReport(_('VAT201 - VAT Returns'), "AuditTrail", user_pagesize(), 8, $orientation);
    if ($orientation == 'L')
      recalculate_cols($cols);

    $rep->Font();

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);
    $rep->NewPage();


    //$trans = getTransactions($from, $to, $systype, $user);




//------------------------------------- First Side Start-----------------------------------------------

        $companyCol = $rep->endLine - 150;
        $titleCol = $rep->leftMargin + 130;
        $col1 = $rep->leftMargin + 280;
        $col2 = $rep->leftMargin + 410;
        $col4 = $rep->leftMargin + 440;
        $amount_col=305;
$rep->row=$rep->row+10;
  $rep->leftMargin=$rep->leftMargin-10;
// display_error($rep->row);
// $rep->leftMargin=$rep->leftMargin-30;
         $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 70, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 100, 555, 200,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Taxable Person Detail "), $companyCol,0,20);
        $rep->fontSize -= 3;
        $rep->Text($rep->leftMargin+20, _("TRN "), $companyCol,0,50);
        $rep->RoundedRect(50, 125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+30,$rep->company['gst_no'], $companyCol,0,70);
  //       
        $rep->Text($rep->leftMargin+20, _("Taxable Person Name(English)"), $companyCol,0,100);
        $rep->RoundedRect(50, 175, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->company['coy_name'] , $companyCol,0,120);

        $rep->Text($rep->leftMargin+285, _("Taxable Person Name(Arabic)"), $companyCol+40,0,100);
        $rep->RoundedRect(315, 175, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
      //  $rep->Text($rep->leftMargin+470   ,$_SESSION['SysPrefs']->prefs['arabic_coy_name'],$companyCol+140,0,120);
        $rep->TextWrap(310, 655, 250,$_SESSION['SysPrefs']->prefs['arabic_coy_name'], 'right'); 

        $rep->Text($rep->leftMargin+20, _("Taxable Person Address"), $companyCol,0,150);
        $rep->RoundedRect(50, 225, 250,60,2.25, '1111','DF',null,array(242, 242, 242));
         $old_row=$rep->row;
         $rep->row=600;

         $rep->TextWrapLines($rep->leftMargin+30,200,$rep->company['postal_address']);
         $rep->row=$old_row;

 //-------------------------------- Second Side Start ------------------------------------------------

        $rep->RoundedRect(30, 310, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 340, 555, 110,0, '0000','DF',null,array(255, 255, 255));
        
   



        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT Return Period "), $companyCol,0,260);
        $rep->fontSize -= 3;

        $rep->Text($rep->leftMargin+20, _("VAT Return Period "), $companyCol,0,290);
        $rep->RoundedRect(50, 365, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->from ." - ".$rep->to, $companyCol,0,310);
              
               $end_date=strtotime(date2sql($rep->to));
              // display_error(date('Y',$end_date));
        $rep->Text($rep->leftMargin+20, _("TAX Year End "), $companyCol,0,340);
        $rep->RoundedRect(50, 415, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
          $rep->Text($rep->leftMargin+30, "31 December ".date('Y',$end_date), $companyCol,0,360);
              // $date1=date2sql($rep->to);
               // $new_date=date_create("$rep->to");
               // date_add($new_date,date_interval_create_from_date_string("28 days"));
  //display_error(date('d/m/Y',strtotime('+30 days',strtotime(str_replace('/', '-', $rep->to))))." = ".$rep->to);
        $rep->Text($rep->leftMargin+285, _("VAT Return Due Date "), $companyCol,0,290);
        $rep->RoundedRect(315, 365, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+295, date('d/m/Y',strtotime('+28 days',strtotime(str_replace('/', '-', $rep->to)))), $companyCol,0,310);
                 
                    $ref_date=strtotime($rep->from);
         $rep->Text($rep->leftMargin+285, _("VAT RETURN REFERENCE NUMBER"), $companyCol+50,0,340);
        $rep->RoundedRect(315, 415, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+295,date('d',$ref_date)."-".date('Y',$end_date), $companyCol+50,0,360);

        // display_error($rep->company['gst_no']);



// ----------------------------------third collum start--------------------------------------------------- 


        $rep->RoundedRect(30, 460, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 490, 555, 280,0, '0000','DF',null,array(255, 255, 255));
      
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT on Sales and ALL Other Outputs "), $companyCol,0,410);
        $rep->fontSize -= 3;
          

    $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));


          $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,440);
          $rep->Text($rep->leftMargin+350, _("VAT Amount(AED) "), $companyCol+40,0,440);
           $rep->Text($rep->leftMargin+460,_("Adjustment(AED) "), $companyCol,0,440);
              
$rep->Text($rep->leftMargin+15, _("1a Standard rated supplier in Abu Dhabi "), $companyCol,0,460);
    $rep->RoundedRect(280, 520, 85,22,3, '1111','DF',null,array(255, 255, 255));

          //$rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,1),2), $companyCol,0,465);
               $rep->TextWrap(260, $amount_col, 100,number_format(getTransactionsAmount($from, $to,1),2) , 'right'); 
    $rep->RoundedRect(380, 520, 85,22,3, '1111','DF',null,array(255, 255, 255));
              $rep->TextWrap(360, $amount_col, 100,number_format(getTransactionsVat($from, $to,1),2), 'right');
           //$rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,1),2), $companyCol+20,0,465);
    $rep->RoundedRect(480, 520, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 520, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,465);
                $rep->fontSize -= 4;

$rep->Text($rep->leftMargin+15, _("1b Standard rated supplier in Dubai "), $companyCol,0,495);
    $rep->RoundedRect(280, 555, 85,22,3, '1111','DF',null,array(255, 255, 255));
         // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,2),2), $companyCol,0,500);
          $rep->TextWrap(260, $amount_col-35, 100,number_format(getTransactionsAmount($from, $to,2),2), 'right');
    $rep->RoundedRect(380, 555, 85,22,3, '1111','DF',null,array(255, 255, 255));
          $rep->TextWrap(360, $amount_col-35, 100,number_format(getTransactionsVat($from, $to,2),2), 'right');
         // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,2),2), $companyCol+20,0,500);
    $rep->RoundedRect(480, 555, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 555, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,500);
                $rep->fontSize -= 4;   

$rep->Text($rep->leftMargin+15, _("1c Standard rated supplier in Sharjah "), $companyCol,0,530);
    $rep->RoundedRect(280, 590, 85,22,3, '1111','DF',null,array(255, 255, 255));

          // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,3),2), $companyCol,0,535);

            $rep->TextWrap(260, $amount_col-70, 100,number_format(getTransactionsAmount($from, $to,3),2), 'right');
    $rep->RoundedRect(380, 590, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $rep->TextWrap(360, $amount_col-70, 100,number_format(getTransactionsVat($from, $to,3),2), 'right');
        //   $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,3),2), $companyCol+20,0,535);
    $rep->RoundedRect(480, 590, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 590, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,535);
                $rep->fontSize -= 4;  

$rep->Text($rep->leftMargin+15, _("1d Standard rated supplier in Ajman "), $companyCol,0,565);
    $rep->RoundedRect(280, 625, 85,22,3, '1111','DF',null,array(255, 255, 255));
              // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,4),2), $companyCol,0,570);
            $rep->TextWrap(260, $amount_col-105, 100,number_format(getTransactionsAmount($from, $to,4),2), 'right');
   $rep->RoundedRect(380, 625, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $rep->TextWrap(360, $amount_col-105, 100,number_format(getTransactionsVat($from, $to,4),2), 'right');
              //$rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,4),2), $companyCol+20,0,570);
    $rep->RoundedRect(480, 625, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 625, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,570);
                $rep->fontSize -= 4;  

$rep->Text($rep->leftMargin+15, _("1e Standard rated supplier in Umm Al Quwain "), $companyCol,0,600);
    $rep->RoundedRect(280, 660, 85,22,3, '1111','DF',null,array(255, 255, 255));
              //   $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,5),2), $companyCol,0,605);
        $rep->TextWrap(260, $amount_col-140, 100,number_format(getTransactionsAmount($from, $to,5),2), 'right');
   $rep->RoundedRect(380, 660, 85,22,3, '1111','DF',null,array(255, 255, 255));
         $rep->TextWrap(360, $amount_col-140, 100,number_format(getTransactionsVat($from, $to,5),2), 'right');
               // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,5),2), $companyCol+20,0,605);
    $rep->RoundedRect(480, 660, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 660, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
                $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,605);
                $rep->fontSize -= 4;  

$rep->Text($rep->leftMargin+15, _("1f Standard rated supplier in Ras Al Khaimah "), $companyCol,0,635);
    $rep->RoundedRect(280, 695, 85,22,3, '1111','DF',null,array(255, 255, 255));
              //  $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,6),2), $companyCol,0,640);
          $rep->TextWrap(260, $amount_col-175, 100,number_format(getTransactionsAmount($from, $to,6),2), 'right');
    $rep->RoundedRect(380, 695, 85,22,3, '1111','DF',null,array(255, 255, 255));
           $rep->TextWrap(360, $amount_col-175, 100,number_format(getTransactionsVat($from, $to,6),2), 'right');
             // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,6),2), $companyCol+20,0,640);
    $rep->RoundedRect(480, 695, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 695, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,640);
                $rep->fontSize -= 4;  


$rep->Text($rep->leftMargin+15, _("1g Standard rated supplier in Fujairah "), $companyCol,0,670);
    $rep->RoundedRect(280,730, 85,22,3, '1111','DF',null,array(255, 255, 255));
            // $rep->Text($rep->leftMargin+290,number_format(getTransactionsAmount($from, $to,7),2), $companyCol,0,675);
              $rep->TextWrap(260, $amount_col-210, 100,number_format(getTransactionsAmount($from, $to,7),2), 'right');
    $rep->RoundedRect(380, 730, 85,22,3, '1111','DF',null,array(255, 255, 255));
               $rep->TextWrap(360, $amount_col-210, 100,number_format(getTransactionsVat($from, $to,7),2), 'right');
            // $rep->Text($rep->leftMargin+390,number_format(getTransactionsVat($from, $to,7),2), $companyCol+20,0,675);
    $rep->RoundedRect(480, 730, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(480, 730, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,675);
                $rep->fontSize -= 4;  
//---------------------------------------2nd Page start--------------------------------

    $rep->NewPage();
    $rep->row=$rep->row+10;
        $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));
        $rep->RoundedRect(30, 23, 555, 280,0, '0000','DF',null,array(255, 255, 255));

// 2 Tax Refunds provide to Tourists Under the Tax Refunds
//  
//
// 

// 

// 

// 
// 8 Totals


  $rep->Text($rep->leftMargin+15, _("2 Tax  Refunds  provide  to  Tourists  Under  the  Tax "), $companyCol,0,10);

  $rep->Text($rep->leftMargin+25, _("Refunds for Tourists Scheme "), $companyCol,0,22);

    $rep->RoundedRect(280, 45, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 45, 85,22,3, '1111','DF',null,array(255, 255, 255));
    //$rep->RoundedRect(480, 45, 85,22,3, '1111','DF',null,array(255, 255, 255));
        $rep->RoundedRect(280, 45, 15,22,3, '0000','DF',null,array(235, 235, 235));
          $rep->RoundedRect(380, 45, 15,22,3, '0000','DF',null,array(235, 235, 235));
                $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+255, _("-"), $companyCol,0,15);
        $rep->Text($rep->leftMargin+355, _("-"), $companyCol,0,15);
                $rep->fontSize -= 4;

   

      $touris_amt_row= tourist_amount_vat($from, $to);
      $rep->TextWrap(260, 780, 100, number_format($touris_amt_row['amount'] ,2), 'right');
      $rep->TextWrap(360, 780, 100, number_format($touris_amt_row['vat'],2), 'right');


   $rep->Text($rep->leftMargin+15,_("3 Supplies subject to the reverse charge provision "),$companyCol,0,45);
    $rep->RoundedRect(280, 80, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 80, 85,22,3, '1111','DF',null,array(255, 255, 255));
    
       $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
       $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);
      $rep->TextWrap(260, 745, 100, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), 'right');
      $rep->TextWrap(360, 745, 100, number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), 'right');



    $rep->Text($rep->leftMargin+15, _("4 Zero rated supplies "), $companyCol,0,80);
    $rep->RoundedRect(280, 115, 85,22,3, '1111','DF',null,array(255, 255, 255));
          $rep->TextWrap(260, 710, 100, number_format(getZeroRatedSupplies($from, $to),2), 'right');
    //$rep->Text($rep->leftMargin+290,number_format(getZeroRatedSupplies($from, $to),2), $companyCol+20,0,85);




    $rep->Text($rep->leftMargin+15, _("5 Exempt supplies "), $companyCol,0,115);
    $rep->RoundedRect(280, 150, 85,22,3, '1111','DF',null,array(255, 255, 255));
      $rep->TextWrap(260, 675, 100, number_format(ExemptSupplies($from, $to),2), 'right');
     //$rep->Text($rep->leftMargin+290,number_format(ExemptSupplies($from, $to),2), $companyCol+20,0,120);





    $rep->Text($rep->leftMargin+15, _("6 Goods imported into UAE "), $companyCol,0,150);
    $rep->RoundedRect(280, 185, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(380, 185, 85,22,3, '1111','DF',null,array(235, 235, 235));


    
//   $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
//       $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);
//       $rep->TextWrap(260, 640, 100, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), 'right');
//       $rep->TextWrap(360, 640, 100, number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), 'right');

    $rep->Text($rep->leftMargin+15, _("7 Adjustment to goods imported into the UAE. "), $companyCol,0,185);
    
    $rep->RoundedRect(280, 220, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 220, 85,22,3, '1111','DF',null,array(255, 255, 255));
            $goods_import=Supp_Import_Amount_own_useable($from, $to);
           $rep->TextWrap(260, 605, 100, number_format($goods_import['import_amt'],2), 'right');
      $rep->TextWrap(360, 605, 100, number_format(($goods_import['import_amt']*5/100),2), 'right');

    //   $rep->TextWrap(260, 605, 100, number_format(0,2), 'right');
    //   $rep->TextWrap(360, 605, 100, number_format(0,2), 'right');


    $rep->Text($rep->leftMargin+15, _("8 Totals "), $companyCol,0,220);
    $rep->RoundedRect(280, 255, 85,22,3, '1111','DF',null,array(235, 235, 235));
      for($i=1; $i<=7;$i++)
        $amount_total+=( getTransactionsAmount($from, $to,$i)  ); 
      for($i=1; $i<=7;$i++)     
       $vat_total+=getTransactionsVat($from, $to,$i);
//display_error($amount_total ."+= ".ExemptSupplies($from, $to)." +". getZeroRatedSupplies($from, $to) );


   $amount_total+=  (   ExemptSupplies($from, $to) + getZeroRatedSupplies($from, $to)  + ( $Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ) + $goods_import['import_amt']  );
  $vat_total+=$Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'];
            $vat_total+=($goods_import['import_amt']*5/100);
            
           $rep->TextWrap(260, 570, 100, number_format($amount_total,2), 'right');
        // $rep->Text($rep->leftMargin+290,number_format($amount_total,2), $companyCol,0,225);
          $rep->RoundedRect(380, 255, 85,22,3, '1111','DF',null,array(235, 235, 235));
            $rep->TextWrap(360, 570, 100, number_format($vat_total,2), 'right');
       //  $rep->Text($rep->leftMargin+390,number_format($vat_total,2), $companyCol+20,0,225);
    
    $rep->RoundedRect(480, 255, 85,22,3, '1111','DF',null,array(235, 235, 235));



//--------------------------------------------- 4th Collum Start-----------------------------------------



   $rep->RoundedRect(30, 315, 555, 30,0, '0000','DF',null,array(242, 242, 242));

 $rep->RoundedRect(30, 345, 555, 200,0, '0000','DF',null,array(255, 255, 255));



            $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,330);
                  $rep->Text($rep->leftMargin+350, _("Rocoverable VAT  "), $companyCol+40,0,330);
            $rep->Text($rep->leftMargin+350, _("Amount(AED) "), $companyCol+20,0,345);
            $rep->Text($rep->leftMargin+450,_("Adjustment(AED) "), $companyCol,0,330);
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("VAT on Expense and All Other Inputs"), $companyCol,0,290);
        $rep->fontSize -= 3;

    
         




    $rep->Text($rep->leftMargin+15, _("9 Standard rated expenses"), $companyCol,0,365);
    $rep->RoundedRect(280, 400, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 400, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(480, 400, 85,22,3, '1111','DF',null,array(255, 255, 255));
       $SuppAmt_VAT=SuppAmountAndVAt($from, $to);
       $SuppCreditAmt_vat=SuppCreditAmountAndVAt($from, $to);
      $rep->TextWrap(260, 425, 100, number_format($SuppAmt_VAT['amount']-$SuppCreditAmt_vat['amount'] ,2), 'right');
      $rep->TextWrap(360, 425, 100, number_format($SuppAmt_VAT['supp_vat']-$SuppCreditAmt_vat['supp_vat'],2), 'right');
        // $rep->RoundedRect(480, 400, 15,22,3, '0000','DF',null,array(235, 235, 235));
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,370);
        //         $rep->fontSize -= 4;  



    $rep->Text($rep->leftMargin+15, _("10 Supplies subject to the reverse charge provisions"), $companyCol,0,400);
    $rep->RoundedRect(280, 435, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->RoundedRect(380, 435, 85,22,3, '1111','DF',null,array(255, 255, 255));
    
    //   $goods_import=Supp_Import_Amount_own_useable($from, $to);
    //   $rep->TextWrap(260, 390, 100, number_format($goods_import['import_amt'],2), 'right');
    //   $rep->TextWrap(360, 390, 100, number_format(($goods_import['import_amt']*5/100),2), 'right');
    
      $Supp_Imported_Amt_VAT=Supp_Imported_AmountAndVAt($from, $to);
      $Supp_Imported_CreditAmt_vat=Supp_Imported_CreditAmountAndVAt($from, $to);
      $rep->TextWrap(260, 390, 100, number_format($Supp_Imported_Amt_VAT['amount']-$Supp_Imported_CreditAmt_vat['amount'] ,2), 'right');
      $rep->TextWrap(360, 390, 100, number_format($Supp_Imported_Amt_VAT['supp_vat']-$Supp_Imported_CreditAmt_vat['supp_vat'],2), 'right');
      
    //$rep->RoundedRect(480, 435, 85,22,3, '1111','DF',null,array(255, 255, 255));
        // $rep->RoundedRect(480, 435, 15,22,3, '0000','DF',null,array(235, 235, 235));
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,370);
        //         $rep->fontSize -= 4;  
                

    $rep->Text($rep->leftMargin+15, _("11 Totals"), $companyCol,0,435);
    $rep->RoundedRect(280, 470, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(380, 470, 85,22,3, '1111','DF',null,array(235, 235, 235));
    $rep->RoundedRect(480, 470, 85,22,3, '1111','DF',null,array(235, 235, 235));

         $supp_amount_total+= ($SuppAmt_VAT['amount'] - $SuppCreditAmt_vat['amount']);
         $supp_vat_total+=( $SuppAmt_VAT['supp_vat'] - $SuppCreditAmt_vat['supp_vat'] );
 //display_error( $supp_vat_total."+=(". $SuppAmt_VAT['supp_vat'] ."-". $SuppCreditAmt_vat['supp_vat'] .")" );
          $rep->TextWrap(260, 355, 100, number_format($supp_amount_total,2), 'right');
          $rep->TextWrap(360, 355, 100, number_format($supp_vat_total,2), 'right');
        
        // $rep->RoundedRect(480, 470, 15,22,3, '0000','DF',null,array(235, 235, 235));
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,370);
        //         $rep->fontSize -= 4;               


        // $rep->RoundedRect(480, 255, 15,22,3, '0000','DF',null,array(235, 235, 235));
        //         $rep->fontSize += 4;
        // $rep->Text($rep->leftMargin+455, _("-"), $companyCol,0,225);
        //         $rep->fontSize -= 4;


    // while ($myrow=db_fetch($trans))
    // {
    //     $rep->TextCol(0, 1, sql2date(date("Y-m-d", $myrow['unix_stamp'])));
    //     if (user_date_format() == 0)
    //      $rep->TextCol(1, 2, date("h:i:s a", $myrow['unix_stamp']));
    //     else 
    //      $rep->TextCol(1, 2, date("H:i:s", $myrow['unix_stamp']));
    //     $rep->TextCol(2, 3, $myrow['user_id']);
    //     $rep->TextCol(3, 4, sql2date($myrow['gl_date']));
    //     $rep->TextCol(4, 5, $systypes_array[$myrow['type']]);
    //     $rep->TextCol(5, 6, $myrow['trans_no']);
    //     if ($myrow['gl_seq'] == null)
    //      $action = _('Changed');
    //     else
    //      $action = _('Closed');
    //     $rep->TextCol(6, 7, $action);
    //     if ($myrow['amount'] != null)
    //      $rep->AmountCol(7, 8, $myrow['amount'], $dec);
    //     $rep->NewLine(1, 2);
    // }
   // $rep->Line($rep->row  + 4);
    $rep->End();
}

