<?php

$page_security = 'SA_GLANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();

//----------------------------------------------------------------------------------------------------
function  getPurchaseListing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT st.supplier_id,st.tran_date,std.supp_trans_no,st.reference ,std.description,ttd.* FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=20   WHERE st.type=20 AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
 return db_query($sql);
}
function  getSalesListing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT dt.debtor_no,dt.tran_date,dtd.debtor_trans_no,dtd.description,ttd.* FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."debtor_trans_details dtd on dtd.debtor_trans_no =dt.trans_no AND dtd.debtor_trans_type=dt.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=dt.type AND ttd.trans_no=dt.trans_no AND ttd.trans_type=10  WHERE dt.type=10 AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'";

 return db_query($sql);
}
function  GL_Listing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT gl.tran_date, gl.account,gl.type,gl.type_no,gl.amount FROM ".TB_PREF."gl_trans as gl WHERE gl.tran_date >= '$fromdate' AND gl.tran_date <= '$todate'";
display_error($sql);

 return db_query($sql);
}

function  get_trans_cust_name($type, $trans_no){

  $sql="SELECT * FROM ".TB_PREF."debtor_trans WHERE type=".db_escape($type)." AND trans_no=".db_escape($trans_no);
   $res = db_query($sql);
   $row  = db_fetch($res);
   return $row['debtor_no'];
}

function  get_trans_supp_name($type, $trans_no){

  $sql="SELECT * FROM ".TB_PREF."supp_trans WHERE type=".db_escape($type)." AND trans_no=".db_escape($trans_no);
   $res = db_query($sql);
   $row  = db_fetch($res);

   return $row['supplier_id'];
}



//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
  $orientation = $_POST['PARAM_2'];
  $destination = $_POST['PARAM_3'];
  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_vat_FAT.inc");

  $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();


    // $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
    //   _('Type'), _('#'), _('Action'), _('Amount'));

    // $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'right');

  // $usr = get_user($user);
  // $user_id = $usr['user_id'];
  //   $params =   array(  0 => $comments,
  //               1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
  //                     2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
  //                     3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));

    $rep = new FrontReport(_('VAT201 - VAT Returns'), "AuditTrail", user_pagesize(), 6, 'L');
    if ($orientation == 'L')
      recalculate_cols($cols);

    $rep->Font();

      $cols = array(5, 100, 175, 230,275,320, 355,440,530,600,640,685,740);
      // $headers = array(_('Supplier Name'), _('Supplier TIN/TRN'), _('Invoice Date'), _('Invoice No')
        // , _('Permit No'), _('Line No') );
    $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);
    $rep->NewPage();


 

     
        $companyCol = $rep->endLine - 150;
        $titleCol = $rep->leftMargin + 130;
        $col1 = $rep->leftMargin + 280;
        $col2 = $rep->leftMargin + 410;
        $col4 = $rep->leftMargin + 440;
        $tcol=19;
        $tcol2=380;



//------------------------------------- First Side Start-----------------------------------------------



     $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
   $rep->RoundedRect(30, 70, 783, 30,0, '0000','DF',null,array(242, 242, 242));

      $rep->RoundedRect(30, 100, 783, 155,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Company Information "), $companyCol,0,25 );
        $rep->fontSize -= 3;
       
        $rep->Text($rep->leftMargin+45, _("Taxable Person Name (English) "), $companyCol,0,55);
        $rep->RoundedRect(75, 125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
       $rep->Text($rep->leftMargin+55,$rep->company['coy_name'], $companyCol,0,75);
  //       
        $rep->Text($rep->leftMargin+45, _("Tax Registration Number"), $companyCol,0,105);
        $rep->RoundedRect(75, 175, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55, $rep->company['gst_no'] , $companyCol,0,125);

        $rep->Text($rep->leftMargin+45, _("Period Start"), $companyCol,0,155);
        $rep->RoundedRect(75 , 225 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));

        $rep->Text($rep->leftMargin+485, _("Tax Agency Name"), $companyCol,0,55);
        $rep->RoundedRect(515, 125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->TextWrap(500, 458, 250,$_SESSION['SysPrefs']->prefs['arabic_coy_name'], 'right'); 
       
        $rep->Text($rep->leftMargin+485, _("Tax Agent Name"), $companyCol,0,105);
        $rep->RoundedRect(515 , 175 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
       
        $rep->Text($rep->leftMargin+485, _("FAF Creation Date"), $companyCol,0,155);
        $rep->RoundedRect(515 , 225 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));


   //------------------------------------Second Column----------------------------------------------------//


       $rep->fontSize += 4;
        $rep->Text($rep->leftMargin+5, _("Purchase Listing Table "), $companyCol,0,220);
        $rep->fontSize -= 4;
       $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(128,128, 128)));
        // $rep->RoundedRect(30, 300, 555, 18,0, '0000');
   




   $trans = getPurchaseListing($from, $to);

 // : Set  1st  Header :   
           
         $rep->row=295;
      
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, 'Supplier Name');
         $rep->TextCol(1, 2, 'Supplier TIN/TRN');
         $rep->TextCol(2, 3, 'Invoice Date');
         $rep->TextCol(3, 4, 'Invoice No');
         $rep->TextCol(4, 5, 'Permit No');
         $rep->TextCol(5, 6, 'Line No');

         $rep->TextCol(6, 7, 'Product Description');
         $rep->TextCol(7, 8, 'Purchase Value(AED)');
         $rep->TextCol(8, 9, 'VAT Value(AED)');
         $rep->TextCol(9, 10, 'Tax Code');
         $rep->TextCol(10, 11, 'FCY Code');
         $rep->TextCol(11, 12, 'Purchase FCY');
         $rep->TextCol(12, 13, 'VAT FCY');
       

         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5, 2);
         // $rep->row=450;
            $rep->NewLine(1.5);
 
            $trans_no=0;
            $line_no=1;
    while ($myrow=db_fetch($trans))
    {
     
        $rep->TextCol(0, 1, get_supplier($myrow['supplier_id'])['supp_name']);
     
         $rep->TextCol(1, 2, get_supplier($myrow['supplier_id'])['gst_no']);
        $rep->TextCol(2, 3, sql2date($myrow['tran_date']));
        $rep->TextCol(3, 4, $myrow['supp_trans_no']);

  $rep->TextCol(4, 5, $myrow['reference']);



         if($trans_no!=$myrow['supp_trans_no'])
         {
          $trans_no=$myrow['supp_trans_no'];
                 $line_no=1;
         }

        $rep->TextCol(5, 6, $line_no++);

        $rep->TextCol(6, 7, $myrow['description']);
          $rep->TextCol(7, 8, number_format($myrow['net_amount'],2));
        $rep->TextCol(8, 9, number_format($myrow['amount'],2));
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );
        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight ))
        {
          
          $rep->NewPage();
      
        }

         $rep->NewLine();
    
    }

  
           $rep->Line($rep->row, 2);
//-----------------------------------------------------------------------------------------------------------
  $rep->NewLine(2);
        $rep->fontSize += 4;
            $rep->TextCol(0, 2, _("Customer Listing Table "));
        $rep->fontSize -= 4;
  $rep->NewLine(2);

 $cols = array(5, 100, 175, 230,275,320, 405,490,560,600,640,685,740);
     
 $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);


              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, 'Customer Name');
         $rep->TextCol(1, 2, 'Customer TIN/TRN');
         $rep->TextCol(2, 3, 'Invoice Date');
         $rep->TextCol(3, 4, 'Invoice No');
         $rep->TextCol(4, 5, 'Line No');
         $rep->TextCol(5, 6, 'Product Description');

        $rep->TextCol(6, 7, 'Supply Value(AED)');
         $rep->TextCol(7, 8, 'VAT Value(AED)');
         $rep->TextCol(8, 9, 'Tax Code');
         $rep->TextCol(9, 10, 'Country');
         $rep->TextCol(10, 11, 'FCY Code');
         $rep->TextCol(11, 12, 'Supply FCY');
         $rep->TextCol(12, 13, 'VAT FCY');








       

         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5, 2);
            $rep->NewLine(1.5);
    $trans = getSalesListing($from, $to);
         // $rep->row=450;
            // display_error(db_num_rows($trans));
            $trans_no=0;
            $line_no=1;
    while ($myrow=db_fetch($trans))
    {
      //display_error($myrow['supp_name']);
        $rep->TextCol(0, 1,  get_customer($myrow['debtor_no'])['name']);
        // if (user_date_format() == 0)
        //  $rep->TextCol(1, 2, date("h:i:s a", $myrow['unix_stamp']));
        // else 
         $rep->TextCol(1, 2, get_customer($myrow['debtor_no'])['tax_id']);
        $rep->TextCol(2, 3, sql2date($myrow['tran_date']));
        $rep->TextCol(3, 4, $myrow['debtor_trans_no']);
        // display_error($trans_no."!=".$myrow['supp_trans_no']);
         if($trans_no!=$myrow['debtor_trans_no'])
         {
          $trans_no=$myrow['debtor_trans_no'];
                 $line_no=1;
         }

        $rep->TextCol(4, 5, $line_no++);
        $rep->TextCol(5, 6, $myrow['description']);
                  $rep->TextCol(6, 7, number_format($myrow['net_amount'],2));
        $rep->TextCol(7, 8, number_format($myrow['amount'],2));
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );
        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight))
        {
              $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, 'Customer Name');
         $rep->TextCol(1, 2, 'Customer TIN/TRN');
         $rep->TextCol(2, 3, 'Invoice Date');
         $rep->TextCol(3, 4, 'Invoice No');
         $rep->TextCol(4, 5, 'Line No');
         $rep->TextCol(5, 6, 'Product Description');

        $rep->TextCol(6, 7, 'Supply Value(AED)');
         $rep->TextCol(7, 8, 'VAT Value(AED)');
         $rep->TextCol(8, 9, 'Tax Code');
         $rep->TextCol(9, 10, 'Country');
         $rep->TextCol(10, 11, 'FCY Code');
         $rep->TextCol(11, 12, 'Supply FCY');
         $rep->TextCol(12, 13, 'VAT FCY');

         $rep->fontSize -= 1;
           $rep->Line($rep->row-5,2);
            $rep->NewLine();
      
        }

         $rep->NewLine();
    
    }

           $rep->Line($rep->row, 2);

//-----------------------------------------------------------------------------------------------------------
  $rep->NewLine(2);
        $rep->fontSize += 5;
            $rep->TextCol(0, 2, _("General Ledger Table "));
        $rep->fontSize -= 5;
  $rep->NewLine(2);

 $cols = array(5, 70, 135, 265,360,460, 510,590,640,690,740);
      
    $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);


              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, 'Trans Date');
         $rep->TextCol(1, 2, 'Account ID');
         $rep->TextCol(2, 3, 'Account Name');
         $rep->TextCol(3, 4, 'Transaction ');
         $rep->TextCol(4, 5, 'SUPP/CUST Name');
         $rep->TextCol(5, 6, 'Trans ID');

        $rep->TextCol(6, 7, 'Source Document ID');
         $rep->TextCol(7, 8, 'Source Type');
         $rep->TextCol(8, 9, 'Debit');
         $rep->TextCol(9, 10, 'Credit');
         $rep->TextCol(10, 11, 'Balance');



         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5, 2);
            $rep->NewLine(1.5);
    $trans = GL_Listing($from, $to);

            $trans_no=0;
            $line_no=1;
    while ($myrow=db_fetch($trans))
    {

        $rep->TextCol(0, 1,  $myrow['tran_date']);
 
         $rep->TextCol(1, 2, $myrow['account']);
        $rep->TextCol(2, 3, get_gl_account($myrow['account'])['account_name']);
        $rep->TextCol(3, 4,$systypes_array[$myrow["type"]]  );

        if($myrow["type"]==10 || $myrow["type"]==13 || $myrow["type"]==11 || $myrow["type"]==12)
             $rep->TextCol(4, 5, get_customer_name(get_trans_cust_name($myrow["type"], $myrow['type_no'])));
       elseif($myrow["type"]==20 || $myrow["type"]==22 || $myrow["type"]==21 )
             $rep->TextCol(4, 5, get_supplier_name(get_trans_supp_name($myrow["type"], $myrow['type_no'])));
       else
         $rep->TextCol(4, 5,"--------------");

 
        $rep->TextCol(5, 6, $myrow['type_no']);

        $total += $myrow['amount'];
if ($myrow['amount'] > 0.0)
         { $rep->AmountCol(8, 9, abs($myrow['amount']), $dec);
           $debit+=$myrow['amount'];
           }
        else
          { $rep->AmountCol(9, 10, abs($myrow['amount']), $dec);
            $Credit+=$myrow['amount'];
            }
        $rep->TextCol(10, 11, number_format2($total, $dec));
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );
        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight))
        {
              $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
              $rep->TextCol(0, 1, 'Trans Date');
         $rep->TextCol(1, 2, 'Account ID');
         $rep->TextCol(2, 3, 'Account Name');
         $rep->TextCol(3, 4, 'Transaction ');
         $rep->TextCol(4, 5, 'SUPP/CUST Name');
         $rep->TextCol(5, 6, 'Trans ID');

        $rep->TextCol(6, 7, 'Source Document ID');
         $rep->TextCol(7, 8, 'Source Type');
         $rep->TextCol(8, 9, 'Debit');
         $rep->TextCol(9, 10, 'Credit');
         $rep->TextCol(10, 11, 'Balance');

         $rep->fontSize -= 1;
           $rep->Line($rep->row-5,2);
            $rep->NewLine();
      
        }

         $rep->NewLine();
    
    }

           $rep->Line($rep->row, 2);
            $rep->NewLine();
                  $rep->fontSize += 1;
            $rep->AmountCol(8, 9, abs($debit), $dec);
             $rep->AmountCol(9, 10, abs($Credit), $dec);
               $rep->AmountCol(10, 11, number_format2(abs($debit)-abs($Credit)), $dec);
                   $rep->fontSize -= 1;
///   ------------------------------------------  third collumn-------------------------------








    $rep->End();
}

