<?php

$page_security = 'SA_GLANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();
function getPurchaseHasDesignated($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT SUM(ttd.net_amount)As amount,SUM(ttd.amount) AS tax FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=20 LEFT JOIN ".TB_PREF."suppliers AS sup ON sup.supplier_id = st.supplier_id  WHERE st.type=20 AND (ttd.tax_type_id='3' OR ttd.tax_type_id='4') AND sup.designated_zone = '1' AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
  // display_error($sql);
 return db_fetch(db_query($sql));
}

function getPurchaseExciseDataCredit($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT SUM(std.unit_price*std.quantity) AS excise_price,SUM(ttd.amount) AS excise_tax FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=21   WHERE st.type=21 AND (ttd.tax_type_id='3' OR ttd.tax_type_id='4') AND (SELECT import FROM ".TB_PREF."supp_trans AS sup LEFT JOIN ".TB_PREF."supp_invoice_items AS supp_item ON supp_item.supp_trans_no = sup.trans_no AND supp_item.supp_trans_type = sup.type Where sup.type = 20 AND supp_item.grn_item_id = std.grn_item_id  AND supp_item.po_detail_item_id = std.po_detail_item_id) = '0' AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
  // display_error($sql);
 return db_fetch(db_query($sql));
}
function getPurchaseExciseDataImportCredit($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT SUM(std.unit_price*std.quantity) AS excise_price,SUM(ttd.amount) AS excise_tax FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=21   WHERE st.type=21 AND (ttd.tax_type_id='3' OR ttd.tax_type_id='4') AND (SELECT import FROM ".TB_PREF."supp_trans AS sup LEFT JOIN ".TB_PREF."supp_invoice_items AS supp_item ON supp_item.supp_trans_no = sup.trans_no AND supp_item.supp_trans_type = sup.type Where sup.type = 20 AND supp_item.grn_item_id = std.grn_item_id  AND supp_item.po_detail_item_id = std.po_detail_item_id) = '1' AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
  // display_error($sql);
 return db_fetch(db_query($sql));
}
function getPurchaseExciseData($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT SUM((std.unit_price*std.quantity)*ttd.ex_rate) AS excise_price,SUM(ttd.amount*ttd.ex_rate) AS excise_tax FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=20 LEFT JOIN ".TB_PREF."suppliers AS sup ON sup.supplier_id = st.supplier_id  WHERE st.type=20 AND (ttd.tax_type_id='3' OR ttd.tax_type_id='4') AND sup.designated_zone = '0' AND st.import = '0' AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
  
//   display_error($sql);
 return db_fetch(db_query($sql));
}
function getPurchaseExciseDataImport($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT SUM(std.unit_price*std.quantity) AS excise_price,SUM(ttd.amount) AS excise_tax FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND ttd.trans_type=20   WHERE st.type=20 AND (ttd.tax_type_id='3' OR ttd.tax_type_id='4') AND st.import = '1' AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
//   display_error($sql);
 return db_fetch(db_query($sql));
}
function getTransactionsAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)."";
            //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getCreditNoteAmount($from,$to,$dim1));
      return ( $row[0]-getCreditNoteAmount($from,$to,$dim1) ); 
    

}

function getTransactionsVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE dt.type='10' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

   //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-getCreditNoteVat($from,$to,$dim1) ); 
}

function getCreditNoteAmount($from, $to,$dim1)
{
  $fromdate = date2sql($from);
  $todate = date2sql($to);

  // $sql .= "SELECT SUM(ov_amount) FROM ".TB_PREF."debtor_trans WHERE type='10' AND tran_date >= '$fromdate'
  //    AND tran_date <= '$todate' AND dimension_id='$dim1'";

   $sql="SELECT ROUND(SUM(ttd.net_amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE ttd.tax_type_id='1' AND dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";
           //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
//display_error($row[0]." - ".getInclusiveVAt($from,$to,$dim1));
     // return ( $row[0]-getInclusiveVAt($from,$to,$dim1) ); 
     return  $row[0] ; 

}


function getCreditNoteVat($from, $to,$dim1)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    // $sql .= "SELECT SUM(ov_gst) FROM ".TB_PREF."debtor_trans WHERE type='10' AND   tran_date >= '$fromdate'
    //         AND tran_date <= '$todate' AND dimension_id='$dim1' ";
      

      $sql="SELECT ROUND(SUM(ttd.amount * ttd.ex_rate),2) as av_gst FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."trans_tax_details ttd ON dt.type=ttd.trans_type AND dt.trans_no=ttd.trans_no WHERE dt.type='11' AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND dt.dimension_id=".db_escape($dim1)." ";

   //  display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}


function getZeroRated($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2' ";
            
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}

/*function getZeroRatedSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='2'";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ($row[0]-getZeroRatedCraditNoteSupplies($from, $to)); 
}*/
function getZeroRatedSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql = "SELECT 
SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
FROM ".TB_PREF."debtor_trans AS dt 
LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
WHERE dt.type = '10' 
AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
AND sm.tax_type_id = 3";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ($row['tot_amount']-getZeroRatedCraditNoteSupplies($from, $to)); 
}

function getZeroRatedCraditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT 
SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
FROM ".TB_PREF."debtor_trans AS dt 
LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
WHERE dt.type = '11' 
AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
AND sm.tax_type_id = 3";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row['tot_amount']; 
}

function ExemptSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

   /* $sql .= "SELECT SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount FROM ".TB_PREF."debtor_trans_details AS dtd LEFT JOIN ".TB_PREF."stock_master AS sm ON  sm.stock_id = dtd.stock_id WHERE dtd.debtor_trans_type = 10 AND sm.tax_type_id = 2";*/
        $sql = "SELECT 
        SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
        FROM ".TB_PREF."debtor_trans AS dt 
        LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
        LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
        WHERE dt.type = '10' 
        AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
        AND sm.tax_type_id = 2";
    
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-ExemptCreditNoteSupplies($from, $to) ) ; 
}

function ExemptCreditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT 
        SUM((dtd.unit_price-dtd.discount_percent)*dtd.quantity) AS tot_amount 
        FROM ".TB_PREF."debtor_trans AS dt 
        LEFT JOIN  ".TB_PREF."debtor_trans_details AS dtd ON  dt.trans_no = dtd.debtor_trans_no AND dtd.debtor_trans_type = dt.type
        LEFT JOIN ".TB_PREF."stock_master AS sm ON sm.stock_id = dtd.stock_id 
        WHERE dt.type = '11' 
        AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate'
        AND sm.tax_type_id = 2";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}

/*function ExemptSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='10' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='3' ";
    
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return ( $row[0]-ExemptCreditNoteSupplies($from, $to) ) ; 
}

function ExemptCreditNoteSupplies($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT SUM(net_amount*ex_rate) FROM ".TB_PREF."trans_tax_details  WHERE trans_type='11' AND   tran_date >= '$fromdate'
            AND tran_date <= '$todate' AND tax_type_id='3' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row[0]; 
}*/






function SuppAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND(SUM(st.ov_gst*st.rate),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import_amount=0 AND   st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function SuppCreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*st.rate ) ) ,2) as amount , ROUND( ABS (SUM(st.ov_gst*st.rate) ),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}
function get_import_supp_invoices($from, $to){
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = "SELECT sum(ov_amount) as payable, sum(ov_gst) as tax_amount  FROM ".TB_PREF."supp_trans WHERE type = 20 AND import = 1 AND tran_date >= '".$from."' AND tran_date <= '".$to."' AND ov_gst != 0";
    // display_error($sql);
    $run = db_query($sql);
    return db_fetch($run);

}

function get_import_amount_supp_inv($from, $to){
    $from = date2sql($from);
    $to = date2sql($to);
//     $sql = "SELECT SUM(
// ) as Import_amount FROM ".TB_PREF."supp_trans WHERE type = 20 AND import = 1 AND tran_date >= '".$from."' AND tran_date <= '".$to."'";
    $sql = "SELECT SUM(st.import_amount) AS import_amount ,SUM(st.import_amount*(SELECT rate FROM ".TB_PREF."tax_types WHERE id = (SELECT tax_group_id FROM ".TB_PREF."suppliers WHERE supplier_id = st.supplier_id))/100) AS import_tax FROM ".TB_PREF."supp_trans AS st WHERE st.type = 20 AND st.import = 1 AND st.tran_date >= '".$from."' AND st.tran_date <= '".$to."'";
    // display_error($sql);
    $run = db_query($sql);
    return db_fetch($run);

}

function Supp_Imported_AmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(  SUM((ov_amount-ov_discount)*st.rate ) ,2) as amount , ROUND(SUM(ov_gst*st.rate),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1' AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
         //    display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

function Supp_Imported_CreditAmountAndVAt($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( ABS( SUM((ov_amount-ov_discount)*ex_rate ) ) ,2) as amount , ROUND( ABS (SUM(ov_gst*st.rate) ),2) as supp_vat FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'  AND st.import=1 AND  st.type='21' AND   st.tran_date >= '$fromdate'
            AND st.tran_date <= '$todate' ";
            // display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function Supp_Import_Amount_own_useable($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND(SUM((import_amount)*st.rate),2) as import_amt  FROM ".TB_PREF."supp_trans st
     LEFT JOIN ".TB_PREF."trans_tax_details ttd ON st.type=ttd.trans_type AND st.trans_no=ttd.trans_no WHERE  ttd.tax_type_id='1'AND st.import_amount!=0 AND st.type='20' AND st.import=1  AND  st.tran_date >= '$fromdate'  AND st.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}


function tourist_amount_vat($from, $to)
{
    $fromdate = date2sql($from);
    $todate = date2sql($to);

    $sql .= "SELECT ROUND( SUM((dt.ov_amount-dt.ov_discount)*dt.rate ) ,2) as amount , ROUND(SUM(dt.ov_gst*dt.rate),2) as vat FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."cust_allocations ca on dt.trans_no=ca.trans_no_to AND dt.type=ca.trans_type_to WHERE dt.type='10' AND ca.trans_type_from='1'  AND  dt.tran_date >= '$fromdate'  AND dt.tran_date <= '$todate' ";
      //   display_error($sql);
     $result=db_query($sql);
     $row=db_fetch($result);
     return $row; 
}

   function get_excise_tax_data($from,$to,$type_id){
        $from = date2sql($from);
        $to = date2sql($to);
        $sql = "SELECT SUM(`net_amount`) AS amount , SUM(`amount`) AS tax FROM `".TB_PREF."trans_tax_details` WHERE (`tax_type_id` = '3' OR `tax_type_id` = '4') AND `tran_date` >= '$from' AND `tran_date`<= '$to' AND `excise_tax_type` = '$type_id'";
        $run = db_query($sql);
        return db_fetch($run);
    }

//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
  $orientation = $_POST['PARAM_2'];
  $destination = $_POST['PARAM_3'];
  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_excise_tax_return_report.inc");

  $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 60, 120, 180, 240, 340, 400, 460, 520);

    $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
      _('Type'), _('#'), _('Action'), _('Amount'));

    $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'right');

  $usr = get_user($user);
  $user_id = $usr['user_id'];
    $params =   array(  0 => $comments,
                1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
                      2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
                      3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));

    $rep = new FrontReport(_('Ecxise Tax Return'), "EcxiseTaxReturn", user_pagesize(), 8, $orientation);
    if ($orientation == 'L')
      recalculate_cols($cols);

    $rep->Font();

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);
    $rep->NewPage();


    //$trans = getTransactions($from, $to, $systype, $user);
    $companyCol = $rep->endLine - 150;
    $titleCol = $rep->leftMargin + 130;
    $col1 = $rep->leftMargin + 280;
    $col2 = $rep->leftMargin + 410;
    $col4 = $rep->leftMargin + 440;
    $amount_col=160;
    $rep->row=$rep->row+10;
    $rep->leftMargin=$rep->leftMargin-10;
    
    if ($rep->l['a_meta_dir'] == 'rtl'){
        $rep->row += 10;
    $rep->fontSize += 4;
    $rep->SetFont('dejavusans', '', '', '', true);
    // $rep->SetFont('helvetica', 'B', '', '', true);
    $rep->Text($rep->leftMargin+200,  _("Ecxise Tax Return"), $companyCol);
    // $rep->SetFont('helvetica', '', '', '', true);
    $rep->fontSize -= 4;
    $rep->row -= 10;
    }else{
       $rep->row += 10;
    $rep->fontSize += 4;
    $rep->SetFont('helvetica', 'B', '', '', true);
    $rep->Text($rep->leftMargin+200,  _("Ecxise Tax Return"), $companyCol);
    $rep->SetFont('helvetica', '', '', '', true);
    $rep->fontSize -= 4;
    $rep->row -= 10; 
    }
    

   

 $rep->row += 130;
$box_alignment = -150;
if ($rep->l['a_meta_dir'] == 'rtl')
    $amt_align = 40;

    //-----------------------work start for Taxable Person Detail heading table zubair--------------------------------
         $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 210+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 240+$box_alignment, 555, 340,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Taxable Person Details"), $companyCol,0,160);
        $rep->fontSize -= 3;
        $rep->Text($rep->leftMargin+20, _("Tax Agent Name"), $companyCol,0,190);
        $rep->RoundedRect(50, 265+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->company['tax_agent_name'], $companyCol,0,210);
  // //       
        $rep->Text($rep->leftMargin+20, _("Tax Agent Accreditation Number (TAAN)"), $companyCol,0,230);
        $rep->RoundedRect(50, 305+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30,$rep->company['taan'] , $companyCol,0,250);

        $rep->Text($rep->leftMargin+20, _("Tax Agency Name"), $companyCol+40,0,270);
        $rep->RoundedRect(50, 345+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30   ,$rep->company['tax_agency_name'],$companyCol+140,0,290);
        // $rep->TextWrap(310, 655, 250,$_SESSION['SysPrefs']->prefs['arabic_coy_name'], 'right'); 

        $rep->Text($rep->leftMargin+20, _("Tax Agency Number(TAN)"), $companyCol,0,310);
        $rep->RoundedRect(50, 385+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+30   ,$rep->company['tan'],$companyCol+140,0,330);

          $rep->Text($rep->leftMargin+20, _("Tax Registration Number (TRN)"), $companyCol,0,310+40);
        $rep->RoundedRect(50, 385+$box_alignment+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+30  ,$rep->company['gst_no'],$companyCol+140,0,310+40+20);

          $rep->Text($rep->leftMargin+20, _("Name of Business (English)"), $companyCol,0,310+40+40);
        $rep->RoundedRect(50, 385+$box_alignment+40+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+30   ,$rep->company['coy_name'],$companyCol+140,0,310+40+40+20);

          $rep->Text($rep->leftMargin+20, _("Name of Business (Arabic)"), $companyCol,0,310+40+40+40);
        $rep->RoundedRect(50, 385+$box_alignment+40+40+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
           $rep->Font();
         $rep->Text($rep->leftMargin+30   ,$rep->company['arabic_coy_name'],$companyCol+140,0,310+40+40+40+20);

        $rep->Text($rep->leftMargin+295, _("Taxable Person Address"), $companyCol,0,190);
        $rep->RoundedRect(325, 265+$box_alignment, 250,60,2.25, '1111','DF',null,array(242, 242, 242));
        $old_row=$rep->row;
        $rep->row=717;
        $rep->TextWrapLines($rep->leftMargin+305,500,$rep->company['postal_address']);
        // $rep->Text($rep->leftMargin+20,$rep->company['postal_address'], $companyCol,0,310);
        $rep->row=$old_row;
       



        $rep->Text($rep->leftMargin+295, _("Building name and number"), $companyCol+40,0,270);
        $rep->RoundedRect(325, 345+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305   ,$rep->company['build_name'],$companyCol+140,0,290);

         $rep->Text($rep->leftMargin+295, _("Street"), $companyCol+40,0,310);
        $rep->RoundedRect(325, 385+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+305   ,$rep->company['street'],$companyCol+140,0,330);


          $rep->Text($rep->leftMargin+295, _("Area"), $companyCol,0,310+40);
        $rep->RoundedRect(325, 385+$box_alignment+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+305  ,$rep->company['area'],$companyCol+140,0,310+40+20);

          $rep->Text($rep->leftMargin+295, _("City"), $companyCol,0,310+40+40);
        $rep->RoundedRect(325, 385+$box_alignment+40+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+305   ,$rep->company['city'],$companyCol+140,0,310+40+40+20);

          $rep->Text($rep->leftMargin+295, _("Emirate"), $companyCol,0,310+40+40+40);
        $rep->RoundedRect(325, 385+$box_alignment+40+40+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+305   ,$rep->company['emirate'],$companyCol+140,0,310+40+40+40+20);

          $rep->Text($rep->leftMargin+295, _("Country"), $companyCol,0,310+40+40+40+40);
        $rep->RoundedRect(325, 385+$box_alignment+40+40+40+40, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
         $rep->Text($rep->leftMargin+305   ,get_country_name($rep->company['country']),$companyCol+140,0,310+40+40+40+20+40);


    //-----------------------work end for Taxable Person Detail heading table zubair--------------------------------

    //-----------------------Exicise Tax Return Period------------
    $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
         $rep->RoundedRect(30, 590+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 620+$box_alignment, 555, 55,0, '0000','DF',null,array(255, 255, 255));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Excise Tax Return Period"), $companyCol,0,540);
        $rep->fontSize -= 3;

        $rep->Text($rep->leftMargin+20, _("Excise Tax Return Period"), $companyCol+40,0,565);
        $rep->RoundedRect(50, 640+$box_alignment, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+30   ,date('d-m-Y',strtotime(date2sql($rep->from))) ." - ".date('d-m-Y',strtotime(date2sql($rep->to))),$companyCol+140,0,585);
    //-----------------------Exicise Tax Return Period End------------

    //----------------------Calculatio of Excise Tax due------------
        $total_excise_goods_amt = 0;
        $total_excise_goods_tax = 0;
        $total_payable_tax_amt = 0;
        $total_payable_tax = 0;

        $box_alignment = -75;
        $amount_col = 180;
         $rep->RoundedRect(30, 610+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 640+$box_alignment, 555, 240,0, '0000','DF',null,array(255, 255, 255));
      
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("Calculation of Excise Tax due"), $companyCol,0,635);
        $rep->fontSize -= 3;
          

    $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(210, 210, 210)));


          // $rep->Text($rep->leftMargin+250, _("Amount(AED)"), $companyCol,0,670);
          $rep->Text($rep->leftMargin+320, _("Value of Excise Goods (AED)"), $companyCol+40,0,670);
           $rep->Text($rep->leftMargin+440,_("Excise Tax due (AED)"), $companyCol,0,670);
              
$text_box_alignment = 52;

$rep->Text($rep->leftMargin+15, _("Importation of Excise Goods from outside of UAE"), $companyCol,0,690);

// $rep->RoundedRect(280, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));     
//                $rep->TextWrap(260, $amount_col+$text_box_alignment, 100,number_format(getTransactionsAmount($from, $to,1),2) , 'right');
        // getPurchaseExciseData($from, $to);
    $rep->RoundedRect(360, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment, 100,number_format(getPurchaseExciseDataImport($from, $to)['excise_price']-abs(getPurchaseExciseDataImportCredit($from, $to)['excise_price']),2), 'right');
    $total_excise_goods_amt = $total_excise_goods_amt + (getPurchaseExciseDataImport($from, $to)['excise_price']-abs(getPurchaseExciseDataImportCredit($from, $to)['excise_price']));
   
    $rep->RoundedRect(470, 670+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment, 100,number_format(getPurchaseExciseDataImport($from, $to)['excise_tax']-abs(getPurchaseExciseDataImportCredit($from, $to)['excise_tax']),2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (getPurchaseExciseDataImport($from, $to)['excise_tax']-abs(getPurchaseExciseDataImportCredit($from, $to)['excise_tax']));

    $rep->Text($rep->leftMargin+15, _("Production of Excise Goods within UAE"), $companyCol,0,690+30);
    $rep->RoundedRect(360, 670+$box_alignment+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30, 100,number_format(getPurchaseExciseData($from, $to)['excise_price']-abs(getPurchaseExciseDataCredit($from, $to)['excise_price']),2), 'right');
     $total_excise_goods_amt = $total_excise_goods_amt + (getPurchaseExciseData($from, $to)['excise_price']-abs(getPurchaseExciseDataCredit($from, $to)['excise_price']));
   
    $rep->RoundedRect(470, 670+$box_alignment+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30, 100,number_format(getPurchaseExciseData($from, $to)['excise_tax']-abs(getPurchaseExciseDataCredit($from, $to)['excise_tax']),2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (getPurchaseExciseData($from, $to)['excise_tax']-abs(getPurchaseExciseDataCredit($from, $to)['excise_tax']));

    // getPurchaseHasDesignated($from, $to);
    $rep->Text($rep->leftMargin+15, _("Release of Excise Goods from a Designated Zone"), $companyCol,0,690+30+30);
    $rep->RoundedRect(360, 670+$box_alignment+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30, 100,number_format(getPurchaseHasDesignated($from, $to)['amount'],2), 'right');
     $total_excise_goods_amt = $total_excise_goods_amt + (getPurchaseHasDesignated($from, $to)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30, 100,number_format(getPurchaseHasDesignated($from, $to)['tax'],2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (getPurchaseHasDesignated($from, $to)['tax']);
 
    $rep->Text($rep->leftMargin+15, _("Stockpiling of Excise Goods in the UAE, including"), $companyCol,0,690+30+30+30);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30, 100,number_format(0,2), 'right');
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30, 100,number_format(0,2), 'right');


    $rep->Text($rep->leftMargin+15, _("A) Tobacco and tobacco products"), $companyCol,0,690+30+30+30+30);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,1)['amount'],2), 'right');
    $total_excise_goods_amt = $total_excise_goods_amt + (get_excise_tax_data($from,$to,1)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,1)['tax'],2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (get_excise_tax_data($from,$to,1)['tax']);

    $rep->Text($rep->leftMargin+15, _("B) Carbonated drinks"), $companyCol,0,690+30+30+30+30+30);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,2)['amount'],2), 'right');
    $total_excise_goods_amt = $total_excise_goods_amt + (get_excise_tax_data($from,$to,2)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,2)['tax'],2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (get_excise_tax_data($from,$to,2)['tax']);

    $rep->Text($rep->leftMargin+15, _("C) Energy drinks"), $companyCol,0,690+30+30+30+30+30+30);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,3)['amount'],2), 'right');
    $total_excise_goods_amt = $total_excise_goods_amt + (get_excise_tax_data($from,$to,3)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,3)['tax'],2), 'right');
    $total_excise_goods_tax = $total_excise_goods_tax + (get_excise_tax_data($from,$to,3)['tax']);
    //-----------------new page--------------------------------
    $rep->NewPage();
    
    $box_alignment = -750;
    $text_box_alignment = 730;
     $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
     // $rep->RoundedRect(30, 470+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

     $rep->RoundedRect(30, 780+$box_alignment, 555, 200,0, '0000','DF',null,array(255, 255, 255));
     $rep->SetFont('helvetica','B','','',true);
     $rep->SetFont('dejavusans', '', '', '', true);
   $rep->Text($rep->leftMargin+15, _("Total value of Excise Goods/Due Tax"), $companyCol,0,-123+30+30+30+30);
   $rep->SetFont('helvetica','','','',true);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30, 100,number_format($total_excise_goods_amt,2), 'right');
    $total_payable_tax_amt = $total_payable_tax_amt+$total_excise_goods_amt;
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30, 100,number_format($total_excise_goods_tax,2), 'right');
    $total_payable_tax = $total_payable_tax + $total_excise_goods_tax;


     $rep->SetFont('helvetica','B','','',true);
     $rep->SetFont('dejavusans', '', '', '', true);
    $rep->Text($rep->leftMargin+15, _("Value of Tax declared in error and identified in the same month"), $companyCol,0,-123+30+30+30+30+30);
     $rep->SetFont('helvetica','','','',true);
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,4)['amount'],2), 'right');
    $total_payable_tax_amt = $total_payable_tax_amt + (get_excise_tax_data($from,$to,4)['amount']);

    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,4)['tax'],2), 'right');
    $total_payable_tax = $total_payable_tax + (get_excise_tax_data($from,$to,4)['tax']);
    
    if ($rep->l['a_meta_dir'] == 'rtl'){
         $rep->SetFont('dejavusans', '', '', '', true);
    $rep->Text($rep->leftMargin+15, _("Value of Deductible Tax for Tax paid in error (which is below AED 10,000)"), $companyCol,0,-123+30+30+30+30+30+30);

    }else{
         $rep->SetFont('helvetica','B','','',true);
    $rep->Text($rep->leftMargin+15, _("Value of Deductible Tax for Tax paid in error (which is below AED 10,000)"), $companyCol,0,-123+30+30+30+30+30+30);
     $rep->SetFont('helvetica','','','',true);
    }
    
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,5)['amount'],2), 'right');
    $total_payable_tax_amt = $total_payable_tax_amt + (get_excise_tax_data($from,$to,5)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,5)['tax'],2), 'right');
    $total_payable_tax = $total_payable_tax + (get_excise_tax_data($from,$to,5)['tax']);
    
    if ($rep->l['a_meta_dir'] == 'rtl'){
        $rep->SetFont('dejavusans', '', '', '', true);
         $rep->Text($rep->leftMargin+15, _("Value of other Deductible Tax"), $companyCol,0,-123+30+30+30+30+30+30+30);
    }else{
       
        $rep->SetFont('helvetica','B','','',true);
    $rep->Text($rep->leftMargin+15, _("Value of other Deductible Tax"), $companyCol,0,-123+30+30+30+30+30+30+30);
     $rep->SetFont('helvetica','','','',true);
    }
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,6)['amount'],2), 'right');
    $total_payable_tax_amt = $total_payable_tax_amt + (get_excise_tax_data($from,$to,6)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,6)['tax'],2), 'right');
    $total_payable_tax = $total_payable_tax + (get_excise_tax_data($from,$to,6)['tax']);
    if ($rep->l['a_meta_dir'] == 'rtl'){
        $rep->SetFont('dejavusans', '', '', '', true);
        $rep->Text($rep->leftMargin+15, _("Value of under declared Tax for the previous tax period"), $companyCol,0,-123+30+30+30+30+30+30+30+30-5);
    $rep->Text($rep->leftMargin+15, _("(which is above AED 10,000)"), $companyCol,0,-123+30+30+30+30+30+30+30+30+5);
    }else{
     $rep->SetFont('helvetica','B','','',true);
    $rep->Text($rep->leftMargin+15, _("Value of under declared Tax for the previous tax period"), $companyCol,0,-123+30+30+30+30+30+30+30+30-5);
    $rep->Text($rep->leftMargin+15, _("(which is above AED 10,000)"), $companyCol,0,-123+30+30+30+30+30+30+30+30+5);
     $rep->SetFont('helvetica','','','',true);
    }
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,7)['amount'],2), 'right');
    $total_payable_tax_amt = $total_payable_tax_amt + (get_excise_tax_data($from,$to,7)['amount']);
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30-30-30-30, 100,number_format(get_excise_tax_data($from,$to,7)['tax'],2), 'right');
    $total_payable_tax = $total_payable_tax + (get_excise_tax_data($from,$to,7)['tax']);
    
    if ($rep->l['a_meta_dir'] == 'rtl'){
        $rep->SetFont('dejavusans', '', '', '', true);
        $rep->Text($rep->leftMargin+15, _("Total value of Payable Tax(Excess Refundable Tax)"), $companyCol,0,-123+30+30+30+30+30+30+30+30+30);
    }else{
        $rep->SetFont('helvetica','B','','',true);
        $rep->Text($rep->leftMargin+15, _("Total value of Payable Tax(Excess Refundable Tax)"), $companyCol,0,-123+30+30+30+30+30+30+30+30+30);
        $rep->SetFont('helvetica','','','',true);
    }
     
    $rep->RoundedRect(360, 670+$box_alignment+30+30+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+340, $amount_col+$text_box_alignment-30-30-30-30-30-30-30-30-30, 100,number_format( $total_payable_tax_amt,2), 'right');
   
    $rep->RoundedRect(470, 670+$box_alignment+30+30+30+30+30+30+30+30+30, 85,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap($amt_align+450, $amount_col+$text_box_alignment-30-30-30-30-30-30-30-30-30, 100,number_format( $total_payable_tax,2), 'right');


    //----------------------Calculatio of Excise Tax due End------------

    //---------------------Declaration----------------------------------
    $box_alignment = -210;
    $text_box_alignment = -215;
    $text_alignment = 100;
    $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
     $rep->RoundedRect(30, 450+$box_alignment, 555, 30,0, '0000','DF',null,array(242, 242, 242));

    $rep->RoundedRect(30, 480+$box_alignment, 555, 390,0, '0000','DF',null,array(255, 255, 255));
    $rep->fontSize += 3;
    $rep->Text($rep->leftMargin+15, _("Declaration"), $companyCol,0,105+$text_alignment);
    $rep->fontSize -= 3;

    $rep->Text($rep->leftMargin+15, _("I declare that all information provided is true, accurate and complete"), $companyCol,0,150+$text_alignment);
    $rep->Text($rep->leftMargin+15, _("to the best of my knowledge and belief."), $companyCol,0,160+$text_alignment);
    // $rep->RoundedRect(360, 320+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
    // $rep->TextWrap(340, $amount_col+$text_box_alignment, 100,number_format(0,2), 'right');
   
    $rep->RoundedRect(430, 510+$box_alignment, 12,12,3, '1111','DF',null,array(255, 255, 255));
      if ($rep->l['a_meta_dir'] == 'rtl'){
         if ($rep->company['declare_y_n']) {
            $check_mark = company_path() . "/images/checkmark.png";
            $rep->AddImage($check_mark, $ccol+155, $rep->row-255, 0, 10);
        } 
      }else{
         if ($rep->company['declare_y_n']) {
            $check_mark = company_path() . "/images/checkmark.png";
            $rep->AddImage($check_mark, $ccol+430, $rep->row-255, 0, 10);
        } 
      }
    
     // $rep->RoundedRect(470, 500+$box_alignment, 85,22,3, '1111','DF',null,array(255, 255, 255));
    // $rep->TextWrap(450, 570+$amount_col+$text_box_alignment, 100,number_format(0,2), 'right');

    $rep->Text($rep->leftMargin+15, _("Are you, as the Online User, making this declaration?"), $companyCol,0,180+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment, 100,($rep->company['online_name'])?'Y':'N', 'right');

    $rep->Text($rep->leftMargin+15, _("Online User name (English)"), $companyCol,0,180+30+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+30, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-30, 100,$rep->company['online_name'], 'right');

    $rep->Text($rep->leftMargin+15, _("Online User name (Arabic)"), $companyCol,0,180+60+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+60, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->Font();
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-60, 100,$rep->company['online_arabic_name'], 'right');
    // $rep->Text($rep->leftMargin+455,$rep->company['online_arabic_name'], $companyCol,0,180+60+$text_alignment);

    $rep->Text($rep->leftMargin+15, _("Declarant name (English)"), $companyCol,0,180+60+30+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+60+30, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-60-30, 100,$rep->company['dec_name'], 'right');

    $rep->Text($rep->leftMargin+15, _("Declarant name (Arabic)"), $companyCol,0,180+60+60+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+60+60, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->Font();
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-60-60, 100,$rep->company['dec_arabic_name'], 'right');

    $rep->Text($rep->leftMargin+15, _("Emirates Identity number"), $companyCol,0,180+60+90+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+60+90, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-60-90, 100,$rep->company['dec_emirate_id'], 'right');

    $rep->Text($rep->leftMargin+15, _("Passport number (if no Emirates ID availabel)"), $companyCol,0,180+90+90+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+90+90, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-90-90, 100,$rep->company['dec_pass_no'], 'right');


    $rep->Text($rep->leftMargin+15, _("Declarant mobile country code"), $companyCol,0,180+90+90+30+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+90+90+30, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-90-90-30, 100,$rep->company['dec_count_code'], 'right');


    $rep->Text($rep->leftMargin+15, _("Declarant mobile number"), $companyCol,0,180+90+90+60+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+90+90+60, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-90-90-60, 100,$rep->company['dec_mobile'], 'right');

     $rep->Text($rep->leftMargin+15, _("Email address"), $companyCol,0,180+90+90+90+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+90+90+90, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-90-90-90, 100,$rep->company['dec_email'], 'right');

     $rep->Text($rep->leftMargin+15, _("Submission Date"), $companyCol,0,180+90+90+120+$text_alignment);
    $rep->RoundedRect(430, 530+$box_alignment+90+90+120, 125,22,3, '1111','DF',null,array(255, 255, 255));
    $rep->TextWrap(450, 540+$amount_col+$text_box_alignment-90-90-120, 100,date('d-m-Y',strtotime(date2sql($rep->company['sub_date']))), 'right');
    //---------------------Declaration END----------------------------------


    $rep->End();
}

