<?php

$page_security = 'SA_GLANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_audit_trail();

//----------------------------------------------------------------------------------------------------
function get_invoice_aginst_delivery($trans_no,$trans_type){
    if ($trans_type == 25) {
        $sql = "SELECT supp_trans_no FROM `0_supp_invoice_items` WHERE po_detail_item_id IN(SELECT po_detail_item FROM 0_purch_order_details WHERE order_no IN (SELECT purch_order_no FROM 0_grn_batch WHERE id='$trans_no')) AND unit_price != '0'";
    }
    $run = db_query($sql);
    return db_fetch($run)[0];
}

function get_references($trans_no,$trans_type){
            if ($trans_type == 25) {
                $sql = "SELECT reference FROM 0_refs WHERE id = '".get_invoice_aginst_delivery($trans_no,$trans_type)."' AND type = '20'";  
            }else{     
                $sql = "SELECT reference FROM 0_refs WHERE id = '$trans_no' AND type = '$trans_type'";
            }
            // display_error($sql);
            $run = db_query($sql);
            return db_fetch($run)[0];
 };
function ST_listing($from,$to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
 /* $sql="SELECT sm.loc_code, sm.stock_id, sm.trans_no,sm.type,sm.tran_date ,ttd.tax_type_id,ttd.rate FROM 0_stock_moves AS sm LEFT JOIN 0_trans_tax_details AS ttd ON ttd.trans_no = sm.trans_no
WHERE ttd.tax_type_id = '3' AND sm.tran_date >= '$fromdate' AND sm.tran_date <= '$todate' GROUP BY sm.trans_no,sm.type";*/
  /*$sql="SELECT sm.loc_code, sm.stock_id, sm.trans_no,sm.type,sm.tran_date
,ttd.tax_type_id,ttd.rate 
FROM 0_stock_moves AS sm 
LEFT JOIN 0_grn_items AS gi ON gi.grn_batch_id = sm.trans_no
LEFT JOIN 0_purch_order_details AS pod ON pod.po_detail_item = gi.po_detail_item
LEFT JOIN 0_supp_invoice_items AS sii ON sii.po_detail_item_id = pod.po_detail_item AND sii.grn_item_id = gi.id
LEFT JOIN 0_trans_tax_details AS ttd ON ttd.trans_no = sii.supp_trans_no AND ttd.trans_type = sii.supp_trans_type AND ttd.amount != 0
WHERE 
ttd.tax_type_id = '3'  AND sm.tran_date >= '$fromdate' AND sm.tran_date <= '$todate' ";*/
$sql = "SELECT * FROM (SELECT sm.loc_code, sm.stock_id, sm.trans_no,sm.type,sm.tran_date ,ttd.tax_type_id,ttd.rate 
FROM 0_stock_moves AS sm   
LEFT JOIN 0_grn_items AS gi ON gi.grn_batch_id = sm.trans_no 
LEFT JOIN 0_purch_order_details AS pod ON pod.po_detail_item = gi.po_detail_item 
LEFT JOIN 0_supp_invoice_items AS sii ON sii.po_detail_item_id = pod.po_detail_item AND sii.grn_item_id = gi.id 
LEFT JOIN 0_trans_tax_details AS ttd ON ttd.trans_no = sii.supp_trans_no AND ttd.trans_type = sii.supp_trans_type AND ttd.amount != 0 
WHERE ttd.tax_type_id = '3' AND sm.tran_date >= '$fromdate' AND sm.tran_date <= '$todate') AS tbl_1
UNION
SELECT * FROM (SELECT sm.loc_code, sm.stock_id, sm.trans_no,sm.type,sm.tran_date ,ttd.tax_type_id,ttd.rate 
FROM 0_stock_moves AS sm 
LEFT JOIN 0_trans_tax_details AS ttd ON ttd.trans_no = sm.trans_no AND (ttd.trans_type = 13 OR ttd.trans_type = 11 OR ttd.trans_type = 21)AND ttd.amount != 0   
WHERE (ttd.tax_type_id = '3' OR ttd.tax_type_id='4') AND sm.tran_date >= '$fromdate' AND sm.tran_date <= '$todate') AS tbl_2";
//   display_error($sql);
 return db_query($sql);
}
function getPurchaseListing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT st.supplier_id,st.tran_date,std.supp_trans_no,st.reference ,std.description,std.unit_price*std.quantity AS unit_price,ttd.amount AS unit_tax,std.stock_id,ttd.* FROM ".TB_PREF."supp_trans st LEFT JOIN ".TB_PREF."supp_invoice_items std on std.supp_trans_no=st.trans_no AND std.supp_trans_type=st.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=std.supp_trans_type AND ttd.trans_no=std.supp_trans_no AND (ttd.trans_type=20 OR ttd.trans_type=21)   WHERE  (ttd.tax_type_id='3' OR ttd.tax_type_id='4' ) AND ttd.net_amount != 0 AND st.tran_date >= '$fromdate' AND st.tran_date <= '$todate'";
//   display_error($sql);
 return db_query($sql);
}
function  getSalesListing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT dt.debtor_no,dt.tran_date,dtd.debtor_trans_no,dtd.description,(dtd.unit_price*dtd.quantity)-dtd.discount_percent AS unit_price, IF(dtd.unit_tax > 0,(((dtd.unit_price*dtd.quantity)-dtd.discount_percent)*ttd.rate)/100,dtd.unit_tax) AS unit_tax,dt.country,dtd.stock_id,ttd.* FROM ".TB_PREF."debtor_trans dt LEFT JOIN ".TB_PREF."debtor_trans_details dtd on dtd.debtor_trans_no =dt.trans_no AND dtd.debtor_trans_type=dt.type LEFT JOIN ".TB_PREF."trans_tax_details ttd on ttd.trans_type=dt.type AND ttd.trans_no=dt.trans_no AND (ttd.trans_type=10 OR ttd.trans_type=11)  WHERE (dt.type=10 OR dt.type=11) AND dt.tran_date >= '$fromdate' AND dt.tran_date <= '$todate' AND ttd.net_amount != 0 AND (ttd.tax_type_id = '3'  OR ttd.tax_type_id='4') #GROUP BY dtd.id";
// display_error($sql);
 return db_query($sql);
}
function  GL_Listing($from, $to){
  $fromdate = date2sql($from);
  $todate = date2sql($to);
  $sql="SELECT gl.tran_date, gl.account,gl.type,gl.type_no,gl.amount FROM ".TB_PREF."gl_trans as gl WHERE gl.tran_date >= '$fromdate' AND gl.tran_date <= '$todate' AND (account = '2390' OR account = '2391')";
// display_error($sql);

 return db_query($sql);
}

function  get_trans_cust_name($type, $trans_no){

  $sql="SELECT * FROM ".TB_PREF."debtor_trans WHERE type=".db_escape($type)." AND trans_no=".db_escape($trans_no);
   $res = db_query($sql);
   $row  = db_fetch($res);
   return $row['debtor_no'];
}

function  get_trans_supp_name($type, $trans_no){

  $sql="SELECT * FROM ".TB_PREF."supp_trans WHERE type=".db_escape($type)." AND trans_no=".db_escape($trans_no);
   $res = db_query($sql);
   $row  = db_fetch($res);

   return $row['supplier_id'];
}



//----------------------------------------------------------------------------------------------------

function print_audit_trail()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
  $orientation = $_POST['PARAM_2'];
  $destination = $_POST['PARAM_3'];
  if ($destination)
    include_once($path_to_root . "/reporting/includes/excel_report.inc");
  else
    include_once($path_to_root . "/reporting/includes/pdf_vat_FAT.inc");

  $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();


    // $headers = array(_('Date'), _('Time'), _('User'), _('Trans Date'),
    //   _('Type'), _('#'), _('Action'), _('Amount'));

    // $aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'right');

  // $usr = get_user($user);
  // $user_id = $usr['user_id'];
  //   $params =   array(  0 => $comments,
  //               1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
  //                     2 => array('text' => _('Type'), 'from' => ($systype != -1 ? $systypes_array[$systype] : _('All')), 'to' => ''),
  //                     3 => array('text' => _('User'), 'from' => ($user != -1 ? $user_id : _('All')), 'to' => ''));

    $rep = new FrontReport(_('VAT201 - VAT Returns'), "AuditTrail", user_pagesize(), 6, 'L');
    if ($orientation == 'L')
      recalculate_cols($cols);

    $rep->Font();

      $cols = array(5, 100, 175, 230,275,320, 355,440,530,600,640,685,740);
      // $headers = array(_('Supplier Name'), _('Supplier TIN/TRN'), _('Invoice Date'), _('Invoice No')
        // , _('Permit No'), _('Line No') );
    $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);
    $rep->NewPage();


 

     
        $companyCol = $rep->endLine - 150;
        $titleCol = $rep->leftMargin + 130;
        $col1 = $rep->leftMargin + 280;
        $col2 = $rep->leftMargin + 410;
        $col4 = $rep->leftMargin + 440;
        $tcol=19;
        $tcol2=380;



//------------------------------------- First Side Start-----------------------------------------------

// $rep->row -= 10;
        $y_def= -50;

     $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(225, 225, 225)));
   // $rep->RoundedRect(30, 70, 783, 30,0, '0000','DF',null,array(242, 242, 242));
    $rep->RoundedRect(30, 20, 783, 30,0, '0000','DF',null,array(242, 242, 242));

        $rep->RoundedRect(30, 50, 783, 250,0, '0000','DF',null,array(255, 255, 255));
        
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("CompInfoStart"), $companyCol,0,$y_def+25);
        $rep->fontSize -= 3;
        $rep->Text($rep->leftMargin+45, _("TaxablePersonNameEn"), $companyCol,0,$y_def+55);
        $rep->RoundedRect(75, $y_def+125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55,$rep->company['coy_name'], $companyCol,0,$y_def+75);
  //    
        $rep->Text($rep->leftMargin+45, _("TaxablePersonNameAr"), $companyCol,0,$y_def+105-10);
        $rep->RoundedRect(75, $y_def+175-10, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55,$rep->company['arabic_coy_name'], $companyCol,0,$y_def+125-10);

        $rep->Text($rep->leftMargin+45, _("TRN"), $companyCol,0,$y_def+155-20);
        $rep->RoundedRect(75, $y_def+225-20, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55, $rep->company['gst_no'] , $companyCol,0,$y_def+175-20);

        $rep->Text($rep->leftMargin+45, _("TaxAgencyName"), $companyCol,0,$y_def+205-31);
        $rep->RoundedRect(75 , $y_def+275-31 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55,$rep->company['tax_agency_name'], $companyCol,0,$y_def+225-31);

        $rep->Text($rep->leftMargin+45, _("TAN"), $companyCol,0,$y_def+255-41);
        $rep->RoundedRect(75 , $y_def+325-41 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55,$rep->company['tan'], $companyCol,0,$y_def+275-41);

        $rep->Text($rep->leftMargin+45, _("TaxAgentName"), $companyCol,0,$y_def+305-51);
        $rep->RoundedRect(75 , $y_def+375-51 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+55,$rep->company['tax_agent_name'], $companyCol,0,$y_def+325-51);



        $rep->Text($rep->leftMargin+485, _("TAAN"), $companyCol,0,$y_def+55);
        $rep->RoundedRect(515, $y_def+125, 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,$rep->company['taan'], $companyCol,0,$y_def+75);
       
        $rep->Text($rep->leftMargin+485, _("PeriodStart"), $companyCol,0,$y_def+105-10);
        $rep->RoundedRect(515 , $y_def+175-10 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,date('d-m-Y',strtotime($from)), $companyCol,0,$y_def+125-10);
       
        $rep->Text($rep->leftMargin+485, _("PeriodEnd"), $companyCol,0,$y_def+155-20);
        $rep->RoundedRect(515 , $y_def+225-20 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,date('d-m-Y',strtotime(date2sql($to))), $companyCol,0,$y_def+175-20);

         $rep->Text($rep->leftMargin+485, _("FAFCreationDate"), $companyCol,0,$y_def+205-31);
        $rep->RoundedRect(515 , $y_def+275-31 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,date('d-m-Y'), $companyCol,0,$y_def+225-31);

        $rep->Text($rep->leftMargin+485, _("ProductVersion"), $companyCol,0,$y_def+255-41);
        $rep->RoundedRect(515 , $y_def+325-41 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,"WAYZERPv20.1", $companyCol,0,$y_def+275-41);

        $rep->Text($rep->leftMargin+485, _("FAFVersion"), $companyCol,0,$y_def+305-51);
        $rep->RoundedRect(515 , $y_def+375-51 , 250,20,2.25, '1111','DF',null,array(242, 242, 242));
        $rep->Text($rep->leftMargin+500,'FAFv1.0.0', $companyCol,0,$y_def+325-51);

        $rep->RoundedRect(30, 300, 783, 29,0, '0000','DF',null,array(242, 242, 242));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("CompInfoEnd"), $companyCol,0,$y_def+355-51 );
        $rep->fontSize -= 3;


   //------------------------------------Second Column----------------------------------------------------//


        /* $rep->RoundedRect(30, 450, 783, 29,0, '0000','DF',null,array(242, 242, 242));
        $rep->fontSize += 3;
        $rep->Text($rep->leftMargin+15, _("PurchDataStart"), $companyCol,0,355 );
        $rep->fontSize -= 3;*/

       $rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(128,128, 128)));
        // $rep->RoundedRect(30, 300, 555, 18,0, '0000');
   
        $rep->Line($rep->row-287,2);
       $rep->fontSize += 4;
       
        $rep->Text($rep->leftMargin+5, _("PurchDataStart"), $companyCol,0,395-91);
        $rep->fontSize -= 4;


         $rep->row=210;


   $trans = getPurchaseListing($from, $to);

 // : Set  1st  Header :   
           
      
         $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, _('SupplierName'),-2);
         $rep->TextCol(1, 2, _('SupplierTIN/TRN'),-2);
         $rep->TextCol(2, 3, _('InvoiceDate'),-2);
         $rep->TextCol(3, 4, _('InvoiceNo'),-2);
         $rep->TextCol(4, 5, _('PermitNo'),-2);
         $rep->TextCol(5, 6, _('LineNo'),-2);

         $rep->TextCol(6, 7, _('ProductDescription'),-2);
         $rep->TextCol(7, 8, _('PurchaseValueAED'),-2);
         $rep->TextCol(8, 9, _('ExciseTaxValueAED'),-2);
         $rep->TextCol(9, 10, _('TaxCode'),-2);
         $rep->TextCol(10, 11, _('FCYCode'),-2);
         $rep->TextCol(11, 12, _('PurchaseFCY'),-2);
         $rep->TextCol(12, 13, _('ExciseTaxFCY'),-2);
       

         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5);
         // $rep->row=450;
            $rep->NewLine(1.5);
 
            $trans_no=0;
            $line_no=1;
            $net_amount_supp_tot = 0;
            $amount_supp_tot = 0;
            $supp_count = 0;
    while ($myrow=db_fetch($trans))
    {
     
        // $rep->TextCol(0, 1, get_supplier($myrow['supplier_id'])['supp_name']);
       $oldrow = $rep->row;
        $rep->TextColLines(0, 1,get_supplier($myrow['supplier_id'])['supp_name'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
     
         $rep->TextCol(1, 2, get_supplier($myrow['supplier_id'])['gst_no'],-2);
        $rep->TextCol(2, 3, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
        $rep->TextCol(3, 4, $myrow['supp_trans_no'],-2);

  $rep->TextCol(4, 5, $myrow['supp_reference']);



         if($trans_no!=$myrow['supp_trans_no'])
         {
          $trans_no=$myrow['supp_trans_no'];
                 $line_no=1;
         }

        $rep->TextCol(5, 6, $line_no++,-2);

        // $rep->TextCol(6, 7, $myrow['description']);
        $oldrow = $rep->row;
        $rep->TextColLines(6, 7, $myrow['description'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        $net_amount_supp = $myrow['unit_price']*$myrow['ex_rate'];
        $rep->TextCol(7, 8, number_format($net_amount_supp,2),-2);
        $net_amount_supp_tot = $net_amount_supp_tot + $net_amount_supp;
        // display_error($myrow['exc_rate']);
        $tax_amount = $myrow['unit_tax']*$myrow['ex_rate'];
        if($myrow['trans_type'] == 21){
          $tax_amount = $tax_amount*-1; 
        }
        $rep->TextCol(8, 9, number_format($tax_amount,2),-2);
        $amount_supp_tot = $amount_supp_tot + $tax_amount;

        $rep->TextCol(9, 10, get_item_tax_type(get_item($myrow['stock_id'])['tax_type_id'])['tax_code'],-2);
        $rep->TextCol(10, 11, get_supplier($myrow['supplier_id'])['curr_code'],-2);

        if ($rep->company['curr_default'] == get_supplier($myrow['supplier_id'])['curr_code']) {
         $rep->TextCol(11, 12, '0.00',-2);
         $rep->TextCol(12, 13, '0.00',-2);
        }else{ 
         $rep->TextCol(11, 12, number_format($myrow['unit_price'],2));
         $rep->TextCol(12, 13, number_format($myrow['unit_tax'],2),-2);
        }

       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );
        $rep->row = min($newrow);
        unset($newrow);
        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight ))
        {
           $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
          $rep->TextCol(0, 1, _('SupplierName'),-2);
         $rep->TextCol(1, 2, _('SupplierTIN/TRN'),-2);
         $rep->TextCol(2, 3, _('InvoiceDate'),-2);
         $rep->TextCol(3, 4, _('InvoiceNo'),-2);
         $rep->TextCol(4, 5, _('PermitNo'),-2);
         $rep->TextCol(5, 6, _('LineNo'),-2);

         $rep->TextCol(6, 7, _('ProductDescription'),-2);
         $rep->TextCol(7, 8, _('PurchaseValueAED'),-2);
         $rep->TextCol(8, 9, _('ExciseTaxValueAED'),-2);
         $rep->TextCol(9, 10, _('TaxCode'),-2);
         $rep->TextCol(10, 11, _('FCYCode'),-2);
         $rep->TextCol(11, 12, _('PurchaseFCY'),-2);
         $rep->TextCol(12, 13, _('ExciseTaxFCY'),-2);

         $rep->fontSize -= 1;
           $rep->Line($rep->row-5);
            $rep->NewLine();
      
        }

         // $rep->NewLine();
    $supp_count++;
    }
        $rep->Line($rep->row);
        $rep->NewLine();
        $rep->fontSize += 4;
         $rep->TextCol(0, 9, _('PurchDataEnd'),-2);
        // $rep->Text($rep->leftMargin+5, _("PurchDataEnd"), $companyCol,0,395);
         $rep->fontSize -= 4;
        if ($rep->l['a_meta_dir'] == 'rtl'){
            $rep->fontSize += 1;
            $rep->SetFont('dejavusans', '', '', '', true);
            $rep->TextCol(5, 7, _('TransactionCountTotal: ').$supp_count,-2);
            // $rep->TextCol(5, 7, _('TransactionCountTotal: ').$supp_count,-2);
            $rep->AmountCol(7, 8, $net_amount_supp_tot, $dec);
            $rep->AmountCol(8, 9, $amount_supp_tot, $dec);
        //    $rep->AmountCol(10, 11, number_format2(abs($debit)-abs($Credit)), $dec);
            $rep->fontSize -= 1;
        }else{
         $rep->SetFont('helvetica','B','','',true);
         $rep->fontSize += 1; 
         $rep->TextCol(5, 7, _('TransactionCountTotal: ').$supp_count,-2);
         $rep->AmountCol(7, 8, $net_amount_supp_tot, $dec);
         $rep->AmountCol(8, 9, $amount_supp_tot, $dec);
        //    $rep->AmountCol(10, 11, number_format2(abs($debit)-abs($Credit)), $dec);
         $rep->fontSize -= 1;
         $rep->SetFont('helvetica','','','',true);
        }
         $rep->NewLine();
           $rep->Line($rep->row, 2);
//-----------------------------------------------------------------------------------------------------------
  $rep->NewLine(2);
   $rep->Line($rep->row,2);
    $rep->NewLine();
        $rep->fontSize += 4;
            $rep->TextCol(0, 2, _("SuppDataStart"),-2);
        $rep->fontSize -= 4;
  $rep->NewLine(2);

 $cols = array(5, 100, 175, 230,275,320, 405,490,560,600,640,685,740);
     
 $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);


              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
        
          $rep->TextCol(0, 1, _('Customer Name'),-2);
         $rep->TextCol(1, 2, _('Customer TIN/TRN'),-2);
         $rep->TextCol(2, 3, _('InvoiceDate'),-2);
         $rep->TextCol(3, 4, _('InvoiceNo'),-2);
         $rep->TextCol(4, 5, _('LineNo'),-2);
         $rep->TextCol(5, 6, _('ProductDescription'),-2);

        $rep->TextCol(6, 7, _('SupplyValueAED'),-2);
         $rep->TextCol(7, 8, _('ExciseTaxValueAED'),-2);
         $rep->TextCol(8, 9, _('TaxCode'),-2);
         $rep->TextCol(9, 10, _('Country'),-2);
         $rep->TextCol(10, 11, _('FCYCode'),-2);
         $rep->TextCol(11, 12, _('SupplyFCY'),-2);
         $rep->TextCol(12, 13, _('ExciseTaxFCY'),-2);





       

         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5);
            $rep->NewLine(1.5);
    $trans = getSalesListing($from, $to);
         // $rep->row=450;
            // display_error(db_num_rows($trans));
            $trans_no=0;
            $line_no=1;
    $net_amount_cust_tot =0;
    $amount_cust_tot =0;
    $cust_count=0;  
    while ($myrow=db_fetch($trans))
    {
      //display_error($myrow['supp_name']);
        // $rep->TextCol(0, 1,  get_customer($myrow['debtor_no'])['name']);
        $oldrow = $rep->row;
        $rep->TextColLines(0, 1,get_customer($myrow['debtor_no'])['name'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        // if (user_date_format() == 0)
        //  $rep->TextCol(1, 2, date("h:i:s a", $myrow['unix_stamp']));
        // else 
         $rep->TextCol(1, 2, get_customer($myrow['debtor_no'])['tax_id'],-2);
        $rep->TextCol(2, 3, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
        $rep->TextCol(3, 4, $myrow['debtor_trans_no'],-2);
        // display_error($trans_no."!=".$myrow['supp_trans_no']);
         if($trans_no!=$myrow['debtor_trans_no'])
         {
          $trans_no=$myrow['debtor_trans_no'];
                 $line_no=1;
         }

        $rep->TextCol(4, 5, $line_no++,-2);
        // $rep->TextCol(5, 6, $myrow['description']);
        $oldrow = $rep->row;
        $rep->TextColLines(5, 6, $myrow['description'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        $net_amount_cust = $myrow['unit_price']*$myrow['ex_rate'];
        if($myrow['trans_type'] == '11'){
            $rep->TextCol(6, 7, number_format(-1*$net_amount_cust,2),-2);
          $net_amount_cust_tot = $net_amount_cust_tot - $net_amount_cust; 
        }else{
            $rep->TextCol(6, 7, number_format($net_amount_cust,2),-2);
         $net_amount_cust_tot = $net_amount_cust_tot + $net_amount_cust;
        }
        

        $amount_cust = $myrow['unit_tax']*$myrow['ex_rate'];
        if($myrow['trans_type'] == '11'){
            $rep->TextCol(7, 8, number_format(-1*$amount_cust,2),-2);
          $amount_cust_tot = $amount_cust_tot - $amount_cust; 
        }else{
            $rep->TextCol(7, 8, number_format($amount_cust,2),-2);
         $amount_cust_tot = $amount_cust_tot + $amount_cust;
        }
        // display_error(get_item($myrow['stock_id'])['tax_type_id']);
        $rep->TextCol(8, 9,get_item_tax_type(get_item($myrow['stock_id'])['tax_type_id'])['tax_code'],-2);
        $rep->TextCol(9, 10, get_country_name($myrow['country']),-2);
        $rep->TextCol(10, 11, get_customer($myrow['debtor_no'])['curr_code'],-2);
         if ($rep->company['curr_default'] == get_customer($myrow['debtor_no'])['curr_code']) {
         $rep->TextCol(11, 12, '0.00',-2);
         $rep->TextCol(12, 13, '0.00',-2);
        }else{ 
        $rep->TextCol(11, 12, number_format($myrow['unit_price'],2),-2);
        $rep->TextCol(12, 13, number_format($myrow['unit_tax'],2),-2);
        }
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );

        $rep->row = min($newrow);
        unset($newrow);
        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight))
        {
              $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
           $rep->TextCol(0, 1, _('Customer Name'),-2);
         $rep->TextCol(1, 2, _('Customer TIN/TRN'),-2);
         $rep->TextCol(2, 3, _('InvoiceDate'),-2);
         $rep->TextCol(3, 4, _('InvoiceNo'),-2);
         $rep->TextCol(4, 5, _('LineNo'),-2);
         $rep->TextCol(5, 6, _('ProductDescription'),-2);

        $rep->TextCol(6, 7, _('SupplyValueAED'),-2);
         $rep->TextCol(7, 8, _('ExciseTaxValueAED'),-2);
         $rep->TextCol(8, 9, _('TaxCode'),-2);
         $rep->TextCol(9, 10, _('Country'),-2);
         $rep->TextCol(10, 11, _('FCYCode'),-2);
         $rep->TextCol(11, 12, _('SupplyFCY'),-2);
         $rep->TextCol(12, 13, _('ExciseTaxFCY'),-2);

         $rep->fontSize -= 1;
           $rep->Line($rep->row-5);
            $rep->NewLine();
      
        }

         // $rep->NewLine();
    $cust_count++;
    }
            $rep->Line($rep->row);
            $rep->NewLine();
            $rep->fontSize += 4;
             $rep->TextCol(0, 9, _('SuppDataEnd'),-2);
            // $rep->Text($rep->leftMargin+5, _("PurchDataEnd"), $companyCol,0,395);
            $rep->fontSize -= 4;
            if ($rep->l['a_meta_dir'] == 'rtl'){
            $rep->fontSize += 1;
            $rep->SetFont('dejavusans', '', '', '', true);
            $rep->TextCol(4, 6, _('TransactionCountTotal: ').$cust_count,-2);
            // $rep->TextCol(5, 7, _('TransactionCountTotal: ').$supp_count,-2);
            $rep->AmountCol(6, 7, $net_amount_cust_tot, $dec);
            $rep->AmountCol(7, 8, $amount_cust_tot, $dec);
        //    $rep->AmountCol(10, 11, number_format2(abs($debit)-abs($Credit)), $dec);
            $rep->fontSize -= 1;
             }else{
            $rep->SetFont('helvetica','B','','',true);
            $rep->fontSize += 1;
            $rep->TextCol(4, 6, _('TransactionCountTotal: ').$cust_count,-2);
            $rep->AmountCol(6, 7, $net_amount_cust_tot, $dec);
            $rep->AmountCol(7, 8, $amount_cust_tot, $dec);
            //    $rep->AmountCol(10, 11, number_format2(abs($debit)-abs($Credit)), $dec);
            $rep->fontSize -= 1;
            $rep->SetFont('helvetica','','','',true);
            }
             $rep->NewLine();
           $rep->Line($rep->row, 2);

//-----------------------------------------------------------------------------------------------------------
  $rep->NewLine(2);
   $rep->Line($rep->row,2);
    $rep->NewLine();
        $rep->fontSize += 5;
            $rep->TextCol(0, 2, _("GLDataStart"),-2);
        $rep->fontSize -= 5;
  $rep->NewLine(2);

 $cols = array(5, 70, 110, 170,310,380, 435,510,590,650,710);
      
    $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);


              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, _('TransactionDate'),-2);
         $rep->TextCol(1, 2, _('AccountID'),-2);
         $rep->TextCol(2, 3, _('AccountName'),-2);
         $rep->TextCol(3, 4, _('TransactionDescription'),-2);
         $rep->TextCol(4, 5, _('Name'),-2);
         $rep->TextCol(5, 6, _('TransactionID'),-2);

         $rep->TextCol(6, 7, _('SourceDocumentID'),-2);
         $rep->TextCol(7, 8, _('SourceType'),-2);
         $rep->TextCol(8, 9, _('Debit'),-2);
         $rep->TextCol(9, 10, _('Credit'),-2);
         $rep->TextCol(10, 11, _('Balance'),-2);



         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5);
            $rep->NewLine(1.5);
    $trans = GL_Listing($from, $to);

            $trans_no=0;
            $line_no=1;
            $gl_count=0;
    while ($myrow=db_fetch($trans))
    {

        $rep->TextCol(0, 1, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
 
         $rep->TextCol(1, 2, $myrow['account'],-2);
        // $rep->TextCol(2, 3, get_gl_account($myrow['account'])['account_name'],-2);
        $oldrow = $rep->row;
        $rep->TextColLines(2, 3,get_gl_account($myrow['account'])['account_name'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        
        // $rep->TextCoLine(3, 4,$myrow["memo"],-2); //
        $oldrow = $rep->row;
        $rep->TextColLines(3, 4,$myrow["memo"], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        if($myrow["type"]==10 || $myrow["type"]==13 || $myrow["type"]==11 || $myrow["type"]==12){

             // $rep->TextCol(4, 5, get_customer_name(get_trans_cust_name($myrow["type"], $myrow['type_no'])),-2);
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,get_customer_name(get_trans_cust_name($myrow["type"], $myrow['type_no'])), -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        }
       elseif($myrow["type"]==20 || $myrow["type"]==22 || $myrow["type"]==21 ){

             // $rep->TextCol(4, 5, get_supplier_name(get_trans_supp_name($myrow["type"], $myrow['type_no'])),-2);
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,get_supplier_name(get_trans_supp_name($myrow["type"], $myrow['type_no'])), -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
       }
       else{
         // $rep->TextCol(4, 5,"");
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,"", -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
       }

 
        $rep->TextCol(5, 6, $myrow['type_no'],-2);
        $rep->TextCol(6, 7, $myrow['type'],-2);
        // $rep->TextCol(7, 8,$systypes_array[$myrow["type"]] ,-2 );
        $oldrow = $rep->row;
        $rep->TextColLines(7, 8,$systypes_array[$myrow["type"]], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        $total += $myrow['amount'];
if ($myrow['amount'] > 0.0)
         { $rep->AmountCol(8, 9, abs($myrow['amount']), $dec);
           $debit+=$myrow['amount'];
           }
        else
          { $rep->AmountCol(9, 10, abs($myrow['amount']), $dec);
            $Credit+=$myrow['amount'];
            }
        $rep->TextCol(10, 11, number_format2($total, $dec),-2);
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );

        $rep->row = min($newrow);
        unset($newrow);

        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight))
        {
              $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, _('TransactionDate'),-2);
         $rep->TextCol(1, 2, _('AccountID'),-2);
         $rep->TextCol(2, 3, _('AccountName'),-2);
         $rep->TextCol(3, 4, _('TransactionDescription'),-2);
         $rep->TextCol(4, 5, _('Name'),-2);
         $rep->TextCol(5, 6, _('TransactionID'),-2);

        $rep->TextCol(6, 7, _('SourceDocumentID'),-2);
         $rep->TextCol(7, 8, _('SourceType'),-2);
         $rep->TextCol(8, 9, _('Debit'),-2);
         $rep->TextCol(9, 10, _('Credit'),-2);
         $rep->TextCol(10, 11, _('Balance'),-2);
         $rep->fontSize -= 1;
           $rep->Line($rep->row-5);
            $rep->NewLine();
      
        }
        
         // $rep->NewLine();

    $gl_count++;
    }

     $rep->Line($rep->row);
            $rep->NewLine();
            $rep->fontSize += 4;
             $rep->TextCol(0, 9, _('GLDataEnd'),-2);
            // $rep->Text($rep->leftMargin+5, _("PurchDataEnd"), $companyCol,0,395);
            $rep->fontSize -= 4;
             // $rep->NewLine();
            if ($rep->l['a_meta_dir'] == 'rtl'){
            $rep->fontSize += 1;
            $rep->SetFont('dejavusans', '', '', '', true);
            $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            //  $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            $rep->AmountCol(8, 9, abs($debit), $dec);
            $rep->AmountCol(9, 10, abs($Credit), $dec);
            $rep->TextCol(10, 11, number_format2(abs($debit)-abs($Credit), $dec)." ".$rep->company['curr_default'],-2);
            $rep->fontSize -= 1;
             }else{
            $rep->SetFont('helvetica','B','','',true);
            $rep->fontSize += 1;
            $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            $rep->AmountCol(8, 9, abs($debit), $dec);
            $rep->AmountCol(9, 10, abs($Credit), $dec);
            $rep->TextCol(10, 11, number_format2(abs($debit)-abs($Credit), $dec)." ".$rep->company['curr_default'],-2);
            $rep->fontSize -= 1;
            $rep->SetFont('helvetica','','','',true);
             }
            $rep->NewLine();
           $rep->Line($rep->row, 2);
///   ------------------------------------------  third collumn-------------------------------


 $rep->NewLine(2);
   $rep->Line($rep->row,2);
    $rep->NewLine();
        $rep->fontSize += 5;
            $rep->TextCol(0, 2, _("SFStart"),-2);
        $rep->fontSize -= 5;
  $rep->NewLine(2);

 $cols = array(5, 55, 110, 170,250,380, 435,510,590,650,710);
      
    $aligns = array('left', 'left', 'left', 'left', 'left', 'left','left', 'left', 'left', 'left', 'left');

    $rep->Info($params, $cols, $headers, $aligns,null,null,null,false,false,'',$from,$to);


              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, _('WarehouseID'),-2);
         $rep->TextCol(1, 2, _('ProductCode'),-2);
         $rep->TextCol(2, 3, _('ExciseRate'),-2);
         $rep->TextCol(3, 4, _('TransactionType'),-2);
         $rep->TextCol(4, 5, _('MovementDetails'),-2);
         $rep->TextCol(5, 6, _('TransferID'),-2);

         $rep->TextCol(6, 7, _('TransactionDate'),-2);
         $rep->TextCol(7, 8, _('TaxPaymentDate'),-2);
         $rep->TextCol(8, 9, _('StockDutyStatus'),-2);
         $rep->TextCol(9, 10, _('StockAdjustment'),-2);
         $rep->TextCol(10, 11, _('GoodsLocation'),-2);



         $rep->fontSize -= 1;
           $rep->Line($rep->row - 5);
            $rep->NewLine(1.5);
    // $trans = GL_Listing($from, $to);
    $trans = ST_listing($from,$to);
    // $trans = '';

            $trans_no=0;
            $line_no=1;
            $gl_count=0;
    while ($myrow=db_fetch($trans))
    {

        // $rep->TextCol(0, 1, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
        $rep->TextCol(0, 1, $myrow['loc_code'],-2);
 
         $rep->TextCol(1, 2, $myrow['stock_id'],-2);
        // $rep->TextCol(2, 3, get_gl_account($myrow['account'])['account_name'],-2);
        $oldrow = $rep->row;
        $rep->TextColLines(2, 3,$myrow['rate'], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        
        // $rep->TextCoLine(3, 4,$myrow["memo"],-2); //
        $oldrow = $rep->row;
        $rep->TextColLines(3, 4,$systypes_array[$myrow["type"]], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        /*if($myrow["type"]==10 || $myrow["type"]==13 || $myrow["type"]==11 || $myrow["type"]==12){

             // $rep->TextCol(4, 5, get_customer_name(get_trans_cust_name($myrow["type"], $myrow['type_no'])),-2);
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,get_customer_name(get_trans_cust_name($myrow["type"], $myrow['type_no'])), -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        }
       elseif($myrow["type"]==20 || $myrow["type"]==22 || $myrow["type"]==21 ){

             // $rep->TextCol(4, 5, get_supplier_name(get_trans_supp_name($myrow["type"], $myrow['type_no'])),-2);
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,get_supplier_name(get_trans_supp_name($myrow["type"], $myrow['type_no'])), -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
       }
       else{
         // $rep->TextCol(4, 5,"");
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5,"", -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
       }
*/
       // display_error(db_fetch(get_comments(ST_SUPPINVOICE,$myrow['trans_no']))['memo_']);
       if ($myrow['type'] == '25') {
          $comments = db_fetch(get_comments(20,get_invoice_aginst_delivery($myrow['trans_no'],$myrow['type'])))['memo_'];
       }else{
          $comments = db_fetch(get_comments($myrow['type'],$myrow['trans_no']))['memo_'];
       }
        $oldrow = $rep->row;
        $rep->TextColLines(4, 5, $comments, -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;
        // $rep->TextColLines(4, 5,"", -2);

        $rep->TextCol(5, 6, get_references($myrow['trans_no'],$myrow['type']),-2);
        $rep->TextCol(6, 7, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
        $rep->TextCol(7, 8, date('d-m-Y',strtotime($myrow['tran_date'])),-2);
        // $rep->TextCol(7, 8,$systypes_array[$myrow["type"]] ,-2 );
        /*$oldrow = $rep->row;
        $rep->TextColLines(7, 8,$systypes_array[$myrow["type"]], -2);
        $newrow[] = $rep->row;
        $rep->row = $oldrow;

        $total += $myrow['amount'];
if ($myrow['amount'] > 0.0)
         { $rep->AmountCol(8, 9, abs($myrow['amount']), $dec);
           $debit+=$myrow['amount'];
           }
        else
          { $rep->AmountCol(9, 10, abs($myrow['amount']), $dec);
            $Credit+=$myrow['amount'];
            }*/
        $rep->TextCol(10, 11,get_location_name($myrow['loc_code']),-2);
       // display_error($rep->row ."<". $rep->bottomMargin ."+". $rep->lineHeight );

        $rep->row = min($newrow);
        unset($newrow);

        if ($rep->row < ($rep->bottomMargin + $rep->lineHeight))
        {
              $rep->Line($rep->row-5);
          $rep->NewPage();
          // $rep->Line($rep->row);
              $rep->Line($rep->row + 12);
         $rep->fontSize += 1;
         $rep->TextCol(0, 1, _('WarehouseID'),-2);
         $rep->TextCol(1, 2, _('ProductCode'),-2);
         $rep->TextCol(2, 3, _('ExciseRate'),-2);
         $rep->TextCol(3, 4, _('TransactionType'),-2);
         $rep->TextCol(4, 5, _('MovementDetails'),-2);
         $rep->TextCol(5, 6, _('TransferID'),-2);

         $rep->TextCol(6, 7, _('TransactionDate'),-2);
         $rep->TextCol(7, 8, _('TaxPaymentDate'),-2);
         $rep->TextCol(8, 9, _('StockDutyStatus'),-2);
         $rep->TextCol(9, 10, _('StockAdjustment'),-2);
         $rep->TextCol(10, 11, _('GoodsLocation'),-2);
         $rep->fontSize -= 1;
           $rep->Line($rep->row-5);
            $rep->NewLine();
      
        }
        
         // $rep->NewLine();

    $gl_count++;
    }

     $rep->Line($rep->row);
            $rep->NewLine();
            $rep->fontSize += 4;
             $rep->TextCol(0, 9, _('SFEnd'),-2);
            // $rep->Text($rep->leftMargin+5, _("PurchDataEnd"), $companyCol,0,395);
            $rep->fontSize -= 4;
             // $rep->NewLine();
             if ($rep->l['a_meta_dir'] == 'rtl'){
            $rep->fontSize += 1;
            $rep->SetFont('dejavusans', '', '', '', true);
            $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            //  $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            // $rep->AmountCol(8, 9, abs($debit), $dec);
            // $rep->AmountCol(9, 10, abs($Credit), $dec);
            // $rep->TextCol(10, 11, number_format2(abs($debit)-abs($Credit), $dec)." ".$rep->company['curr_default'],-2);
            $rep->fontSize -= 1;
             }else{
            $rep->SetFont('helvetica','B','','',true);
            $rep->fontSize += 1;
            $rep->TextCol(3, 9, _('TransactionCountTotal: ').$gl_count,-2);
            // $rep->AmountCol(8, 9, abs($debit), $dec);
            // $rep->AmountCol(9, 10, abs($Credit), $dec);
            // $rep->TextCol(10, 11, number_format2(abs($debit)-abs($Credit), $dec)." ".$rep->company['curr_default'],-2);
            $rep->fontSize -= 1;
            $rep->SetFont('helvetica','','','',true);
             }
            $rep->NewLine();
           $rep->Line($rep->row, 2);





    $rep->End();
}

