<?php

$page_security = 'SA_SUPPINQDASHREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/po_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");


//----------------------------------------------------------------------------------------------------

//zeeshan
function systype_name($dummy, $type)
{
    global $systypes_array;
    return $systypes_array[$type];
}
function due_date($row)
{
    return ($row["type"]== ST_SUPPINVOICE) || ($row["type"]== ST_SUPPCREDIT) ? $row["due_date"] : '';
}

//zeeshan
//----------------------------------------------------------------------------------------------------
print_customer_balances();



function print_customer_balances()
{
        global $path_to_root, $systypes_array;


$trans_type = $_POST['PARAM_0'];
$from = $_POST['PARAM_1'];
$to = $_POST['PARAM_2'];
$supplier_id = $_POST['PARAM_3'];
$filter = $_POST['PARAM_4'];
$destination = $_POST['PARAM_5'];
$def_orientation = $_POST['PARAM_6']=1;
$dimension_id = $_POST['PARAM_7'];


// excel/pdf and landscape/portrait conditions -------------------------------------------------------------------------------

    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();

// Ending excel/pdf and landscape/portrait conditions -------------------------------------------------------------------------------



// header cols params, aligns -------------------------------------------------------------------------------
    $cols = array(0, 100, 120, 160, 240,  290, 365, 410,460, 500);
    $headers = array(_('Type'), _('#'), _('Reference'), _('Supplier'), _('Site Name'), _('Supplier Reference'), _('Date'),
        _('DueDate'), _('Currency'), _('Amount')    );
    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left','left', 'right');
    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to'=>$to),
                        2 => array('text' => _('supplier ID'), 'from' => (!$supplier_id ? "ALL SUPPLIERS" : $supplier_id) ),
                        3 => array('text' => _('Types'), 'from' => (!$filter ? "ALL Types" : $filter) ),
                        4 => array('text' => _('Site'), 'from' => (!$dimension_id ? "ALL Sites" : get_dimension($dimension_id)['name']) ));

    $rep = new FrontReport(_('Supplier Inquiry'), "Supplier Inquiry", user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
// ending header cols params, aligns -------------------------------------------------------------------------------



//Zeeshan---------------------------------------------------------------------------------------------------

$sql = get_sql_for_supplier_inquiry($filter, $from, $to, $supplier_id, null, $dimension_id);

$result=db_query($sql);

    while ($myrow = db_fetch($result))
    {
        $c=0;
   
        $rep->TextCol($c, $c++,  systype_name('',$myrow['type']));         
        $rep->TextCol($c, $c++,  $myrow['trans_no']);
        $rep->TextCol($c, $c++,  $myrow['reference']);
              if($destination)
         {
        $rep->TextCol($c, $c++,  $myrow['supp_name']);
        $rep->TextCol($c, $c++,  $myrow['dimension_id'] ? get_dimension($myrow['dimension_id'])['name'] : 'N/A');

        $rep->TextCol($c, $c++,  $myrow['supp_reference']);
         }
         else
         {
             
              $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['supp_name'], -2);
                $newrow1 = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['dimension_id'] ? get_dimension($myrow['dimension_id'])['name'] : 'N/A', -2);
                $newrow2 = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['supp_reference'], -2);
                $newrow2 = $rep->row;
                $rep->row = $oldrow;
         }
         
         
        $rep->TextCol($c, $c++,  sql2date($myrow['tran_date']));
        $rep->TextCol($c, $c++,  sql2date(due_date($myrow)));
        $rep->TextCol($c, $c++,  $myrow['curr_code']);
        if($destination)
        $rep->TextCol($c,$c++,  $myrow['TotalAmount'],$dec);
        else
        $rep->AmountCol($c,$c++,  $myrow['TotalAmount'],$dec);
       
       if($newrow1<$newrow2)
         $rep->row = $newrow1;
       else
          $rep->row = $newrow2;
          
        unset($newrow1);
        unset($newrow2);
        $rep->NewLine();


     }   


//zeeshan END//
//--------------------------------------------------------------------------------------------------------


    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}