<?php

$page_security = 'SA_CUSTPAYMREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/po_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");


//----------------------------------------------------------------------------------------------------

//zeeshan
function systype_name($dummy, $type)
{
    global $systypes_array;
    
    return $systypes_array[$type];
}

function check_value($name)
{
    return (empty($_POST[$name]) ? 0 : 1);
}

function due_date($row)
{
    return (($row["type"] == ST_SUPPINVOICE) || ($row["type"]== ST_SUPPCREDIT))
        ? $row["due_date"] : "";
}


function fmt_debit($row)
{
    $value = -$row["TotalAmount"];
    return $value>=0 ? price_format($value) : '';

}

function fmt_credit($row)
{
    $value = $row["TotalAmount"];
    return $value>0 ? price_format($value) : '';
}
function alloc_link($row)
{
    $link = 
    pager_link(_("Allocations"),
        "/purchasing/allocations/supplier_allocate.php?trans_no=" .
            $row["trans_no"]. "&trans_type=" . $row["type"]. "&supplier_id=" . $row["supplier_id"], ICON_ALLOC );

    if ($row["type"] == ST_BANKPAYMENT || $row["type"] == ST_SUPPAYMENT ||
        (($row["type"] == ST_SUPPCREDIT || $row["type"] == ST_JOURNAL) && $row["TotalAmount"] < 0))
        return floatcmp(-$row["TotalAmount"], $row["Allocated"]) ? $link : '';

    $link = 
    pager_link(_("Payment"),
        "/purchasing/supplier_payment.php?supplier_id=".$row["supplier_id"]."&PInvoice=" 
            . $row["trans_no"]."&trans_type=" . $row["type"], ICON_MONEY);

    if ($row["type"] == ST_SUPPINVOICE || (($row["type"] == ST_SUPPCREDIT || $row["type"] == ST_JOURNAL) && $row["TotalAmount"] > 0))
        return floatcmp($row["TotalAmount"], $row["Allocated"]) ? $link : '';


}

function fmt_balance($row)
{
    $value = ($row["type"] == ST_BANKPAYMENT || $row["type"] == ST_SUPPCREDIT || $row["type"] == ST_SUPPAYMENT) ? -$row["TotalAmount"] - $row["Allocated"]
        : ($row["type"] == ST_JOURNAL ? abs($row["TotalAmount"]) - $row["Allocated"] :
            $row["TotalAmount"] - $row["Allocated"]);
    return $value;
}


print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
        global $path_to_root, $systypes_array;

      //Zeeshan 
      

        //////// PARAS ///////////////
$_POST['showSettled']=$show_settled = $_POST['PARAM_0'];
$filter = $_POST['PARAM_1'];
$destination = $_POST['PARAM_2'];
$trans_type = $_POST['PARAM_3'];
$_POST['TransAfterDate']=$from = $_POST['PARAM_4'];
$_POST['TransToDate']=$to = $_POST['PARAM_5'];

$supplier_id = $_POST['PARAM_6'];
$def_orientation = $_POST['PARAM_7']=1;




//-----EXCEL AND PDF CONDITION , LANDSCAPE AND PORTRAIT-------------------------------------------------------------------
    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();


    //Cols Headers And Params, Aligns---------------------------------------------------------------------------------------

    $cols = array(0, 70, 80,110,150,210,260, 310, 345, 400, 450, 520,560);


    $headers = array(_('Type'), _('#'), _('Ref'), _('Supplier'), _('Supp Reference'), _('Date'),
        _('DueDate'), _('Currency'), _('Debit'), _('Credit'), _('Allocated'), _('Balance')    );

    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to'=>$to),
                        2 => array('text' => _('Types'), 'from' => (!$filter ? "ALL Types" : $filter) ),
                        3 => array('text' => _('Supplier id'), 'from' => (!$supplier_id ? "ALL Suppliers" : $supplier_id )    )

                    );
    //-----------------------------------------------------------------------------------------------------------------------

    $rep = new FrontReport(_('Supplier Allocation Inquiry'), "Supplier Allocation Inquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();





$sql = get_sql_for_supplier_allocation_inquiry($from, $to, $filter, $supplier_id,check_value($show_settled));


//zeeshan Code--------------------------------------------------------------------------------

$result=db_query($sql);

    while ($myrow = db_fetch($result))
    {
        $c=0;
        $rep->TextCol($c, $c++,  systype_name('',$myrow['type']));        
        $rep->TextCol($c, $c++,  $myrow['trans_no']);
        $rep->TextCol($c, $c++,  $myrow['reference']);
        if($destination)
         {
           $rep->TextCol($c, $c++,  $myrow['supp_name']);
           $rep->TextCol($c, $c++,  $myrow['supp_reference']);
         }
         else
         {
             
              $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['supp_name'], -2);
                $newrow1 = $rep->row;
                $rep->row = $oldrow;

                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['supp_reference'], -2);
                $newrow2 = $rep->row;
                $rep->row = $oldrow;
         }
         
        $rep->TextCol($c, $c++,  $myrow['tran_date']);
        $rep->TextCol($c, $c++,  due_date($myrow));
        $rep->TextCol($c, $c++,  $myrow['curr_code']);
        $rep->TextCol($c, $c++,  fmt_debit($myrow));
        $rep->TextCol($c, $c++,  fmt_credit($myrow));
        $rep->AmountCol($c, $c++,  $myrow['Allocated'],$dec);
        $rep->TextCol($c, $c++,  fmt_balance($myrow));

        if($newrow1<$newrow2)
         $rep->row = $newrow1;
       else
          $rep->row = $newrow2;
          
        unset($newrow1);
        unset($newrow2);
        $rep->NewLine();

     }   


        $rep->Line($rep->row  - 4);
        $rep->End();
    
}