<?php

$page_security = 'SA_INVENTORYADJSTMENTREPORT';




$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/po_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");


print_customer_balances();

function get_sql_for_inventry1($from, $to, $Fromlocation=ALL_TEXT, $Tolocation=ALL_TEXT,
	$order_number = '', $stock_id = '' ,$type = '')

{ 
     if($type==ST_LOCTRANSFER)
	 $sql="SELECT sm1.trans_no, sm1.type, sm1.reference, sm1.loc_code ,sm2.loc_code as loc_code2, sm1.tran_date FROM ".TB_PREF."stock_moves sm1 LEFT JOIN ".TB_PREF."stock_moves sm2 on sm2.trans_no=sm1.trans_no AND sm2.stock_id=sm1.stock_id AND sm2.qty>0 WHERE sm1.type IN (16,17) AND sm1.qty<0";
      else
      $sql="SELECT sm1.trans_no, sm1.type, sm1.reference, sm1.loc_code ,null as loc_code2, sm1.tran_date FROM ".TB_PREF."stock_moves sm1 WHERE type=".db_escape($type);

   	if ($order_number != "")
	{
		$sql .= " AND  CONCAT(sm1.trans_no, ' ', sm1.reference) LIKE ".db_escape('%'. $order_number . '%');
		if ($type !== '')
		{
			$sql .= " AND sm1.type=".db_escape($type);
		}
	}
	else
	{

		$data_after = date2sql($from);
		$date_before = date2sql($to);

		$sql .= " AND sm1.tran_date >= '$data_after'";
		$sql .= " AND sm1.tran_date <= '$date_before'";

		if ($Fromlocation !=0)
		{
			$sql .= " AND sm1.loc_code = ".db_escape($Fromlocation);
		}
		if ($Tolocation != 0)
		{
			$sql .= " AND sm2.loc_code = ".db_escape($Tolocation);
		}
		if ($stock_id !== '')
		{
			$sql .= " AND sm1.stock_id=".db_escape($stock_id);

		}
		if ($type !== '')
		{
			$sql .= " AND sm1.type=".db_escape($type);
		}
		// if ($supplier_id != ALL_TEXT)
		// 	$sql .= " AND supplier.supplier_id=".db_escape($supplier_id);

	}


     $sql.=" GROUP by sm1.trans_no ";
   // display_error($sql);exit();
     return $sql;

}


function loc_name1($row)
{
	return get_location_name($row['loc_code']);
}


function loc_name2($row)
{
	if($row['loc_code2']==null)
		return ;
	else
	return get_location_name($row['loc_code2']);
}





function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$destination = $_POST['PARAM_0'];
$from_location = $_POST['PARAM_1'];
$trans_type = $_POST['PARAM_2'];
$from = $_POST['PARAM_3'];
$to = $_POST['PARAM_4'];
$items = $_POST['PARAM_5'];
$to_location = $_POST['PARAM_6'];
$order_no = $_POST['PARAM_7'];

$order_no = $_POST['PARAM_8'];
$def_orientation = $_POST['PARAM_9']=1;



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 50, 180, 270, 360,  450,  500);

#	Type	Reference	From Location	To Location	Trans Date
    $headers = array(_('#'), _('Type'), _('Reference'), _('From Location'), _('To Location'), _('Trans Date')  );



    $aligns = array('left', 'left',   'left', 'left', 'left', 'left');
    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to'=>$to),
                        2 => array('text' => _('Items'), 'from' => (!$items ? "ALL ITEMS" : $items) ),
                        3 => array('text' => _('Locations'), 'from' => (  $systypes_array[$trans_type]  ) )

                );

    $rep = new FrontReport(_('Adjustments and Location Transfer '), "Adjustments and Location Transfer", user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


$sql =get_sql_for_inventry1($from, $to, $from_location , $to_location, $order_no ,$items , $trans_type);
global $systypes_array;

$result=db_query($sql);

    while ($myrow = db_fetch($result))
    {
        $c=0;
        $rep->TextCol($c, $c++,  $myrow['trans_no']);        
        $rep->TextCol($c, $c++,  $systypes_array[$myrow['type']]);
        $rep->TextCol($c, $c++,  $myrow['reference']);
        $rep->TextCol($c, $c++, loc_name1($myrow));
        $rep->TextCol($c, $c++, loc_name2($myrow));
        $rep->TextCol($c, $c++, sql2date($myrow['tran_date']));       

        $newrow = $rep->row;
        $rep->row = $newrow;
        $rep->NewLine();


     }   


    $rep->Line($rep->row  - 4);
    $rep->End();
}


?>