<?php

$page_security = 'SA_INVENTORYITEMMOVEMENT';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// -------------------------------------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");

//---------------------------------------------------------------------------------------------------



print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$stock_location = $_POST['PARAM_0'];
$destination = $_POST['PARAM_1'];
$trans_type = $_POST['PARAM_2'];
$from = $_POST['PARAM_3'];
$to = $_POST['PARAM_4'];
$stock_id = $_POST['PARAM_5'];
$def_orientation = $_POST['PARAM_6']=1;
$type = $_POST['PARAM_7'];



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 100, 130, 210, 250, 300, 350, 420, 490,540);


    $headers = array(_('Type'), _('#'), _('Reference'), _('Location'), _('Date'), _('Detail'),
        _('QuantityIn'), _('QuantityOut'), _('QuantityOnHand')    );


    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Date before'), 'from' => $from),
                        2 => array('text' => _('Date after'), 'from' => $to),
                        3 => array('text' => _('locations'), 'from' => (!$stock_location ? "ALL Locations" : $stock_location) ),
                        4 => array('text' => _('Items'), 'from' => (!$stock_id ? "ALL Items    " : $stock_id) )


                    );
if($type=='FIXEDMOV')
 $rep = new FrontReport(_('Fixed Assets Movement'), "Fixed Assets Movement", user_pagesize(), 9, $def_orientation);
   else
    $rep = new FrontReport(_('Inventory Stock Movement'), "Inventory Stock Movement", user_pagesize(), 9, $def_orientation);
       
    

  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();



//Zeeshan---------------------------------------------------------------------------------------------------

// $sql = get_sql_for_po_search_completed($from, $to, $supplier_id, $stocklocation, $order_no, $stocklist, $also_closed);
    $rep->Line($rep->row  -8);

    $rep->Font('bold');
  $rep->TextCol(2,5,  "Quantity on hand before : ".$from );       
  $before_qty = get_qoh_on_date($stock_id,$stock_location, add_days( $from, -1));
  
    $rep->TextCol(8,9,  $before_qty);       
        $rep->Font();
    $rep->NewLine();
    $rep->NewLine();
$after_qty+=$before_qty;
$sql = get_stock_movements($stock_id, $stock_location, $to, $from);

// $result=db_query($sql);
// $rep->TextColLines(200, 300,$stock_id."stck->". $stock_location."strtdate-=>". $to."enddate-->". $from."==show_settled", -2,200);


$total_in = 0;
$total_out = 0;

    while ($myrow = db_fetch($sql))
    {



    	if (get_post('fixed_asset') == 1 && isset($fa_systypes_array[$myrow["type"]]))
		$type_name = $fa_systypes_array[$myrow["type"]];
	else
		$type_name = $systypes_array[$myrow["type"]];

    	if ($myrow["qty"] > 0)
	{
		$quantity_formatted = number_format2($myrow["qty"], $dec);
		$total_in += $myrow["qty"];
	}
	else
	{
		$quantity_formatted = number_format2(-$myrow["qty"], $dec);
		$total_out += $myrow["qty"];
	}
	$after_qty += $myrow["qty"];
        $c=0;
        $rep->TextCol($c, ++$c,  $type_name);        
        $rep->TextCol($c, ++$c,  $myrow["trans_no"]);
        $rep->TextCol($c, ++$c,  $myrow['reference']);        
        $rep->TextCol($c, ++$c,  $myrow['loc_code']);
        $rep->TextCol($c, ++$c,  sql2date($myrow["tran_date"]));
                if($destination)
            $rep->TextCol($c, ++$c,  $myrow["name"]);
                else
                {
        		  $oldrow = $rep->row;
                  $rep->TextColLines($c, ++$c,  $myrow['name']);
            	  $newrow = $rep->row;
				  $rep->row = $oldrow;
                }
        $rep->TextCol($c, ++$c,  (($myrow["qty"] >= 0) ? $quantity_formatted : ""));
        $rep->TextCol($c, ++$c,  (($myrow["qty"] < 0) ? $quantity_formatted : ""));
             if($destination)
             $rep->TextCol($c, ++$c,  $after_qty, $dec);
             else
        $rep->AmountCol($c, ++$c,  $after_qty, $dec);
     
    
     $rep->row = $newrow;
        $rep->NewLine();
   

     }   

    $rep->Line($rep->row  - 1);
    // $rep->NewLine();
    $rep->NewLine();
    $rep->Font('bold');
  	// $rep->TextCol(2,9,  "Quantity on hand before : ".$to.'__________________________'.$total_in.'_______________'.$total_out.
   //      '_____________'.$after_qty);        
    $rep->TextCol(2,9,  "Quantity on hand before : ".$to);
    $rep->TextCol(6,7,  $total_in);

    $rep->TextCol(7,8,  $total_out);
    $rep->TextCol(8,9,  $after_qty);
    $rep->NewLine();
    $rep->Font();


    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}