<?php

$page_security = 'SA_INVENTORYITEMSTATUS';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");






print_customer_balances();


function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$stock_id = $_POST['PARAM_0'];
$destination = $_POST['PARAM_1'];
$trans_type = $_POST['PARAM_2'];
$def_orientation = $_POST['PARAM_3']=1;



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 80, 160, 240, 320, 400);


    $headers = array(_('Location'), _('Quantity On Hand'), _('Re-Order Level'), _('Demand'), _('Availabale'), _('On Order')    );


    $aligns = array('left', 'left',   'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Date before'), 'from' => $from),
                        2 => array('text' => _('Items'), 'from' => (!$stock_id ? "ALL Items    " : $stock_id) )



                    );

    $rep = new FrontReport(_('Inventory Stock Movement'), "Inventory Item Status", user_pagesize(), 9, $def_orientation);

  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();



$loc_details = get_loc_details($stock_id);


    while ($myrow = db_fetch($loc_details))
    {


    $demand_qty = get_demand_qty($stock_id, $myrow["loc_code"]);
    $demand_qty += get_demand_asm_qty($stock_id, $myrow["loc_code"]);

        $qoh = get_qoh_on_date($stock_id, $myrow["loc_code"]);
        $qoo = get_on_porder_qty($stock_id, $myrow["loc_code"]);
        $qoo += get_on_worder_qty($stock_id, $myrow["loc_code"]);


        $c=0;

        $rep->TextCol($c, $c++,  $myrow['location_name']);
        $rep->TextCol($c, $c++,  number_format2($qoh), false, $dec);
        $rep->TextCol($c, $c++,  number_format2($myrow["reorder_level"],2), false, $dec);        
        $rep->TextCol($c, $c++,  number_format2($demand_qty), false, $dec);
        $rep->TextCol($c, $c++,  number_format2($qoh - $demand_qty), false, $dec);
        $rep->TextCol($c, $c++,  number_format2($qoo), false, $dec);



        $newrow = $rep->row;
        $rep->row = $newrow;
        $rep->NewLine();


     }   



    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}