<?php

$page_security = 'SA_JOURNALINQDASHBREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";
include($path_to_root . "/reporting/includes/reporting.inc");

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");





//----------------------------------------------------------------------------------------------------
function journal_pos($row)
{
  return $row['gl_seq'] ? $row['gl_seq'] : '-';
}
function check_value($name)
{
    return (empty($_POST[$name]) ? 0 : 1);
}
function systype_name($dummy, $type)
{
  global $systypes_array;
  
  return $systypes_array[$type];
}

function view_link($row) 
{
  return get_trans_view_str($row["trans_type"], $row["trans_no"]);
}

function gl_link($row) 
{
  return get_gl_view_str($row["trans_type"], $row["trans_no"]);
}

function edit_link($row)
{

  $ok = true;
  if ($row['trans_type'] == ST_SALESINVOICE)
  {
    $myrow = get_customer_trans($row["trans_no"], $row["trans_type"]);
    if ($myrow['alloc'] != 0 || get_voided_entry(ST_SALESINVOICE, $row["trans_no"]) !== false)
      $ok = false;
  }
  return $ok ? trans_editor_link( $row["trans_type"], $row["trans_no"]) : '';
}

function invoice_supp_reference($row)
{
  return $row['supp_reference'];
}


print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$reference =        $_POST['PARAM_0'];
$user_id =          $_POST['PARAM_1'];
$also_closed =      $_POST['PARAM_2'];
$destination =      $_POST['PARAM_3'];
$trans_type =       $_POST['PARAM_4'];
$filterType =       $_POST['PARAM_5'];
$from =             $_POST['PARAM_6'];
$to =               $_POST['PARAM_7'];
$memo =             $_POST['PARAM_8'];
$efrom =            $_GET['PARAM_9'];
$eto =               $_GET['PARAM_10'];
$def_orientation = $_POST['PARAM_11']=1;



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 50, 120, 160, 270, 310,360,440,480, 550,600);


    $headers = array(_('Date'), _('Type'), _('Trans no'), _('Counterparty'), _('Reference'), _('Amount'), _('Memo'),_('User'),_('E Date'));


    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Date before'), 'from' => $from),
                        2 => array('text' => _('Users'), 'from' => (!$user_id ? "ALL Users    " : $user_id) ),
                        3 => array('text' => _('Reference'), 'from' => (!$reference ? "ALL Reference    " : $reference) )
                        

                    );

    $rep = new FrontReport(_('Journal Inquiry'), "Journal Inquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
    recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();



//Zeeshan---------------------------------------------------------------------------------------------------

$sql = get_sql_for_journal_inquiry($filterType, $from, $to, $reference, $memo, check_value($also_closed), $user_id,null,null,$efrom,$eto);
$result=db_query($sql);
    while ($myrow = db_fetch($result) )
    {


        $c=0;

        $rep->TextCol($c, $c++,  sql2date($myrow['tran_date'])  );
        $rep->TextCol($c, $c++,  systype_name('',$myrow['trans_type'])   );
        $rep->TextCol($c, $c++,  $myrow['trans_no']);  
             if($destination)  
        $rep->TextCol($c, $c++,  $myrow['name']);
             else
             {
                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['name'], -2);
                $newrow1 = $rep->row;
                $rep->row = $oldrow;
                 
             }
        
        $rep->TextCol($c, $c++,  $myrow['reference']);
        if($destination)
        $rep->TextCol($c, $c++,  $myrow['amount']);
        else
        $rep->AmountCol($c, $c++,  $myrow['amount'],$dec);
        
        if($destination)
        $rep->TextCol($c, $c++,  $myrow['memo_']);
        else
        {
            
                $oldrow = $rep->row;
                $rep->TextColLines($c++, $c, $myrow['memo_'], -2);
                $newrow2 = $rep->row;
                $rep->row = $oldrow;
        }
        $rep->TextCol($c, $c++,  $myrow['user_id']);
        $rep->TextCol($c, $c++,  date('d/m/Y', strtotime($myrow['stamp']))." ".date('h:i A', strtotime($myrow['stamp'])));



         if($newrow1<$newrow2)
         $rep->row = $newrow1;
       else
          $rep->row = $newrow2;
          
        unset($newrow1);
        unset($newrow2);
        $rep->NewLine();


     }   

//zeeshan//
//--------------------------------------------------------------------------------------------------------


    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}