<?php

$page_security = 'SA_JOURNALLEDGERINQDASHBREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";
include($path_to_root . "/reporting/includes/reporting.inc");

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");







//----------------------------------------------------------------------------------------------------

function fmt_debit($row)
{
    $value = -$row["amount"];
    return $value>=0 ? price_format($value) : '';

}
function check_value($name)
{
    return (empty($_POST[$name]) ? 0 : 1);
}
function input_num($postname=null, $dflt=0)
{
  if (!isset($_POST[$postname]) || $_POST[$postname] == "")
      return $dflt;

    return user_numeric($_POST[$postname]);
}

function fmt_credit($row)
{
    $value = $row["amount"];
    return $value>0 ? price_format($value) : '';
}


function journal_pos($row)
{
  return $row['gl_seq'] ? $row['gl_seq'] : '-';
}

function systype_name($dummy, $type)
{
  global $systypes_array;
  
  return $systypes_array[$type];
}

function view_link($row) 
{
  return get_trans_view_str($row["trans_type"], $row["trans_no"]);
}

function gl_link($row) 
{
  return get_gl_view_str($row["trans_type"], $row["trans_no"]);
}





print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{




global $path_to_root, $systypes_array;

$account =         $_POST['PARAM_0'];
$destination =     $_POST['PARAM_1'];
$from =            $_POST['PARAM_2'];
$to =              $_POST['PARAM_3'];
$trans_no =        $_POST['PARAM_4'];
$dimension1 =      $_POST['PARAM_5'];
$dimension2 =      $_POST['PARAM_6'];
$amount_min =      $_POST['PARAM_7'];
$amount_max =      $_POST['PARAM_8'];
$def_orientation = $_POST['PARAM_9']=1;







    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 70, 85, 130, 245, 295,335,455, 480, 520,580);


    $headers = array(_('Type'), _('#'), _('Date'), _('Account'), _('Dimension1'), _('Dimension2'), 
      _('Person/item'), _('Debit'), _('Credit'), _('Memo')    );


    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

 $params =   array(  0 => $comments,
                     1 => array('text' => _('Date before'), 'from' => $from),
                     2 => array('text' => _('Account'), 'from' => (!$account ? "ALL Accounts    " : $account.' '.get_gl_account_name($account)) ),
                     3 => array('text' => _('Dimension'), 'from' => (!$dimension1 ? "ALL Dimension    " : get_dimension_string($dimension1)    ) ),
                     4 => array('text' => _('Dimension2'), 'from' => (!$dimension2 ? "ALL Dimension    " : get_dimension_string($dimension2)    ) )
                        

                    );

    $rep = new FrontReport(_('General Ledger Inquiry'), "General Ledger Inquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
    recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();


    //--------------------------------------------------------------------------------------------------

$result = get_gl_transactions($from, $to, $trans_no,
      $account, $dimension1, $dimension2, null,
      input_num($amount_min), input_num($amount_max));



    while ($myrow = db_fetch($result) )
    {


        $c=0;
         global $path_to_root, $systypes_array;
        $rep->TextCol($c, $c++, $systypes_array[$myrow["type"]]   );
        $rep->TextCol($c, $c++,  $myrow['type_no']);
        $rep->TextCol($c, $c++,  sql2date($myrow["tran_date"]) );
        
        $rep->TextCol($c, $c++,  $myrow["account"].' '.get_gl_account_name($myrow["account"]) );
        $rep->TextCol($c, $c++,  get_dimension_string($myrow['dimension_id'], true)  );
        $rep->TextCol($c, $c++,  get_dimension_string($myrow['dimension2_id'], true)  );
         if($destination)  
        $rep->TextCol($c, $c++,  payment_person_name($myrow["person_type_id"],$myrow["person_id"]) );
        else
        {
                  $oldrow = $rep->row;
                  $rep->TextColLines($c, ++$c,  payment_person_name($myrow["person_type_id"],$myrow["person_id"]) );
            	  $newrow1 = $rep->row;
				  $rep->row = $oldrow;
        }
        
        $rep->TextCol($c, $c++,  fmt_credit ($myrow));
        $rep->TextCol($c, $c++,  fmt_debit($myrow));

        if ($myrow['memo_'] == "")
        $myrow['memo_'] = get_comments_string($myrow['type'], $myrow['type_no']);
        
             if($destination)  
        $rep->TextCol($c, $c++,  $myrow['memo_']);
        else
        {
                   $oldrow = $rep->row;
                  $rep->TextColLines($c, ++$c,  $myrow['memo_']);
            	  $newrow2 = $rep->row;
				  $rep->row = $oldrow;
        }



    
         if($newrow1<$newrow2)
         $rep->row = $newrow1;
       else
          $rep->row = $newrow2;
          
        unset($newrow1);
        unset($newrow2);
        $rep->NewLine();


     }   

//zeeshan//
//--------------------------------------------------------------------------------------------------------


    // $rep->Line($rep->row  - 4);

        $rep->End();
}