<?php

$page_security = 'SA_BANKSTATEMENTDASHBREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";
include($path_to_root . "/reporting/includes/reporting.inc");

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");





//----------------------------------------------------------------------------------------------------


function fmt_debit($row)
{
    $value = -$row["amount"];
    return $value>=0 ? price_format($value) : '';

}

function fmt_credit($row)
{
    $value = $row["amount"];
    return $value>0 ? price_format($value) : '';
}

function fmt_balance($row)
{
    $value = ($row["type"] == ST_BANKPAYMENT || $row["type"] == ST_SUPPCREDIT || $row["type"] == ST_SUPPAYMENT) ? -$row["amount"] - $row["Allocated"]
        : ($row["type"] == ST_JOURNAL ? abs($row["amount"]) - $row["Allocated"] :
            $row["amount"] - $row["Allocated"]);
    return $value;
}

function journal_pos($row)
{
  return $row['gl_seq'] ? $row['gl_seq'] : '-';
}

function systype_name($dummy, $type)
{
  global $systypes_array;
  
  return $systypes_array[$type];
}

function view_link($row) 
{
  return get_trans_view_str($row["trans_type"], $row["trans_no"]);
}

function gl_link($row) 
{
  return get_gl_view_str($row["trans_type"], $row["trans_no"]);
}



function invoice_supp_reference($row)
{
  return $row['supp_reference'];
}


print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$destination =            $_POST['PARAM_0'];
$from =            $_POST['PARAM_1'];
$to =              $_POST['PARAM_2'];
$bank_acc =        $_POST['PARAM_3'];
$trans_type =      $_POST['PARAM_4'];
$def_orientation = $_POST['PARAM_5']=1;



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0, 80, 100, 150, 210, 250,290,360,490,560);


    $headers = array(_('Type'), _('#'), _('Reference'), _('Date'), _('Debit'),
     _('Credit'), _('Balance'),_('Person/Item') ,_('memo'));


    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left','left');

$act = get_bank_account($bank_acc);
// display_heading($act['bank_account_name']." - ".$act['bank_curr_code']);

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
                        2 => array('text' => _('Bank Account'), 'from' => $act['bank_account_name']." - ".$act['bank_curr_code'])
                        // 3 => array('text' => _('Reference'), 'from' => (!$reference ? "ALL Reference    " : $reference) )
                        

                    );

    $rep = new FrontReport(_('Bank Statement'), "Bank Statement", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
    recalculate_cols($cols);
    $rep->Font('bold');
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

// 	$summary_start_row = $rep->bottomMargin + (5 * $rep->lineHeight);

//Zeeshan---------------------------------------------------------------------------------------------------

$bfw = get_balance_before_for_bank_account($bank_acc, $from);

    $rep->Font('bold'); 

$rep->FontSize += 2;
      $rep->Line($rep->row  -8);

  $rep->TextCol(0,3,  _("Quantity on hand before")." : ".$from);       
  if(fmt_debit()!=null) 
    $rep->AmountCol(4,5,  $bfw  ,$dec);
  if(fmt_credit()!=null)
    $rep->AmountCol(5,6,  $bfw - (2*$bfw) ,$dec);
     
    $rep->Font();

    $rep->NewLine();
    $rep->NewLine();




    $result = get_bank_trans_for_bank_account($bank_acc, $from, $to); 
    
// $rep->TextColLines(200, 300,'bankaccount--->'.$bank_acc.'from--->'.$from.'to---->'.$to, -2,200);
$credit=0;
$debit=0;
$credit=fmt_debit($myrow);
$debit=fmt_credit($myrow);



$running_total = $bfw;
if ($bfw > 0 ) 
    $debit += $bfw;
else 
    $credit += $bfw;

// $rep->row+=10;
    while ($myrow = db_fetch($result) )
    {

         $running_total += $myrow["amount"];

       $c=0;
        

        $rep->TextCol($c, $c++,  $systypes_array[$myrow["type"]]  );
        $rep->TextCol($c, $c++,  $myrow['trans_no']);
        $rep->TextCol($c, $c++,  $myrow['ref']);
        $rep->TextCol($c, $c++,  sql2date($myrow["trans_date"])  );
        $rep->TextCol($c, $c++,  fmt_credit($myrow) );
        $rep->TextCol($c, $c++,  fmt_debit($myrow) );
        $rep->AmountCol($c, $c++,  $running_total, $dec );
        
         if($destination)
          {
              $rep->TextCol($c, $c++,   payment_person_name($myrow["person_type_id"],$myrow["person_id"]));
                 $rep->TextCol($c, $c++,   get_comments_string($myrow["type"], $myrow["trans_no"]) );
          }
          else
          {
        
        		$oldrow = $rep->row;
        $rep->TextColLines($c++, $c,  payment_person_name($myrow["person_type_id"],$myrow["person_id"]) ,-2);
           		$newrow1 = $rep->row;
				$rep->row = $oldrow;
				
				
				$oldrow = $rep->row;
        $rep->TextColLines($c++, $c,  get_comments_string($myrow["type"], $myrow["trans_no"]) ,-2);
           		$newrow2 = $rep->row;
				$rep->row = $oldrow;
          }	
			

			
				

    


if ($myrow["amount"] > 0 ) 
        $debit += $myrow["amount"];
    else 
        $credit += $myrow["amount"];




             if($newrow1<$newrow2)
      	  	$rep->row = $newrow1;
      		else
      	    $rep->row = $newrow2;
      			
      			
      $rep->NewLine();
     }   





      // $rep->Line($rep->row  -8);

    $rep->Font('bold');
    $rep->NewLine();

  $rep->TextCol(0,3,  _("Quantity on hand before")." : ".$from);
    $rep->AmountCol(4,5,  $debit,$dec);

    $rep->AmountCol(5,6,  $credit - (2*$credit) ,$dec);
    $rep->AmountCol(6,7,  $running_total ,$dec);


        $rep->Font();
      
    $rep->NewLine();
//zeeshan//
//--------------------------------------------------------------------------------------------------------


    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}